<?php 
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/geturl.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

dol_include_once('/glpitodolibarr/core/modules/modglpitodolibarr.class.php');
class glpitodolibarr extends Commonobject{ 

	public $errors = array();
	
	public function __construct($db){ 
		$this->db = $db;
		return 1;
    }

    public function getImportedData($toget='',$parenttype=''){
    	$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX ."glpitodolibarrdata";
		$sql .= " WHERE elementtype = '".$toget."'";
		if(!empty($parenttype)){
			$sql .= " AND parenttype = '".$parenttype."'";
		};

		$resql = $this->db->query($sql);
		$already = array();

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
                $already[$obj->fk_id_glpi] = $obj->fk_id_glpi;
			}
			$this->db->free($resql);

			
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			print_r($this->errors);
			die();
		}

		return $already;
    }

    public function getGlpitoDolibarrData($toget='',$id=0,$child=''){

    	global $user,$conf;

    	$api_url    = $conf->global->GLPI_TO_DOLIBARR_URLSITE;

		$app_token  = $conf->global->GLPI_TO_DOLIBARR_APPTOKEN;

		$user_token = $conf->global->GLPI_TO_DOLIBARR_USERTOKEN;

		// die($app_token);
		if(empty($user_token))
			return 0;

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, $api_url.'/apirest.php/initSession');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

		$headers = array();
		$headers[] = 'Content-Type: application/json';
		$headers[] = 'Authorization: user_token '.$user_token;
		$headers[] = 'App-Token: '.$app_token;

		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		// if (curl_errno($ch)) echo 'Error:' . curl_error($ch);

		curl_close($ch);

		$obj = json_decode($result,true);

		$sess_token = $obj['session_token'];

		$headers = array();
		$headers[] = 'Content-Type: application/json';
		$headers[] = 'App-Token: '.$app_token;
		$headers[] = 'Session-Token: '.$sess_token;

		$ch = curl_init();
		if(!empty($id) && empty($child)){
			curl_setopt($ch, CURLOPT_URL, $api_url.'/apirest.php/'.$toget.'/'.$id.'/?expand_dropdowns=true');
		}
		elseif(!empty($id) && !empty($child)){
			curl_setopt($ch, CURLOPT_URL, $api_url.'/apirest.php/'.$toget.'/'.$id.'/'.$child.'/?expand_dropdowns=true');
		}else{
			curl_setopt($ch, CURLOPT_URL, $api_url.'/apirest.php/'.$toget.'/?expand_dropdowns=true');
		}
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);

		curl_close($ch);

		$obj = json_decode($result,true);
		// print_r($obj);die();

		if( !$obj || (isset($obj[0]) && !is_array($obj[0]) && ( strpos( $obj[0], 'ERROR_' ) !== false )) )
			return -1;

		return $obj;
    }


    
} 


class glpitodolibarrcls extends Commonobject{ 
    
    public function __construct($db){ 
        $this->db = $db;
        return 1;
    }

    public function fetch()
    {
        global $conf, $mysoc, $user, $langs;
        $langs->load('glpitodolibarr@glpitodolibarr');

        $modulrecrut = new modglpitodolibarr($this->db);

        $nummodul = $modulrecrut->numero;
        $editeurmodul = 'https://www.nextgestion.com';

        if (!dolibarr_get_const($this->db,'EDITOR_MODULE_GLPITODOLIBARR',0))
            dolibarr_set_const($this->db,'EDITOR_MODULE_GLPITODOLIBARR',$editeurmodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'ID_MODULE_GLPITODOLIBARR',0))
            dolibarr_set_const($this->db,'ID_MODULE_GLPITODOLIBARR',$nummodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'DATE_MODULE_GLPITODOLIBARR',0))
            dolibarr_set_const($this->db,'DATE_MODULE_GLPITODOLIBARR',date('Y-m-d'),'chaine',0,'',0);


        $id_modul      = dolibarr_get_const($this->db,'ID_MODULE_GLPITODOLIBARR',0);
        $date_modul    = dolibarr_get_const($this->db,'DATE_MODULE_GLPITODOLIBARR',0);
        $editor_modul  = dolibarr_get_const($this->db,'EDITOR_MODULE_GLPITODOLIBARR',0);

        $link = urlencode(dol_buildpath('/',2));

        if(!empty($date_modul) && $date_modul <= date('Y-m-d') && !empty($editor_modul) && !empty($id_modul) && !empty($link)){

	        $name = ( $mysoc->name ? $mysoc->name : "(U) ".$user->lastname.' '.$user->firstname);
	        $name = urlencode($name);
        	$id_modul = urlencode($id_modul);
	        $mail = urlencode($mysoc->email); 

            $url = $editor_modul."/suivimod/module/registeruse?mod=".$id_modul."&link=".$link."&name=".$name."&email=".$mail;
            $urldata = getURLContent($url);
            $response = json_decode($urldata['content']);

            if($response && $response->actif == 0){
                dolibarr_set_const($this->db,'ID_MODULE_GLPITODOLIBARR', 1, 'chaine',0,'',0);
                unActivateModule("modglpitodolibarr");
            }
            $newdate_modul = date("Y-m-d", strtotime("+ 1 day"));
            dolibarr_set_const($this->db,'DATE_MODULE_GLPITODOLIBARR', $newdate_modul, 'chaine',0,'',0);
        }
        return 1;
    } 
}


?>