<?php
$check = '<i class="fa fa-check" aria-hidden="true"></i>';
$uncheck = '<i class="fa fa-times" aria-hidden="true"></i>';

$assurance 	= $gestionvehicules->fetchRecaps("assurance",$item->rowid);
$carnet 	= $gestionvehicules->fetchRecaps("carnet_disque",$item->rowid);
$grise 		= $gestionvehicules->fetchRecaps("carte_grise",$item->rowid);
$extincteur	= $gestionvehicules->fetchRecaps("controle_extincteur",$item->rowid);
$permis		= $gestionvehicules->fetchRecaps("permis_circuler",$item->rowid);
$tax_poids	= $gestionvehicules->fetchRecaps("tax_poids",$item->rowid);
$visite		= $gestionvehicules->fetchRecaps("visite_technique",$item->rowid);
$vignette	= $gestionvehicules->fetchRecaps("vignette",$item->rowid);
$feuille_circulation   = $gestionvehicules->fetchRecaps("feuille_circulation",$item->rowid);

print '<div class="all_recap">';
print '<link rel="stylesheet" href="https://use.fontawesome.com/2ff5ea6f71.css">';

// Recap
$cols = 9;
print '<table class="border recap" width="100%">';
print '<thead>';
print '<tr class="liste_titre">';
print '<td colspan="'.$cols.'" class="title"><h3><div class="icon-ecm"></div><b>Recap</b></h3></td>';
print '</tr>';
print '<tr class="transparent"><td colspan="'.$cols.'"></td></tr>';
print '<tr class="liste_titre">';
	print '<th class="liste_titre">Assurance</th>';
	print '<th class="liste_titre">Carnet Disque</th>';
	print '<th class="liste_titre">Carte Grise</th>';
	print '<th class="liste_titre">Contrôle extincteur</th>';
	print '<th class="liste_titre">Permis Circuler</th>';
	print '<th class="liste_titre">Taxe sur poids</th>';
	print '<th class="liste_titre">Visite Technique</th>';
	print '<th class="liste_titre">Vignette</th>';
	print '<th class="liste_titre">Feuille de Circulation</th>';
print '</tr>';
print '</thead>';
print '<tbody>';
print '<tr>';
	print'<td class="check go_to" data-go="assurance">'.( ($assurance) ? $check : $uncheck ).'</td>';
	print'<td class="check go_to" data-go="carnet">'.( ($carnet) ? $check : $uncheck ).'</td>';
	print'<td class="check go_to" data-go="grise">'.( ($grise) ? $check : $uncheck ).'</td>';
	print'<td class="check go_to" data-go="extincteur">'.( ($extincteur) ? $check : $uncheck ).'</td>';
	print'<td class="check go_to" data-go="permis">'.( ($permis) ? $check : $uncheck ).'</td>';
	print'<td class="check go_to" data-go="tax_poids">'.( ($tax_poids) ? $check : $uncheck ).'</td>';
	print'<td class="check go_to" data-go="visite">'.( ($visite) ? $check : $uncheck ).'</td>';
	print'<td class="check go_to" data-go="vignette">'.( ($vignette) ? $check : $uncheck ).'</td>';
	print'<td class="check go_to" data-go="feuille_circulation">'.( ($feuille_circulation) ? $check : $uncheck ).'</td>';
print '</tr>';
print '</tbody>';
print '</table>';

// Assurance
$cols = 8;
print '<br>';
print '<table class="border assurance" width="100%" id="assurance">';
print '<thead>';
print '<tr class="liste_titre">';
print '<td colspan="'.$cols.'" class="title"><h3><div class="icon-gestion_assurance mainvmenu"></div><b>Assurance</b></h3></td>';
print '</tr>';
print '<tr class="transparent"><td colspan="'.$cols.'"></td></tr>';
print '<tr class="liste_titre">';
	print '<th class="liste_titre action_b">Action</th>';
	print '<th class="liste_titre">N° d\'order</th>';
	print '<th class="liste_titre">Entreprise d\'assurances</th>';
	print '<th class="liste_titre">N° de la police</th>';
	print '<th class="liste_titre">Intermédiaire</th>';
	// print '<th class="liste_titre">Periode de garantie</th>';
	print '<th class="liste_titre">Du</th>';
	print '<th class="liste_titre">Au</th>';
	print '<th class="liste_titre photos_b">Photos</th>';
print '</tr>';
print '</thead>';
print '<tbody>';
$thirdpartystatic   = new Societe($db);
if ($assurance) {
	for ($i=0; $i < count($assurance) ; $i++) {
		$item = $assurance[$i];
		print '<tr>';
			print'<td><a target="_blank" style="color: #000; font-size: 15px;" href="'. dol_buildpath('/gestionvehicules/gestion_assurance/card.php?id='.$item->rowid,2).'"><i class="fa fa-eye"></i></a></td>';
			print'<td>'.$item->num_order.'</td>';
			$thirdpartystatic->fetch($item->entreprise);
			print'<td>'.$thirdpartystatic->getNomUrl().'</td>';
			print'<td>'.$item->num_police.'</td>';
			print'<td>'.$item->sub_entreprise.'</td>';
			// print'<td>-</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->debut,'day').'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->fin,'day').'</td>';
			$dire = $conf->gestionvehicules->dir_output.'/gestion_assurance/img/'.$item->rowid.'/';
			print'<td class="check">';
			$file0 = $uncheck;
			if(count(glob($dire."*.{jpg,png,gif,jpeg}", GLOB_BRACE)) || count(glob("$dire/files/*")))
            	$file0 = $check;
            print $file0;
			print '</td>';
		print '</tr>';
	}
}else{
	print '<tr><td colspan="'.$cols.'">La gestion d\'assurance de ce Matricule n\'existe pas</td></tr>';
}
print '</tr>';
print '</tbody>';
print '</table>';


// Carnet Disque
$cols = 10;
print '<br>';
print '<table class="border carnet" width="100%" id="carnet">';
print '<thead>';
print '<tr class="liste_titre">';
print '<td colspan="'.$cols.'" class="title"><h3><div class="icon-gestion_carnet_disque mainvmenu"></div><b>Carnet Disque</b></h3></td>';
print '</tr>';
print '<tr class="transparent"><td colspan="'.$cols.'"></td></tr>';
print '<tr class="liste_titre">';
	print '<th class="liste_titre action_b">Action</th>';
	print '<th class="liste_titre">N°</th>';
	print '<th class="liste_titre">N° Homologation</th>';
	print '<th class="liste_titre">Marque</th>';
	print '<th class="liste_titre">Type</th>';
	print '<th class="liste_titre">Serie</th>';
	print '<th class="liste_titre">Entreprise</th>';
	print '<th class="liste_titre">Du</th>';
	print '<th class="liste_titre">Au</th>';
	print '<th class="liste_titre photos_b">Photos</th>';
print '</tr>';
print '</thead>';
print '<tbody>';
if ($carnet) {
	for ($i=0; $i < count($carnet) ; $i++) {
		$item = $carnet[$i];
		print '<tr>';
			print'<td><a target="_blank" style="color: #000; font-size: 15px;" href="'. dol_buildpath('/gestionvehicules/gestion_carnet_disque/card.php?id='.$item->rowid,2).'"><i class="fa fa-eye"></i></a></td>';
			print'<td>'.$item->num_facture.'</td>';
			print'<td>'.$item->num_homologation.'</td>';
			print'<td>'.$item->marque.'</td>';
			print'<td>'.$item->type.'</td>';
			print'<td>'.$item->serie.'</td>';
			$thirdpartystatic->fetch($item->entreprise);
			print'<td>'.$thirdpartystatic->getNomUrl().'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->debut,'day').'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->fin,'day').'</td>';
			$dire = $conf->gestionvehicules->dir_output.'/gestion_carnet_disque/img/'.$item->rowid.'/';
			print'<td class="check">';
			$file0 = $uncheck;
			if(count(glob($dire."*.{jpg,png,gif,jpeg}", GLOB_BRACE)) || count(glob("$dire/files/*")))
            	$file0 = $check;
            print $file0;
			print '</td>';
		print '</tr>';
	}
}else{
	print '<tr><td colspan="'.$cols.'">La gestion des Carnets Disque de ce Matricule n\'existe pas</td></tr>';
}
print '</tr>';
print '</tbody>';
print '</table>';




// Carte Grise
$cols = 7;
print '<br>';
print '<table class="border Grise" width="100%" id="grise">';
print '<thead>';
print '<tr class="liste_titre">';
print '<td colspan="'.$cols.'" class="title"><h3><div class="icon-gestion_carte_grise mainvmenu"></div><b>Carte Grise</b></h3></td>';
print '</tr>';
print '<tr class="transparent"><td colspan="'.$cols.'"></td></tr>';
print '<tr class="liste_titre">';
	print '<th class="liste_titre action_b">Action</th>';
	print '<th class="liste_titre">Matricule Antérieure</th>';
	print '<th class="liste_titre">Marque</th>';
	print '<th class="liste_titre">Type</th>';
	print '<th class="liste_titre">Du</th>';
	print '<th class="liste_titre">Au</th>';
	print '<th class="liste_titre photos_b">Photos</th>';
print '</tr>';
print '</thead>';
print '<tbody>';
if ($grise) {
	for ($i=0; $i < count($grise) ; $i++) {
		$item = $grise[$i];
		print '<tr>';
			print'<td><a target="_blank" style="color: #000; font-size: 15px;" href="'. dol_buildpath('/gestionvehicules/gestion_carte_grise/card.php?id='.$item->rowid,2).'"><i class="fa fa-eye"></i></a></td>';
			print'<td>'.$item->old_matr.'</td>';
			print'<td>'.$item->marque.'</td>';
			print'<td>'.$item->type.'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->debut,'day').'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->fin,'day').'</td>';
			$dire = $conf->gestionvehicules->dir_output.'/gestion_carte_grise/img/'.$item->rowid.'/';
			print'<td class="check">';
			$file0 = $uncheck;
			if(count(glob($dire."*.{jpg,png,gif,jpeg}", GLOB_BRACE)) || count(glob("$dire/files/*")))
            	$file0 = $check;
            print $file0;
			print '</td>';
		print '</tr>';
	}
}else{
	print '<tr><td colspan="'.$cols.'">La gestion de Carte Grise de ce Matricule n\'existe pas</td></tr>';
}
print '</tr>';
print '</tbody>';
print '</table>';




// Contrôle extincteur
dol_include_once('/gestionvehicules/gestion_controle_extincteur/class/gestion_controle_extincteur.class.php');
$gestion_controle_extincteur_type = new gestion_controle_extincteur_type($db);
$cols = 5;
print '<br>';
print '<table class="border carnet" width="100%" id="extincteur">';
print '<thead>';
print '<tr class="liste_titre">';
print '<td colspan="'.$cols.'" class="title"><h3><div class="icon-controle_extincteur mainvmenu"></div><b>Contrôle extincteur</b></h3></td>';
print '</tr>';
print '<tr class="transparent"><td colspan="'.$cols.'"></td></tr>';
print '<tr class="liste_titre">';
	print '<th class="liste_titre action_b">Action</th>';
	print '<th class="liste_titre">Extincteur type</th>';
	print '<th class="liste_titre">Date de contrôle</th>';
	print '<th class="liste_titre">Prochain contrôle</th>';
	print '<th class="liste_titre photos_b">Photos</th>';
print '</tr>';
print '</thead>';
print '<tbody>';
if ($extincteur) {
	for ($i=0; $i < count($extincteur) ; $i++) {
		$item = $extincteur[$i];
		print '<tr>';
			print'<td><a target="_blank" style="color: #000; font-size: 15px;" href="'. dol_buildpath('/gestionvehicules/gestion_controle_extincteur/card.php?id='.$item->rowid,2).'"><i class="fa fa-eye"></i></a></td>';
			$gestion_controle_extincteur_type->fetch($item->type);
			print'<td>'.$gestion_controle_extincteur_type->getNomUrl(0,$gestion_controle_extincteur_type->rowid,$gestion_controle_extincteur_type->name).'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->debut,'day').'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->fin,'day').'</td>';
			$dire = $conf->gestionvehicules->dir_output.'/gestion_controle_extincteur/img/'.$item->rowid.'/';
			print'<td class="check">';
			$file0 = $uncheck;
			if(count(glob($dire."*.{jpg,png,gif,jpeg}", GLOB_BRACE)) || count(glob("$dire/files/*")))
            	$file0 = $check;
            print $file0;
			print '</td>';
		print '</tr>';
	}
}else{
	print '<tr><td colspan="'.$cols.'">La gestion de Contrôle extincteur de ce Matricule n\'existe pas</td></tr>';
}
print '</tr>';
print '</tbody>';
print '</table>';




// Permis Circuler
$cols = 5;
print '<br>';
print '<table class="border carnet" width="100%" id="permis">';
print '<thead>';
print '<tr class="liste_titre">';
print '<td colspan="'.$cols.'" class="title"><h3><div class="icon-gestion_permis_circuler mainvmenu"></div><b>Permis Circuler</b></h3></td>';
print '</tr>';
print '<tr class="transparent"><td colspan="'.$cols.'"></td></tr>';
print '<tr class="liste_titre">';
	print '<th class="liste_titre action_b">Action</th>';
	print '<th class="liste_titre">N° Dossier</th>';
	print '<th class="liste_titre">Date de debut</th>';
	print '<th class="liste_titre">Date de fin</th>';
	print '<th class="liste_titre photos_b">Photos</th>';
print '</tr>';
print '</thead>';
print '<tbody>';
if ($permis) {
	for ($i=0; $i < count($permis) ; $i++) {
		$item = $permis[$i];
		print '<tr>';
			print'<td><a target="_blank" style="color: #000; font-size: 15px;" href="'. dol_buildpath('/gestionvehicules/gestion_permis_circuler/card.php?id='.$item->rowid,2).'"><i class="fa fa-eye"></i></a></td>';
			print'<td>'.$item->num_dossier.'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->debut,'day').'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->fin,'day').'</td>';
			$dire = $conf->gestionvehicules->dir_output.'/gestion_permis_circuler/img/'.$item->rowid.'/';
			print'<td class="check">';
			$file0 = $uncheck;
			if(count(glob($dire."*.{jpg,png,gif,jpeg}", GLOB_BRACE)) || count(glob("$dire/files/*")))
            	$file0 = $check;
            print $file0;
			print '</td>';
		print '</tr>';
	}
}else{
	print '<tr><td colspan="'.$cols.'">La gestion des Permis Circuler de ce Matricule n\'existe pas</td></tr>';
}
print '</tr>';
print '</tbody>';
print '</table>';




// Taxe sur poids
$cols = 6;
print '<br>';
print '<table class="border carnet" width="100%" id="tax_poids">';
print '<thead>';
print '<tr class="liste_titre">';
print '<td colspan="'.$cols.'" class="title"><h3><div class="icon-gestion_tax_poids mainvmenu"></div><b>Taxe sur poids</b></h3></td>';
print '</tr>';
print '<tr class="transparent"><td colspan="'.$cols.'"></td></tr>';
print '<tr class="liste_titre">';
	print '<th class="liste_titre action_b">Action</th>';
	print '<th class="liste_titre">Montant</th>';
	print '<th class="liste_titre">Tarif</th>';
	print '<th class="liste_titre">Date de debut</th>';
	print '<th class="liste_titre">Date de fin</th>';
	print '<th class="liste_titre photos_b">Photos</th>';
print '</tr>';
print '</thead>';
print '<tbody>';
if ($tax_poids) {
	for ($i=0; $i < count($tax_poids) ; $i++) {
		$item = $tax_poids[$i];
		print '<tr>';
			print'<td><a target="_blank" style="color: #000; font-size: 15px;" href="'. dol_buildpath('/gestionvehicules/gestion_tax_poids/card.php?id='.$item->rowid,2).'"><i class="fa fa-eye"></i></a></td>';
			print'<td>'.number_format($item->montant, 2, '.', ' ').'</td>';
			print'<td>'.number_format($item->tarif, 2, '.', ' ').'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->debut,'day').'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->fin,'day').'</td>';
			$dire = $conf->gestionvehicules->dir_output.'/gestion_tax_poids/img/'.$item->rowid.'/';
			print'<td class="check">';
			$file0 = $uncheck;
			if(count(glob($dire."*.{jpg,png,gif,jpeg}", GLOB_BRACE)) || count(glob("$dire/files/*")))
            	$file0 = $check;
            print $file0;
			print '</td>';
		print '</tr>';
	}
}else{
	print '<tr><td colspan="'.$cols.'">Les Taxes sur poids de ce Matricule n\'existe pas</td></tr>';
}
print '</tr>';
print '</tbody>';
print '</table>';




// Visite Technique
dol_include_once('/gestionvehicules/gestion_visite_technique/class/gestion_visite_technique.class.php');
$gestion_visite_technique_type = new gestion_visite_technique_type($db);
$cols = 8;
print '<br>';
print '<table class="border carnet" width="100%" id="visite">';
print '<thead>';
print '<tr class="liste_titre">';
print '<td colspan="'.$cols.'" class="title"><h3><div class="icon-gestion_visite_technique mainvmenu"></div><b>Visite Technique</b></h3></td>';
print '</tr>';
print '<tr class="transparent"><td colspan="'.$cols.'"></td></tr>';
print '<tr class="liste_titre">';
	print '<th class="liste_titre action_b">Action</th>';
	print '<th class="liste_titre">Identifiant unique du contrôle</th>';
	print '<th class="liste_titre">Centre de visite technique</th>';
	print '<th class="liste_titre">Type de contrôle</th>';
	print '<th class="liste_titre">Resultat du contrôle</th>';
	// print '<th class="liste_titre">Periode de contrôle</th>';
	print '<th class="liste_titre">Du</th>';
	print '<th class="liste_titre">Au</th>';
	print '<th class="liste_titre photos_b">Photos</th>';
print '</tr>';
print '</thead>';
print '<tbody>';
if ($visite) {
	for ($i=0; $i < count($visite) ; $i++) {
		$item = $visite[$i];
		print '<tr>';
			print'<td><a target="_blank" style="color: #000; font-size: 15px;" href="'. dol_buildpath('/gestionvehicules/gestion_visite_technique/card.php?id='.$item->rowid,2).'"><i class="fa fa-eye"></i></a></td>';
			print'<td>'.$item->id_controle.'</td>';
			$thirdpartystatic->fetch($item->entreprise);
			print'<td>'.$thirdpartystatic->getNomUrl().'</td>';
			$gestion_visite_technique_type->fetch($item->type);
			print'<td>'.$gestion_visite_technique_type->getNomUrl(0,$item->type,$gestion_visite_technique_type->name).'</td>';
			print'<td>'.$item->resultat.'</td>';
			// print'<td>-</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->debut,'day').'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->fin,'day').'</td>';
			$dire = $conf->gestionvehicules->dir_output.'/gestion_visite_technique/img/'.$item->rowid.'/';
			print'<td class="check">';
			$file0 = $uncheck;
			if(count(glob($dire."*.{jpg,png,gif,jpeg}", GLOB_BRACE)) || count(glob("$dire/files/*")))
            	$file0 = $check;
            print $file0;
			print '</td>';
		print '</tr>';
	}
}else{
	print '<tr><td colspan="'.$cols.'">La gestion des Visites Technique de ce Matricule n\'existe pas</td></tr>';
}
print '</tr>';
print '</tbody>';
print '</table>';




// Vignette
$cols = 6;
print '<br>';
print '<table class="border carnet" width="100%" id="vignette">';
print '<thead>';
print '<tr class="liste_titre">';
print '<td colspan="'.$cols.'" class="title"><h3><div class="icon-gestion_vignette mainvmenu"></div><b>Vignette</b></h3></td>';
print '</tr>';
print '<tr class="transparent"><td colspan="'.$cols.'"></td></tr>';
print '<tr class="liste_titre">';
	print '<th class="liste_titre action_b">Action</th>';
	print '<th class="liste_titre">Montant</th>';
	print '<th class="liste_titre">Nombre ordinal</th>';
	print '<th class="liste_titre">Date de debut</th>';
	print '<th class="liste_titre">Date de fin</th>';
	print '<th class="liste_titre photos_b">Photos</th>';
print '</tr>';
print '</thead>';
print '<tbody>';
if ($vignette) {
	for ($i=0; $i < count($vignette) ; $i++) {
		$item = $vignette[$i];
		print '<tr>';
			print'<td><a target="_blank" style="color: #000; font-size: 15px;" href="'. dol_buildpath('/gestionvehicules/gestion_vignette/card.php?id='.$item->rowid,2).'"><i class="fa fa-eye"></i></a></td>';
			print'<td>'.number_format($item->montant, 2, '.', ' ').'</td>';
			print'<td>'.$item->num_order.'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->debut,'day').'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->fin,'day').'</td>';
			$dire = $conf->gestionvehicules->dir_output.'/gestion_vignette/img/'.$item->rowid.'/';
			print'<td class="check">';
			$file0 = $uncheck;
			if(count(glob($dire."*.{jpg,png,gif,jpeg}", GLOB_BRACE)) || count(glob("$dire/files/*")))
            	$file0 = $check;
            print $file0;
			print '</td>';
		print '</tr>';
	}
}else{
	print '<tr><td colspan="'.$cols.'">La gestion des Vignettes de ce Matricule n\'existe pas</td></tr>';
}
print '</tr>';
print '</tbody>';
print '</table>';





// Feuille de Circulation
$cols = 5;
print '<br>';
print '<table class="border carnet" width="100%" id="feuille_circulation">';
print '<thead>';
print '<tr class="liste_titre">';
print '<td colspan="'.$cols.'" class="title"><h3><div class="icon-feuille_circulation mainvmenu"></div><b>Feuille de Circulation</b></h3></td>';
print '</tr>';
print '<tr class="transparent"><td colspan="'.$cols.'"></td></tr>';
print '<tr class="liste_titre">';
	print '<th class="liste_titre action_b">Action</th>';
	print '<th class="liste_titre">Dossier N°</th>';
	print '<th class="liste_titre" style="max-width:350px;width:350px;">Acte établi le</th>';
	print '<th class="liste_titre" style="max-width:350px;width:350px;">Autorisation valable jusqu\'au</th>';
	print '<th class="liste_titre photos_b">Photos</th>';
print '</tr>';
print '</thead>';
print '<tbody>';
if ($feuille_circulation) {
	for ($i=0; $i < count($feuille_circulation) ; $i++) {
		$item = $feuille_circulation[$i];
		print '<tr>';
			print'<td><a target="_blank" style="color: #000; font-size: 15px;" href="'. dol_buildpath('/gestionvehicules/gestion_feuille_circulation/card.php?id='.$item->rowid,2).'"><i class="fa fa-eye"></i></a></td>';
			print'<td>'.$item->num_dossier.'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->acte_etabli,'day').'</td>';
			print'<td class="date_td_tab">'.dol_print_date($item->autorisation_jusqu,'day').'</td>';
			$dire = $conf->gestionvehicules->dir_output.'/gestion_feuille_circulation/img/'.$item->rowid.'/';
			print'<td class="check">';
			$file0 = $uncheck;
			if(count(glob($dire."*.{jpg,png,gif,jpeg}", GLOB_BRACE)) || count(glob("$dire/files/*")))
            	$file0 = $check;
            print $file0;
			print '</td>';
		print '</tr>';
	}
}else{
	print '<tr><td colspan="'.$cols.'">La gestion de Feuille de Circulation de ce Matricule n\'existe pas</td></tr>';
}
print '</tr>';
print '</tbody>';
print '</table>';



print '</div>';



















?>
<script>
$(document).ready(function (){
	$(".go_to").click(function() {
		var go = $(this).data("go");
	    $('html, body, #id-right').animate({
	        scrollTop: $("#"+go).offset().top - ($("#tmenu_tooltip").height() + 5)
	    }, 500);
	});
});
</script>


