<?php

/**
 * Get translated string
 * @param string $str
 * @param string|null $lang
 * @return string
 */
function fm_t($str, $lang = null)
{
    if ($lang === null) {
        if (defined('FM_LANG')) {
            $lang = FM_LANG;
        } else {
            return $str;
        }
    }
    $strings = fm_get_strings();
    if (!isset($strings[$lang]) || !is_array($strings[$lang])) {
        return $str;
    }
    if (array_key_exists($str, $strings[$lang])) {
        return $strings[$lang][$str];
    }
    return $str;
}
