<?php
/* Copyright (C) 2014-2019	Charlene Benke	<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file	   htdocs/extraodt/class/actions_extraodt.class.php
 * 	\ingroup	extrodt
 * 	\brief	  Fichier de la classe des actions/hooks de extraodt
 */

class ActionsExtraodt // extends CommonObject 
{
	/** Overloading the doActions function : replacing the parent's function with the one below 
	 *  @param	  parameters  meta datas of the hook (context, etc...) 
	 *  @param	  object			 the object you want to process (an invoice if you are in invoice module, a propale in propale's module, etc...) 
	 *  @param	  action			 current action (if set). Generally create or edit or null 
	 *  @return	   void 
	 */
	function beforeODTSave($parameters, $object, $action) 
	{
		global $conf, $langs, $db;

		$localHandler = $parameters['odfHandler'];

		// pour grer les autres filtrage sur les odt autres que ceux du tiers
		if ($parameters['object']->element=='societe')
			$idsoc=$parameters['object']->id;
		else
			$idsoc=$parameters['object']->fk_soc;

		// d'abord le paramtrage par dfaut, ensuite celui du document
		// selon la paramtrage de l'odt, on limite les enregistrements
		$nbOnODT = $conf->global->nbActionOnODT;
		$nb=$localHandler->getvalue("nbActionOnODT");
		if ($nb)
			$nbOnODT = $nb;

		// Si il y a un filtrage supplmentaire sur l'action
		$whereodt=$conf->global->CondActionOnODT;
		$condodt=$localHandler->getvalue("CondActionOnODT");
		if ($condodt)
			$whereodt=$condodt;

		// alimentation du tableau des actions commerciales
		$sql = "SELECT id FROM ".MAIN_DB_PREFIX."actioncomm as ac";
		$sql.= " WHERE fk_soc = ".$idsoc;
		if ($whereodt)
			$sql.= " AND ".$whereodt;
		$resql=$db->query($sql);

		if ($resql) {
			try {
				$num = $db->num_rows($resql);
				if ($nbOnODT > 0 && $num > $nbOnODT)
					$num = $nbOnODT;

				//print html_entity_decode($localHandler->__toString());
				if ($num) {
					$i = 0;
					require_once DOL_DOCUMENT_ROOT.'/comm/action/class/actioncomm.class.php';
					$actionstatic = new ActionComm($db);
					$listlines = $localHandler->setSegment('companyaction');
					// on boucle sur les contacts
					while ($i < $num) {
						$objp = $db->fetch_object($resql);
						$res_contact = $actionstatic->fetch($objp->id);

						$tmpline = get_substitutionarray_actions($actionstatic, $langs, 'companyaction');

						foreach ($tmpline as $key => $val) {
							//print "==".$key."))".$val.'<br>';
							try	{ $listlines->setVars($key, $val, true, 'UTF-8'); }
							catch(OdfException $e) {} // pour dsactiver cette erreur
							catch(SegmentException $e) {} // pour dsactiver cette erreur
						}
						$listlines->merge();
						$i++;
					}
					$localHandler->mergeSegment($listlines);
				}
			}
			catch(OdfException $e) {
				//print $e->getMessage();
				//$this->error=$e->getMessage();
				//dol_syslog($this->error, LOG_WARNING);
				//return -1;
			}
			catch(SegmentException $e) {
			} // pour dsactiver cette erreur
			
		} else {
			try {
				// on y passe en vidant les variables (action comm  vide
				require_once DOL_DOCUMENT_ROOT.'/comm/action/class/actioncomm.class.php';
				$actionstatic = new ActionComm($db);
				$listlines = $localHandler->setSegment('companyaction');
				$tmpline = get_substitutionarray_actions($actionstatic, $langs, 'companyaction');

				foreach ($tmpline as $key => $val) {
					try	{ 
						$listlines->setVars($key, $val, true, 'UTF-8'); 
					}
					catch(OdfException $e) {
					} // pour dsactiver cette erreur
					catch(SegmentException $e) {
					} // pour dsactiver cette erreur
				}
				$listlines->merge();
				$i++;

				$localHandler->mergeSegment($listlines);
			}
			catch(OdfException $e) {
				//print $e->getMessage();
				//$this->error=$e->getMessage();
				//dol_syslog($this->error, LOG_WARNING);
				//return -1;
			}
			catch(SegmentException $e) {
			} // pour dsactiver cette erreur
		}


		// selon la paramtrage de l'odt, on limite les enregistrements
		$nbOnODT = $conf->global->nbPropaleOnODT;
		$nb=$localHandler->getvalue("nbPropalOnODT");
		if ($nb)
			$nbOnODT = $nb;

		// Si il y a un filtrage supplmentaire sur l'action
		$whereodt=$conf->global->CondPropaleOnODT;
		$condodt=$localHandler->getvalue("CondPropalOnODT");
		if ($condodt)
			$whereodt=$condodt;

		$orderbyodt=$localHandler->getvalue("OrderPropalOnODT");

		$sql = "SELECT rowid FROM ".MAIN_DB_PREFIX."propal";
		$sql.= " WHERE fk_soc = ".$idsoc;
		if ($whereodt)
			$sql.= " AND ".$whereodt;
		if ($orderbyodt)
			$sql.= " ORDER BY ".$orderbyodt;

		$resql=$db->query($sql);

		if ($resql) {
			try {
				$num = $db->num_rows($resql);
				if ($nbOnODT > 0 && $num > $nbOnODT)
					$num = $nbOnODT;
				$i = 0;
				//print html_entity_decode($localHandler->__toString());

				require_once DOL_DOCUMENT_ROOT.'/comm/propal/class/propal.class.php';
				$objectstatic  = new Propal($db);
				$listlines = $localHandler->setSegment('companypropal');

				if ($num) {
					// on boucle sur les enregistrements
					while ($i < $num) {
						$objp = $db->fetch_object($resql);
						$res_contact = $objectstatic ->fetch($objp->rowid);
						$tmpline = $object->get_substitutionarray_object($objectstatic, $langs, 'companypropal');

						foreach ($tmpline as $key => $val) {
							try {
								$listlines->setVars($key, $val, true, 'UTF-8');
							}
							catch(OdfException $e) {
							} // pour dsactiver cette erreur
							catch(SegmentException $e) {
							} // pour dsactiver cette erreur
						}
						$listlines->merge();
						$i++;
					}
				} else {
					$tmpline = $object->get_substitutionarray_object($objectstatic, $langs, 'companypropal');
					foreach ($tmpline as $key => $val) {
						try {
							$listlines->setVars($key, $val, true, 'UTF-8');
						}
						catch(OdfException $e) {
						} // pour dsactiver cette erreur
						catch(SegmentException $e) {
						} // pour dsactiver cette erreur
					}
					$listlines->merge();
				}
				$localHandler->mergeSegment($listlines);
			}
			catch(OdfException $e) {
				//print $e->getMessage();
				//$this->error=$e->getMessage();
				//dol_syslog($this->error, LOG_WARNING);
				//return -1;
			}
			catch(SegmentException $e) {
			} // pour dsactiver cette erreur

		} else {
			try	{
				require_once DOL_DOCUMENT_ROOT.'/comm/propal/class/propal.class.php';
				$objectstatic  = new Propal($db);
				$listlines = $localHandler->setSegment('companypropal');
				// si pas de propale on cache le tableau
				$tmpline = $object->get_substitutionarray_object($objectstatic, $langs, 'companypropal');
				foreach ($tmpline as $key => $val) {
					try {
						$listlines->setVars($key, $val, true, 'UTF-8');
					}
					catch(OdfException $e) {
					} // pour dsactiver cette erreur
					catch(SegmentException $e) {
					} // pour dsactiver cette erreur
				}
				$listlines->merge();
				$localHandler->mergeSegment($listlines);
			}
			catch(OdfException $e) {
				//print $e->getMessage();
				//$this->error=$e->getMessage();
				//dol_syslog($this->error, LOG_WARNING);
				//return -1;
			}
			catch(SegmentException $e) {
			} // pour dsactiver cette erreur

		}


		// selon la paramtrage de l'odt, on limite les enregistrements
		$nbOnODT = $conf->global->nbOrderOnODT;
		$nb=$localHandler->getvalue("nbOrderOnODT");
		if ($nb)
			$nbOnODT = $nb;

		// Si il y a un filtrage supplmentaire sur l'action
		$whereodt=$conf->global->CondOrderOnODT;
		$condodt=$localHandler->getvalue("CondOrderOnODT");
		if ($condodt)
			$whereodt=$condodt;

		$orderbyodt=$localHandler->getvalue("OrderOrderOnODT");

		$sql = "SELECT rowid FROM ".MAIN_DB_PREFIX."commande";
		$sql.= " WHERE fk_soc = ".$idsoc;
		if ($whereodt)
			$sql.= " AND ".$whereodt;
		if ($orderbyodt)
			$sql.= " ORDER BY ".$orderbyodt;
		
		$resql=$db->query($sql);
		if ($resql) {
			try{
				$num = $db->num_rows($resql);
				if ($nbOnODT > 0 && $num > $nbOnODT)
					$num = $nbOnODT ;
				$i=0;
				//print html_entity_decode($localHandler->__toString());
				require_once DOL_DOCUMENT_ROOT.'/commande/class/commande.class.php';
				$objectstatic = new Commande($db);
				$listlines = $localHandler->setSegment('companyorder');
				
				if ($num) {
					// on boucle sur les enregistrements
					while ($i < $num) {
						$objp = $db->fetch_object($resql);
						$res_contact = $objectstatic->fetch($objp->rowid);
						$tmpline = $object->get_substitutionarray_object($objectstatic, $langs, 'companyorder');

						foreach ($tmpline as $key => $val) {
							try {
								$listlines->setVars($key, $val, true, 'UTF-8'); 
							}
							catch(OdfException $e) {
							} // pour dsactiver cette erreur
							catch(SegmentException $e) {
							} // pour dsactiver cette erreur
						}
						$listlines->merge();
						$i++;
					}
				} else {
					// on purge la liste
					$tmpline = $object->get_substitutionarray_object($objectstatic, $langs, 'companyorder');
					foreach ($tmpline as $key => $val) {
						try {
							$listlines->setVars($key, $val, true, 'UTF-8');
						}
						catch(OdfException $e) {
						} // pour dsactiver cette erreur
						catch(SegmentException $e) {
						} // pour dsactiver cette erreur
					}
					$listlines->merge();
					
				}
				$localHandler->mergeSegment($listlines);
			}
			catch(OdfException $e) {
				//print $e->getMessage();
				//$this->error=$e->getMessage();
				//dol_syslog($this->error, LOG_WARNING);
				//return -1;
			}
			catch(SegmentException $e) {
				} // pour dsactiver cette erreur
		} else {
			// si on ne trouve rien on affiche rien
			try {
				require_once DOL_DOCUMENT_ROOT.'/commande/class/commande.class.php';
				$objectstatic = new Commande($db);
				$listlines = $localHandler->setSegment('companyorder');
				// si pas de propale on cache le tableau
				$tmpline = $object->get_substitutionarray_object($objectstatic, $langs, 'companyorder');
				foreach ($tmpline as $key => $val) {
					try	{ 
						$listlines->setVars($key, $val, true, 'UTF-8'); 
					}
					catch(OdfException $e) {
					} // pour dsactiver cette erreur
					catch(SegmentException $e) {
					} // pour dsactiver cette erreur
				}
				$listlines->merge();
				$localHandler->mergeSegment($listlines);
			}
			catch(OdfException $e) {
				//print $e->getMessage();
				//$this->error=$e->getMessage();
				//dol_syslog($this->error, LOG_WARNING);
				//return -1;
			}
			catch(SegmentException $e) {
			} // pour dsactiver cette erreur

		}


		// selon la paramtrage de l'odt, on limite les enregistrements
		$nbOnODT = $conf->global->nbBillOnODT;
		$nb=$localHandler->getvalue("nbBillOnODT");
		if ($nb)
			$nbOnODT = $nb;

		// Si il y a un filtrage supplmentaire sur l'action
		$whereodt=$conf->global->CondBillOnODT;
		$condodt=$localHandler->getvalue("CondBillOnODT");
		if ($condodt)
			$whereodt=$condodt;

		$orderbyodt=$localHandler->getvalue("OrderBillOnODT");


		$sql = "SELECT rowid FROM ".MAIN_DB_PREFIX."facture";
		$sql.= " WHERE fk_soc = ".$idsoc;
		if ($whereodt) 
			$sql.= " AND ".$whereodt;
		if ($orderbyodt)
			$sql.= " ORDER BY ".$orderbyodt;

		$resql=$db->query($sql);
		if ($resql) {
			try {
				$num = $db->num_rows($resql);
				if ($nbOnODT > 0 && $num > $nbOnODT)
					$num = $nbOnODT ;

				$i = 0;
				require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
				$objectstatic = new Facture($db);
				$listlines = $localHandler->setSegment('companybill');
				
				//print html_entity_decode($localHandler->__toString());
				if ($num) {
					// on boucle sur les enregistrements
					while ($i < $num) {
						$objp = $db->fetch_object($resql);
						$res_contact = $objectstatic->fetch($objp->rowid);
						$tmpline = $object->get_substitutionarray_object($objectstatic, $langs, 'companybill');

						foreach ($tmpline as $key => $val) {
							try	{ 
								$listlines->setVars($key, $val, true, 'UTF-8'); 
							}
							catch(OdfException $e) {
							} // pour dsactiver cette erreur
							catch(SegmentException $e) {
							} // pour dsactiver cette erreur
						}
						$listlines->merge();
						$i++;
					}
				} else {
					// on purge la liste
					$tmpline = $object->get_substitutionarray_object($objectstatic, $langs, 'companybill');
					foreach ($tmpline as $key => $val) {
						try {
							$listlines->setVars($key, $val, true, 'UTF-8');
						}
						catch(OdfException $e) {
						} // pour dsactiver cette erreur
						catch(SegmentException $e) {
						} // pour dsactiver cette erreur
					}
					$listlines->merge();
				}
				$localHandler->mergeSegment($listlines);
			}
			catch(OdfException $e) {
				//print $e->getMessage();
				//$this->error=$e->getMessage();
				//dol_syslog($this->error, LOG_WARNING);
				//return -1;
			}
			catch(SegmentException $e) {
			} // pour dsactiver cette erreur
		} else {
			try {
				require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
				$objectstatic = new Facture($db);
				$listlines = $localHandler->setSegment('companybill');
				// si pas de propale on cache le tableau
				$tmpline = $object->get_substitutionarray_object($objectstatic, $langs, 'companybill');
				foreach ($tmpline as $key => $val) {
					try	{ $listlines->setVars($key, $val, true, 'UTF-8'); }
					catch(OdfException $e) {
					} // pour dsactiver cette erreur
					catch(SegmentException $e) {
					} // pour dsactiver cette erreur
				}
				$listlines->merge();
				$localHandler->mergeSegment($listlines);
			}
			catch(OdfException $e) {
				//print $e->getMessage();
				//$this->error=$e->getMessage();
				//dol_syslog($this->error, LOG_WARNING);
				//return -1;
			}
			catch(SegmentException $e) {
			} // pour dsactiver cette erreur
		}


		// selon le paramtrage de l'odt, on limite les enregistrements
		$nbOnODT = $conf->global->nbSupplierOrderOnODT;
		$nb=$localHandler->getvalue("nbSupplierOrderOnODT");
		if ($nb)
			$nbOnODT = $nb;

		// Si il y a un filtrage supplmentaire sur l'action
		$whereodt=$conf->global->CondSupplierOrderOnODT;
		$condodt=$localHandler->getvalue("CondSupplierOrderOnODT");
		if ($condodt)
			$whereodt=$condodt;

		$sql = "SELECT rowid FROM ".MAIN_DB_PREFIX."commande_fournisseur";
		$sql.= " WHERE fk_soc = ".$idsoc;
		if ($whereodt)
			$sql.= " AND ".$whereodt;
		$resql=$db->query($sql);
		if ($resql) {
			try {
				$num = $db->num_rows($resql);
				if ($nbOnODT > 0 && $num > $nbOnODT)
					$num = $nbOnODT ;
				$i=0;
				require_once DOL_DOCUMENT_ROOT.'/fourn/class/fournisseur.commande.class.php';
				$objectstatic = new CommandeFournisseur($db);
				$listlines = $localHandler->setSegment('companysupplierorder');

				//print html_entity_decode($localHandler->__toString());
				if ($num) {
					// on boucle sur les enregistrements
					while ($i < $num) {
						$objp = $db->fetch_object($resql);
						$res_contact = $objectstatic->fetch($objp->rowid);
						$tmpline = $object->get_substitutionarray_object($objectstatic, $langs, 'companysupplierorder');

						foreach ($tmpline as $key => $val) {
							try	{
								$listlines->setVars($key, $val, true, 'UTF-8');
							}
							catch(OdfException $e) {
							} // pour dsactiver cette erreur
							catch(SegmentException $e) {
							} // pour dsactiver cette erreur
						}
						$listlines->merge();
						$i++;
					}
				} else {
					// on purge la liste
					$tmpline = $object->get_substitutionarray_object($objectstatic, $langs, 'companysupplierorder');
					foreach ($tmpline as $key => $val) {
						try {
							$listlines->setVars($key, $val, true, 'UTF-8');
						}
						catch(OdfException $e) {
						} // pour dsactiver cette erreur
						catch(SegmentException $e) {
						} // pour dsactiver cette erreur
					}
					$listlines->merge();
				}
				$localHandler->mergeSegment($listlines);
			}
			catch(OdfException $e) {
				//print $e->getMessage();
				//$this->error=$e->getMessage();
				//dol_syslog($this->error, LOG_WARNING);
				//return -1;
			}
			catch(SegmentException $e) {
			} // pour dsactiver cette erreur
		} else {
			try	{
				require_once DOL_DOCUMENT_ROOT.'/fourn/class/fournisseur.commande.class.php';
				$objectstatic = new CommandeFournisseur($db);
				$listlines = $localHandler->setSegment('companysupplierorder');
				// si pas de propale on cache le tableau
				$tmpline = $object->get_substitutionarray_object($objectstatic, $langs, 'companysupplierorder');
				foreach ($tmpline as $key => $val) {
					try	{ $listlines->setVars($key, $val, true, 'UTF-8'); }
					catch(OdfException $e) {
					} // pour dsactiver cette erreur
					catch(SegmentException $e) {
					} // pour dsactiver cette erreur
				}
				$listlines->merge();
				$localHandler->mergeSegment($listlines);
			}
			catch(OdfException $e) {
				//print $e->getMessage();
				//$this->error=$e->getMessage();
				//dol_syslog($this->error, LOG_WARNING);
				//return -1;
			}
			catch(SegmentException $e) {
			} // pour dsactiver cette erreur
		}

		// selon la paramtrage de l'odt, on limite les enregistrements
		$nbOnODT = $conf->global->nbSupplierBillOnODT;
		$nb=$localHandler->getvalue("nbSupplierBillOnODT");
		if ($nb)
			$nbOnODT = $nb;

		// Si il y a un filtrage supplmentaire sur l'action
		$whereodt=$conf->global->CondSupplierBillOnODT;
		$condodt=$localHandler->getvalue("CondSupplierBillOnODT");
		if ($condodt)
			$whereodt=$condodt;

		$sql = "SELECT rowid FROM ".MAIN_DB_PREFIX."facture_fourn";
		$sql.= " WHERE fk_soc = ".$idsoc;
		if ($whereodt)
			$sql.= " AND ".$whereodt;
		$resql=$db->query($sql);
		if ($resql) {
			try {
				$num = $db->num_rows($resql);
				if ($nbOnODT > 0 && $num > $nbOnODT)
					$num = $nbOnODT ;
				$i = 0;

				//print html_entity_decode($localHandler->__toString());
				if ($num) {
					require_once DOL_DOCUMENT_ROOT.'/fourn/class/fournisseur.facture.class.php';
					$objectstatic = new FactureFournisseur($db);
					$listlines = $localHandler->setSegment('companysupplierbill');
					// on boucle sur les enregistrements
					while ($i < $num) {
						$objp = $db->fetch_object($resql);
						$res_contact = $objectstatic->fetch($objp->rowid);
						$tmpline = $object->get_substitutionarray_object($objectstatic, $langs, 'companysupplierbill');

						foreach ($tmpline as $key => $val) {
							try	{
								$listlines->setVars($key, $val, true, 'UTF-8');
							}
							catch(OdfException $e) {
							} // pour dsactiver cette erreur
							catch(SegmentException $e) {
							} // pour dsactiver cette erreur
						}
						$listlines->merge();
						$i++;
					}
					$localHandler->mergeSegment($listlines);
				}
			}
			catch(OdfException $e) {
				//print $e->getMessage();
				//$this->error=$e->getMessage();
				//dol_syslog($this->error, LOG_WARNING);
				//return -1;
			}
			catch(SegmentException $e) {
			} // pour dsactiver cette erreur
		} else {
			try {
				require_once DOL_DOCUMENT_ROOT.'/fourn/class/fournisseur.facture.class.php';
				$objectstatic = new FactureFournisseur($db);
				$listlines = $localHandler->setSegment('companysupplierbill');
				// si pas de propale on cache le tableau
				$tmpline = $object->get_substitutionarray_object($objectstatic, $langs, 'companysupplierbill');
				foreach ($tmpline as $key => $val) {
					try	{ $listlines->setVars($key, $val, true, 'UTF-8'); }
					catch(OdfException $e) {
					} // pour dsactiver cette erreur
					catch(SegmentException $e) {
					} // pour dsactiver cette erreur
				}
				$listlines->merge();
				$localHandler->mergeSegment($listlines);
			}
			catch(OdfException $e) {
				//print $e->getMessage();
				//$this->error=$e->getMessage();
				//dol_syslog($this->error, LOG_WARNING);
				//return -1;
			}
			catch(SegmentException $e) {
			} // pour dsactiver cette erreur

		}

		if ($parameters['object']->element=='facture') {

			// rglement des factures
			$sql = "SELECT p.rowid ";
			$sql.= " FROM ".MAIN_DB_PREFIX."paiement as p, ".MAIN_DB_PREFIX."paiement_facture as pf";
			$sql.= " WHERE p.rowid = pf.fk_paiement";
			$sql.= " AND pf.fk_facture=".$parameters['object']->id;

			$resql=$db->query($sql);
			if ($resql) {
				try {

					$num = $db->num_rows($resql);
					$i = 0;

					//print html_entity_decode($localHandler->__toString());
					if ($num > 0) {
						require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
						$objectstatic = new Paiement($db);

						$listlines = $localHandler->setSegment('paiements');

						// on boucle sur les enregistrements
						while ($i < $num) {
							$objp = $db->fetch_object($resql);
							$res_contact = $objectstatic->fetch($objp->rowid);
							$tmpline = get_substitutionarray_paiement($objectstatic, $langs, 'paiement');

							foreach ($tmpline as $key => $val) {
								try	{
									$listlines->setVars($key, $val, true, 'UTF-8');
								}
								catch(OdfException $e) {
								} // pour dsactiver cette erreur
								catch(SegmentException $e) {
								} // pour dsactiver cette erreur
							}
							$listlines->merge();
							$i++;
						}
						$localHandler->mergeSegment($listlines);
					}
				}
				catch(OdfException $e) {
					print $e->getMessage();
					//$this->error=$e->getMessage();
					//dol_syslog($this->error, LOG_WARNING);
					//return -1;
				}
				catch(SegmentException $e) {
				} // pour dsactiver cette erreur
			} else {
			// pour grer l'absence de rglements
			try {
				require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
				$objectstatic = new Paiement($db);
				$listlines = $localHandler->setSegment('paiements');
				// si pas de reglement on cache le tableau
				$tmpline = $object->get_substitutionarray_reglements($objectstatic, $langs, 'paiement');
				foreach ($tmpline as $key => $val) {
					try	{ $listlines->setVars($key, $val, true, 'UTF-8'); }
					catch(OdfException $e) {
					} // pour dsactiver cette erreur
					catch(SegmentException $e) {
					} // pour dsactiver cette erreur
				}
				$listlines->merge();
				$localHandler->mergeSegment($listlines);
			}
			catch(OdfException $e) {
				//print $e->getMessage();
				//$this->error=$e->getMessage();
				//dol_syslog($this->error, LOG_WARNING);
				//return -1;
			}
			catch(SegmentException $e) {
			} // pour dsactiver cette erreur

		}
	}

		return 0;
	}
	
		/** Overloading the doActions function : replacing the parent's function with the one below 
	 *  @param	  parameters  meta datas of the hook (context, etc...) 
	 *  @param	  object			 the object you want to process (an invoice if you are in invoice module, a propale in propale's module, etc...) 
	 *  @param	  action			 current action (if set). Generally create or edit or null 
	 *  @return	   void 
	 */
	function ODTSubstitution($parameters, $object, $action) 
	{
		global $conf, $langs, $db;

		$localArray = $parameters['substitutionarray'];
		$localHandler = $parameters['odfHandler'];

		// if no localhandler (first call of odtsubstitution, we do nothing
		if ($localHandler) {
			// Replace variables into document
			foreach ($localArray as $key => $value)
				$tmptag.= $key." = ".$value."\n";

			try {
				$localHandler->setVars("odt_show_all_tags", $tmptag, true, 'UTF-8');
			}
			catch(OdfException $e)	{
				}	// setVars failed, probably because key not found
			catch(SegmentException $e) {
				} // pour dsactiver cette erreur
		}

		return 0;
	}
	
	/** Add some function on builddoc
	 *  @param	  parameters  meta datas of the hook (context, etc...) 
	 *  @param	  object			 the object you want to process (an invoice if you are in invoice module, a propale in propale's module, etc...) 
	 *  @param	  action			 current action (if set). Generally create or edit or null 
	 *  @return	   void 
	 */	
	function formBuilddocOptions($parameters, $object, $action) 
	{
		global $langs, $conf, $user;
		if ($object->element == "product") {
			$langs->load("extraodt@extraodt");

			$showinfo = '<tr class="liste_titre">';
			$showinfo.= '<th>'.$langs->trans("SelectDisplayInfoList").'</th>';
			$showinfo.= '<th colspan=3 align=center><select name=displaylist>';
			$checked = GETPOST("displaylist") == "displaypriceinfo" ? " checked=checked " : "";
			$showinfo.= '<option value="displaypriceinfo"  >'.$langs->trans("DisplayPriceInfo").'</option>';

			$checked = GETPOST("displaylist") =="displaystockinfo" ? " checked=checked " : "";
			$showinfo.= '<option value="displaypriceinfo"  >'.$langs->trans("DisplayStockInfo").'</option>';
			if ($conf->global->MAIN_MODULE_FACTORY) {
				$checked = GETPOST("displaylist") == "displayfactoryinfo" ? " checked=checked " : "";
				$showinfo.= '<option value="displayfactoryinfo"  >'.$langs->trans("DisplayFactoryInfo").'</option>';
			}
			if ($conf->global->MAIN_MODULE_EQUIPEMENT) {
				$checked = GETPOST("displaylist") == "displayequipementinfo" ? " checked=checked " : "";
				$showinfo.= '<option value="displayequipementinfo"  >'.$langs->trans("DisplayEquipementInfo").'</option>';
			}
			$showinfo.= '</select></th></tr>';
			return $showinfo;
		} else
			return 0;
	}
}

function get_substitutionarray_actions($object, $outputlangs, $array_key = 'object')
{
	global $db, $conf;
	$usertodo=new User($db);
	require_once DOL_DOCUMENT_ROOT . '/contact/class/contact.class.php';
	$socpeople=new Contact($db);
	if ($object->contactid > 0)
		$socpeople->fetch($object->contactid);

	$array_action = array (
	$array_key . '_code' 		=> $object->code,
	$array_key . '_label' 		=> $object->label,
	$array_key . '_datep'		=> dol_print_date($object->datep, 'day', false, $outputlangs),
	$array_key . '_datep2'		=> dol_print_date($object->datep2, 'day', false, $outputlangs),
	$array_key . '_datea'		=> dol_print_date($object->datea, 'day', false, $outputlangs),
	$array_key . '_datea2'		=> dol_print_date($object->datea2, 'day', false, $outputlangs),
	$array_key . '_percent'		=>($object->percent?$object->percent.'%':''),
	$array_key . '_note' 		=> $object->note,
	$array_key . '_location' 	=> $object->location,
	$array_key . '_durationa' 	=> $object->durationa,
	$array_key . '_socpeople' 	=> $socpeople->firstname." ".$socpeople->lastname,
	$array_key . '_durationp' 	=> $object->durationp,
	$array_key . '_punctual' 	=> $object->punctual,
	$array_key . '_priority' 	=> $object->priority,
	$array_key . '_elementtype' => $object->elementtype
//	$array_key . '_usertodo' 	=> $usertodo->firstname." ".$usertodo->lastname
	);
	
	// Retrieve extrafields
	if (is_array($object->array_options) && count($object->array_options)) {
		$extrafieldkey=$object->element;

		require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
		$extrafields = new ExtraFields($db);
		$extralabels = $extrafields->fetch_name_optionals_label($extrafieldkey, true);
		$object->fetch_optionals($object->id, $extralabels);

		$array_action = $object->fill_substitutionarray_with_extrafields(
						$object, $array_action, $extrafields,
						$array_key = $array_key, $outputlangs
		);
	}
	
	return $array_action;
}

function get_substitutionarray_paiement($object, $outputlangs, $array_key = 'object')
{
	global $db, $conf;

	$array_paiement = array (
					$array_key . '_ref' 		=> $object->ref,
					$array_key . '_label' 		=> $object->date,
					$array_key . '_datepaye'	=> dol_print_date($object->datepaye, 'day', false, $outputlangs),
					$array_key . '_numero' 		=> $object->numero,
					$array_key . '_amount'		=> price($object->amount),
					$array_key . '_type_libelle'	=> $object->type_libelle,
					$array_key . '_statut'		=> $object->statut,
					$array_key . '_bank_line' 	=> $object->bank_line
	);
	
	require_once DOL_DOCUMENT_ROOT . '/compta/bank/class/account.class.php';
	$bankstatic=new AccountLine($db);
	if ($object->bank_line > 0) {
		$bankstatic->fetch($object->bank_line);
		$array_paiement_bank = array (

						$array_key . '_bank_ref' 	=> $bankstatic->bank_account_ref,
						$array_key . '_bank_label' 	=> $bankstatic->bank_account_label,
						$array_key . '_num_releve' 	=> $bankstatic->num_releve,
						$array_key . '_num_chq' 	=> $bankstatic->num_chq,
						$array_key . '_bank_chq' 	=> $bankstatic->bank_chq,
						$array_key . '_fk_type' 	=> $bankstatic->fk_type
		);
		$array_paiement=array_merge($array_paiement, $array_paiement_bank);
	}

	return $array_paiement;
}
