<?php
/* Copyright (C) 2014-2017		Charlene BENKE	<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  \file	   htdocs/extraodt/admin/setup.php
 *  \ingroup	extraodt
 *  \brief	  Page d'administration-configuration du module extraodt
 */

$res=0;
if (! $res && file_exists("../../main.inc.php")) 
	$res=@include("../../main.inc.php");					// For root directory
if (! $res && file_exists("../../../main.inc.php")) 
	$res=@include("../../../main.inc.php");	// For "custom" directory

dol_include_once("/extraodt/core/lib/extraodt.lib.php");
require_once(DOL_DOCUMENT_ROOT."/core/lib/admin.lib.php");
require_once(DOL_DOCUMENT_ROOT."/core/class/html.formadmin.class.php");
require_once(DOL_DOCUMENT_ROOT."/core/class/html.form.class.php");
require_once(DOL_DOCUMENT_ROOT."/core/class/html.formother.class.php");

$langs->load("admin");
$langs->load("other");
$langs->load("extraodt@extraodt");

// Security check
if (! $user->admin || $user->design) accessforbidden();

$action = GETPOST('action', 'alpha');

/*
 * Actions
 */

if ($action == 'setvalue') {
	// on ajoute des \ devant les dollars
	// save the setting
	dolibarr_set_const($db, "nbActionOnODT", GETPOST('nbActionOnODT', 'text'), 'chaine', 0, '', $conf->entity);
	dolibarr_set_const($db, "nbPropaleOnODT", GETPOST('nbPropaleOnODT', 'text'), 'chaine', 0, '', $conf->entity);
	dolibarr_set_const($db, "nbOrderOnODT", GETPOST('nbOrderOnODT', 'text'), 'chaine', 0, '', $conf->entity);
	dolibarr_set_const($db, "nbBillOnODT", GETPOST('nbBillOnODT', 'text'), 'chaine', 0, '', $conf->entity);
	dolibarr_set_const(
					$db, "nbSupplierOrderOnODT", GETPOST('nbSupplierOrderOnODT', 'text'), 
					'chaine', 0, '', $conf->entity
	);
	dolibarr_set_const($db, "nbSupplierBillOnODT", GETPOST('nbSupplierBillOnODT', 'text'), 'chaine', 0, '', $conf->entity);

	dolibarr_set_const($db, "CondActionOnODT", GETPOST('CondActionOnODT', 'text'), 'chaine', 0, '', $conf->entity);
	dolibarr_set_const($db, "CondPropaleOnODT", GETPOST('CondPropaleOnODT', 'text'), 'chaine', 0, '', $conf->entity);
	dolibarr_set_const($db, "CondOrderOnODT", GETPOST('CondOrderOnODT', 'text'), 'chaine', 0, '', $conf->entity);
	dolibarr_set_const($db, "CondBillOnODT", GETPOST('CondBillOnODT', 'text'), 'chaine', 0, '', $conf->entity);
	dolibarr_set_const(
					$db, "CondSupplierOrderOnODT", GETPOST('CondSupplierOrderOnODT', 'text'), 
					'chaine', 0, '', $conf->entity
	);
	dolibarr_set_const(
					$db, "CondSupplierBillOnODT", GETPOST('CondSupplierBillOnODT', 'text'), 
					'chaine', 0, '', $conf->entity
	);

	$mesg = "<font class='ok'>".$langs->trans("SetupSaved")."</font>";
}

/*
 * View
 */

$page_name = $langs->trans("ExtraODTSetup") . ' - '.$langs->trans("extraodtGeneralSetting");
llxHeader('', $page_name);

$linkback='<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
print_fiche_titre($page_name, $linkback, 'title_setup');


$nbActionOnODT=$conf->global->nbActionOnODT;
$nbPropaleOnODT=$conf->global->nbPropaleOnODT;
$nbOrderOnODT=$conf->global->nbOrderOnODT;
$nbBillOnODT=$conf->global->nbBillOnODT;
$nbSupplierOrderOnODT=$conf->global->nbSupplierOrderOnODT;
$nbSuplierBillOnODT=$conf->global->nbSuplierBillOnODT;

$condActionOnODT=$conf->global->CondActionOnODT;
$condPropaleOnODT=$conf->global->CondPropaleOnODT;
$condOrderOnODT=$conf->global->CondOrderOnODT;
$condBillOnODT=$conf->global->CondBillOnODT;
$condSupplierOrderOnODT=$conf->global->CondSupplierOrderOnODT;
$condSuplierBillOnODT=$conf->global->CondSuplierBillOnODT;


$head = extraodt_admin_prepare_head();

dol_fiche_head($head, 'setup', $langs->trans("Extraodt"), 0, "extraodt@extraodt");

print_titre($langs->trans("ExtraODTLimitValue"));
print '<br>';
print '<form method="post" action="setup.php">';
print '<input type="hidden" name="action" value="setvalue">';
print '<table class="noborder" >';
print '<tr class="liste_titre">';
print '<td width=20% align=left>'.$langs->trans("Parameters").'</td>';
print '<td width=10% align=left>'.$langs->trans("LimitValues").'</td>';
print '<td align=left>'.$langs->trans("FilterValues").'</td>';

print '</tr>'."\n";
print '<tr >';
print '<td align=left valign=top>'.$langs->trans("ActionOnODT").'</td>';
print '<td align=left valign=top><input type=text size=3 name=nbActionOnODT value="'.$nbActionOnODT.'"></td>';
print '<td align=left valign=top><textarea name=CondActionOnODT rows=2 cols=60>'.$condActionOnODT.'</textarea></td>';
print '</tr>'."\n";
print '<tr><td colspan=3><hr></td></tr>'."\n";
print '<tr >';
print '<td align=left valign=top >'.$langs->trans("PropalOnODT").'</td>';
print '<td align=left valign=top ><input type=text size=3 name=nbPropaleOnODT value="'.$nbPropaleOnODT.'"></td>';
print '<td align=left valign=top><textarea name=CondPropaleOnODT rows=2 cols=60>'.$condPropaleOnODT.'</textarea></td>';
print '</tr>'."\n";
print '<tr >';
print '<td align=left valign=top >'.$langs->trans("OrderOnODT").'</td>';
print '<td align=left valign=top ><input type=text size=3 name=nbOrderOnODT value="'.$nbOrderOnODT.'"></td>';
print '<td align=left valign=top><textarea name=CondOrderOnODT rows=2 cols=60>'.$condOrderOnODT.'</textarea></td>';
print '</tr>'."\n";
print '<tr >';
print '<td align=left valign=top >'.$langs->trans("BillOnODT").'</td>';
print '<td align=left valign=top ><input type=text size=3 name=nbBillOnODT value="'.$nbBillOnODT.'"></td>';
print '<td align=left valign=top><textarea name=CondBillOnODT rows=2 cols=60>'.$condBillOnODT.'</textarea></td>';
print '</tr>'."\n";
print '<tr><td colspan=3><hr></td></tr>'."\n";
print '<tr >';
print '<td align=left valign=top >'.$langs->trans("SupplierOrderOnODT").'</td>';
print '<td align=left valign=top >';
print '<input type=text size=3 name=nbSupplierOrderOnODT value="'.$nbSupplierOrderOnODT.'"></td>';
print '<td align=left valign=top>';
print '<textarea name=CondSupplierOrderOnODT rows=2 cols=60>'.$condSupplierOrderOnODT.'</textarea></td>';
print '</tr>'."\n";
print '<tr >';
print '<td align=left valign=top >'.$langs->trans("SupplierBillOnODT").'</td>';
print '<td align=left valign=top >';
print '<input type=text size=3 name=nbSupplierBillOnODT value="'.$nbSupplierBillOnODT.'"></td>';
print '<td align=left valign=top>';
print '<textarea name=CondSupplierBillOnODT rows=2 cols=60>'.$condSupplierBillOnODT.'</textarea></td>';
print '</tr>'."\n";

print '<tr ><td>';
// Boutons d'action
print '<div class="tabsAction">';
print '<input type="submit" class="button" value="'.$langs->trans("Modify").'">';
print '</div>';
print '</td></tr>'."\n";
print '</table>';
print '</form>';
// Show errors
dol_htmloutput_errors($object->error, $object->errors);

/*
 *  Infos pour le support
 */
print '<br>';
libxml_use_internal_errors(true);
$sxe = simplexml_load_string(nl2br(file_get_contents('../changelog.xml')));
if ($sxe === false) {
	echo "Erreur lors du chargement du XML\n";
	foreach (libxml_get_errors() as $error) 
		print $error->message;
	exit;
} else
	$tblversions=$sxe->Version;

$currentversion = $tblversions[count($tblversions)-1];

print '<table class="noborder" width="100%">'."\n";
print '<tr class="liste_titre">'."\n";
print '<td width=20%>'.$langs->trans("SupportModuleInformation").'</td>'."\n";
print '<td>'.$langs->trans("Value").'</td>'."\n";
print "</tr>\n";
print '<tr '.$bc[false].'><td >'.$langs->trans("DolibarrVersion").'</td><td>'.DOL_VERSION.'</td></tr>'."\n";
print '<tr '.$bc[true].'><td >'.$langs->trans("ModuleVersion").'</td>';
print '<td>'.$currentversion->attributes()->Number." (".$currentversion->attributes()->MonthVersion.')</td></tr>'."\n";
print '<tr '.$bc[false].'><td >'.$langs->trans("PHPVersion").'</td><td>'.version_php().'</td></tr>'."\n";
print '<tr '.$bc[true].'><td >'.$langs->trans("DatabaseVersion").'</td>';
print '<td>'.$db::LABEL." ".$db->getVersion().'</td></tr>'."\n";
print '<tr '.$bc[false].'><td >'.$langs->trans("WebServerVersion").'</td>';
print '<td>'.$_SERVER["SERVER_SOFTWARE"].'</td></tr>'."\n";
print '<tr>'."\n";
print '<td colspan="2">'.$langs->trans("SupportModuleInformationDesc").'</td></tr>'."\n";
print "</table>\n";

// Show messages
dol_htmloutput_mesg($object->mesg, '', 'ok');

// Footer
llxFooter();
$db->close();