<?php

// Load Dolibase
dol_include_once('/externalsitepro/autoload.php');

// Load Dolibase Module class
dolibase_include_once('/core/class/module.php');

// Load Dolibase QueryBuilder class
dolibase_include_once('/core/class/query_builder.php');

// Load Dolibarr files lib
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';

// Load object class
dol_include_once('/externalsitepro/class/externalsite.class.php');

/**
 *	Class to describe and enable module
 */
class modExternalSitePro extends DolibaseModule
{
	/**
	 * Function called after module configuration.
	 * 
	 */
	public function loadSettings()
	{
		// Update picto for Dolibarr 12++
		if (function_exists('version_compare') && version_compare(DOL_VERSION, '12.0.0') >= 0) {
			$this->picto = "website_128.png@externalsitepro";
		}

		// Permissions
		$this->addPermission("read", "See External Websites", "r");

		// CSS files
		$this->addCssFile('icons.css.php');
	}

	/**
	 * Function called when module is enabled.
	 * The init function add constants, boxes, permissions and menus
	 * (defined in constructor) into Dolibarr database.
	 * It also creates data directories
	 *
	 * @param string $options Options when enabling module ('', 'noboxes')
	 * @return int 1 if OK, 0 if KO
	 */
	public function init($options = '')
	{
		// Allow module for external users (only if not already enabled)
		global $conf;

		// if (strpos($conf->global->MAIN_MODULES_FOR_EXTERNAL, 'externalsitepro') === false) {
		// 	//include_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
		// 	dolibarr_set_const($this->db, 'MAIN_MODULES_FOR_EXTERNAL', $conf->global->MAIN_MODULES_FOR_EXTERNAL.',externalsitepro', 'chaine', 1, '', $conf->entity);
		// }

		$result = parent::init($options);

		// Copy icons
		$srcdir = dol_buildpath('externalsitepro/img/icons');
		$destdir = DOL_DATA_ROOT.'/externalsitepro/icons/';
		dolCopyDir($srcdir, $destdir, $conf->global->MAIN_UMASK, 0);

		return $result;
	}

	/**
	 * Create tables, keys and data required by module
	 * Files llx_table1.sql, llx_table1.key.sql llx_data.sql with create table, create keys
	 * and create data commands must be stored in directory /mymodule/sql/
	 * This function is called by this->init
	 *
	 * @return int <=0 if KO, >0 if OK
	 */
	protected function loadTables()
	{
		$result = parent::loadTables();

		// Init object
		$externalsite = new ExternalSite();

		// Fetch enabled external sites
		foreach (QueryBuilder::getInstance()->select($externalsite->fetch_fields)->from($externalsite->table_element)->where('status = 1')->orderBy('position', 'ASC')->result() as $row)
		{
			// Add external sites menus
			$url = ($row->standalone ? $row->url : '/externalsitepro/frames.php?wsid='.$row->rowid);
			$this->addTopMenu('externalsitepro website'.$row->rowid, $row->label, $url, '$user->rights->externalsitepro->read', '$conf->externalsitepro->enabled', $row->position, ($row->target_blank == 1 ? '_blank' : ''));
		}

		return $result;
	}
}
