<?php

// Load Dolibase
include_once '../autoload.php';

// Load Dolibase SetupPage class
dolibase_include_once('/core/pages/setup.php');

// Load object class
dol_include_once('/externalsitepro/class/externalsite.class.php');

// Load Dolibase QueryBuilder class
dolibase_include_once('/core/class/query_builder.php');

// Load files & images lib
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';

// Create Setup Page using Dolibase
$page = new SetupPage('Setup', '$user->admin', true);

// Get parameters
$action = GETPOST('action', 'alpha');
$confirm = GETPOST('confirm', 'alpha');
$id = GETPOST('id', 'int');
$label = GETPOST('label');
$url = GETPOST('url');
//$icon = GETPOST('icon');
$position = GETPOST('position');
$target_blank = GETPOST('target_blank', 'int');
$standalone = GETPOST('standalone', 'int');

global $langs, $conf;

// Init object
$externalsites = new ExternalSite();

// Set fields
$fields[] = new Field('label', 'WebSiteLabel', 'required');
$fields[] = new Field('url', 'WebSiteUrl', 'required');
$page->setFields($fields);

// Set actions ---

// Add
if ($action == 'add' && $page->checkFields())
{
	if (! preg_match('/^(http|https):\/\//', $url)) {
		$url = 'https://'.$url;
	}

	// Check for duplicate url
	$externalsites->fetchWhere("url = '".$url."'");

	if (count($externalsites->rows) > 0)
	{
		setEventMessage($langs->trans('UrlAlreadyExists'), 'errors');
	}
	else
	{
		$error = 0;

		// Upload icon
		$icon = '';
		$varforimage = 'icon';
		$dirforimage = $conf->externalsitepro->dir_output.'/icons/';
		if ($_FILES[$varforimage]["tmp_name"])
		{
			if (preg_match('/([^\\/:]+)$/i', $_FILES[$varforimage]["name"], $reg))
			{
				$original_file = $reg[1];

				$isimage = image_format_supported($original_file);
				if ($isimage >= 0)
				{
					dol_syslog("Move file ".$_FILES[$varforimage]["tmp_name"]." to ".$dirforimage.$original_file);
					if (! is_dir($dirforimage))
					{
						dol_mkdir($dirforimage);
					}
					$result = dol_move_uploaded_file($_FILES[$varforimage]["tmp_name"], $dirforimage.$original_file, 1, 0, $_FILES[$varforimage]['error']);
					if ($result > 0)
					{
						$icon = $original_file;
					}
					else if (preg_match('/^ErrorFileIsInfectedWithAVirus/',$result))
					{
						$error++;
						$langs->load("errors");
						$tmparray = explode(':', $result);
						setEventMessages($langs->trans('ErrorFileIsInfectedWithAVirus',$tmparray[1]), null, 'errors');
					}
					else
					{
						$error++;
						setEventMessages($langs->trans("ErrorFailedToSaveFile"), null, 'errors');
					}
				}
				else
				{
					$error++;
					$langs->load("errors");
					setEventMessages($langs->trans("ErrorBadImageFormat"), null, 'errors');
				}
			}
		}

		// Add website
		if (! $error)
		{
			$data = array(
				'label' => str_escape($label),
				'url' => str_escape($url),
				'position' => $position,
				'target_blank' => $target_blank,
				'standalone' => str_escape($standalone),
				'status' => 1
			);

			if (! empty($icon)) {
				$data['icon'] = str_escape($icon);
			}

			$id = $externalsites->add($data);

			if ($id > 0) {
				// Creation OK
				setEventMessage($langs->trans('WebSiteAddSuccess'), 'mesgs');
				dolibase_redirect($_SERVER['PHP_SELF']);
			}
		}
	}
}

// Update
else if ($action == 'update' && $id > 0)
{
	if ($page->checkFields())
	{
		if (! preg_match('/^(http|https):\/\//', $url)) {
			$url = 'https://'.$url;
		}

		// Check for duplicate url
		$externalsites->fetchWhere("url = '".$url."' AND rowid != ".$id);

		if (count($externalsites->rows) > 0)
		{
			setEventMessage($langs->trans('UrlAlreadyExists'), 'errors');
			$action = 'edit';
		}
		else
		{
			$error = 0;

			// Upload icon
			$icon = '';
			$varforimage = 'icon';
			$dirforimage = $conf->externalsitepro->dir_output.'/icons/';
			if ($_FILES[$varforimage]["tmp_name"])
			{
				if (preg_match('/([^\\/:]+)$/i', $_FILES[$varforimage]["name"], $reg))
				{
					$original_file = $reg[1];

					$isimage = image_format_supported($original_file);
					if ($isimage >= 0)
					{
						dol_syslog("Move file ".$_FILES[$varforimage]["tmp_name"]." to ".$dirforimage.$original_file);
						if (! is_dir($dirforimage))
						{
							dol_mkdir($dirforimage);
						}
						$result = dol_move_uploaded_file($_FILES[$varforimage]["tmp_name"], $dirforimage.$original_file, 1, 0, $_FILES[$varforimage]['error']);
						if ($result > 0)
						{
							$icon = $original_file;
						}
						else if (preg_match('/^ErrorFileIsInfectedWithAVirus/',$result))
						{
							$error++;
							$langs->load("errors");
							$tmparray = explode(':', $result);
							setEventMessages($langs->trans('ErrorFileIsInfectedWithAVirus',$tmparray[1]), null, 'errors');
						}
						else
						{
							$error++;
							setEventMessages($langs->trans("ErrorFailedToSaveFile"), null, 'errors');
						}
					}
					else
					{
						$error++;
						$langs->load("errors");
						setEventMessages($langs->trans("ErrorBadImageFormat"), null, 'errors');
					}
				}
			}

			// Update website
			if (! $error)
			{
				$data = array(
					'label' => str_escape($label),
					'url' => str_escape($url),
					'position' => $position,
					'target_blank' => $target_blank,
					'standalone' => str_escape($standalone)
				);

				if (! empty($icon)) {
					$data['icon'] = str_escape($icon);
				}

				$result = $externalsites->modify($data, $id);

				if ($result > 0) {
					// Creation OK
					setEventMessage($langs->trans('WebSiteUpdateSuccess'), 'mesgs');
					dolibase_redirect($_SERVER['PHP_SELF']);
				}
			}
			else
			{
				$action = 'edit';
			}
		}
	}
	else
	{
		$action = 'edit';
	}
}

// Delete

else if ($action == 'delete')
{
	$page->askForConfirmation($_SERVER["PHP_SELF"] . '?id=' . $id, 'Delete', 'ConfirmDelete', 'confirm_delete');
}

else if ($action == 'confirm_delete' && $confirm == 'yes')
{
	$result = $externalsites->remove($id);
	if ($result > 0) {
		setEventMessage($langs->trans('WebSiteDeleteSuccess'), 'mesgs');
		dolibase_redirect($_SERVER['PHP_SELF']);
	}
}

// Enable

else if ($action == 'enable')
{
	$result = $externalsites->enable($id);
	if ($result > 0) {
		dolibase_redirect($_SERVER['PHP_SELF']);
	}
}

// Disable

else if ($action == 'disable')
{
	$result = $externalsites->disable($id);
	if ($result > 0) {
		dolibase_redirect($_SERVER['PHP_SELF']);
	}
}

// --- End actions

$page->begin();

/*
 * Add/Update form
 */

if ($action == 'edit' && $id > 0 && $externalsites->fetch($id))
{
	$form_action = 'update';
	$submit_button = 'Modify';
	if (! is_submitted('label')) {
		$label = $externalsites->label;
	}
	if (! is_submitted('url')) {
		$url = $externalsites->url;
	}
	if (! is_submitted('position')) {
		$position = $externalsites->position;
	}
	if (! is_submitted('target_blank')) {
		$target_blank = $externalsites->target_blank;
	}
	if (! is_submitted('standalone')) {
		$standalone = $externalsites->standalone;
	}
}
else
{
	$form_action = 'add';
	$submit_button = 'Add';
}

// open form
$page->openForm($form_action, 'multipart/form-data');

if ($form_action == 'update') {
	echo '<input type="hidden" name="id" value="'.$id.'">';
}

// open table
$table_header = array(
	array('name' => 'Parameter', 'attr' => 'width="30%"'),
	array('name' => 'Value', 'attr' => 'width="30%"'),
	array('name' => 'Examples')
);

$page->openTable($table_header);

// Website Label
$page->openRow();
$page->addColumn($langs->trans('WebSiteLabel'), 'class="fieldrequired"');
$page->addColumn($page->form->textInput('label', $label));
$page->addColumn($langs->trans('WebSiteLabelExamples'));
$page->closeRow();

// Website Url
$page->openRow();
$page->addColumn($langs->trans('WebSiteUrl'), 'class="fieldrequired"');
$page->addColumn($page->form->textArea('url', $url));
$page->addColumn($langs->trans('WebSiteUrlExamples'));
$page->closeRow();

// Website Icon
$page->openRow();
$page->addColumn($langs->trans('WebSiteIcon'));
$page->addColumn($page->form->fileInput('icon', 'image/*'));
$page->addColumn($langs->trans('WebSiteIconExamples'));
$page->closeRow();

// Website Position
$page->openRow();
$page->addColumn($langs->trans('WebSitePosition'));
$page->addColumn($page->form->numberInput('position', (empty($position) ? 100 : $position), 1, 500));
$page->addColumn('');
$page->closeRow();

// Website Target Blank
$page->openRow();
$page->addColumn($langs->trans('WebSiteTargetBlank'));
$page->addColumn($page->form->selectyesno('target_blank', (empty($target_blank) ? 0 : $target_blank), 1));
$page->addColumn('');
$page->closeRow();

// Website Standalone
$page->openRow();
$page->addColumn($langs->trans('WebSiteStandalone'));
$page->addColumn($page->form->selectyesno('standalone', (empty($standalone) ? 0 : $standalone), 1));
$page->addColumn($langs->trans('WebSiteStandaloneExamples', img_warning()));
$page->closeRow();

// close table
$page->closeTable();
$page->addLineBreak();

// submit button
echo '<div class="center"><input class="butAction" value="'.$langs->trans($submit_button).'" type="submit"></div>';

// close form
$page->closeForm();
$page->addLineBreak();

/*
 * Websites list
 */

$table_header = array(
	array('name' => 'WebSiteLabel'),
	array('name' => 'WebSiteUrl'),
	array('name' => 'WebSiteIcon'),
	array('name' => 'WebSitePosition', 'attr' => 'align="center"'),
	array('name' => 'WebSiteTargetBlank', 'attr' => 'align="center"'),
	array('name' => 'WebSiteStandalone', 'attr' => 'align="center"'),
	array('name' => 'WebSiteStatus', 'attr' => 'align="center"'),
	array('name' => '', 'attr' => 'align="right"'),
	array('name' => '', 'attr' => 'align="right"')
);

$page->openTable($table_header);

// Fetch
$qb = new QueryBuilder();
$qb->select($externalsites->fetch_fields)
   ->from($externalsites->table_element)
   ->orderBy('position', 'ASC');

// Fetch result
$odd = true;

foreach ($qb->result() as $row)
{
	$odd = ! $odd;
	$page->openRow($odd);

	// Label
	$page->addColumn($row->label);

	// Url
	$page->addColumn(str_escape($row->url));

	// Icon
	$icon = (! empty($row->icon) ? '<img class="paddingleft valignmiddle" width="24px" src="'.DOL_URL_ROOT.'/viewimage.php?modulepart=externalsitepro&amp;file='.urlencode('/icons/'.$row->icon).'">' : $langs->trans('DefaultIcon'));
	$page->addColumn($icon);

	// Position
	$page->addColumn($row->position, 'align="center"');

	// Target Blank
	$page->addColumn(yn($row->target_blank), 'align="center"');

	// Standalone
	$page->addColumn(yn($row->standalone), 'align="center"');

	// Status
	$page->addColumn('<a href="'.$_SERVER['PHP_SELF'].'?action='.($row->status > 0 ? 'disable' : 'enable').'&id='.$row->rowid.'">'.($row->status > 0 ? img_picto($langs->trans("Enabled"), 'switch_on') : img_picto($langs->trans("Disabled"), 'switch_off')).'</a>', 'align="center"');

	// Modify link
	$page->addColumn('<a href="'.$_SERVER['PHP_SELF'].'?action=edit&id='.$row->rowid.'">'.img_edit($langs->trans("Modify")).'</a>');

	// Delete link
	$page->addColumn('<a href="'.$_SERVER['PHP_SELF'].'?action=delete&id='.$row->rowid.'">'.img_delete($langs->trans("Delete")).'</a>');

	$page->closeRow();
}

$page->closeTable();

$page->end();
