<?php
/* Copyright (C) 2003      Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2012 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup   events     Module events
 *  \brief      Example of a module descriptor.
 *				Such a file must be copied into htdocs/eventsmod/core/modules directory.
 *  \file       htdocs/eventsmod/core/modules/modevents.class.php
 *  \ingroup    events
 *  \brief      Description and activation file for module events
 */
include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';

/**
 *  Description and activation class for module events
 */
class modeventsmod extends DolibarrModules
{
	/**
	 *   Constructor. Define names, constants, directories, boxes, permissions
	 *
	 *   @param      DoliDB		$db      Database handler
	 */
	function __construct($db)
	{
        global $langs,$conf;

        $this->db = $db;

		$this->numero = 96001996; 
		$this->rights_class = 'eventsmod';
		// Family can be 'crm','financial','hr','projects','products','ecm','technic','other'
		// It is used to group modules in module setup page
		$this->family = "Next";
		// Module label (no space allowed), used if translation string 'ModuleXXXName' not found (where XXX is value of numeric property 'numero' of module)
		$this->name = preg_replace('/^mod/i','',get_class($this));
		$this->description = "ModuleDesceventsmod";
		// Possible values for version are: 'development', 'experimental', 'dolibarr' or version
		$this->version = '6.0';
		// Key used in llx_const table to save module status enabled/disabled (where MYMODULE is value of property name of module in uppercase)
		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		$this->special = 0;
		// Name of image file used for this module.
		// If file is in theme/yourtheme/img directory under name object_pictovalue.png, use this->picto='pictovalue'
		// If file is in module/img directory under name object_pictovalue.png, use this->picto='pictovalue@module'
		$this->picto='eventsmod@eventsmod';
		
		// Defined all module parts (triggers, login, substitutions, menus, css, etc...)
		// for default path (eg: /eventsmod/core/xxxxx) (0=disable, 1=enable)
		// for specific path of parts (eg: /eventsmod/core/modules/barcode)
		// for specific css file (eg: /eventsmod/css/events.css.php)
		//$this->module_parts = array(
		//                        	'triggers' => 0,                                 	// Set this to 1 if module has its own trigger directory (core/triggers)
		//							'login' => 0,                                    	// Set this to 1 if module has its own login method directory (core/login)
		//							'substitutions' => 0,                            	// Set this to 1 if module has its own substitution function file (core/substitutions)
		//							'menus' => 0,                                    	// Set this to 1 if module has its own menus handler directory (core/menus)
		//							'theme' => 0,                                    	// Set this to 1 if module has its own theme directory (theme)
		//                        	'tpl' => 0,                                      	// Set this to 1 if module overwrite template dir (core/tpl)
		//							'barcode' => 0,                                  	// Set this to 1 if module has its own barcode directory (core/modules/barcode)
		//							'models' => 0,                                   	// Set this to 1 if module has its own models directory (core/modules/xxx)
		//							'css' => array('/eventsmod/css/events.css.php'),	// Set this to relative path of css file if module has its own css file
	 	//							'js' => array('/eventsmod/js/events.js'),          // Set this to relative path of js file if module must load a js on all pages
		//							'hooks' => array('hookcontext1','hookcontext2')  	// Set here all hooks context managed by module
		//							'dir' => array('output' => 'othermodulename'),      // To force the default directories names
		//							'workflow' => array('WORKFLOW_MODULE1_YOURACTIONTYPE_MODULE2'=>array('enabled'=>'! empty($conf->module1->enabled) && ! empty($conf->module2->enabled)', 'picto'=>'yourpicto@events')) // Set here all workflow context managed by module
		//                        );
		$this->module_parts = array(
		    // 'hooks' => array(),
		    'css' => array("/eventsmod/css/eventsmod.css"),
		    'js' => array("/eventsmod/js/eventsmod.js"),
		);

		// Data directories to create when module is enabled.
		// Example: this->dirs = array("/eventsmod/temp");
		$this->dirs = array();

		// Config pages. Put here list of php page, stored into events/admin directory, to use to setup module.
		$this->config_page_url = array();
		// $this->config_page_url = array("admin.php@events");
		// $this->config_page_url = array("events_setup.php@events");

		// Dependencies
		$this->hidden = false;			// A condition to hide module
		$this->depends = array();		// List of modules id that must be enabled if this module is enabled
		$this->requiredby = array();	// List of modules id to disable if this one is disabled
		$this->conflictwith = array();	// List of modules id this module is in conflict with
		$this->phpmin = array(5,0);					// Minimum version of PHP required by module
		$this->need_dolibarr_version = array(3,0);	// Minimum version of Dolibarr required by module
		$this->langfiles = array("eventsmod@eventsmod");
		// Constants
		// List of particular constants to add when module is enabled (key, 'chaine', value, desc, visible, 'current' or 'allentities', deleteonunactive)
		// Example: $this->const=array(0=>array('MYMODULE_MYNEWCONST1','chaine','myvalue','This is a constant to add',1),
		//                             1=>array('MYMODULE_MYNEWCONST2','chaine','myvalue','This is another constant to add',0, 'current', 1)
		// );
		$this->const = array();

		// Array to add new pages in new tabs
		// Example: $this->tabs = array('objecttype:+tabname1:Title1:eventsmod@eventsmod:$user->rights->eventsmod->read:/eventsmod/mynewtab1.php?id=__ID__',  	// To add a new tab identified by code tabname1
        //                              'objecttype:+tabname2:Title2:eventsmod@eventsmod:$user->rights->othermodule->read:/eventsmod/mynewtab2.php?id=__ID__',  	// To add another new tab identified by code tabname2
        //                              'objecttype:-tabname:NU:conditiontoremove');                                                     						// To remove an existing tab identified by code tabname
		// where objecttype can be
		// 'categories_x'	  to add a tab in category view (replace 'x' by type of category (0=product, 1=supplier, 2=customer, 3=member)
		// 'contact'          to add a tab in contact view
		// 'contract'         to add a tab in contract view
		// 'group'            to add a tab in group view
		// 'intervention'     to add a tab in intervention view
		// 'invoice'          to add a tab in customer invoice view
		// 'invoice_supplier' to add a tab in supplier invoice view
		// 'member'           to add a tab in fundation member view
		// 'opensurveypoll'	  to add a tab in opensurvey poll view
		// 'order'            to add a tab in customer order view
		// 'order_supplier'   to add a tab in supplier order view
		// 'payment'		  to add a tab in payment view
		// 'payment_supplier' to add a tab in supplier payment view
		// 'product'          to add a tab in product view
		// 'propal'           to add a tab in propal view
		// 'project'          to add a tab in project view
		// 'stock'            to add a tab in stock view
		// 'thirdparty'       to add a tab in third party view
		// 'user'             to add a tab in user view
        $this->tabs = array();

        // Dictionaries
	    if (! isset($conf->eventsmod->enabled))
        {
        	$conf->eventsmod=new stdClass();
        	$conf->eventsmod->enabled=0;
        }
		$this->dictionaries=array();
        
        // Boxes
		// Add here list of php file(s) stored in core/boxes that contains class to show a box.
        $this->boxes = array();			// List of boxes
		// Example:
		//$this->boxes=array(array(0=>array('file'=>'myboxa.php','note'=>'','enabledbydefaulton'=>'Home'),1=>array('file'=>'myboxb.php','note'=>''),2=>array('file'=>'myboxc.php','note'=>'')););

		// Permissions
		$this->rights = array();		// Permission array used by this module
		$r=1;
		// Add here list of permission defined by an id, a label, a boolean and two constant strings.

		$this->rights[$r][0] = $this->numero+$r;	// Permission id (must not be already used)
		$this->rights[$r][1] = 'consulter';	// Permission label
		$this->rights[$r][3] = 1; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'gestion';				
		$this->rights[$r][5] = 'consulter';				
		$r++;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Ajouter/Modifier';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'gestion';
		$this->rights[$r][5] = 'update';
		$r++;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Supprimer';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'gestion';
		$this->rights[$r][5] = 'delete';
		$r++;

		// print_r($this->rights);die();

		// Main menu entries
		$this->menu = array();			// List of menus to add
		$r=0;
		// Add here entries to declare new menus
		// Top Menu
		$this->menu[$r]=array(	'fk_menu'=>0,
			'type'=>'top',
			'titre'=>'eventsmod',
			'mainmenu'=>'eventsmod',
			'leftmenu'=>'eventsmod',
			'url'=>'/eventsmod/index.php?p=',
			'langs'=>'eventsmod@eventsmod',
			'position'=>208,
			'enabled'=>'1',
			'perms'=>'$user->rights->eventsmod->gestion->consulter',
			'target'=>'',
			'user'=>2);
		$r++;
		// Left Menu


		// $this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=eventsmod',
		// 	'type'=>'left',
		// 	'titre'=>'search',
  //           'leftmenu'=>'eventsdb',
		// 	'url'=>'/eventsmod/search.php',
		// 	'langs'=>'eventsmod@eventsmod',
		// 	'position'=>2,
		// 	'enabled'=>'1',
		// 	'perms'=>'$user->rights->eventsmod->gestion->consulter',
		// 	'target'=>'',
		// 	'user'=>2);
		// $r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=eventsmod',
			'type'=>'left',
			'titre'=>'Liste_des_events',
            'leftmenu'=>'tab_events',
			'url'=>'/eventsmod/index.php?p=',
			'langs'=>'eventsmod@eventsmod',
			'position'=>3,
			'enabled'=>'1',
			'perms'=>'$user->rights->eventsmod->gestion->consulter',
			'target'=>'',
			'user'=>2);
		$r++;


			$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=eventsmod,fk_leftmenu=tab_events',
				'type'=>'left',
				'titre'=>'Liste_des_events',
				'url'=>'/eventsmod/index.php?p=',
				'langs'=>'eventsmod@eventsmod',
				'position'=>4,
				'enabled'=>'1',
				'perms'=>'$user->rights->eventsmod->gestion->consulter',
				'target'=>'',
				'user'=>2);
			$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=eventsmod,fk_leftmenu=tab_events',
			'type'=>'left',
			'titre'=>'add_events',
			'url'=>'/eventsmod/card.php?action=add',
			'langs'=>'eventsmod@eventsmod',
			'position'=> 5,
			'enabled'=>'1',
			'perms'=>'$user->rights->eventsmod->gestion->consulter',
			'target'=>'',
			'user'=>2);		
			$r++;

			

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=eventsmod',
			'type'=>'left',
			'titre'=>'analyse_events',
			'leftmenu'=>'analys_events',
			'url'=>'/eventsmod/dashbord/events.php',
			'langs'=>'eventsmod@eventsmod',
			'position'=>7,
			'enabled'=>'1',
			'perms'=>'$user->rights->eventsmod->gestion->consulter',
			'target'=>'',
			'user'=>2);
		$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=eventsmod,fk_leftmenu=analys_events',
				'type'=>'left',
				'titre'=>'chart_events',
				'url'=>'/eventsmod/dashbord/events.php',
				'langs'=>'eventsmod@eventsmod',
				'position'=> 8,
				'enabled'=>'1',
				'perms'=>'$user->rights->eventsmod->gestion->consulter',
				'target'=>'',
				'user'=>2);		
			$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=eventsmod,fk_leftmenu=analys_events',
				'type'=>'left',
				'titre'=>'chart_participants',
				'url'=>'/eventsmod/dashbord/participants.php',
				'langs'=>'eventsmod@eventsmod',
				'position'=> 9,
				'enabled'=>'1',
				'perms'=>'$user->rights->eventsmod->gestion->consulter',
				'target'=>'',
				'user'=>2);		
			$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=eventsmod,fk_leftmenu=analys_events',
				'type'=>'left',
				'titre'=>'calendries_events',
				'url'=>'/eventsmod/calendries.php',
				'langs'=>'eventsmod@eventsmod',
				'position'=> 10,
				'enabled'=>'1',
				'perms'=>'$user->rights->eventsmod->gestion->consulter',
				'target'=>'',
				'user'=>2);		
			$r++;


		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=eventsmod',
		'type'=>'left',
		'titre'=>'Configuration',
		'leftmenu'=>'configuration',
		'url'=>'/eventsmod/category/index.php',
		'langs'=>'eventsmod@eventsmod',
		'position'=>11,
		'enabled'=>'1',
		'perms'=>'$user->rights->eventsmod->gestion->consulter',
		'target'=>'',
		'user'=>2);
		$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=eventsmod,fk_leftmenu=configuration',
			'type'=>'left',
			'titre'=>'list_des_category',
			'url'=>'/eventsmod/category/index.php',
			'langs'=>'eventsmod@eventsmod',
			'position'=> 12,
			'enabled'=>'1',
			'perms'=>'$user->rights->eventsmod->gestion->consulter',
			'target'=>'',
			'user'=>2);		
			$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=eventsmod,fk_leftmenu=configuration',
			'type'=>'left',
			'titre'=>'add_category',
			'url'=>'/eventsmod/category/card.php?action=add',
			'langs'=>'eventsmod@eventsmod',
			'position'=> 13,
			'enabled'=>'1',
			'perms'=>'$user->rights->eventsmod->gestion->consulter',
			'target'=>'',
			'user'=>2);		
			$r++;

		$r=1;
	}

	function init($options='')
	{
		global $conf;
		$sqlm = array();

		

		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."eventsmod` (
		  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		  	`nom` varchar(100) NULL,
		  	`fk_organise` int(11) NULL,
		  	`lieu` varchar(10) NULL,
		  	`fk_resp` int(11) NULL,
		  	`periode_de` datetime NULL,
		  	`periode_au` datetime NULL,
		  	`category` int(11) NULL,
		  	`min_participant` int(11) NULL,
		  	`max_participant` int(11) NULL,
		  	`type_max` varchar(11) NULL,
		  	`etat` varchar(255) NULL
		);";	
		$resql = $this->db->query($sql);

		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."events_participants` (
		  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		  	`date` date NULL,
		  	`fk_contact` int(11) NULL,
		  	`nom` varchar(255) NULL,
		  	`mail` varchar(255) NULL,
		  	`tel` varchar(100) NULL,
		  	`mobile` varchar(100) NULL,
		  	`fk_event` int(11) NULL
		);";	
		$resql = $this->db->query($sql);


		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."events_communication` (
		  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		  	`fk_event` int(11) NULL,
		  	`fk_courriel` int(11) NULL,
		  	`interval` int(11) NULL,
		  	`unite` varchar(255) NULL,
		  	`declencheur` varchar(255) NULL,
		  	`etat` varchar(100) NULL
		);";	
		$resql = $this->db->query($sql);

		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."events_category` (
		  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		  	`nom` varchar(255) NULL,
		  	`color` varchar(255) NULL
		);";	
		$resql = $this->db->query($sql);

		$sql = "ALTER table `".MAIN_DB_PREFIX."events_participants` add etat varchar(250) NULL";
		$resql = $this->db->query($sql);

		$sql = "INSERT INTO `".MAIN_DB_PREFIX."c_email_templates`(`entity`, `module`, `type_template`, `private`, `tms`, `label`, `topic`, `joinfiles`, `content`) VALUES (".$conf->entity.",'eventsmod','templete_events',0, date('Y-m-d H:i:s'),'registre','sendmailregistreevents',1,'YourContentmailRegistreevents' )";
		$resql = $this->db->query($sql);
		
    	$sql = "INSERT INTO `".MAIN_DB_PREFIX."c_email_templates`(`entity`, `module`, `type_template`, `private`, `tms`, `label`, `topic`, `joinfiles`, `content`) VALUES (".$conf->entity.",'eventsmod','templete_events',0, date('Y-m-d H:i:s'),'reminder','sendmailreminderevents',1,'YourContentmailreminderevents' )";
		$resql = $this->db->query($sql);

		if (!dolibarr_get_const($this->db,'EVENTS_CHOOSE_GRIDORLIST',$conf->entity))
			dolibarr_set_const($this->db,'EVENTS_CHOOSE_GRIDORLIST',"GRID",'chaine',0,'',$conf->entity);
		
		// $result=$this->_load_tables('/eventsmod/sql/');
		return $this->_init($sqlm, $options);	
	}

	/**
	 *		Function called when module is disabled.
	 *      Remove from database constants, boxes and permissions from Dolibarr database.
	 *		Data directories are not deleted
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function remove($options='')
	{
		$sql = array();

		return $this->_remove($sql, $options);
	}

}
