<?php 
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php"; 
require_once DOL_DOCUMENT_ROOT.'/core/lib/geturl.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 
dol_include_once('/eventsmod/core/modules/modeventsmod.class.php');
dol_include_once('/eventsmod/class/events_category.class.php');
dol_include_once('/eventsmod/class/events_participants.class.php');


class eventsmod extends Commonobject{ 

	public $errors = array();
	public $rowid;
	public $nom;
	public $lieu;
	public $fk_organise;
	public $periode_de;
	public $periode_au;
	public $fk_resp;

	public $element='eventsmod';
	public $table_element='eventsmod';
	
	const COLORS_STATUS = [
			'a_soumettre' 	=>'#62B0F7',
			'soumi' 		=>'#DBE270',
			'confirme_resp' =>'#59D859',
			'refuse' 		=>'#F59A9A',
			'annuler' 		=>'#FFB164',
		];

	public function __construct($db){ 
		$this->db = $db;
		return 1;
    }

	public function create($echo_sql=0,$insert)
	{

		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .get_class($this)." ( ";

		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			if($value != ""){
				$sql_column .= " , `".$column."`";
				$sql_value .= " , ".$alias.$value.$alias;
			}
		}

		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			print_r($this->errors);die();
			
			return 0;
		} 
		// return $this->db->db->insert_id;
		return $this->db->last_insert_id(MAIN_DB_PREFIX.'events');
	}

	public function update($id, array $data,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

        $sql = 'UPDATE ' . MAIN_DB_PREFIX .get_class($this). ' SET ';

        if (count($data) && is_array($data))
            foreach ($data as $key => $val) {
                $val = is_numeric($val) ? $val : '"'. $val .'"';
                $val = ($val == '') ? 'NULL' : $val;
                $sql .= '`'. $key. '` = '. $val .',';
            }

        $sql  = substr($sql, 0, -1);
        $sql .= ' WHERE rowid = ' . $id;

        $resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			return -1;
		} 

		return 1;
	}

    
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);
		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX .get_class($this);

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}
		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    		    =  $obj->rowid;
				$line->rowid 		    =  $obj->rowid;
				$line->nom 	     	    =  $obj->nom;
				$line->category 	     	    =  $obj->category;
				$line->fk_organise      =  $obj->fk_organise;
				$line->fk_resp          =  $obj->fk_resp;
				$line->lieu 		    =  $obj->lieu;
				$line->periode_de 	    =  $obj->periode_de;
				$line->periode_au 	    =  $obj->periode_au;
				$line->min_participant 	=  $obj->min_participant;
				$line->max_participant 	=  $obj->max_participant;
				$line->type_max 	    =  $obj->type_max;
				$line->etat 	        = $obj->etat;
                // ....

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	public function fetch($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .get_class($this). ' WHERE rowid = ' . $id;
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			  	    =  $this->db->fetch_object($resql);
                $this->id         	    =  $obj->rowid;
                $this->rowid      	    =  $obj->rowid;
				$this->nom 	  	        =  $obj->nom;
				$this->category 	  	        =  $obj->category;
				$this->fk_organise 	    =  $obj->fk_organise;
				$this->fk_resp   	    =  $obj->fk_resp;
				$this->lieu 	  	    =  $obj->lieu;
				$this->periode_de  	    =  $obj->periode_de;
				$this->periode_au  	    =  $obj->periode_au;
				$this->min_participant 	=  $obj->min_participant;
				$this->max_participant 	=  $obj->max_participant;
				$this->type_max 	    =  $obj->type_max;
				$this->etat 	        = $obj->etat;
                // ....
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="nom",$id='',$attr=''){

	    global $conf;

	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'">';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

    function getNomUrl($withpicto=0, $option='', $get_params='', $notooltip=0, $save_lastsearch_value=-1)
    {
        global $langs, $conf, $user;
        if (! empty($conf->dol_no_mouse_hover)) $notooltip=1;   // Force disable tooltips

        $result='';
        $label='';
        $url = dol_buildpath('/eventsmod/card.php?id='.$this->id,2);

        // if ($user->rights->propal->lire){}

        $linkclose='';
        if (empty($notooltip))
        {
            $linkclose.= ' title="'.dol_escape_htmltag($label, 1).'"';
            $linkclose.=' class="classfortooltip"';
        }
        $linkstart = "";
        $linkend = "";
        $result = "";
        if(!empty($this->nom)){
        	$ref=$this->nom;
        }else
        	$ref=$this->rowid;
        if ($ref) {
            $linkstart = '<a href="'.$url.'"';
            $linkstart.=$linkclose.'>';
            $linkend='</a>';

            $result .= $linkstart;
            if ($withpicto) 
                $result.= '<img height="16" src="'.dol_buildpath('/eventsmod/img/object_eventsmod.png',2).'" >&nbsp;';
            if ($withpicto != 2) $result.= $ref;
        }

        $result .= $linkend;

        return $result;
    }

    public function getcountrows(){
        $tot = 0;
        $sql = "SELECT COUNT(rowid) as tot FROM ".MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);

        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
                $tot = $obj->tot;
            }
        }
        return $tot;
    }

    public function getdateformat($date,$time=true){
        
        $d = explode(' ', $date);
        $date = explode('-', $d[0]);
        $d2 = explode(':', $d[1]);
        $result = $date[2]."/".$date[1]."/".$date[0];
        if ($time) {
            $result .= " ".$d2[0].":".$d2[1];
        }
        return $result;
    }

    public function getYears($debut="debut")
    {
        $sql = 'SELECT YEAR('.$debut.') as years FROM ' . MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }

    public function getmonth($year)
    {
        $sql = 'SELECT MONTH(debut) as years FROM ' . MAIN_DB_PREFIX.get_class($this).' WHERE YEAR(debut) = '.$year;
        $resql  = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }




	
	public function select_events($selected=0,$name='events')
	{
		global $conf;
		$id = (!empty($id)) ? $id : $name;


		$events = $this->fetchAll();

		$nb=count($this->rows);
		$select = '<select required class="flat" id="select_'.$id.'" name="'.$name.'" >';
	    	$select.='<option value="0">&nbsp;</option>';
			for ($i=0; $i < $nb; $i++) { 
				$item=$this->rows[$i];
				$select.='<option value="'.$item->rowid.'"';
	            if ($item->rowid == $selected) $select.='selected';
	            $select.='>'.$item->label.'</option>';
			}
    	
		$select.='</select>';
		$select.='<script>$(function(){$("#select_'.$id.'").select2()})</script>';
	    return $select;
	}

	public function select_etat_particps($etat='',$name="etat")	
	{
		global $langs;
		$select ='<select class="select_'.$name.'" name="'.$name.'" >';
			$select .='<option value=""></option>';
			$select .='<option value="confirme">'.$langs->trans('confirme').'</option>';
			$select .='<option value="no_confirm">'.$langs->trans('no_confirm').'</option>';
			$select .='<option value="present">'.$langs->trans('present').'</option>';
		$select .='</select>';

		$select = str_replace('<option value="'.$etat.'"', '<option value="'.$etat.'" selected ', $select);

		return $select;
	}
	

	public function select_etat($etat='',$name='etat')
	{
		global $langs;
		$select ='<select class="select_'.$name.'" name="'.$name.'" >';
			$select .='<option value=""></option>';
			$select .='<option value="confirme">'.$langs->trans('confirme').'</option>';
			$select .='<option value="no_confirm">'.$langs->trans('no_confirm').'</option>';
			$select .='<option value="fait">'.$langs->trans('fait').'</option>';
			$select .='<option value="annuler">'.$langs->trans('annuler').'</option>';
		$select .='</select>';

		$select = str_replace('<option value="'.$etat.'"', '<option value="'.$etat.'" selected ', $select);

		return $select;
	}



	public function select_category($category='',$name='category')
	{
		global $langs;
		$categories  = new events_category($this->db);
		$categories->fetchAll();
		$select ='<select class="select_'.$name.'" name="'.$name.'" ><option value=""></option>';
			foreach ($categories->rows as $key => $value) {

				$select .='<option value="'.$value->rowid.'" ';
				if($category == $value->rowid){ $select .='selected';}
				$select .= '>'.$value->nom.'</option>';
			}
		$select .='</select>';

		$select = str_replace('<option value="'.$category.'"', '<option value="'.$category.'" selected ', $select);

		return $select;
	}

	public function count_approb_revise($type='')
	{
		global $langs, $conf, $user;
		$this->fetchAll('','',0,0,' AND fk_type='.$type.' AND '.$user->id.' IN (approbateurs)');
		$nbdata = count($this->rows);
		return $nbdata;
	}

	

	public function array_img($type="")
	{
		$array_img = [
			'pdf'	=> dol_buildpath('/events/img/pdf.png',2),
			'doc'	=> dol_buildpath('/events/img/doc.png',2),
			'docx'	=> dol_buildpath('/events/img/doc.png',2),
			'ppt'	=> dol_buildpath('/events/img/ppt.png',2),
			'pptx'	=> dol_buildpath('/events/img/ppt.png',2),
			'xls'	=> dol_buildpath('/events/img/xls.png',2),
			'xlsx'	=> dol_buildpath('/events/img/xls.png',2),
			'txt'	=> dol_buildpath('/events/img/txt.png',2),
			'sans'	=> dol_buildpath('/events/img/sans.png',2),
		];

		if(!isset($array_img[$type]))
			$img =$array_img['sans'];
		elseif(empty($type)){
			$img =$array_img['sans'];
		}else{
			$img = $array_img[$type];
		}
		return $img;

	}
	
	public function select_unite($unite='',$name='unite')
	{
		global $langs;

				$select  ='<option value="false" style="display: none"></option>';
				$select .='<option value="immediatement" style="">'.$langs->trans('immediatement').'</option>';
				$select .='<option value="hours" style="">'.$langs->trans('Hours').'</option>';
				$select .='<option value="days" style="">'.$langs->trans('Days').'</option>';
				$select .='<option value="weeks" style="">'.$langs->trans('Weeks').'</option>';
				$select .='<option value="months" style="">'.$langs->trans('Month').'</option>';

		$select = str_replace('<option value="'.$unite.'"', '<option value="'.$unite.'" selected ', $select);

		return $select;
	}

	public function select_interval_type($type='',$name='interval_type')
	{
		global $langs;

		$select  ='<option value="false" style="display: none"></option>';
		$select .='<option value="after_inscrp" style="">'.$langs->trans('after_inscrp').'</option>';
		$select .='<option value="before_event" style="">'.$langs->trans('before_event').'</option>';
		$select .='<option value="after_event" style="">'.$langs->trans('after_event').'</option>';

		// $select .='<option value="after_inscrp;" style="">Après chaque inscription</option>';
		// $select .='option value="&quot;before_event&quot;" style="">Avant l'événement</option>';
		// $select .='<option value="&quot;after_event&quot;" style="">Après l'événement</option>';

		$select = str_replace('<option value="'.$type.'"', '<option value="'.$type.'" selected ', $select);
		return $select;
	} 

	public function get_participant($fk_event='')
	{
		$participants = new events_participants($this->db);
		$participants->fetchAll('','',0,0,' AND fk_event='.$fk_event);
		return $participants->rows;
	}

	public function datachart_events()
	{
		$data_user = [];
		$data_events = [];
		$this->fetchAll();
		$nb = count($this->rows);
		for ($i=0; $i < count($this->rows); $i++) {
			$event = $this->rows[$i];

			$data_events['user'][$event->fk_resp] ++; 
			$data_events['etat'][$event->fk_resp][$event->etat] ++; 

			if(!in_array($event->fk_resp, $data_user)){
				$data_user[] = $event->fk_resp; 
			}

		}
		$data=['data_user'=>$data_user,'data_events'=>$data_events];
		return $data;
	}
	
	public function datachart_participants()
	{
		$participants  = new events_participants($this->db);
		$data_event = [];
		$data_participant = [];
		$participants->fetchAll();
		$nb = count($participants->rows);
		for ($i=0; $i < $nb; $i++) {
			$participant = $participants->rows[$i];

			$data_participant['event'][$participant->fk_event] ++; 
			$data_participant['etat'][$participant->fk_event][$participant->etat] ++; 

			if(!in_array($event->fk_event, $data_event)){
				$data_event[] = $participant->fk_event; 
			}

		}
		$data=['data_event'=>$data_event,'data_participant'=>$data_participant];
		return $data;
	}

	public function getAllMailTiers($selected=null){
	 	global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $name = "sendto";
	    $objet = "label";
	    $moreforfilter.='<select class="select2-selection select2-selection--multiple" id="selectallparticipant" multiple name="receiverccuser[]">';
	    // if ($showempty) 
    	$moreforfilter.='<option value="">&nbsp;</option>';

    	$data = $this->get_participant($selected);
    	if($data && count($data)){
    		foreach ($data as $key => $value) {
    			$nom = explode('_', $value->nom);
				$moreforfilter.='<option value="'.$value->mail.'" data-email="'.$value->mail.'" >'.$nom[1].' '.$nom[0].' '.html_entity_decode('< ').$value->mail.html_entity_decode(' >').' </option>';
    		}
    	}
    	
	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';

	    return $moreforfilter;
    }

    public function fetch_thirdparty($force_thirdparty_id = 0)
	{
        
		return 1;
	}
	
} 


class eventsmodcls extends Commonobject{ 
    
    public function __construct($db){ 
        $this->db = $db;
        return 1;
    }

    public function fetch()
    {
        global $conf, $mysoc, $user, $langs;
        $langs->load('eventsmod@eventsmod');

        $modulrecrut = new modeventsmod($this->db);

        $nummodul = $modulrecrut->numero;
        $editeurmodul = 'https://www.nextgestion.com';

        if (!dolibarr_get_const($this->db,'EDITOR_MODULE_EVENTSMOD',0))
            dolibarr_set_const($this->db,'EDITOR_MODULE_EVENTSMOD',$editeurmodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'ID_MODULE_EVENTSMOD',0))
            dolibarr_set_const($this->db,'ID_MODULE_EVENTSMOD',$nummodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'DATE_MODULE_EVENTSMOD',0))
            dolibarr_set_const($this->db,'DATE_MODULE_EVENTSMOD',date('Y-m-d'),'chaine',0,'',0);


        $id_modul      = dolibarr_get_const($this->db,'ID_MODULE_EVENTSMOD',0);
        $date_modul    = dolibarr_get_const($this->db,'DATE_MODULE_EVENTSMOD',0);
        $editor_modul  = dolibarr_get_const($this->db,'EDITOR_MODULE_EVENTSMOD',0);

        $link = urlencode(dol_buildpath('/',2));

        if(!empty($date_modul) && $date_modul <= date('Y-m-d') && !empty($editor_modul) && !empty($id_modul) && !empty($link)){

	        $name = ( $mysoc->name ? $mysoc->name : "(U) ".$user->lastname.' '.$user->firstname);
	        $name = urlencode($name);
        	$id_modul = urlencode($id_modul);
	        $mail = urlencode($mysoc->email); 

            $url = $editor_modul."/suivimod/module/registeruse?mod=".$id_modul."&link=".$link."&name=".$name."&email=".$mail;
            $urldata = getURLContent($url);
            $response = json_decode($urldata['content']);

            if($response && $response->actif == 0){
                dolibarr_set_const($this->db,'ID_MODULE_EVENTSMOD', 1, 'chaine',0,'',0);
                unActivateModule("modeventsmod");
            }
            $newdate_modul = date("Y-m-d", strtotime("+ 1 day"));
            dolibarr_set_const($this->db,'DATE_MODULE_EVENTSMOD', $newdate_modul, 'chaine',0,'',0);
        }
        return 1;
    } 
}


?>