<?php

$path = dol_buildpath('/domain/vendor/autoload.php');
require_once $path;

use phpWhois\Whois;
use phpWhois\Utils;

/**
 * Class to manage Ticketfetcher CRON tasks
 *
 * @package default
 * @author
 */
class DomainCron
{
    
    public function __construct()
    {
        global $db;
        $this->db = $db;
    }

    /**
     * Update domain with registrar values
     *
     * For each active account
     *
     * @return void
     * @author
     */
    public function updateDomainsFromWhois()
    {

        global $conf, $langs, $user;

        $this->output = '';
        $this->error='';

        $updatedRegistrar = array();
        $updatedExpiration = array();

        $return = 0;
        dol_syslog(__METHOD__, LOG_DEBUG);
        dol_include_once('/domain/class/domain.class.php');

        $object = new Domain($this->db);
        $numDomains = $object->fetchAll();
        if ($numDomains) {
            // Loop on each domains
            foreach ($object->lines as $domain) {
                dol_syslog(__METHOD__.': Verif de '.$domain->label, LOG_DEBUG);
                if ($domain->status > 0 && strlen($domain->label) > 0) {
                    // ake WHOIS request
                    $whois = new Whois();
    
                    $allowproxy = false;

                    // get faster but less acurate results
                    // $whois->deep_whois = empty($_GET['fast']);

                    // To use special whois servers (see README)
                    // $whois->UseServer('uk','whois.nic.uk:1043?{hname} {ip} {query}');
                    // $whois->UseServer('au','whois-check.ausregistry.net.au');

                    // Comment the following line to disable support for non ICANN tld's
                    $whois->non_icann = true;
                    $result = $whois->Lookup($domain->label);

                    if (empty($result['rawdata'])) {
                        dol_syslog(__METHOD__.': Unexpected error for domain  '.$domain->label, LOG_ERR);
                        $this->output.= 'Unexpected error for domain '.$domain->label."\n";
                        continue;
                    }

                    if ((isset($result['regrinfo']['registered']) && $result['regrinfo']['registered'] != 'yes') || (isset($result['regrinfo']['domain']['registered']) && $result['regrinfo']['domain']['registered'] !== 'yes')) {
                        dol_syslog(__METHOD__.': Domain not registered '.$domain->label, LOG_DEBUG);
                        continue;
                    }

                    /*
                    * Registration date in whois
                    * 
                    */
                    $whois_date_registrar = '';
                    $created_date = strtotime($result['regrinfo']['domain']['created']);
                
                    // Look for 'Creation Date: ' into raw results
                    foreach ($result['rawdata'] as $line) {
                        if (preg_match('/Creation Date: (.*)/', $line, $match)) {
                            $created_date = strtotime($match[1]);
                            $whois_date_registrar = dol_print_date($created_date, 'dayhour');
                            break;
                        }
                    }
                    if (! empty($whois_date_registrar)) {
                        if ($created_date <> $domain->date_registrar) {
                            if ($domain->setDateRegistrar($created_date)) {
                                $updatedRegistrar[] = array($domain->id => $whois_date_registrar);
                                dol_syslog(__METHOD__.': Update registrar date for domain  '.$domain->label, LOG_DEBUG);
                            }
                        } else {
                            dol_syslog(__METHOD__.': No need to update registration date for domain  '.$domain->label, LOG_DEBUG);
                        }
                    } else {
                        dol_syslog(__METHOD__.': Registration date not found for domain  '.$domain->label, LOG_DEBUG);
                    }

                    /*
                     *  Expiration date
                     */
                    $whois_date_expire = '';
                    
                    // Look for 'Registry Expiry Date: ' into raw results
                    foreach ($result['rawdata'] as $line) {
                        if (preg_match('/Registry Expiry Date: (.*)/', $line, $match)) {
                            $expire_date = strtotime($match[1]);
                            $whois_date_expire = dol_print_date($expire_date, 'dayhour');
                            break;
                        }
                    }

                    if (! empty($whois_date_expire)) {
                        if ($expire_date <> $domain->date_expiration) {
                            if ($domain->setDateExpiration($expire_date)) {
                                $updatedExpiration[] = array($domain->id => $whois_date_expire);
                                dol_syslog(__METHOD__.': Update expiration date for domain  '.$domain->label, LOG_DEBUG);
                            }
                        } else {
                            dol_syslog(__METHOD__.': No need to update expiration date for domain  '.$domain->label, LOG_DEBUG);
                        }
                    } else {
                        dol_syslog(__METHOD__.': Expiration date not found for domain '.$domain->label, LOG_DEBUG);
                    }
                } else {
                    dol_syslog(__METHOD__.': domain non active', LOG_DEBUG);
                }
            }

            // Output log
            if (count($updatedRegistrar) > 0) {
                foreach ($updatedRegistrar as $key => $up) {
                    foreach ($up as $id => $date) {
                        $this->output .= "Domain ID $id updated with registration date $date\n";
                    }
                }
            } else {
                $this->output .= "No domain update for registration date\n";
            }
            if (count($updatedExpiration) > 0) {
                foreach ($updatedExpiration as $key => $up) {
                    foreach ($up as $id => $date) {
                        $this->output .= "Domain ID $id updated with expiration date $date\n";
                    }
                }
            } else {
                $this->output .= "No domain update for expiration date\n";
            }
            $this->output.= "\n";
        }
        return 0;
    }
}
