<?php
/**
 * Domain management
 * Copyright (C) 2013-2019  Jean-François FERRY <hello@librethic.io>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *     \file        admin/admin_domain.php
 *     \ingroup    domain
 *     \brief        This file is a module setup page
 */
// Dolibarr environment
$res = '';
if (file_exists("../../main.inc.php")) {
    $res = include "../../main.inc.php"; // From htdocs directory
} elseif (!$res && file_exists("../../../main.inc.php")) {
    $res = include "../../../main.inc.php"; // From "custom" directory
} else {
    die("Include of main fails");
}

// Libraries
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
dol_include_once("/domain/class/domain.class.php");
dol_include_once("/domain/lib/domain.lib.php");
// Translations
$langs->loadLangs(
    array('admin', "domain@domain")
);

// Access control
if (!$user->admin) {
    accessforbidden();
}

// Parameters
$value = GETPOST('value', 'alpha');
$action = GETPOST('action', 'alpha');
$label = GETPOST('label', 'alpha');
$scandir = GETPOST('scandir', 'alpha');
$type = 'domain';

if ($action == 'updateMask') {
    $maskconstdomain = GETPOST('maskconstdomain', 'alpha');
    $maskdomain = GETPOST('maskdomain', 'alpha');

    if ($maskconstdomain) {
        $res = dolibarr_set_const($db, $maskconstdomain, $maskdomain, 'chaine', 0, '', $conf->entity);
    }

    if (!$res > 0) {
        $error++;
    }

    if (!$error) {
        setEventMessage($langs->trans("SetupSaved"));
    } else {
        setEventMessage($langs->trans("Error"), 'errors');
    }
} elseif ($action == 'setmod') {
    // TODO Verifier si module numerotation choisi peut etre active
    // par appel methode canBeActivated

    dolibarr_set_const($db, "DOMAIN_ADDON", $value, 'chaine', 0, '', $conf->entity);
}

/*
 * View
 */
$dirmodels = array_merge(array('/'), (array) $conf->modules_parts['models']);

$form = new Form($db);

$help_url = "FR:Module_Domain";
$page_name = "DomainSetup";
llxHeader('', $langs->trans($page_name), $help_url);

// Subheader
$linkback = '<a href="' . DOL_URL_ROOT . '/admin/modules.php">'
. $langs->trans("BackToModuleList") . '</a>';
print load_fiche_titre($langs->trans($page_name), $linkback);

// Configuration header
$head = domainAdminPrepareHead();
dol_fiche_head(
    $head,
    'settings',
    $langs->trans("Module1664Name"),
    0,
    "domain@domain"
);


if ($action == 'migrate_ref') {
    $sql = "SELECT rowid";
    $sql.= " FROM ".MAIN_DB_PREFIX."domain";
    $sql.= " WHERE ref IS NULL";
    $sql.= " ORDER BY rowid ASC";

    dol_syslog('MigrateRef:: Select domains', LOG_DEBUG);
    $resql=$db->query($sql);
    if ($resql) {
        $num = $db->num_rows($resql);
        $i = 0;
        if ($num) {
            while ($i < $num) {
                $obj = $db->fetch_object($resql);
                if ($obj) {
                    $domainStatic = new Domain($db);
                    $domainStatic->fetch($obj->rowid);
                    $domainStatic->ref = $domainStatic->getDefaultRef();
                    $result=$domainStatic->update($user);
                    if ($result < 0) {
                        $error++;
                        dol_print_error($db, $domainStatic->error);
                    } else {
                        print "Domain with id ".$domainStatic->id." updated<br />";
                    }
                }
                $i++;
            }
        }
    } else {
        $error++;
        dol_print_error($db);
    }
} else {
    print '<p>'.  $langs->trans("DomainMigrateRefExplanation").'<br />';
    $url = dol_buildpath('/domain/admin/admin_domain.php', 1);
    print '<a href="'.$url.'?action=migrate_ref">';
    print $langs->trans('DomainMigrateRefLaunchMigration');
    print '</a>';
    print '</p>';
}

dol_fiche_end();

/*
 * Projects Numbering model
 */

print_titre($langs->trans("DomainNumberingModules"));

print '<table class="noborder centpercent">';
print '<tr class="liste_titre">';
print '<td width="100">' . $langs->trans("Name") . '</td>';
print '<td>' . $langs->trans("Description") . '</td>';
print '<td>' . $langs->trans("Example") . '</td>';
print '<td align="center" width="60">' . $langs->trans("Activated") . '</td>';
print '<td align="center" width="80">' . $langs->trans("ShortInfo") . '</td>';
print "</tr>\n";

clearstatcache();

foreach ($dirmodels as $reldir) {
    $dir = dol_buildpath($reldir . "core/modules/domain/");
    
    if (is_dir($dir)) {
        $handle = opendir($dir);
        if (is_resource($handle)) {
            $var = true;
            
            while (($file = readdir($handle)) !== false) {
                if (preg_match('/^(mod_.*)\.php$/i', $file, $reg)) {
                    $file = $reg[1];
                    $classname = substr($file, 4);
                    
                    include_once $dir . $file . '.php';
                    
                    $module = new $file;
                    
                    // Show modules according to features level
                    if ($module->version == 'development' && $conf->global->MAIN_FEATURES_LEVEL < 2) {
                        continue;
                    }
                    
                    if ($module->version == 'experimental' && $conf->global->MAIN_FEATURES_LEVEL < 1) {
                        continue;
                    }
                    
                    if ($module->isEnabled()) {
                        $var = !$var;
                        print '<tr ' . $bc[$var] . '><td>' . $module->name . "</td><td>\n";
                        print $module->info();
                        print '</td>';

                        // Show example of numbering model
                        print '<td class="nowrap">';
                        $tmp = $module->getExample();
                        if (preg_match('/^Error/', $tmp)) {
                            print '<div class="error">' . $langs->trans($tmp) . '</div>';
                        } elseif ($tmp == 'NotConfigured') {
                            print $langs->trans($tmp);
                        } else {
                            print $tmp;
                        }

                        print '</td>' . "\n";

                        print '<td align="center">';
                        if ($conf->global->DOMAIN_ADDON == 'mod_' . $classname) {
                            print img_picto($langs->trans("Activated"), 'switch_on');
                        } else {
                            print '<a href="' . $_SERVER["PHP_SELF"] . '?action=setmod&amp;value=mod_' . $classname . '" alt="' . $langs->trans("Default") . '">' . img_picto($langs->trans("Disabled"), 'switch_off') . '</a>';
                        }
                        print '</td>';
                        
                        $domain = new Domain($db);
                        $domain->initAsSpecimen();

                        // Info
                        $htmltooltip = '';
                        $htmltooltip .= '' . $langs->trans("Version") . ': <b>' . $module->getVersion() . '</b><br>';
                        $nextval = $module->getNextValue($mysoc, $domain);
                        if ("$nextval" != $langs->trans("NotAvailable")) { // Keep " on nextval
                            $htmltooltip .= '' . $langs->trans("NextValue") . ': ';
                            if ($nextval) {
                                $htmltooltip .= $nextval . '<br>';
                            } else {
                                $htmltooltip .= $langs->trans($module->error) . '<br>';
                            }
                        }

                        print '<td align="center">';
                        print $form->textwithpicto('', $htmltooltip, 1, 0);
                        print '</td>';

                        print '</tr>';
                    }
                }
            }
            closedir($handle);
        }
    }
}

print '</table><br>';


llxFooter();

$db->close();
