# Incoming Message

## Structure
Incoming Message is an object(SSilence\ImapClient\IncomingMessage) that has 5 basic properties
```
$imap->incomingMessage->header
$imap->incomingMessage->message
$imap->incomingMessage->attachments
$imap->incomingMessage->section
$imap->incomingMessage->structure
```
and one for debugging
```
$imap->incomingMessage->debug
```

### Header properties
The header properties typically look like this:
```
["header"]=>
  object(stdClass)#3 (15) {
    ["subject"]=>
    string(10) "Ocoto cat is in the new!"
    ["from"]=>
    string(36) "..."
    ["to"]=>
    string(36) "..."
    ["date"]=>
    string(31) "Tue, 21 Mar 2017 11:02:37 +0000"
    ["message_id"]=>
    string(37) "<1490094157.905281607@f369.i.gmail.com>"
    ["size"]=>
    int(472418)
    ["uid"]=>
    int(42243)
    ["msgno"]=>
    int(82)
    ["recent"]=>
    int(0)
    ["flagged"]=>
    int(0)
    ["answered"]=>
    int(0)
    ["deleted"]=>
    int(0)
    ["seen"]=>
    int(1)
    ["draft"]=>
    int(0)
    ["udate"]=>
    int(1490094157)
    ["details"]=>
        object(stdClass)#4 (20) {}
  }
```
To get the subject of the message, use
$imap->incomingMessage->header->subject

This object also contains the id and the uid of the current message according to http://php.net/manual/ru/function.imap-fetch-overview.php:
```php
# id
    $imap->incomingMessage->header->msgno;
# uid
    $imap->incomingMessage->header->uid;
```

To get the CC or BCC use the property
```php
$imap->incomingMessage->header->details
```
Header details properties have more properties like this [imap_headerinfo](http://php.net/manual/ru/function.imap-headerinfo.php).
If there is no property in the returned object, then it is not present in this email.
To get the CC or BCC of the message, use
```php
$imap->incomingMessage->header->details->cc
# or
$imap->incomingMessage->header->details->bcc
# cc and bcc is an array of objects with properties [personal, adl, mailbox, host]
```

### Message properties
Message properties will look like this:
```
["message"]=>
  object(stdClass)#29 (3) {
    ["plain"]=>
    string(16) "text message"
    ["text"]=>
    string(16) "text message"
    ["info"]=>
    array(2) {
      [0]=>
      object(stdClass)#27 (2) {
        ["structure"]=>
        object(stdClass)#28 (11) {
          ["type"]=>
          int(0)
          ["encoding"]=>
          int(3)
          ["ifsubtype"]=>
          int(1)
          ["subtype"]=>
          string(5) "PLAIN"
          ["ifdescription"]=>
          int(0)
          ["ifid"]=>
          int(0)
          ["bytes"]=>
          int(20)
          ["ifdisposition"]=>
          int(0)
          ["ifdparameters"]=>
          int(0)
          ["ifparameters"]=>
          int(1)
          ["parameters"]=>
          array(1) {
            [0]=>
            object(stdClass)#33 (2) {
              ["attribute"]=>
              string(7) "charset"
              ["value"]=>
              string(5) "utf-8"
            }
          }
        }
        ["body"]=>
        string(16) "text message"
      }
      [1]=>
      object(stdClass)#30 (2) {
        ["structure"]=>
        object(stdClass)#31 (11) {
          ["type"]=>
          int(0)
          ["encoding"]=>
          int(3)
          ["ifsubtype"]=>
          int(1)
          ["subtype"]=>
          string(4) "HTML"
          ["ifdescription"]=>
          int(0)
          ["ifid"]=>
          int(0)
          ["bytes"]=>
          int(72)
          ["ifdisposition"]=>
          int(0)
          ["ifdparameters"]=>
          int(0)
          ["ifparameters"]=>
          int(1)
          ["parameters"]=>
          array(1) {
            [0]=>
            object(stdClass)#34 (2) {
              ["attribute"]=>
              string(7) "charset"
              ["value"]=>
              string(5) "utf-8"
            }
          }
        }
        ["body"]=>
        string(56) "<HTML><BODY><br><br><br>html text message<br></BODY></HTML>"
      }
    }
    ["html"]=>
    string(56) "<HTML><BODY><br><br><br>html text message<br></BODY></HTML>"
  }
```
To get info on the message use
$imap->incomingMessage->message->info Is an array. It will allways return an array

To get the body of the message use
```php
$imap->incomingMessage->message->html
# or
$imap->incomingMessage->message->plain
# or synonym plain
$imap->incomingMessage->message->text
```
Get the emails charset like this:
```php
$imap->incomingMessage->message->html->charset
```
Get all subtype message:
```php
# array
$imap->incomingMessage->message->types
```
These are auto generated by the client. This allows you to have an html and a plain text version of the email

### Attachments properties
Attachment properties is an array of objects.
If the letter has attachments, then its return will look like as follows
```
["attachments"]=>
  array(1) {
    [0]=>
      object(stdClass)#26 (3) {
        ["name"]=> string(19) "20140228_160524.jpg"
        ["body"]=> string(945576) "..."
        ["info"]=> "info about attachment"

      ... and next object ...
    [1]=>
       object(stdClass)#18 (2) {}
  }
```

The attachment object has 3 basic properties. Like this:
```php
$imap->incomingMessage->attachments[0]->name;
$imap->incomingMessage->attachments[0]->body;
$imap->incomingMessage->attachments[0]->info;
```

To get the names of all attachments in an email, use the following
```php
foreach($attachments as $attachment){
    echo $attachment->name;
}
```

All information for the email will be in the info property. It will look like this:
```php
["info"]=>
    object(stdClass)#18 (2) {
      ["structure"]=>
      object(stdClass)#19 (13) {
        ["type"]=>
        int(5)
        ["encoding"]=>
        int(3)
        ["ifsubtype"]=>
        int(1)
        ["subtype"]=>
        string(4) "JPEG"
        ["ifdescription"]=>
        int(0)
        ["ifid"]=>
        int(0)
        ["bytes"]=>
        int(237916)
        ["ifdisposition"]=>
        int(1)
        ["disposition"]=>
        string(10) "attachment"
        ["ifdparameters"]=>
        int(1)
        ["dparameters"]=>
        array(1) {
          [0]=>
          object(stdClass)#25 (2) {
            ["attribute"]=>
            string(8) "filename"
            ["value"]=>
            string(12) "Location.jpg"
          }
        }
        ["ifparameters"]=>
        int(1)
        ["parameters"]=>
        array(1) {
          [0]=>
          object(stdClass)#24 (2) {
            ["attribute"]=>
            string(4) "name"
            ["value"]=>
            string(12) "Location.jpg"
          }
        }
      }
      ["body"]=>string(173862) ""
```

The attachment info object has 2 basic properties.
```php
$imap->incomingMessage->attachment[0]->info->structure
$imap->incomingMessage->attachment[0]->info->body
```

Body properties contain the body attachment(s).

### Section properties
Section properties it is array sections of which the email consists.
```
["section"]=>
  array(5) {
    [0]=>
    string(1) "1"
    [1]=>
    string(1) "2"
    [2]=>
    string(1) "3"
    [5]=>
    string(3) "1.1"
    [7]=>
    string(3) "1.2"
  }
```
### Structure properties
The structure propertie is the complete structure of the email
### Debug properties
The debug propertie can be used for debugging
