<?php
/**
 * SalesDataTransactionInterface
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Magento Enterprise Edition 2.0
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * SalesDataTransactionInterface Class Doc Comment
 *
 * @category Class
 * @description Transaction interface. A transaction is an interaction between a merchant and a customer such as a purchase, a credit, a refund, and so on.
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class SalesDataTransactionInterface implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'sales-data-transaction-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'transaction_id' => 'int',
        'parent_id' => 'int',
        'order_id' => 'int',
        'payment_id' => 'int',
        'txn_id' => 'string',
        'parent_txn_id' => 'string',
        'txn_type' => 'string',
        'is_closed' => 'int',
        'additional_information' => 'string[]',
        'created_at' => 'string',
        'child_transactions' => '\Swagger\Client\Model\SalesDataTransactionInterface[]',
        'extension_attributes' => '\Swagger\Client\Model\SalesDataTransactionExtensionInterface'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'transaction_id' => null,
        'parent_id' => null,
        'order_id' => null,
        'payment_id' => null,
        'txn_id' => null,
        'parent_txn_id' => null,
        'txn_type' => null,
        'is_closed' => null,
        'additional_information' => null,
        'created_at' => null,
        'child_transactions' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'transaction_id' => 'transactionId',
        'parent_id' => 'parentId',
        'order_id' => 'orderId',
        'payment_id' => 'paymentId',
        'txn_id' => 'txnId',
        'parent_txn_id' => 'parentTxnId',
        'txn_type' => 'txnType',
        'is_closed' => 'isClosed',
        'additional_information' => 'additionalInformation',
        'created_at' => 'createdAt',
        'child_transactions' => 'childTransactions',
        'extension_attributes' => 'extensionAttributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'transaction_id' => 'setTransactionId',
        'parent_id' => 'setParentId',
        'order_id' => 'setOrderId',
        'payment_id' => 'setPaymentId',
        'txn_id' => 'setTxnId',
        'parent_txn_id' => 'setParentTxnId',
        'txn_type' => 'setTxnType',
        'is_closed' => 'setIsClosed',
        'additional_information' => 'setAdditionalInformation',
        'created_at' => 'setCreatedAt',
        'child_transactions' => 'setChildTransactions',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'transaction_id' => 'getTransactionId',
        'parent_id' => 'getParentId',
        'order_id' => 'getOrderId',
        'payment_id' => 'getPaymentId',
        'txn_id' => 'getTxnId',
        'parent_txn_id' => 'getParentTxnId',
        'txn_type' => 'getTxnType',
        'is_closed' => 'getIsClosed',
        'additional_information' => 'getAdditionalInformation',
        'created_at' => 'getCreatedAt',
        'child_transactions' => 'getChildTransactions',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['transaction_id'] = isset($data['transaction_id']) ? $data['transaction_id'] : null;
        $this->container['parent_id'] = isset($data['parent_id']) ? $data['parent_id'] : null;
        $this->container['order_id'] = isset($data['order_id']) ? $data['order_id'] : null;
        $this->container['payment_id'] = isset($data['payment_id']) ? $data['payment_id'] : null;
        $this->container['txn_id'] = isset($data['txn_id']) ? $data['txn_id'] : null;
        $this->container['parent_txn_id'] = isset($data['parent_txn_id']) ? $data['parent_txn_id'] : null;
        $this->container['txn_type'] = isset($data['txn_type']) ? $data['txn_type'] : null;
        $this->container['is_closed'] = isset($data['is_closed']) ? $data['is_closed'] : null;
        $this->container['additional_information'] = isset($data['additional_information']) ? $data['additional_information'] : null;
        $this->container['created_at'] = isset($data['created_at']) ? $data['created_at'] : null;
        $this->container['child_transactions'] = isset($data['child_transactions']) ? $data['child_transactions'] : null;
        $this->container['extension_attributes'] = isset($data['extension_attributes']) ? $data['extension_attributes'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['transaction_id'] === null) {
            $invalidProperties[] = "'transaction_id' can't be null";
        }
        if ($this->container['order_id'] === null) {
            $invalidProperties[] = "'order_id' can't be null";
        }
        if ($this->container['payment_id'] === null) {
            $invalidProperties[] = "'payment_id' can't be null";
        }
        if ($this->container['txn_id'] === null) {
            $invalidProperties[] = "'txn_id' can't be null";
        }
        if ($this->container['parent_txn_id'] === null) {
            $invalidProperties[] = "'parent_txn_id' can't be null";
        }
        if ($this->container['txn_type'] === null) {
            $invalidProperties[] = "'txn_type' can't be null";
        }
        if ($this->container['is_closed'] === null) {
            $invalidProperties[] = "'is_closed' can't be null";
        }
        if ($this->container['created_at'] === null) {
            $invalidProperties[] = "'created_at' can't be null";
        }
        if ($this->container['child_transactions'] === null) {
            $invalidProperties[] = "'child_transactions' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['transaction_id'] === null) {
            return false;
        }
        if ($this->container['order_id'] === null) {
            return false;
        }
        if ($this->container['payment_id'] === null) {
            return false;
        }
        if ($this->container['txn_id'] === null) {
            return false;
        }
        if ($this->container['parent_txn_id'] === null) {
            return false;
        }
        if ($this->container['txn_type'] === null) {
            return false;
        }
        if ($this->container['is_closed'] === null) {
            return false;
        }
        if ($this->container['created_at'] === null) {
            return false;
        }
        if ($this->container['child_transactions'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets transaction_id
     *
     * @return int
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param int $transaction_id Transaction ID.
     *
     * @return $this
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets parent_id
     *
     * @return int
     */
    public function getParentId()
    {
        return $this->container['parent_id'];
    }

    /**
     * Sets parent_id
     *
     * @param int $parent_id The parent ID for the transaction. Otherwise, null.
     *
     * @return $this
     */
    public function setParentId($parent_id)
    {
        $this->container['parent_id'] = $parent_id;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return int
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param int $order_id Order ID.
     *
     * @return $this
     */
    public function setOrderId($order_id)
    {
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets payment_id
     *
     * @return int
     */
    public function getPaymentId()
    {
        return $this->container['payment_id'];
    }

    /**
     * Sets payment_id
     *
     * @param int $payment_id Payment ID.
     *
     * @return $this
     */
    public function setPaymentId($payment_id)
    {
        $this->container['payment_id'] = $payment_id;

        return $this;
    }

    /**
     * Gets txn_id
     *
     * @return string
     */
    public function getTxnId()
    {
        return $this->container['txn_id'];
    }

    /**
     * Sets txn_id
     *
     * @param string $txn_id Transaction business ID.
     *
     * @return $this
     */
    public function setTxnId($txn_id)
    {
        $this->container['txn_id'] = $txn_id;

        return $this;
    }

    /**
     * Gets parent_txn_id
     *
     * @return string
     */
    public function getParentTxnId()
    {
        return $this->container['parent_txn_id'];
    }

    /**
     * Sets parent_txn_id
     *
     * @param string $parent_txn_id Parent transaction business ID.
     *
     * @return $this
     */
    public function setParentTxnId($parent_txn_id)
    {
        $this->container['parent_txn_id'] = $parent_txn_id;

        return $this;
    }

    /**
     * Gets txn_type
     *
     * @return string
     */
    public function getTxnType()
    {
        return $this->container['txn_type'];
    }

    /**
     * Sets txn_type
     *
     * @param string $txn_type Transaction type.
     *
     * @return $this
     */
    public function setTxnType($txn_type)
    {
        $this->container['txn_type'] = $txn_type;

        return $this;
    }

    /**
     * Gets is_closed
     *
     * @return int
     */
    public function getIsClosed()
    {
        return $this->container['is_closed'];
    }

    /**
     * Sets is_closed
     *
     * @param int $is_closed Is-closed flag value.
     *
     * @return $this
     */
    public function setIsClosed($is_closed)
    {
        $this->container['is_closed'] = $is_closed;

        return $this;
    }

    /**
     * Gets additional_information
     *
     * @return string[]
     */
    public function getAdditionalInformation()
    {
        return $this->container['additional_information'];
    }

    /**
     * Sets additional_information
     *
     * @param string[] $additional_information Array of additional information. Otherwise, null.
     *
     * @return $this
     */
    public function setAdditionalInformation($additional_information)
    {
        $this->container['additional_information'] = $additional_information;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string $created_at Created-at timestamp.
     *
     * @return $this
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets child_transactions
     *
     * @return \Swagger\Client\Model\SalesDataTransactionInterface[]
     */
    public function getChildTransactions()
    {
        return $this->container['child_transactions'];
    }

    /**
     * Sets child_transactions
     *
     * @param \Swagger\Client\Model\SalesDataTransactionInterface[] $child_transactions Array of child transactions.
     *
     * @return $this
     */
    public function setChildTransactions($child_transactions)
    {
        $this->container['child_transactions'] = $child_transactions;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return \Swagger\Client\Model\SalesDataTransactionExtensionInterface
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param \Swagger\Client\Model\SalesDataTransactionExtensionInterface $extension_attributes extension_attributes
     *
     * @return $this
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


