<?php
/**
 * SalesDataOrderItemInterface
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Magento Enterprise Edition 2.0
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * SalesDataOrderItemInterface Class Doc Comment
 *
 * @category Class
 * @description Order item interface. An order is a document that a web store issues to a customer. Magento generates a sales order that lists the product items, billing and shipping addresses, and shipping and payment methods. A corresponding external document, known as a purchase order, is emailed to the customer.
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class SalesDataOrderItemInterface implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'sales-data-order-item-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'additional_data' => 'string',
        'amount_refunded' => 'float',
        'applied_rule_ids' => 'string',
        'base_amount_refunded' => 'float',
        'base_cost' => 'float',
        'base_discount_amount' => 'float',
        'base_discount_invoiced' => 'float',
        'base_discount_refunded' => 'float',
        'base_discount_tax_compensation_amount' => 'float',
        'base_discount_tax_compensation_invoiced' => 'float',
        'base_discount_tax_compensation_refunded' => 'float',
        'base_original_price' => 'float',
        'base_price' => 'float',
        'base_price_incl_tax' => 'float',
        'base_row_invoiced' => 'float',
        'base_row_total' => 'float',
        'base_row_total_incl_tax' => 'float',
        'base_tax_amount' => 'float',
        'base_tax_before_discount' => 'float',
        'base_tax_invoiced' => 'float',
        'base_tax_refunded' => 'float',
        'base_weee_tax_applied_amount' => 'float',
        'base_weee_tax_applied_row_amnt' => 'float',
        'base_weee_tax_disposition' => 'float',
        'base_weee_tax_row_disposition' => 'float',
        'created_at' => 'string',
        'description' => 'string',
        'discount_amount' => 'float',
        'discount_invoiced' => 'float',
        'discount_percent' => 'float',
        'discount_refunded' => 'float',
        'event_id' => 'int',
        'ext_order_item_id' => 'string',
        'free_shipping' => 'int',
        'gw_base_price' => 'float',
        'gw_base_price_invoiced' => 'float',
        'gw_base_price_refunded' => 'float',
        'gw_base_tax_amount' => 'float',
        'gw_base_tax_amount_invoiced' => 'float',
        'gw_base_tax_amount_refunded' => 'float',
        'gw_id' => 'int',
        'gw_price' => 'float',
        'gw_price_invoiced' => 'float',
        'gw_price_refunded' => 'float',
        'gw_tax_amount' => 'float',
        'gw_tax_amount_invoiced' => 'float',
        'gw_tax_amount_refunded' => 'float',
        'discount_tax_compensation_amount' => 'float',
        'discount_tax_compensation_canceled' => 'float',
        'discount_tax_compensation_invoiced' => 'float',
        'discount_tax_compensation_refunded' => 'float',
        'is_qty_decimal' => 'int',
        'is_virtual' => 'int',
        'item_id' => 'int',
        'locked_do_invoice' => 'int',
        'locked_do_ship' => 'int',
        'name' => 'string',
        'no_discount' => 'int',
        'order_id' => 'int',
        'original_price' => 'float',
        'parent_item_id' => 'int',
        'price' => 'float',
        'price_incl_tax' => 'float',
        'product_id' => 'int',
        'product_type' => 'string',
        'qty_backordered' => 'float',
        'qty_canceled' => 'float',
        'qty_invoiced' => 'float',
        'qty_ordered' => 'float',
        'qty_refunded' => 'float',
        'qty_returned' => 'float',
        'qty_shipped' => 'float',
        'quote_item_id' => 'int',
        'row_invoiced' => 'float',
        'row_total' => 'float',
        'row_total_incl_tax' => 'float',
        'row_weight' => 'float',
        'sku' => 'string',
        'store_id' => 'int',
        'tax_amount' => 'float',
        'tax_before_discount' => 'float',
        'tax_canceled' => 'float',
        'tax_invoiced' => 'float',
        'tax_percent' => 'float',
        'tax_refunded' => 'float',
        'updated_at' => 'string',
        'weee_tax_applied' => 'string',
        'weee_tax_applied_amount' => 'float',
        'weee_tax_applied_row_amount' => 'float',
        'weee_tax_disposition' => 'float',
        'weee_tax_row_disposition' => 'float',
        'weight' => 'float',
        'parent_item' => '\Swagger\Client\Model\SalesDataOrderItemInterface',
        'product_option' => '\Swagger\Client\Model\CatalogDataProductOptionInterface',
        'extension_attributes' => '\Swagger\Client\Model\SalesDataOrderItemExtensionInterface'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'additional_data' => null,
        'amount_refunded' => null,
        'applied_rule_ids' => null,
        'base_amount_refunded' => null,
        'base_cost' => null,
        'base_discount_amount' => null,
        'base_discount_invoiced' => null,
        'base_discount_refunded' => null,
        'base_discount_tax_compensation_amount' => null,
        'base_discount_tax_compensation_invoiced' => null,
        'base_discount_tax_compensation_refunded' => null,
        'base_original_price' => null,
        'base_price' => null,
        'base_price_incl_tax' => null,
        'base_row_invoiced' => null,
        'base_row_total' => null,
        'base_row_total_incl_tax' => null,
        'base_tax_amount' => null,
        'base_tax_before_discount' => null,
        'base_tax_invoiced' => null,
        'base_tax_refunded' => null,
        'base_weee_tax_applied_amount' => null,
        'base_weee_tax_applied_row_amnt' => null,
        'base_weee_tax_disposition' => null,
        'base_weee_tax_row_disposition' => null,
        'created_at' => null,
        'description' => null,
        'discount_amount' => null,
        'discount_invoiced' => null,
        'discount_percent' => null,
        'discount_refunded' => null,
        'event_id' => null,
        'ext_order_item_id' => null,
        'free_shipping' => null,
        'gw_base_price' => null,
        'gw_base_price_invoiced' => null,
        'gw_base_price_refunded' => null,
        'gw_base_tax_amount' => null,
        'gw_base_tax_amount_invoiced' => null,
        'gw_base_tax_amount_refunded' => null,
        'gw_id' => null,
        'gw_price' => null,
        'gw_price_invoiced' => null,
        'gw_price_refunded' => null,
        'gw_tax_amount' => null,
        'gw_tax_amount_invoiced' => null,
        'gw_tax_amount_refunded' => null,
        'discount_tax_compensation_amount' => null,
        'discount_tax_compensation_canceled' => null,
        'discount_tax_compensation_invoiced' => null,
        'discount_tax_compensation_refunded' => null,
        'is_qty_decimal' => null,
        'is_virtual' => null,
        'item_id' => null,
        'locked_do_invoice' => null,
        'locked_do_ship' => null,
        'name' => null,
        'no_discount' => null,
        'order_id' => null,
        'original_price' => null,
        'parent_item_id' => null,
        'price' => null,
        'price_incl_tax' => null,
        'product_id' => null,
        'product_type' => null,
        'qty_backordered' => null,
        'qty_canceled' => null,
        'qty_invoiced' => null,
        'qty_ordered' => null,
        'qty_refunded' => null,
        'qty_returned' => null,
        'qty_shipped' => null,
        'quote_item_id' => null,
        'row_invoiced' => null,
        'row_total' => null,
        'row_total_incl_tax' => null,
        'row_weight' => null,
        'sku' => null,
        'store_id' => null,
        'tax_amount' => null,
        'tax_before_discount' => null,
        'tax_canceled' => null,
        'tax_invoiced' => null,
        'tax_percent' => null,
        'tax_refunded' => null,
        'updated_at' => null,
        'weee_tax_applied' => null,
        'weee_tax_applied_amount' => null,
        'weee_tax_applied_row_amount' => null,
        'weee_tax_disposition' => null,
        'weee_tax_row_disposition' => null,
        'weight' => null,
        'parent_item' => null,
        'product_option' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'additional_data' => 'additionalData',
        'amount_refunded' => 'amountRefunded',
        'applied_rule_ids' => 'appliedRuleIds',
        'base_amount_refunded' => 'baseAmountRefunded',
        'base_cost' => 'baseCost',
        'base_discount_amount' => 'baseDiscountAmount',
        'base_discount_invoiced' => 'baseDiscountInvoiced',
        'base_discount_refunded' => 'baseDiscountRefunded',
        'base_discount_tax_compensation_amount' => 'baseDiscountTaxCompensationAmount',
        'base_discount_tax_compensation_invoiced' => 'baseDiscountTaxCompensationInvoiced',
        'base_discount_tax_compensation_refunded' => 'baseDiscountTaxCompensationRefunded',
        'base_original_price' => 'baseOriginalPrice',
        'base_price' => 'basePrice',
        'base_price_incl_tax' => 'basePriceInclTax',
        'base_row_invoiced' => 'baseRowInvoiced',
        'base_row_total' => 'baseRowTotal',
        'base_row_total_incl_tax' => 'baseRowTotalInclTax',
        'base_tax_amount' => 'baseTaxAmount',
        'base_tax_before_discount' => 'baseTaxBeforeDiscount',
        'base_tax_invoiced' => 'baseTaxInvoiced',
        'base_tax_refunded' => 'baseTaxRefunded',
        'base_weee_tax_applied_amount' => 'baseWeeeTaxAppliedAmount',
        'base_weee_tax_applied_row_amnt' => 'baseWeeeTaxAppliedRowAmnt',
        'base_weee_tax_disposition' => 'baseWeeeTaxDisposition',
        'base_weee_tax_row_disposition' => 'baseWeeeTaxRowDisposition',
        'created_at' => 'createdAt',
        'description' => 'description',
        'discount_amount' => 'discountAmount',
        'discount_invoiced' => 'discountInvoiced',
        'discount_percent' => 'discountPercent',
        'discount_refunded' => 'discountRefunded',
        'event_id' => 'eventId',
        'ext_order_item_id' => 'extOrderItemId',
        'free_shipping' => 'freeShipping',
        'gw_base_price' => 'gwBasePrice',
        'gw_base_price_invoiced' => 'gwBasePriceInvoiced',
        'gw_base_price_refunded' => 'gwBasePriceRefunded',
        'gw_base_tax_amount' => 'gwBaseTaxAmount',
        'gw_base_tax_amount_invoiced' => 'gwBaseTaxAmountInvoiced',
        'gw_base_tax_amount_refunded' => 'gwBaseTaxAmountRefunded',
        'gw_id' => 'gwId',
        'gw_price' => 'gwPrice',
        'gw_price_invoiced' => 'gwPriceInvoiced',
        'gw_price_refunded' => 'gwPriceRefunded',
        'gw_tax_amount' => 'gwTaxAmount',
        'gw_tax_amount_invoiced' => 'gwTaxAmountInvoiced',
        'gw_tax_amount_refunded' => 'gwTaxAmountRefunded',
        'discount_tax_compensation_amount' => 'discountTaxCompensationAmount',
        'discount_tax_compensation_canceled' => 'discountTaxCompensationCanceled',
        'discount_tax_compensation_invoiced' => 'discountTaxCompensationInvoiced',
        'discount_tax_compensation_refunded' => 'discountTaxCompensationRefunded',
        'is_qty_decimal' => 'isQtyDecimal',
        'is_virtual' => 'isVirtual',
        'item_id' => 'itemId',
        'locked_do_invoice' => 'lockedDoInvoice',
        'locked_do_ship' => 'lockedDoShip',
        'name' => 'name',
        'no_discount' => 'noDiscount',
        'order_id' => 'orderId',
        'original_price' => 'originalPrice',
        'parent_item_id' => 'parentItemId',
        'price' => 'price',
        'price_incl_tax' => 'priceInclTax',
        'product_id' => 'productId',
        'product_type' => 'productType',
        'qty_backordered' => 'qtyBackordered',
        'qty_canceled' => 'qtyCanceled',
        'qty_invoiced' => 'qtyInvoiced',
        'qty_ordered' => 'qtyOrdered',
        'qty_refunded' => 'qtyRefunded',
        'qty_returned' => 'qtyReturned',
        'qty_shipped' => 'qtyShipped',
        'quote_item_id' => 'quoteItemId',
        'row_invoiced' => 'rowInvoiced',
        'row_total' => 'rowTotal',
        'row_total_incl_tax' => 'rowTotalInclTax',
        'row_weight' => 'rowWeight',
        'sku' => 'sku',
        'store_id' => 'storeId',
        'tax_amount' => 'taxAmount',
        'tax_before_discount' => 'taxBeforeDiscount',
        'tax_canceled' => 'taxCanceled',
        'tax_invoiced' => 'taxInvoiced',
        'tax_percent' => 'taxPercent',
        'tax_refunded' => 'taxRefunded',
        'updated_at' => 'updatedAt',
        'weee_tax_applied' => 'weeeTaxApplied',
        'weee_tax_applied_amount' => 'weeeTaxAppliedAmount',
        'weee_tax_applied_row_amount' => 'weeeTaxAppliedRowAmount',
        'weee_tax_disposition' => 'weeeTaxDisposition',
        'weee_tax_row_disposition' => 'weeeTaxRowDisposition',
        'weight' => 'weight',
        'parent_item' => 'parentItem',
        'product_option' => 'productOption',
        'extension_attributes' => 'extensionAttributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'additional_data' => 'setAdditionalData',
        'amount_refunded' => 'setAmountRefunded',
        'applied_rule_ids' => 'setAppliedRuleIds',
        'base_amount_refunded' => 'setBaseAmountRefunded',
        'base_cost' => 'setBaseCost',
        'base_discount_amount' => 'setBaseDiscountAmount',
        'base_discount_invoiced' => 'setBaseDiscountInvoiced',
        'base_discount_refunded' => 'setBaseDiscountRefunded',
        'base_discount_tax_compensation_amount' => 'setBaseDiscountTaxCompensationAmount',
        'base_discount_tax_compensation_invoiced' => 'setBaseDiscountTaxCompensationInvoiced',
        'base_discount_tax_compensation_refunded' => 'setBaseDiscountTaxCompensationRefunded',
        'base_original_price' => 'setBaseOriginalPrice',
        'base_price' => 'setBasePrice',
        'base_price_incl_tax' => 'setBasePriceInclTax',
        'base_row_invoiced' => 'setBaseRowInvoiced',
        'base_row_total' => 'setBaseRowTotal',
        'base_row_total_incl_tax' => 'setBaseRowTotalInclTax',
        'base_tax_amount' => 'setBaseTaxAmount',
        'base_tax_before_discount' => 'setBaseTaxBeforeDiscount',
        'base_tax_invoiced' => 'setBaseTaxInvoiced',
        'base_tax_refunded' => 'setBaseTaxRefunded',
        'base_weee_tax_applied_amount' => 'setBaseWeeeTaxAppliedAmount',
        'base_weee_tax_applied_row_amnt' => 'setBaseWeeeTaxAppliedRowAmnt',
        'base_weee_tax_disposition' => 'setBaseWeeeTaxDisposition',
        'base_weee_tax_row_disposition' => 'setBaseWeeeTaxRowDisposition',
        'created_at' => 'setCreatedAt',
        'description' => 'setDescription',
        'discount_amount' => 'setDiscountAmount',
        'discount_invoiced' => 'setDiscountInvoiced',
        'discount_percent' => 'setDiscountPercent',
        'discount_refunded' => 'setDiscountRefunded',
        'event_id' => 'setEventId',
        'ext_order_item_id' => 'setExtOrderItemId',
        'free_shipping' => 'setFreeShipping',
        'gw_base_price' => 'setGwBasePrice',
        'gw_base_price_invoiced' => 'setGwBasePriceInvoiced',
        'gw_base_price_refunded' => 'setGwBasePriceRefunded',
        'gw_base_tax_amount' => 'setGwBaseTaxAmount',
        'gw_base_tax_amount_invoiced' => 'setGwBaseTaxAmountInvoiced',
        'gw_base_tax_amount_refunded' => 'setGwBaseTaxAmountRefunded',
        'gw_id' => 'setGwId',
        'gw_price' => 'setGwPrice',
        'gw_price_invoiced' => 'setGwPriceInvoiced',
        'gw_price_refunded' => 'setGwPriceRefunded',
        'gw_tax_amount' => 'setGwTaxAmount',
        'gw_tax_amount_invoiced' => 'setGwTaxAmountInvoiced',
        'gw_tax_amount_refunded' => 'setGwTaxAmountRefunded',
        'discount_tax_compensation_amount' => 'setDiscountTaxCompensationAmount',
        'discount_tax_compensation_canceled' => 'setDiscountTaxCompensationCanceled',
        'discount_tax_compensation_invoiced' => 'setDiscountTaxCompensationInvoiced',
        'discount_tax_compensation_refunded' => 'setDiscountTaxCompensationRefunded',
        'is_qty_decimal' => 'setIsQtyDecimal',
        'is_virtual' => 'setIsVirtual',
        'item_id' => 'setItemId',
        'locked_do_invoice' => 'setLockedDoInvoice',
        'locked_do_ship' => 'setLockedDoShip',
        'name' => 'setName',
        'no_discount' => 'setNoDiscount',
        'order_id' => 'setOrderId',
        'original_price' => 'setOriginalPrice',
        'parent_item_id' => 'setParentItemId',
        'price' => 'setPrice',
        'price_incl_tax' => 'setPriceInclTax',
        'product_id' => 'setProductId',
        'product_type' => 'setProductType',
        'qty_backordered' => 'setQtyBackordered',
        'qty_canceled' => 'setQtyCanceled',
        'qty_invoiced' => 'setQtyInvoiced',
        'qty_ordered' => 'setQtyOrdered',
        'qty_refunded' => 'setQtyRefunded',
        'qty_returned' => 'setQtyReturned',
        'qty_shipped' => 'setQtyShipped',
        'quote_item_id' => 'setQuoteItemId',
        'row_invoiced' => 'setRowInvoiced',
        'row_total' => 'setRowTotal',
        'row_total_incl_tax' => 'setRowTotalInclTax',
        'row_weight' => 'setRowWeight',
        'sku' => 'setSku',
        'store_id' => 'setStoreId',
        'tax_amount' => 'setTaxAmount',
        'tax_before_discount' => 'setTaxBeforeDiscount',
        'tax_canceled' => 'setTaxCanceled',
        'tax_invoiced' => 'setTaxInvoiced',
        'tax_percent' => 'setTaxPercent',
        'tax_refunded' => 'setTaxRefunded',
        'updated_at' => 'setUpdatedAt',
        'weee_tax_applied' => 'setWeeeTaxApplied',
        'weee_tax_applied_amount' => 'setWeeeTaxAppliedAmount',
        'weee_tax_applied_row_amount' => 'setWeeeTaxAppliedRowAmount',
        'weee_tax_disposition' => 'setWeeeTaxDisposition',
        'weee_tax_row_disposition' => 'setWeeeTaxRowDisposition',
        'weight' => 'setWeight',
        'parent_item' => 'setParentItem',
        'product_option' => 'setProductOption',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'additional_data' => 'getAdditionalData',
        'amount_refunded' => 'getAmountRefunded',
        'applied_rule_ids' => 'getAppliedRuleIds',
        'base_amount_refunded' => 'getBaseAmountRefunded',
        'base_cost' => 'getBaseCost',
        'base_discount_amount' => 'getBaseDiscountAmount',
        'base_discount_invoiced' => 'getBaseDiscountInvoiced',
        'base_discount_refunded' => 'getBaseDiscountRefunded',
        'base_discount_tax_compensation_amount' => 'getBaseDiscountTaxCompensationAmount',
        'base_discount_tax_compensation_invoiced' => 'getBaseDiscountTaxCompensationInvoiced',
        'base_discount_tax_compensation_refunded' => 'getBaseDiscountTaxCompensationRefunded',
        'base_original_price' => 'getBaseOriginalPrice',
        'base_price' => 'getBasePrice',
        'base_price_incl_tax' => 'getBasePriceInclTax',
        'base_row_invoiced' => 'getBaseRowInvoiced',
        'base_row_total' => 'getBaseRowTotal',
        'base_row_total_incl_tax' => 'getBaseRowTotalInclTax',
        'base_tax_amount' => 'getBaseTaxAmount',
        'base_tax_before_discount' => 'getBaseTaxBeforeDiscount',
        'base_tax_invoiced' => 'getBaseTaxInvoiced',
        'base_tax_refunded' => 'getBaseTaxRefunded',
        'base_weee_tax_applied_amount' => 'getBaseWeeeTaxAppliedAmount',
        'base_weee_tax_applied_row_amnt' => 'getBaseWeeeTaxAppliedRowAmnt',
        'base_weee_tax_disposition' => 'getBaseWeeeTaxDisposition',
        'base_weee_tax_row_disposition' => 'getBaseWeeeTaxRowDisposition',
        'created_at' => 'getCreatedAt',
        'description' => 'getDescription',
        'discount_amount' => 'getDiscountAmount',
        'discount_invoiced' => 'getDiscountInvoiced',
        'discount_percent' => 'getDiscountPercent',
        'discount_refunded' => 'getDiscountRefunded',
        'event_id' => 'getEventId',
        'ext_order_item_id' => 'getExtOrderItemId',
        'free_shipping' => 'getFreeShipping',
        'gw_base_price' => 'getGwBasePrice',
        'gw_base_price_invoiced' => 'getGwBasePriceInvoiced',
        'gw_base_price_refunded' => 'getGwBasePriceRefunded',
        'gw_base_tax_amount' => 'getGwBaseTaxAmount',
        'gw_base_tax_amount_invoiced' => 'getGwBaseTaxAmountInvoiced',
        'gw_base_tax_amount_refunded' => 'getGwBaseTaxAmountRefunded',
        'gw_id' => 'getGwId',
        'gw_price' => 'getGwPrice',
        'gw_price_invoiced' => 'getGwPriceInvoiced',
        'gw_price_refunded' => 'getGwPriceRefunded',
        'gw_tax_amount' => 'getGwTaxAmount',
        'gw_tax_amount_invoiced' => 'getGwTaxAmountInvoiced',
        'gw_tax_amount_refunded' => 'getGwTaxAmountRefunded',
        'discount_tax_compensation_amount' => 'getDiscountTaxCompensationAmount',
        'discount_tax_compensation_canceled' => 'getDiscountTaxCompensationCanceled',
        'discount_tax_compensation_invoiced' => 'getDiscountTaxCompensationInvoiced',
        'discount_tax_compensation_refunded' => 'getDiscountTaxCompensationRefunded',
        'is_qty_decimal' => 'getIsQtyDecimal',
        'is_virtual' => 'getIsVirtual',
        'item_id' => 'getItemId',
        'locked_do_invoice' => 'getLockedDoInvoice',
        'locked_do_ship' => 'getLockedDoShip',
        'name' => 'getName',
        'no_discount' => 'getNoDiscount',
        'order_id' => 'getOrderId',
        'original_price' => 'getOriginalPrice',
        'parent_item_id' => 'getParentItemId',
        'price' => 'getPrice',
        'price_incl_tax' => 'getPriceInclTax',
        'product_id' => 'getProductId',
        'product_type' => 'getProductType',
        'qty_backordered' => 'getQtyBackordered',
        'qty_canceled' => 'getQtyCanceled',
        'qty_invoiced' => 'getQtyInvoiced',
        'qty_ordered' => 'getQtyOrdered',
        'qty_refunded' => 'getQtyRefunded',
        'qty_returned' => 'getQtyReturned',
        'qty_shipped' => 'getQtyShipped',
        'quote_item_id' => 'getQuoteItemId',
        'row_invoiced' => 'getRowInvoiced',
        'row_total' => 'getRowTotal',
        'row_total_incl_tax' => 'getRowTotalInclTax',
        'row_weight' => 'getRowWeight',
        'sku' => 'getSku',
        'store_id' => 'getStoreId',
        'tax_amount' => 'getTaxAmount',
        'tax_before_discount' => 'getTaxBeforeDiscount',
        'tax_canceled' => 'getTaxCanceled',
        'tax_invoiced' => 'getTaxInvoiced',
        'tax_percent' => 'getTaxPercent',
        'tax_refunded' => 'getTaxRefunded',
        'updated_at' => 'getUpdatedAt',
        'weee_tax_applied' => 'getWeeeTaxApplied',
        'weee_tax_applied_amount' => 'getWeeeTaxAppliedAmount',
        'weee_tax_applied_row_amount' => 'getWeeeTaxAppliedRowAmount',
        'weee_tax_disposition' => 'getWeeeTaxDisposition',
        'weee_tax_row_disposition' => 'getWeeeTaxRowDisposition',
        'weight' => 'getWeight',
        'parent_item' => 'getParentItem',
        'product_option' => 'getProductOption',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['additional_data'] = isset($data['additional_data']) ? $data['additional_data'] : null;
        $this->container['amount_refunded'] = isset($data['amount_refunded']) ? $data['amount_refunded'] : null;
        $this->container['applied_rule_ids'] = isset($data['applied_rule_ids']) ? $data['applied_rule_ids'] : null;
        $this->container['base_amount_refunded'] = isset($data['base_amount_refunded']) ? $data['base_amount_refunded'] : null;
        $this->container['base_cost'] = isset($data['base_cost']) ? $data['base_cost'] : null;
        $this->container['base_discount_amount'] = isset($data['base_discount_amount']) ? $data['base_discount_amount'] : null;
        $this->container['base_discount_invoiced'] = isset($data['base_discount_invoiced']) ? $data['base_discount_invoiced'] : null;
        $this->container['base_discount_refunded'] = isset($data['base_discount_refunded']) ? $data['base_discount_refunded'] : null;
        $this->container['base_discount_tax_compensation_amount'] = isset($data['base_discount_tax_compensation_amount']) ? $data['base_discount_tax_compensation_amount'] : null;
        $this->container['base_discount_tax_compensation_invoiced'] = isset($data['base_discount_tax_compensation_invoiced']) ? $data['base_discount_tax_compensation_invoiced'] : null;
        $this->container['base_discount_tax_compensation_refunded'] = isset($data['base_discount_tax_compensation_refunded']) ? $data['base_discount_tax_compensation_refunded'] : null;
        $this->container['base_original_price'] = isset($data['base_original_price']) ? $data['base_original_price'] : null;
        $this->container['base_price'] = isset($data['base_price']) ? $data['base_price'] : null;
        $this->container['base_price_incl_tax'] = isset($data['base_price_incl_tax']) ? $data['base_price_incl_tax'] : null;
        $this->container['base_row_invoiced'] = isset($data['base_row_invoiced']) ? $data['base_row_invoiced'] : null;
        $this->container['base_row_total'] = isset($data['base_row_total']) ? $data['base_row_total'] : null;
        $this->container['base_row_total_incl_tax'] = isset($data['base_row_total_incl_tax']) ? $data['base_row_total_incl_tax'] : null;
        $this->container['base_tax_amount'] = isset($data['base_tax_amount']) ? $data['base_tax_amount'] : null;
        $this->container['base_tax_before_discount'] = isset($data['base_tax_before_discount']) ? $data['base_tax_before_discount'] : null;
        $this->container['base_tax_invoiced'] = isset($data['base_tax_invoiced']) ? $data['base_tax_invoiced'] : null;
        $this->container['base_tax_refunded'] = isset($data['base_tax_refunded']) ? $data['base_tax_refunded'] : null;
        $this->container['base_weee_tax_applied_amount'] = isset($data['base_weee_tax_applied_amount']) ? $data['base_weee_tax_applied_amount'] : null;
        $this->container['base_weee_tax_applied_row_amnt'] = isset($data['base_weee_tax_applied_row_amnt']) ? $data['base_weee_tax_applied_row_amnt'] : null;
        $this->container['base_weee_tax_disposition'] = isset($data['base_weee_tax_disposition']) ? $data['base_weee_tax_disposition'] : null;
        $this->container['base_weee_tax_row_disposition'] = isset($data['base_weee_tax_row_disposition']) ? $data['base_weee_tax_row_disposition'] : null;
        $this->container['created_at'] = isset($data['created_at']) ? $data['created_at'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['discount_amount'] = isset($data['discount_amount']) ? $data['discount_amount'] : null;
        $this->container['discount_invoiced'] = isset($data['discount_invoiced']) ? $data['discount_invoiced'] : null;
        $this->container['discount_percent'] = isset($data['discount_percent']) ? $data['discount_percent'] : null;
        $this->container['discount_refunded'] = isset($data['discount_refunded']) ? $data['discount_refunded'] : null;
        $this->container['event_id'] = isset($data['event_id']) ? $data['event_id'] : null;
        $this->container['ext_order_item_id'] = isset($data['ext_order_item_id']) ? $data['ext_order_item_id'] : null;
        $this->container['free_shipping'] = isset($data['free_shipping']) ? $data['free_shipping'] : null;
        $this->container['gw_base_price'] = isset($data['gw_base_price']) ? $data['gw_base_price'] : null;
        $this->container['gw_base_price_invoiced'] = isset($data['gw_base_price_invoiced']) ? $data['gw_base_price_invoiced'] : null;
        $this->container['gw_base_price_refunded'] = isset($data['gw_base_price_refunded']) ? $data['gw_base_price_refunded'] : null;
        $this->container['gw_base_tax_amount'] = isset($data['gw_base_tax_amount']) ? $data['gw_base_tax_amount'] : null;
        $this->container['gw_base_tax_amount_invoiced'] = isset($data['gw_base_tax_amount_invoiced']) ? $data['gw_base_tax_amount_invoiced'] : null;
        $this->container['gw_base_tax_amount_refunded'] = isset($data['gw_base_tax_amount_refunded']) ? $data['gw_base_tax_amount_refunded'] : null;
        $this->container['gw_id'] = isset($data['gw_id']) ? $data['gw_id'] : null;
        $this->container['gw_price'] = isset($data['gw_price']) ? $data['gw_price'] : null;
        $this->container['gw_price_invoiced'] = isset($data['gw_price_invoiced']) ? $data['gw_price_invoiced'] : null;
        $this->container['gw_price_refunded'] = isset($data['gw_price_refunded']) ? $data['gw_price_refunded'] : null;
        $this->container['gw_tax_amount'] = isset($data['gw_tax_amount']) ? $data['gw_tax_amount'] : null;
        $this->container['gw_tax_amount_invoiced'] = isset($data['gw_tax_amount_invoiced']) ? $data['gw_tax_amount_invoiced'] : null;
        $this->container['gw_tax_amount_refunded'] = isset($data['gw_tax_amount_refunded']) ? $data['gw_tax_amount_refunded'] : null;
        $this->container['discount_tax_compensation_amount'] = isset($data['discount_tax_compensation_amount']) ? $data['discount_tax_compensation_amount'] : null;
        $this->container['discount_tax_compensation_canceled'] = isset($data['discount_tax_compensation_canceled']) ? $data['discount_tax_compensation_canceled'] : null;
        $this->container['discount_tax_compensation_invoiced'] = isset($data['discount_tax_compensation_invoiced']) ? $data['discount_tax_compensation_invoiced'] : null;
        $this->container['discount_tax_compensation_refunded'] = isset($data['discount_tax_compensation_refunded']) ? $data['discount_tax_compensation_refunded'] : null;
        $this->container['is_qty_decimal'] = isset($data['is_qty_decimal']) ? $data['is_qty_decimal'] : null;
        $this->container['is_virtual'] = isset($data['is_virtual']) ? $data['is_virtual'] : null;
        $this->container['item_id'] = isset($data['item_id']) ? $data['item_id'] : null;
        $this->container['locked_do_invoice'] = isset($data['locked_do_invoice']) ? $data['locked_do_invoice'] : null;
        $this->container['locked_do_ship'] = isset($data['locked_do_ship']) ? $data['locked_do_ship'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['no_discount'] = isset($data['no_discount']) ? $data['no_discount'] : null;
        $this->container['order_id'] = isset($data['order_id']) ? $data['order_id'] : null;
        $this->container['original_price'] = isset($data['original_price']) ? $data['original_price'] : null;
        $this->container['parent_item_id'] = isset($data['parent_item_id']) ? $data['parent_item_id'] : null;
        $this->container['price'] = isset($data['price']) ? $data['price'] : null;
        $this->container['price_incl_tax'] = isset($data['price_incl_tax']) ? $data['price_incl_tax'] : null;
        $this->container['product_id'] = isset($data['product_id']) ? $data['product_id'] : null;
        $this->container['product_type'] = isset($data['product_type']) ? $data['product_type'] : null;
        $this->container['qty_backordered'] = isset($data['qty_backordered']) ? $data['qty_backordered'] : null;
        $this->container['qty_canceled'] = isset($data['qty_canceled']) ? $data['qty_canceled'] : null;
        $this->container['qty_invoiced'] = isset($data['qty_invoiced']) ? $data['qty_invoiced'] : null;
        $this->container['qty_ordered'] = isset($data['qty_ordered']) ? $data['qty_ordered'] : null;
        $this->container['qty_refunded'] = isset($data['qty_refunded']) ? $data['qty_refunded'] : null;
        $this->container['qty_returned'] = isset($data['qty_returned']) ? $data['qty_returned'] : null;
        $this->container['qty_shipped'] = isset($data['qty_shipped']) ? $data['qty_shipped'] : null;
        $this->container['quote_item_id'] = isset($data['quote_item_id']) ? $data['quote_item_id'] : null;
        $this->container['row_invoiced'] = isset($data['row_invoiced']) ? $data['row_invoiced'] : null;
        $this->container['row_total'] = isset($data['row_total']) ? $data['row_total'] : null;
        $this->container['row_total_incl_tax'] = isset($data['row_total_incl_tax']) ? $data['row_total_incl_tax'] : null;
        $this->container['row_weight'] = isset($data['row_weight']) ? $data['row_weight'] : null;
        $this->container['sku'] = isset($data['sku']) ? $data['sku'] : null;
        $this->container['store_id'] = isset($data['store_id']) ? $data['store_id'] : null;
        $this->container['tax_amount'] = isset($data['tax_amount']) ? $data['tax_amount'] : null;
        $this->container['tax_before_discount'] = isset($data['tax_before_discount']) ? $data['tax_before_discount'] : null;
        $this->container['tax_canceled'] = isset($data['tax_canceled']) ? $data['tax_canceled'] : null;
        $this->container['tax_invoiced'] = isset($data['tax_invoiced']) ? $data['tax_invoiced'] : null;
        $this->container['tax_percent'] = isset($data['tax_percent']) ? $data['tax_percent'] : null;
        $this->container['tax_refunded'] = isset($data['tax_refunded']) ? $data['tax_refunded'] : null;
        $this->container['updated_at'] = isset($data['updated_at']) ? $data['updated_at'] : null;
        $this->container['weee_tax_applied'] = isset($data['weee_tax_applied']) ? $data['weee_tax_applied'] : null;
        $this->container['weee_tax_applied_amount'] = isset($data['weee_tax_applied_amount']) ? $data['weee_tax_applied_amount'] : null;
        $this->container['weee_tax_applied_row_amount'] = isset($data['weee_tax_applied_row_amount']) ? $data['weee_tax_applied_row_amount'] : null;
        $this->container['weee_tax_disposition'] = isset($data['weee_tax_disposition']) ? $data['weee_tax_disposition'] : null;
        $this->container['weee_tax_row_disposition'] = isset($data['weee_tax_row_disposition']) ? $data['weee_tax_row_disposition'] : null;
        $this->container['weight'] = isset($data['weight']) ? $data['weight'] : null;
        $this->container['parent_item'] = isset($data['parent_item']) ? $data['parent_item'] : null;
        $this->container['product_option'] = isset($data['product_option']) ? $data['product_option'] : null;
        $this->container['extension_attributes'] = isset($data['extension_attributes']) ? $data['extension_attributes'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['sku'] === null) {
            $invalidProperties[] = "'sku' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['sku'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets additional_data
     *
     * @return string
     */
    public function getAdditionalData()
    {
        return $this->container['additional_data'];
    }

    /**
     * Sets additional_data
     *
     * @param string $additional_data Additional data.
     *
     * @return $this
     */
    public function setAdditionalData($additional_data)
    {
        $this->container['additional_data'] = $additional_data;

        return $this;
    }

    /**
     * Gets amount_refunded
     *
     * @return float
     */
    public function getAmountRefunded()
    {
        return $this->container['amount_refunded'];
    }

    /**
     * Sets amount_refunded
     *
     * @param float $amount_refunded Amount refunded.
     *
     * @return $this
     */
    public function setAmountRefunded($amount_refunded)
    {
        $this->container['amount_refunded'] = $amount_refunded;

        return $this;
    }

    /**
     * Gets applied_rule_ids
     *
     * @return string
     */
    public function getAppliedRuleIds()
    {
        return $this->container['applied_rule_ids'];
    }

    /**
     * Sets applied_rule_ids
     *
     * @param string $applied_rule_ids Applied rule IDs.
     *
     * @return $this
     */
    public function setAppliedRuleIds($applied_rule_ids)
    {
        $this->container['applied_rule_ids'] = $applied_rule_ids;

        return $this;
    }

    /**
     * Gets base_amount_refunded
     *
     * @return float
     */
    public function getBaseAmountRefunded()
    {
        return $this->container['base_amount_refunded'];
    }

    /**
     * Sets base_amount_refunded
     *
     * @param float $base_amount_refunded Base amount refunded.
     *
     * @return $this
     */
    public function setBaseAmountRefunded($base_amount_refunded)
    {
        $this->container['base_amount_refunded'] = $base_amount_refunded;

        return $this;
    }

    /**
     * Gets base_cost
     *
     * @return float
     */
    public function getBaseCost()
    {
        return $this->container['base_cost'];
    }

    /**
     * Sets base_cost
     *
     * @param float $base_cost Base cost.
     *
     * @return $this
     */
    public function setBaseCost($base_cost)
    {
        $this->container['base_cost'] = $base_cost;

        return $this;
    }

    /**
     * Gets base_discount_amount
     *
     * @return float
     */
    public function getBaseDiscountAmount()
    {
        return $this->container['base_discount_amount'];
    }

    /**
     * Sets base_discount_amount
     *
     * @param float $base_discount_amount Base discount amount.
     *
     * @return $this
     */
    public function setBaseDiscountAmount($base_discount_amount)
    {
        $this->container['base_discount_amount'] = $base_discount_amount;

        return $this;
    }

    /**
     * Gets base_discount_invoiced
     *
     * @return float
     */
    public function getBaseDiscountInvoiced()
    {
        return $this->container['base_discount_invoiced'];
    }

    /**
     * Sets base_discount_invoiced
     *
     * @param float $base_discount_invoiced Base discount invoiced.
     *
     * @return $this
     */
    public function setBaseDiscountInvoiced($base_discount_invoiced)
    {
        $this->container['base_discount_invoiced'] = $base_discount_invoiced;

        return $this;
    }

    /**
     * Gets base_discount_refunded
     *
     * @return float
     */
    public function getBaseDiscountRefunded()
    {
        return $this->container['base_discount_refunded'];
    }

    /**
     * Sets base_discount_refunded
     *
     * @param float $base_discount_refunded Base discount refunded.
     *
     * @return $this
     */
    public function setBaseDiscountRefunded($base_discount_refunded)
    {
        $this->container['base_discount_refunded'] = $base_discount_refunded;

        return $this;
    }

    /**
     * Gets base_discount_tax_compensation_amount
     *
     * @return float
     */
    public function getBaseDiscountTaxCompensationAmount()
    {
        return $this->container['base_discount_tax_compensation_amount'];
    }

    /**
     * Sets base_discount_tax_compensation_amount
     *
     * @param float $base_discount_tax_compensation_amount Base discount tax compensation amount.
     *
     * @return $this
     */
    public function setBaseDiscountTaxCompensationAmount($base_discount_tax_compensation_amount)
    {
        $this->container['base_discount_tax_compensation_amount'] = $base_discount_tax_compensation_amount;

        return $this;
    }

    /**
     * Gets base_discount_tax_compensation_invoiced
     *
     * @return float
     */
    public function getBaseDiscountTaxCompensationInvoiced()
    {
        return $this->container['base_discount_tax_compensation_invoiced'];
    }

    /**
     * Sets base_discount_tax_compensation_invoiced
     *
     * @param float $base_discount_tax_compensation_invoiced Base discount tax compensation invoiced.
     *
     * @return $this
     */
    public function setBaseDiscountTaxCompensationInvoiced($base_discount_tax_compensation_invoiced)
    {
        $this->container['base_discount_tax_compensation_invoiced'] = $base_discount_tax_compensation_invoiced;

        return $this;
    }

    /**
     * Gets base_discount_tax_compensation_refunded
     *
     * @return float
     */
    public function getBaseDiscountTaxCompensationRefunded()
    {
        return $this->container['base_discount_tax_compensation_refunded'];
    }

    /**
     * Sets base_discount_tax_compensation_refunded
     *
     * @param float $base_discount_tax_compensation_refunded Base discount tax compensation refunded.
     *
     * @return $this
     */
    public function setBaseDiscountTaxCompensationRefunded($base_discount_tax_compensation_refunded)
    {
        $this->container['base_discount_tax_compensation_refunded'] = $base_discount_tax_compensation_refunded;

        return $this;
    }

    /**
     * Gets base_original_price
     *
     * @return float
     */
    public function getBaseOriginalPrice()
    {
        return $this->container['base_original_price'];
    }

    /**
     * Sets base_original_price
     *
     * @param float $base_original_price Base original price.
     *
     * @return $this
     */
    public function setBaseOriginalPrice($base_original_price)
    {
        $this->container['base_original_price'] = $base_original_price;

        return $this;
    }

    /**
     * Gets base_price
     *
     * @return float
     */
    public function getBasePrice()
    {
        return $this->container['base_price'];
    }

    /**
     * Sets base_price
     *
     * @param float $base_price Base price.
     *
     * @return $this
     */
    public function setBasePrice($base_price)
    {
        $this->container['base_price'] = $base_price;

        return $this;
    }

    /**
     * Gets base_price_incl_tax
     *
     * @return float
     */
    public function getBasePriceInclTax()
    {
        return $this->container['base_price_incl_tax'];
    }

    /**
     * Sets base_price_incl_tax
     *
     * @param float $base_price_incl_tax Base price including tax.
     *
     * @return $this
     */
    public function setBasePriceInclTax($base_price_incl_tax)
    {
        $this->container['base_price_incl_tax'] = $base_price_incl_tax;

        return $this;
    }

    /**
     * Gets base_row_invoiced
     *
     * @return float
     */
    public function getBaseRowInvoiced()
    {
        return $this->container['base_row_invoiced'];
    }

    /**
     * Sets base_row_invoiced
     *
     * @param float $base_row_invoiced Base row invoiced.
     *
     * @return $this
     */
    public function setBaseRowInvoiced($base_row_invoiced)
    {
        $this->container['base_row_invoiced'] = $base_row_invoiced;

        return $this;
    }

    /**
     * Gets base_row_total
     *
     * @return float
     */
    public function getBaseRowTotal()
    {
        return $this->container['base_row_total'];
    }

    /**
     * Sets base_row_total
     *
     * @param float $base_row_total Base row total.
     *
     * @return $this
     */
    public function setBaseRowTotal($base_row_total)
    {
        $this->container['base_row_total'] = $base_row_total;

        return $this;
    }

    /**
     * Gets base_row_total_incl_tax
     *
     * @return float
     */
    public function getBaseRowTotalInclTax()
    {
        return $this->container['base_row_total_incl_tax'];
    }

    /**
     * Sets base_row_total_incl_tax
     *
     * @param float $base_row_total_incl_tax Base row total including tax.
     *
     * @return $this
     */
    public function setBaseRowTotalInclTax($base_row_total_incl_tax)
    {
        $this->container['base_row_total_incl_tax'] = $base_row_total_incl_tax;

        return $this;
    }

    /**
     * Gets base_tax_amount
     *
     * @return float
     */
    public function getBaseTaxAmount()
    {
        return $this->container['base_tax_amount'];
    }

    /**
     * Sets base_tax_amount
     *
     * @param float $base_tax_amount Base tax amount.
     *
     * @return $this
     */
    public function setBaseTaxAmount($base_tax_amount)
    {
        $this->container['base_tax_amount'] = $base_tax_amount;

        return $this;
    }

    /**
     * Gets base_tax_before_discount
     *
     * @return float
     */
    public function getBaseTaxBeforeDiscount()
    {
        return $this->container['base_tax_before_discount'];
    }

    /**
     * Sets base_tax_before_discount
     *
     * @param float $base_tax_before_discount Base tax before discount.
     *
     * @return $this
     */
    public function setBaseTaxBeforeDiscount($base_tax_before_discount)
    {
        $this->container['base_tax_before_discount'] = $base_tax_before_discount;

        return $this;
    }

    /**
     * Gets base_tax_invoiced
     *
     * @return float
     */
    public function getBaseTaxInvoiced()
    {
        return $this->container['base_tax_invoiced'];
    }

    /**
     * Sets base_tax_invoiced
     *
     * @param float $base_tax_invoiced Base tax invoiced.
     *
     * @return $this
     */
    public function setBaseTaxInvoiced($base_tax_invoiced)
    {
        $this->container['base_tax_invoiced'] = $base_tax_invoiced;

        return $this;
    }

    /**
     * Gets base_tax_refunded
     *
     * @return float
     */
    public function getBaseTaxRefunded()
    {
        return $this->container['base_tax_refunded'];
    }

    /**
     * Sets base_tax_refunded
     *
     * @param float $base_tax_refunded Base tax refunded.
     *
     * @return $this
     */
    public function setBaseTaxRefunded($base_tax_refunded)
    {
        $this->container['base_tax_refunded'] = $base_tax_refunded;

        return $this;
    }

    /**
     * Gets base_weee_tax_applied_amount
     *
     * @return float
     */
    public function getBaseWeeeTaxAppliedAmount()
    {
        return $this->container['base_weee_tax_applied_amount'];
    }

    /**
     * Sets base_weee_tax_applied_amount
     *
     * @param float $base_weee_tax_applied_amount Base WEEE tax applied amount.
     *
     * @return $this
     */
    public function setBaseWeeeTaxAppliedAmount($base_weee_tax_applied_amount)
    {
        $this->container['base_weee_tax_applied_amount'] = $base_weee_tax_applied_amount;

        return $this;
    }

    /**
     * Gets base_weee_tax_applied_row_amnt
     *
     * @return float
     */
    public function getBaseWeeeTaxAppliedRowAmnt()
    {
        return $this->container['base_weee_tax_applied_row_amnt'];
    }

    /**
     * Sets base_weee_tax_applied_row_amnt
     *
     * @param float $base_weee_tax_applied_row_amnt Base WEEE tax applied row amount.
     *
     * @return $this
     */
    public function setBaseWeeeTaxAppliedRowAmnt($base_weee_tax_applied_row_amnt)
    {
        $this->container['base_weee_tax_applied_row_amnt'] = $base_weee_tax_applied_row_amnt;

        return $this;
    }

    /**
     * Gets base_weee_tax_disposition
     *
     * @return float
     */
    public function getBaseWeeeTaxDisposition()
    {
        return $this->container['base_weee_tax_disposition'];
    }

    /**
     * Sets base_weee_tax_disposition
     *
     * @param float $base_weee_tax_disposition Base WEEE tax disposition.
     *
     * @return $this
     */
    public function setBaseWeeeTaxDisposition($base_weee_tax_disposition)
    {
        $this->container['base_weee_tax_disposition'] = $base_weee_tax_disposition;

        return $this;
    }

    /**
     * Gets base_weee_tax_row_disposition
     *
     * @return float
     */
    public function getBaseWeeeTaxRowDisposition()
    {
        return $this->container['base_weee_tax_row_disposition'];
    }

    /**
     * Sets base_weee_tax_row_disposition
     *
     * @param float $base_weee_tax_row_disposition Base WEEE tax row disposition.
     *
     * @return $this
     */
    public function setBaseWeeeTaxRowDisposition($base_weee_tax_row_disposition)
    {
        $this->container['base_weee_tax_row_disposition'] = $base_weee_tax_row_disposition;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string $created_at Created-at timestamp.
     *
     * @return $this
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description Description.
     *
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets discount_amount
     *
     * @return float
     */
    public function getDiscountAmount()
    {
        return $this->container['discount_amount'];
    }

    /**
     * Sets discount_amount
     *
     * @param float $discount_amount Discount amount.
     *
     * @return $this
     */
    public function setDiscountAmount($discount_amount)
    {
        $this->container['discount_amount'] = $discount_amount;

        return $this;
    }

    /**
     * Gets discount_invoiced
     *
     * @return float
     */
    public function getDiscountInvoiced()
    {
        return $this->container['discount_invoiced'];
    }

    /**
     * Sets discount_invoiced
     *
     * @param float $discount_invoiced Discount invoiced.
     *
     * @return $this
     */
    public function setDiscountInvoiced($discount_invoiced)
    {
        $this->container['discount_invoiced'] = $discount_invoiced;

        return $this;
    }

    /**
     * Gets discount_percent
     *
     * @return float
     */
    public function getDiscountPercent()
    {
        return $this->container['discount_percent'];
    }

    /**
     * Sets discount_percent
     *
     * @param float $discount_percent Discount percent.
     *
     * @return $this
     */
    public function setDiscountPercent($discount_percent)
    {
        $this->container['discount_percent'] = $discount_percent;

        return $this;
    }

    /**
     * Gets discount_refunded
     *
     * @return float
     */
    public function getDiscountRefunded()
    {
        return $this->container['discount_refunded'];
    }

    /**
     * Sets discount_refunded
     *
     * @param float $discount_refunded Discount refunded.
     *
     * @return $this
     */
    public function setDiscountRefunded($discount_refunded)
    {
        $this->container['discount_refunded'] = $discount_refunded;

        return $this;
    }

    /**
     * Gets event_id
     *
     * @return int
     */
    public function getEventId()
    {
        return $this->container['event_id'];
    }

    /**
     * Sets event_id
     *
     * @param int $event_id Event ID.
     *
     * @return $this
     */
    public function setEventId($event_id)
    {
        $this->container['event_id'] = $event_id;

        return $this;
    }

    /**
     * Gets ext_order_item_id
     *
     * @return string
     */
    public function getExtOrderItemId()
    {
        return $this->container['ext_order_item_id'];
    }

    /**
     * Sets ext_order_item_id
     *
     * @param string $ext_order_item_id External order item ID.
     *
     * @return $this
     */
    public function setExtOrderItemId($ext_order_item_id)
    {
        $this->container['ext_order_item_id'] = $ext_order_item_id;

        return $this;
    }

    /**
     * Gets free_shipping
     *
     * @return int
     */
    public function getFreeShipping()
    {
        return $this->container['free_shipping'];
    }

    /**
     * Sets free_shipping
     *
     * @param int $free_shipping Free-shipping flag value.
     *
     * @return $this
     */
    public function setFreeShipping($free_shipping)
    {
        $this->container['free_shipping'] = $free_shipping;

        return $this;
    }

    /**
     * Gets gw_base_price
     *
     * @return float
     */
    public function getGwBasePrice()
    {
        return $this->container['gw_base_price'];
    }

    /**
     * Sets gw_base_price
     *
     * @param float $gw_base_price GW base price.
     *
     * @return $this
     */
    public function setGwBasePrice($gw_base_price)
    {
        $this->container['gw_base_price'] = $gw_base_price;

        return $this;
    }

    /**
     * Gets gw_base_price_invoiced
     *
     * @return float
     */
    public function getGwBasePriceInvoiced()
    {
        return $this->container['gw_base_price_invoiced'];
    }

    /**
     * Sets gw_base_price_invoiced
     *
     * @param float $gw_base_price_invoiced GW base price invoiced.
     *
     * @return $this
     */
    public function setGwBasePriceInvoiced($gw_base_price_invoiced)
    {
        $this->container['gw_base_price_invoiced'] = $gw_base_price_invoiced;

        return $this;
    }

    /**
     * Gets gw_base_price_refunded
     *
     * @return float
     */
    public function getGwBasePriceRefunded()
    {
        return $this->container['gw_base_price_refunded'];
    }

    /**
     * Sets gw_base_price_refunded
     *
     * @param float $gw_base_price_refunded GW base price refunded.
     *
     * @return $this
     */
    public function setGwBasePriceRefunded($gw_base_price_refunded)
    {
        $this->container['gw_base_price_refunded'] = $gw_base_price_refunded;

        return $this;
    }

    /**
     * Gets gw_base_tax_amount
     *
     * @return float
     */
    public function getGwBaseTaxAmount()
    {
        return $this->container['gw_base_tax_amount'];
    }

    /**
     * Sets gw_base_tax_amount
     *
     * @param float $gw_base_tax_amount GW base tax amount.
     *
     * @return $this
     */
    public function setGwBaseTaxAmount($gw_base_tax_amount)
    {
        $this->container['gw_base_tax_amount'] = $gw_base_tax_amount;

        return $this;
    }

    /**
     * Gets gw_base_tax_amount_invoiced
     *
     * @return float
     */
    public function getGwBaseTaxAmountInvoiced()
    {
        return $this->container['gw_base_tax_amount_invoiced'];
    }

    /**
     * Sets gw_base_tax_amount_invoiced
     *
     * @param float $gw_base_tax_amount_invoiced GW base tax amount invoiced.
     *
     * @return $this
     */
    public function setGwBaseTaxAmountInvoiced($gw_base_tax_amount_invoiced)
    {
        $this->container['gw_base_tax_amount_invoiced'] = $gw_base_tax_amount_invoiced;

        return $this;
    }

    /**
     * Gets gw_base_tax_amount_refunded
     *
     * @return float
     */
    public function getGwBaseTaxAmountRefunded()
    {
        return $this->container['gw_base_tax_amount_refunded'];
    }

    /**
     * Sets gw_base_tax_amount_refunded
     *
     * @param float $gw_base_tax_amount_refunded GW base tax amount refunded.
     *
     * @return $this
     */
    public function setGwBaseTaxAmountRefunded($gw_base_tax_amount_refunded)
    {
        $this->container['gw_base_tax_amount_refunded'] = $gw_base_tax_amount_refunded;

        return $this;
    }

    /**
     * Gets gw_id
     *
     * @return int
     */
    public function getGwId()
    {
        return $this->container['gw_id'];
    }

    /**
     * Sets gw_id
     *
     * @param int $gw_id GW ID.
     *
     * @return $this
     */
    public function setGwId($gw_id)
    {
        $this->container['gw_id'] = $gw_id;

        return $this;
    }

    /**
     * Gets gw_price
     *
     * @return float
     */
    public function getGwPrice()
    {
        return $this->container['gw_price'];
    }

    /**
     * Sets gw_price
     *
     * @param float $gw_price GW price.
     *
     * @return $this
     */
    public function setGwPrice($gw_price)
    {
        $this->container['gw_price'] = $gw_price;

        return $this;
    }

    /**
     * Gets gw_price_invoiced
     *
     * @return float
     */
    public function getGwPriceInvoiced()
    {
        return $this->container['gw_price_invoiced'];
    }

    /**
     * Sets gw_price_invoiced
     *
     * @param float $gw_price_invoiced GW price invoiced.
     *
     * @return $this
     */
    public function setGwPriceInvoiced($gw_price_invoiced)
    {
        $this->container['gw_price_invoiced'] = $gw_price_invoiced;

        return $this;
    }

    /**
     * Gets gw_price_refunded
     *
     * @return float
     */
    public function getGwPriceRefunded()
    {
        return $this->container['gw_price_refunded'];
    }

    /**
     * Sets gw_price_refunded
     *
     * @param float $gw_price_refunded GW price refunded.
     *
     * @return $this
     */
    public function setGwPriceRefunded($gw_price_refunded)
    {
        $this->container['gw_price_refunded'] = $gw_price_refunded;

        return $this;
    }

    /**
     * Gets gw_tax_amount
     *
     * @return float
     */
    public function getGwTaxAmount()
    {
        return $this->container['gw_tax_amount'];
    }

    /**
     * Sets gw_tax_amount
     *
     * @param float $gw_tax_amount GW tax amount.
     *
     * @return $this
     */
    public function setGwTaxAmount($gw_tax_amount)
    {
        $this->container['gw_tax_amount'] = $gw_tax_amount;

        return $this;
    }

    /**
     * Gets gw_tax_amount_invoiced
     *
     * @return float
     */
    public function getGwTaxAmountInvoiced()
    {
        return $this->container['gw_tax_amount_invoiced'];
    }

    /**
     * Sets gw_tax_amount_invoiced
     *
     * @param float $gw_tax_amount_invoiced GW tax amount invoiced.
     *
     * @return $this
     */
    public function setGwTaxAmountInvoiced($gw_tax_amount_invoiced)
    {
        $this->container['gw_tax_amount_invoiced'] = $gw_tax_amount_invoiced;

        return $this;
    }

    /**
     * Gets gw_tax_amount_refunded
     *
     * @return float
     */
    public function getGwTaxAmountRefunded()
    {
        return $this->container['gw_tax_amount_refunded'];
    }

    /**
     * Sets gw_tax_amount_refunded
     *
     * @param float $gw_tax_amount_refunded GW tax amount refunded.
     *
     * @return $this
     */
    public function setGwTaxAmountRefunded($gw_tax_amount_refunded)
    {
        $this->container['gw_tax_amount_refunded'] = $gw_tax_amount_refunded;

        return $this;
    }

    /**
     * Gets discount_tax_compensation_amount
     *
     * @return float
     */
    public function getDiscountTaxCompensationAmount()
    {
        return $this->container['discount_tax_compensation_amount'];
    }

    /**
     * Sets discount_tax_compensation_amount
     *
     * @param float $discount_tax_compensation_amount Discount tax compensation amount.
     *
     * @return $this
     */
    public function setDiscountTaxCompensationAmount($discount_tax_compensation_amount)
    {
        $this->container['discount_tax_compensation_amount'] = $discount_tax_compensation_amount;

        return $this;
    }

    /**
     * Gets discount_tax_compensation_canceled
     *
     * @return float
     */
    public function getDiscountTaxCompensationCanceled()
    {
        return $this->container['discount_tax_compensation_canceled'];
    }

    /**
     * Sets discount_tax_compensation_canceled
     *
     * @param float $discount_tax_compensation_canceled Discount tax compensation canceled.
     *
     * @return $this
     */
    public function setDiscountTaxCompensationCanceled($discount_tax_compensation_canceled)
    {
        $this->container['discount_tax_compensation_canceled'] = $discount_tax_compensation_canceled;

        return $this;
    }

    /**
     * Gets discount_tax_compensation_invoiced
     *
     * @return float
     */
    public function getDiscountTaxCompensationInvoiced()
    {
        return $this->container['discount_tax_compensation_invoiced'];
    }

    /**
     * Sets discount_tax_compensation_invoiced
     *
     * @param float $discount_tax_compensation_invoiced Discount tax compensation invoiced.
     *
     * @return $this
     */
    public function setDiscountTaxCompensationInvoiced($discount_tax_compensation_invoiced)
    {
        $this->container['discount_tax_compensation_invoiced'] = $discount_tax_compensation_invoiced;

        return $this;
    }

    /**
     * Gets discount_tax_compensation_refunded
     *
     * @return float
     */
    public function getDiscountTaxCompensationRefunded()
    {
        return $this->container['discount_tax_compensation_refunded'];
    }

    /**
     * Sets discount_tax_compensation_refunded
     *
     * @param float $discount_tax_compensation_refunded Discount tax compensation refunded.
     *
     * @return $this
     */
    public function setDiscountTaxCompensationRefunded($discount_tax_compensation_refunded)
    {
        $this->container['discount_tax_compensation_refunded'] = $discount_tax_compensation_refunded;

        return $this;
    }

    /**
     * Gets is_qty_decimal
     *
     * @return int
     */
    public function getIsQtyDecimal()
    {
        return $this->container['is_qty_decimal'];
    }

    /**
     * Sets is_qty_decimal
     *
     * @param int $is_qty_decimal Is-quantity-decimal flag value.
     *
     * @return $this
     */
    public function setIsQtyDecimal($is_qty_decimal)
    {
        $this->container['is_qty_decimal'] = $is_qty_decimal;

        return $this;
    }

    /**
     * Gets is_virtual
     *
     * @return int
     */
    public function getIsVirtual()
    {
        return $this->container['is_virtual'];
    }

    /**
     * Sets is_virtual
     *
     * @param int $is_virtual Is-virtual flag value.
     *
     * @return $this
     */
    public function setIsVirtual($is_virtual)
    {
        $this->container['is_virtual'] = $is_virtual;

        return $this;
    }

    /**
     * Gets item_id
     *
     * @return int
     */
    public function getItemId()
    {
        return $this->container['item_id'];
    }

    /**
     * Sets item_id
     *
     * @param int $item_id Item ID.
     *
     * @return $this
     */
    public function setItemId($item_id)
    {
        $this->container['item_id'] = $item_id;

        return $this;
    }

    /**
     * Gets locked_do_invoice
     *
     * @return int
     */
    public function getLockedDoInvoice()
    {
        return $this->container['locked_do_invoice'];
    }

    /**
     * Sets locked_do_invoice
     *
     * @param int $locked_do_invoice Locked DO invoice flag value.
     *
     * @return $this
     */
    public function setLockedDoInvoice($locked_do_invoice)
    {
        $this->container['locked_do_invoice'] = $locked_do_invoice;

        return $this;
    }

    /**
     * Gets locked_do_ship
     *
     * @return int
     */
    public function getLockedDoShip()
    {
        return $this->container['locked_do_ship'];
    }

    /**
     * Sets locked_do_ship
     *
     * @param int $locked_do_ship Locked DO ship flag value.
     *
     * @return $this
     */
    public function setLockedDoShip($locked_do_ship)
    {
        $this->container['locked_do_ship'] = $locked_do_ship;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Name.
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets no_discount
     *
     * @return int
     */
    public function getNoDiscount()
    {
        return $this->container['no_discount'];
    }

    /**
     * Sets no_discount
     *
     * @param int $no_discount No-discount flag value.
     *
     * @return $this
     */
    public function setNoDiscount($no_discount)
    {
        $this->container['no_discount'] = $no_discount;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return int
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param int $order_id Order ID.
     *
     * @return $this
     */
    public function setOrderId($order_id)
    {
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets original_price
     *
     * @return float
     */
    public function getOriginalPrice()
    {
        return $this->container['original_price'];
    }

    /**
     * Sets original_price
     *
     * @param float $original_price Original price.
     *
     * @return $this
     */
    public function setOriginalPrice($original_price)
    {
        $this->container['original_price'] = $original_price;

        return $this;
    }

    /**
     * Gets parent_item_id
     *
     * @return int
     */
    public function getParentItemId()
    {
        return $this->container['parent_item_id'];
    }

    /**
     * Sets parent_item_id
     *
     * @param int $parent_item_id Parent item ID.
     *
     * @return $this
     */
    public function setParentItemId($parent_item_id)
    {
        $this->container['parent_item_id'] = $parent_item_id;

        return $this;
    }

    /**
     * Gets price
     *
     * @return float
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param float $price Price.
     *
     * @return $this
     */
    public function setPrice($price)
    {
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets price_incl_tax
     *
     * @return float
     */
    public function getPriceInclTax()
    {
        return $this->container['price_incl_tax'];
    }

    /**
     * Sets price_incl_tax
     *
     * @param float $price_incl_tax Price including tax.
     *
     * @return $this
     */
    public function setPriceInclTax($price_incl_tax)
    {
        $this->container['price_incl_tax'] = $price_incl_tax;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return int
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param int $product_id Product ID.
     *
     * @return $this
     */
    public function setProductId($product_id)
    {
        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets product_type
     *
     * @return string
     */
    public function getProductType()
    {
        return $this->container['product_type'];
    }

    /**
     * Sets product_type
     *
     * @param string $product_type Product type.
     *
     * @return $this
     */
    public function setProductType($product_type)
    {
        $this->container['product_type'] = $product_type;

        return $this;
    }

    /**
     * Gets qty_backordered
     *
     * @return float
     */
    public function getQtyBackordered()
    {
        return $this->container['qty_backordered'];
    }

    /**
     * Sets qty_backordered
     *
     * @param float $qty_backordered Quantity backordered.
     *
     * @return $this
     */
    public function setQtyBackordered($qty_backordered)
    {
        $this->container['qty_backordered'] = $qty_backordered;

        return $this;
    }

    /**
     * Gets qty_canceled
     *
     * @return float
     */
    public function getQtyCanceled()
    {
        return $this->container['qty_canceled'];
    }

    /**
     * Sets qty_canceled
     *
     * @param float $qty_canceled Quantity canceled.
     *
     * @return $this
     */
    public function setQtyCanceled($qty_canceled)
    {
        $this->container['qty_canceled'] = $qty_canceled;

        return $this;
    }

    /**
     * Gets qty_invoiced
     *
     * @return float
     */
    public function getQtyInvoiced()
    {
        return $this->container['qty_invoiced'];
    }

    /**
     * Sets qty_invoiced
     *
     * @param float $qty_invoiced Quantity invoiced.
     *
     * @return $this
     */
    public function setQtyInvoiced($qty_invoiced)
    {
        $this->container['qty_invoiced'] = $qty_invoiced;

        return $this;
    }

    /**
     * Gets qty_ordered
     *
     * @return float
     */
    public function getQtyOrdered()
    {
        return $this->container['qty_ordered'];
    }

    /**
     * Sets qty_ordered
     *
     * @param float $qty_ordered Quantity ordered.
     *
     * @return $this
     */
    public function setQtyOrdered($qty_ordered)
    {
        $this->container['qty_ordered'] = $qty_ordered;

        return $this;
    }

    /**
     * Gets qty_refunded
     *
     * @return float
     */
    public function getQtyRefunded()
    {
        return $this->container['qty_refunded'];
    }

    /**
     * Sets qty_refunded
     *
     * @param float $qty_refunded Quantity refunded.
     *
     * @return $this
     */
    public function setQtyRefunded($qty_refunded)
    {
        $this->container['qty_refunded'] = $qty_refunded;

        return $this;
    }

    /**
     * Gets qty_returned
     *
     * @return float
     */
    public function getQtyReturned()
    {
        return $this->container['qty_returned'];
    }

    /**
     * Sets qty_returned
     *
     * @param float $qty_returned Quantity returned.
     *
     * @return $this
     */
    public function setQtyReturned($qty_returned)
    {
        $this->container['qty_returned'] = $qty_returned;

        return $this;
    }

    /**
     * Gets qty_shipped
     *
     * @return float
     */
    public function getQtyShipped()
    {
        return $this->container['qty_shipped'];
    }

    /**
     * Sets qty_shipped
     *
     * @param float $qty_shipped Quantity shipped.
     *
     * @return $this
     */
    public function setQtyShipped($qty_shipped)
    {
        $this->container['qty_shipped'] = $qty_shipped;

        return $this;
    }

    /**
     * Gets quote_item_id
     *
     * @return int
     */
    public function getQuoteItemId()
    {
        return $this->container['quote_item_id'];
    }

    /**
     * Sets quote_item_id
     *
     * @param int $quote_item_id Quote item ID.
     *
     * @return $this
     */
    public function setQuoteItemId($quote_item_id)
    {
        $this->container['quote_item_id'] = $quote_item_id;

        return $this;
    }

    /**
     * Gets row_invoiced
     *
     * @return float
     */
    public function getRowInvoiced()
    {
        return $this->container['row_invoiced'];
    }

    /**
     * Sets row_invoiced
     *
     * @param float $row_invoiced Row invoiced.
     *
     * @return $this
     */
    public function setRowInvoiced($row_invoiced)
    {
        $this->container['row_invoiced'] = $row_invoiced;

        return $this;
    }

    /**
     * Gets row_total
     *
     * @return float
     */
    public function getRowTotal()
    {
        return $this->container['row_total'];
    }

    /**
     * Sets row_total
     *
     * @param float $row_total Row total.
     *
     * @return $this
     */
    public function setRowTotal($row_total)
    {
        $this->container['row_total'] = $row_total;

        return $this;
    }

    /**
     * Gets row_total_incl_tax
     *
     * @return float
     */
    public function getRowTotalInclTax()
    {
        return $this->container['row_total_incl_tax'];
    }

    /**
     * Sets row_total_incl_tax
     *
     * @param float $row_total_incl_tax Row total including tax.
     *
     * @return $this
     */
    public function setRowTotalInclTax($row_total_incl_tax)
    {
        $this->container['row_total_incl_tax'] = $row_total_incl_tax;

        return $this;
    }

    /**
     * Gets row_weight
     *
     * @return float
     */
    public function getRowWeight()
    {
        return $this->container['row_weight'];
    }

    /**
     * Sets row_weight
     *
     * @param float $row_weight Row weight.
     *
     * @return $this
     */
    public function setRowWeight($row_weight)
    {
        $this->container['row_weight'] = $row_weight;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string $sku SKU.
     *
     * @return $this
     */
    public function setSku($sku)
    {
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets store_id
     *
     * @return int
     */
    public function getStoreId()
    {
        return $this->container['store_id'];
    }

    /**
     * Sets store_id
     *
     * @param int $store_id Store ID.
     *
     * @return $this
     */
    public function setStoreId($store_id)
    {
        $this->container['store_id'] = $store_id;

        return $this;
    }

    /**
     * Gets tax_amount
     *
     * @return float
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param float $tax_amount Tax amount.
     *
     * @return $this
     */
    public function setTaxAmount($tax_amount)
    {
        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }

    /**
     * Gets tax_before_discount
     *
     * @return float
     */
    public function getTaxBeforeDiscount()
    {
        return $this->container['tax_before_discount'];
    }

    /**
     * Sets tax_before_discount
     *
     * @param float $tax_before_discount Tax before discount.
     *
     * @return $this
     */
    public function setTaxBeforeDiscount($tax_before_discount)
    {
        $this->container['tax_before_discount'] = $tax_before_discount;

        return $this;
    }

    /**
     * Gets tax_canceled
     *
     * @return float
     */
    public function getTaxCanceled()
    {
        return $this->container['tax_canceled'];
    }

    /**
     * Sets tax_canceled
     *
     * @param float $tax_canceled Tax canceled.
     *
     * @return $this
     */
    public function setTaxCanceled($tax_canceled)
    {
        $this->container['tax_canceled'] = $tax_canceled;

        return $this;
    }

    /**
     * Gets tax_invoiced
     *
     * @return float
     */
    public function getTaxInvoiced()
    {
        return $this->container['tax_invoiced'];
    }

    /**
     * Sets tax_invoiced
     *
     * @param float $tax_invoiced Tax invoiced.
     *
     * @return $this
     */
    public function setTaxInvoiced($tax_invoiced)
    {
        $this->container['tax_invoiced'] = $tax_invoiced;

        return $this;
    }

    /**
     * Gets tax_percent
     *
     * @return float
     */
    public function getTaxPercent()
    {
        return $this->container['tax_percent'];
    }

    /**
     * Sets tax_percent
     *
     * @param float $tax_percent Tax percent.
     *
     * @return $this
     */
    public function setTaxPercent($tax_percent)
    {
        $this->container['tax_percent'] = $tax_percent;

        return $this;
    }

    /**
     * Gets tax_refunded
     *
     * @return float
     */
    public function getTaxRefunded()
    {
        return $this->container['tax_refunded'];
    }

    /**
     * Sets tax_refunded
     *
     * @param float $tax_refunded Tax refunded.
     *
     * @return $this
     */
    public function setTaxRefunded($tax_refunded)
    {
        $this->container['tax_refunded'] = $tax_refunded;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string $updated_at Updated-at timestamp.
     *
     * @return $this
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets weee_tax_applied
     *
     * @return string
     */
    public function getWeeeTaxApplied()
    {
        return $this->container['weee_tax_applied'];
    }

    /**
     * Sets weee_tax_applied
     *
     * @param string $weee_tax_applied WEEE tax applied.
     *
     * @return $this
     */
    public function setWeeeTaxApplied($weee_tax_applied)
    {
        $this->container['weee_tax_applied'] = $weee_tax_applied;

        return $this;
    }

    /**
     * Gets weee_tax_applied_amount
     *
     * @return float
     */
    public function getWeeeTaxAppliedAmount()
    {
        return $this->container['weee_tax_applied_amount'];
    }

    /**
     * Sets weee_tax_applied_amount
     *
     * @param float $weee_tax_applied_amount WEEE tax applied amount.
     *
     * @return $this
     */
    public function setWeeeTaxAppliedAmount($weee_tax_applied_amount)
    {
        $this->container['weee_tax_applied_amount'] = $weee_tax_applied_amount;

        return $this;
    }

    /**
     * Gets weee_tax_applied_row_amount
     *
     * @return float
     */
    public function getWeeeTaxAppliedRowAmount()
    {
        return $this->container['weee_tax_applied_row_amount'];
    }

    /**
     * Sets weee_tax_applied_row_amount
     *
     * @param float $weee_tax_applied_row_amount WEEE tax applied row amount.
     *
     * @return $this
     */
    public function setWeeeTaxAppliedRowAmount($weee_tax_applied_row_amount)
    {
        $this->container['weee_tax_applied_row_amount'] = $weee_tax_applied_row_amount;

        return $this;
    }

    /**
     * Gets weee_tax_disposition
     *
     * @return float
     */
    public function getWeeeTaxDisposition()
    {
        return $this->container['weee_tax_disposition'];
    }

    /**
     * Sets weee_tax_disposition
     *
     * @param float $weee_tax_disposition WEEE tax disposition.
     *
     * @return $this
     */
    public function setWeeeTaxDisposition($weee_tax_disposition)
    {
        $this->container['weee_tax_disposition'] = $weee_tax_disposition;

        return $this;
    }

    /**
     * Gets weee_tax_row_disposition
     *
     * @return float
     */
    public function getWeeeTaxRowDisposition()
    {
        return $this->container['weee_tax_row_disposition'];
    }

    /**
     * Sets weee_tax_row_disposition
     *
     * @param float $weee_tax_row_disposition WEEE tax row disposition.
     *
     * @return $this
     */
    public function setWeeeTaxRowDisposition($weee_tax_row_disposition)
    {
        $this->container['weee_tax_row_disposition'] = $weee_tax_row_disposition;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float $weight Weight.
     *
     * @return $this
     */
    public function setWeight($weight)
    {
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets parent_item
     *
     * @return \Swagger\Client\Model\SalesDataOrderItemInterface
     */
    public function getParentItem()
    {
        return $this->container['parent_item'];
    }

    /**
     * Sets parent_item
     *
     * @param \Swagger\Client\Model\SalesDataOrderItemInterface $parent_item parent_item
     *
     * @return $this
     */
    public function setParentItem($parent_item)
    {
        $this->container['parent_item'] = $parent_item;

        return $this;
    }

    /**
     * Gets product_option
     *
     * @return \Swagger\Client\Model\CatalogDataProductOptionInterface
     */
    public function getProductOption()
    {
        return $this->container['product_option'];
    }

    /**
     * Sets product_option
     *
     * @param \Swagger\Client\Model\CatalogDataProductOptionInterface $product_option product_option
     *
     * @return $this
     */
    public function setProductOption($product_option)
    {
        $this->container['product_option'] = $product_option;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return \Swagger\Client\Model\SalesDataOrderItemExtensionInterface
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param \Swagger\Client\Model\SalesDataOrderItemExtensionInterface $extension_attributes extension_attributes
     *
     * @return $this
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


