<?php
/**
 * SalesDataOrderAddressInterface
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Magento Enterprise Edition 2.0
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * SalesDataOrderAddressInterface Class Doc Comment
 *
 * @category Class
 * @description Order address interface. An order is a document that a web store issues to a customer. Magento generates a sales order that lists the product items, billing and shipping addresses, and shipping and payment methods. A corresponding external document, known as a purchase order, is emailed to the customer.
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class SalesDataOrderAddressInterface implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'sales-data-order-address-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'address_type' => 'string',
        'city' => 'string',
        'company' => 'string',
        'country_id' => 'string',
        'customer_address_id' => 'int',
        'customer_id' => 'int',
        'email' => 'string',
        'entity_id' => 'int',
        'fax' => 'string',
        'firstname' => 'string',
        'lastname' => 'string',
        'middlename' => 'string',
        'parent_id' => 'int',
        'postcode' => 'string',
        'prefix' => 'string',
        'region' => 'string',
        'region_code' => 'string',
        'region_id' => 'int',
        'street' => 'string[]',
        'suffix' => 'string',
        'telephone' => 'string',
        'vat_id' => 'string',
        'vat_is_valid' => 'int',
        'vat_request_date' => 'string',
        'vat_request_id' => 'string',
        'vat_request_success' => 'int',
        'extension_attributes' => '\Swagger\Client\Model\SalesDataOrderAddressExtensionInterface'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'address_type' => null,
        'city' => null,
        'company' => null,
        'country_id' => null,
        'customer_address_id' => null,
        'customer_id' => null,
        'email' => null,
        'entity_id' => null,
        'fax' => null,
        'firstname' => null,
        'lastname' => null,
        'middlename' => null,
        'parent_id' => null,
        'postcode' => null,
        'prefix' => null,
        'region' => null,
        'region_code' => null,
        'region_id' => null,
        'street' => null,
        'suffix' => null,
        'telephone' => null,
        'vat_id' => null,
        'vat_is_valid' => null,
        'vat_request_date' => null,
        'vat_request_id' => null,
        'vat_request_success' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'address_type' => 'addressType',
        'city' => 'city',
        'company' => 'company',
        'country_id' => 'countryId',
        'customer_address_id' => 'customerAddressId',
        'customer_id' => 'customerId',
        'email' => 'email',
        'entity_id' => 'entityId',
        'fax' => 'fax',
        'firstname' => 'firstname',
        'lastname' => 'lastname',
        'middlename' => 'middlename',
        'parent_id' => 'parentId',
        'postcode' => 'postcode',
        'prefix' => 'prefix',
        'region' => 'region',
        'region_code' => 'regionCode',
        'region_id' => 'regionId',
        'street' => 'street',
        'suffix' => 'suffix',
        'telephone' => 'telephone',
        'vat_id' => 'vatId',
        'vat_is_valid' => 'vatIsValid',
        'vat_request_date' => 'vatRequestDate',
        'vat_request_id' => 'vatRequestId',
        'vat_request_success' => 'vatRequestSuccess',
        'extension_attributes' => 'extensionAttributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'address_type' => 'setAddressType',
        'city' => 'setCity',
        'company' => 'setCompany',
        'country_id' => 'setCountryId',
        'customer_address_id' => 'setCustomerAddressId',
        'customer_id' => 'setCustomerId',
        'email' => 'setEmail',
        'entity_id' => 'setEntityId',
        'fax' => 'setFax',
        'firstname' => 'setFirstname',
        'lastname' => 'setLastname',
        'middlename' => 'setMiddlename',
        'parent_id' => 'setParentId',
        'postcode' => 'setPostcode',
        'prefix' => 'setPrefix',
        'region' => 'setRegion',
        'region_code' => 'setRegionCode',
        'region_id' => 'setRegionId',
        'street' => 'setStreet',
        'suffix' => 'setSuffix',
        'telephone' => 'setTelephone',
        'vat_id' => 'setVatId',
        'vat_is_valid' => 'setVatIsValid',
        'vat_request_date' => 'setVatRequestDate',
        'vat_request_id' => 'setVatRequestId',
        'vat_request_success' => 'setVatRequestSuccess',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'address_type' => 'getAddressType',
        'city' => 'getCity',
        'company' => 'getCompany',
        'country_id' => 'getCountryId',
        'customer_address_id' => 'getCustomerAddressId',
        'customer_id' => 'getCustomerId',
        'email' => 'getEmail',
        'entity_id' => 'getEntityId',
        'fax' => 'getFax',
        'firstname' => 'getFirstname',
        'lastname' => 'getLastname',
        'middlename' => 'getMiddlename',
        'parent_id' => 'getParentId',
        'postcode' => 'getPostcode',
        'prefix' => 'getPrefix',
        'region' => 'getRegion',
        'region_code' => 'getRegionCode',
        'region_id' => 'getRegionId',
        'street' => 'getStreet',
        'suffix' => 'getSuffix',
        'telephone' => 'getTelephone',
        'vat_id' => 'getVatId',
        'vat_is_valid' => 'getVatIsValid',
        'vat_request_date' => 'getVatRequestDate',
        'vat_request_id' => 'getVatRequestId',
        'vat_request_success' => 'getVatRequestSuccess',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['address_type'] = isset($data['address_type']) ? $data['address_type'] : null;
        $this->container['city'] = isset($data['city']) ? $data['city'] : null;
        $this->container['company'] = isset($data['company']) ? $data['company'] : null;
        $this->container['country_id'] = isset($data['country_id']) ? $data['country_id'] : null;
        $this->container['customer_address_id'] = isset($data['customer_address_id']) ? $data['customer_address_id'] : null;
        $this->container['customer_id'] = isset($data['customer_id']) ? $data['customer_id'] : null;
        $this->container['email'] = isset($data['email']) ? $data['email'] : null;
        $this->container['entity_id'] = isset($data['entity_id']) ? $data['entity_id'] : null;
        $this->container['fax'] = isset($data['fax']) ? $data['fax'] : null;
        $this->container['firstname'] = isset($data['firstname']) ? $data['firstname'] : null;
        $this->container['lastname'] = isset($data['lastname']) ? $data['lastname'] : null;
        $this->container['middlename'] = isset($data['middlename']) ? $data['middlename'] : null;
        $this->container['parent_id'] = isset($data['parent_id']) ? $data['parent_id'] : null;
        $this->container['postcode'] = isset($data['postcode']) ? $data['postcode'] : null;
        $this->container['prefix'] = isset($data['prefix']) ? $data['prefix'] : null;
        $this->container['region'] = isset($data['region']) ? $data['region'] : null;
        $this->container['region_code'] = isset($data['region_code']) ? $data['region_code'] : null;
        $this->container['region_id'] = isset($data['region_id']) ? $data['region_id'] : null;
        $this->container['street'] = isset($data['street']) ? $data['street'] : null;
        $this->container['suffix'] = isset($data['suffix']) ? $data['suffix'] : null;
        $this->container['telephone'] = isset($data['telephone']) ? $data['telephone'] : null;
        $this->container['vat_id'] = isset($data['vat_id']) ? $data['vat_id'] : null;
        $this->container['vat_is_valid'] = isset($data['vat_is_valid']) ? $data['vat_is_valid'] : null;
        $this->container['vat_request_date'] = isset($data['vat_request_date']) ? $data['vat_request_date'] : null;
        $this->container['vat_request_id'] = isset($data['vat_request_id']) ? $data['vat_request_id'] : null;
        $this->container['vat_request_success'] = isset($data['vat_request_success']) ? $data['vat_request_success'] : null;
        $this->container['extension_attributes'] = isset($data['extension_attributes']) ? $data['extension_attributes'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['address_type'] === null) {
            $invalidProperties[] = "'address_type' can't be null";
        }
        if ($this->container['city'] === null) {
            $invalidProperties[] = "'city' can't be null";
        }
        if ($this->container['country_id'] === null) {
            $invalidProperties[] = "'country_id' can't be null";
        }
        if ($this->container['firstname'] === null) {
            $invalidProperties[] = "'firstname' can't be null";
        }
        if ($this->container['lastname'] === null) {
            $invalidProperties[] = "'lastname' can't be null";
        }
        if ($this->container['postcode'] === null) {
            $invalidProperties[] = "'postcode' can't be null";
        }
        if ($this->container['telephone'] === null) {
            $invalidProperties[] = "'telephone' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['address_type'] === null) {
            return false;
        }
        if ($this->container['city'] === null) {
            return false;
        }
        if ($this->container['country_id'] === null) {
            return false;
        }
        if ($this->container['firstname'] === null) {
            return false;
        }
        if ($this->container['lastname'] === null) {
            return false;
        }
        if ($this->container['postcode'] === null) {
            return false;
        }
        if ($this->container['telephone'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets address_type
     *
     * @return string
     */
    public function getAddressType()
    {
        return $this->container['address_type'];
    }

    /**
     * Sets address_type
     *
     * @param string $address_type Address type.
     *
     * @return $this
     */
    public function setAddressType($address_type)
    {
        $this->container['address_type'] = $address_type;

        return $this;
    }

    /**
     * Gets city
     *
     * @return string
     */
    public function getCity()
    {
        return $this->container['city'];
    }

    /**
     * Sets city
     *
     * @param string $city City.
     *
     * @return $this
     */
    public function setCity($city)
    {
        $this->container['city'] = $city;

        return $this;
    }

    /**
     * Gets company
     *
     * @return string
     */
    public function getCompany()
    {
        return $this->container['company'];
    }

    /**
     * Sets company
     *
     * @param string $company Company.
     *
     * @return $this
     */
    public function setCompany($company)
    {
        $this->container['company'] = $company;

        return $this;
    }

    /**
     * Gets country_id
     *
     * @return string
     */
    public function getCountryId()
    {
        return $this->container['country_id'];
    }

    /**
     * Sets country_id
     *
     * @param string $country_id Country ID.
     *
     * @return $this
     */
    public function setCountryId($country_id)
    {
        $this->container['country_id'] = $country_id;

        return $this;
    }

    /**
     * Gets customer_address_id
     *
     * @return int
     */
    public function getCustomerAddressId()
    {
        return $this->container['customer_address_id'];
    }

    /**
     * Sets customer_address_id
     *
     * @param int $customer_address_id Country address ID.
     *
     * @return $this
     */
    public function setCustomerAddressId($customer_address_id)
    {
        $this->container['customer_address_id'] = $customer_address_id;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return int
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int $customer_id Customer ID.
     *
     * @return $this
     */
    public function setCustomerId($customer_id)
    {
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string $email Email address.
     *
     * @return $this
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets entity_id
     *
     * @return int
     */
    public function getEntityId()
    {
        return $this->container['entity_id'];
    }

    /**
     * Sets entity_id
     *
     * @param int $entity_id Order address ID.
     *
     * @return $this
     */
    public function setEntityId($entity_id)
    {
        $this->container['entity_id'] = $entity_id;

        return $this;
    }

    /**
     * Gets fax
     *
     * @return string
     */
    public function getFax()
    {
        return $this->container['fax'];
    }

    /**
     * Sets fax
     *
     * @param string $fax Fax number.
     *
     * @return $this
     */
    public function setFax($fax)
    {
        $this->container['fax'] = $fax;

        return $this;
    }

    /**
     * Gets firstname
     *
     * @return string
     */
    public function getFirstname()
    {
        return $this->container['firstname'];
    }

    /**
     * Sets firstname
     *
     * @param string $firstname First name.
     *
     * @return $this
     */
    public function setFirstname($firstname)
    {
        $this->container['firstname'] = $firstname;

        return $this;
    }

    /**
     * Gets lastname
     *
     * @return string
     */
    public function getLastname()
    {
        return $this->container['lastname'];
    }

    /**
     * Sets lastname
     *
     * @param string $lastname Last name.
     *
     * @return $this
     */
    public function setLastname($lastname)
    {
        $this->container['lastname'] = $lastname;

        return $this;
    }

    /**
     * Gets middlename
     *
     * @return string
     */
    public function getMiddlename()
    {
        return $this->container['middlename'];
    }

    /**
     * Sets middlename
     *
     * @param string $middlename Middle name.
     *
     * @return $this
     */
    public function setMiddlename($middlename)
    {
        $this->container['middlename'] = $middlename;

        return $this;
    }

    /**
     * Gets parent_id
     *
     * @return int
     */
    public function getParentId()
    {
        return $this->container['parent_id'];
    }

    /**
     * Sets parent_id
     *
     * @param int $parent_id Parent ID.
     *
     * @return $this
     */
    public function setParentId($parent_id)
    {
        $this->container['parent_id'] = $parent_id;

        return $this;
    }

    /**
     * Gets postcode
     *
     * @return string
     */
    public function getPostcode()
    {
        return $this->container['postcode'];
    }

    /**
     * Sets postcode
     *
     * @param string $postcode Postal code.
     *
     * @return $this
     */
    public function setPostcode($postcode)
    {
        $this->container['postcode'] = $postcode;

        return $this;
    }

    /**
     * Gets prefix
     *
     * @return string
     */
    public function getPrefix()
    {
        return $this->container['prefix'];
    }

    /**
     * Sets prefix
     *
     * @param string $prefix Prefix.
     *
     * @return $this
     */
    public function setPrefix($prefix)
    {
        $this->container['prefix'] = $prefix;

        return $this;
    }

    /**
     * Gets region
     *
     * @return string
     */
    public function getRegion()
    {
        return $this->container['region'];
    }

    /**
     * Sets region
     *
     * @param string $region Region.
     *
     * @return $this
     */
    public function setRegion($region)
    {
        $this->container['region'] = $region;

        return $this;
    }

    /**
     * Gets region_code
     *
     * @return string
     */
    public function getRegionCode()
    {
        return $this->container['region_code'];
    }

    /**
     * Sets region_code
     *
     * @param string $region_code Region code.
     *
     * @return $this
     */
    public function setRegionCode($region_code)
    {
        $this->container['region_code'] = $region_code;

        return $this;
    }

    /**
     * Gets region_id
     *
     * @return int
     */
    public function getRegionId()
    {
        return $this->container['region_id'];
    }

    /**
     * Sets region_id
     *
     * @param int $region_id Region ID.
     *
     * @return $this
     */
    public function setRegionId($region_id)
    {
        $this->container['region_id'] = $region_id;

        return $this;
    }

    /**
     * Gets street
     *
     * @return string[]
     */
    public function getStreet()
    {
        return $this->container['street'];
    }

    /**
     * Sets street
     *
     * @param string[] $street Array of any street values. Otherwise, null.
     *
     * @return $this
     */
    public function setStreet($street)
    {
        $this->container['street'] = $street;

        return $this;
    }

    /**
     * Gets suffix
     *
     * @return string
     */
    public function getSuffix()
    {
        return $this->container['suffix'];
    }

    /**
     * Sets suffix
     *
     * @param string $suffix Suffix.
     *
     * @return $this
     */
    public function setSuffix($suffix)
    {
        $this->container['suffix'] = $suffix;

        return $this;
    }

    /**
     * Gets telephone
     *
     * @return string
     */
    public function getTelephone()
    {
        return $this->container['telephone'];
    }

    /**
     * Sets telephone
     *
     * @param string $telephone Telephone number.
     *
     * @return $this
     */
    public function setTelephone($telephone)
    {
        $this->container['telephone'] = $telephone;

        return $this;
    }

    /**
     * Gets vat_id
     *
     * @return string
     */
    public function getVatId()
    {
        return $this->container['vat_id'];
    }

    /**
     * Sets vat_id
     *
     * @param string $vat_id VAT ID.
     *
     * @return $this
     */
    public function setVatId($vat_id)
    {
        $this->container['vat_id'] = $vat_id;

        return $this;
    }

    /**
     * Gets vat_is_valid
     *
     * @return int
     */
    public function getVatIsValid()
    {
        return $this->container['vat_is_valid'];
    }

    /**
     * Sets vat_is_valid
     *
     * @param int $vat_is_valid VAT-is-valid flag value.
     *
     * @return $this
     */
    public function setVatIsValid($vat_is_valid)
    {
        $this->container['vat_is_valid'] = $vat_is_valid;

        return $this;
    }

    /**
     * Gets vat_request_date
     *
     * @return string
     */
    public function getVatRequestDate()
    {
        return $this->container['vat_request_date'];
    }

    /**
     * Sets vat_request_date
     *
     * @param string $vat_request_date VAT request date.
     *
     * @return $this
     */
    public function setVatRequestDate($vat_request_date)
    {
        $this->container['vat_request_date'] = $vat_request_date;

        return $this;
    }

    /**
     * Gets vat_request_id
     *
     * @return string
     */
    public function getVatRequestId()
    {
        return $this->container['vat_request_id'];
    }

    /**
     * Sets vat_request_id
     *
     * @param string $vat_request_id VAT request ID.
     *
     * @return $this
     */
    public function setVatRequestId($vat_request_id)
    {
        $this->container['vat_request_id'] = $vat_request_id;

        return $this;
    }

    /**
     * Gets vat_request_success
     *
     * @return int
     */
    public function getVatRequestSuccess()
    {
        return $this->container['vat_request_success'];
    }

    /**
     * Sets vat_request_success
     *
     * @param int $vat_request_success VAT-request-success flag value.
     *
     * @return $this
     */
    public function setVatRequestSuccess($vat_request_success)
    {
        $this->container['vat_request_success'] = $vat_request_success;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return \Swagger\Client\Model\SalesDataOrderAddressExtensionInterface
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param \Swagger\Client\Model\SalesDataOrderAddressExtensionInterface $extension_attributes extension_attributes
     *
     * @return $this
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


