<?php
/* Copyright (C) 2020 ATM Consulting <support@atm-consulting.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

if (!class_exists('SeedObject'))
{
	/**
	 * Needed if $form->showLinkedObjectBlock() is call or for session timeout on our module page
	 */
	define('INC_FROM_DOLIBARR', true);
	require_once dirname(__FILE__).'/../config.php';
}

dol_include_once('/dolifleet/class/dictionary.class.php');

class dictionaryVehiculeActivityType extends dictionary
{
	/** @var string $table_element Table name in SQL */
	public $table_element = 'c_dolifleet_vehicule_activity_type';

	/** @var string $element Name of the element (tip for better integration in Dolibarr: this value should be the reflection of the class name with ucfirst() function) */
	public $element = 'dolifleetVehiculeActivityType';

	public function getValueFromId($id, $field = 'label')
	{
		global $langs;

		if (empty($id)) return $langs->trans('NodoliFleetActivity');

		return parent::getValueFromId($id, $field); // TODO: Change the autogenerated stub
	}


}
