<?php 
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 

dol_include_once('/comm/propal/class/propal.class.php');
dol_include_once('/core/class/html.form.class.php');

class dolimobpropals extends Commonobject{ 
	
	public $errors = array();

	public function __construct(DoliDBMysqli $db){ 
		$this->db = $db;
		return 1;
	}	
	
	public function listelements($userapi)
	{
		global $langs;
		$langs->loadLangs(array('orders','bills','deliveries'));
		
		$result = [];
		$result['otherparams'][0]['permissiondata'] = 0;

		$form = new Form($this->db);

		if($userapi->rights->propal->lire || $userapi->admin){

			$filter = "";
			if ($userapi->societe_id) {
			  $filter .= " AND fk_soc = '".$userapi->societe_id."'";
			}
			$sortorder = "DESC";
			$sortfield = "rowid";

			$nbrtotal = $this->fetchAll($sortorder, $sortfield, 0, 0, $filter);

			$result['otherparams'][0]['countdata'] = count($this->rows);
			$result['otherparams'][0]['permissiondata'] = 1;

			if (count($this->rows) > 0) {
				global $dolibarr_main_data_root;
				$documenturl = DOL_MAIN_URL_ROOT.'/document.php';

				$form->load_cache_types_paiements();
				$form->load_cache_conditions_paiements();
				
				for ($i=0; $i < count($this->rows) ; $i++) {
				    $item = $this->rows[$i];

				    $propalorig  = new Propal($this->db);
				    $propalorig->fetch($item->rowid);

				    $result['Propals'][$i]['id'] = $item->rowid;
					$result['Propals'][$i]['ref'] = $item->ref;


					$result['Propals'][$i]['date'] = dol_print_date($this->db->jdate($item->datep),'daytextshort');
					$result['Propals'][$i]['finvalidite'] = dol_print_date($this->db->jdate($item->fin_validite),'daytextshort');
					$result['Propals'][$i]['etat'] = html_entity_decode($propalorig->getLibStatut(1), 0, 'UTF-8');
					$result['Propals'][$i]['montantttc'] = number_format($item->total, 2, ",", " ")." ".$item->multicurrency_code;
					$result['Propals'][$i]['datelivraison'] = "-";
					if(!empty($item->date_livraison))
						$result['Propals'][$i]['datelivraison'] = dol_print_date($this->db->jdate($item->date_livraison),'daytextshort');



					$otherdetails = [];
					$otherdetails['ref_client'] = $item->ref_client; // ref client
					$otherdetails['total_ht'] = number_format($item->multicurrency_total_ht, 2, ",", " ")." ".$item->multicurrency_code; // Total HT
					$otherdetails['total_tva'] = number_format($item->multicurrency_total_tva, 2, ",", " ")." ".$item->multicurrency_code; // Total TVA
					$otherdetails['mode_regelement'] = $form->cache_types_paiements[$propalorig->mode_reglement_id]['label']; // Mode regelement
					$otherdetails['condition_regelement'] = html_entity_decode($form->cache_conditions_paiements[$propalorig->cond_reglement_id]['label'], 0, 'UTF-8'); // Condition regelement

					$result['Propals'][$i]['otherdetails'] = json_encode($otherdetails);

			  }
			}
		}

		return $result;
	}

	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX ."propal";
		

		global $conf;

		if (dolibarr_get_const($this->db,'DOLIBARRMOBILE_FIX_ENTITY',0) && (dolibarr_get_const($this->db,'DOLIBARRMOBILE_FIX_ENTITY',0) > 0)){
			$filter .= " AND entity = ".dolibarr_get_const($this->db,'DOLIBARRMOBILE_FIX_ENTITY',0);
		}else{
			$filter .= " AND entity =  ".$conf->entity;
		}

		
		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		// echo $sql;
		// die;
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		// echo $sql;
		// die($sql);
		$this->rows = array();
		$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->id 	= $obj->rowid;
				$line->rowid 	= $obj->rowid;
				$line->entity 	= $obj->entity;
				$line->ref 	= $obj->ref;
				$line->datep 	= $obj->datep;
				$line->date_livraison 	= $obj->date_livraison;
				$line->fin_validite 	= $obj->fin_validite;
				$line->fk_statut 	= $obj->fk_statut;
				$line->total 	= $obj->total;
				$line->multicurrency_code 	= $obj->multicurrency_code;

				$line->ref_client 	= $obj->ref_client;
				$line->multicurrency_total_ht 	= $obj->multicurrency_total_ht;
				$line->multicurrency_total_tva 	= $obj->multicurrency_total_tva;
				$this->rows[] 	= $line;
			}
			
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}

	}

















	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'propal WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
				$this->id 		= $obj->rowid;
				$this->rowid 		= $obj->rowid;
				$this->ref 		= $obj->ref;
				$this->fk_soc 		= $obj->fk_soc;
				$this->fk_statut 	= $obj->fk_statut;
				$this->total 	= $obj->total;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

} 

?>