<?php 
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 
class dolimobfactures extends Commonobject{ 
	public $errors = array();

	public function __construct(DoliDBMysqli $db){ 
		$this->db = $db;
		return 1;
	}
	
	

	public function listelements($userapi)
	{
		global $langs;
		$langs->loadLangs(array('orders','bills','deliveries'));
		
		$langs->loadLangs(array('orders','bills'));
		dol_include_once('/dolibarrmobile/class/dolimobfactures.class.php');
		dol_include_once('/compta/facture/class/facture.class.php');
		dol_include_once('/core/class/html.form.class.php');

		$factures      = new dolimobfactures($this->db);
		$form           = new Form($this->db);

		$result = [];
		$result['otherparams'][0]['permissiondata'] = 0;

		if($userapi->rights->facture->lire || $userapi->admin){
			$filter = "";
			if ($userapi->societe_id) {
			  $filter .= " AND fk_soc = '".$userapi->societe_id."'";
			}
			$sortorder = "DESC";
			$sortfield = "rowid";

			$nbrtotal = $factures->fetchAll($sortorder, $sortfield, 0, 0, $filter);

			$result['otherparams'][0]['countdata'] = count($factures->rows);
			$result['otherparams'][0]['permissiondata'] = 1;

			if (count($factures->rows) > 0) {
				global $dolibarr_main_data_root;
				$documenturl = DOL_MAIN_URL_ROOT.'/document.php';
				$form->load_cache_types_paiements();
				$form->load_cache_conditions_paiements();
				for ($i=0; $i < count($factures->rows) ; $i++) {
				    $item = $factures->rows[$i];

				    $facturesorig  = new Facture($this->db);
				    $facturesorig->fetch($item->rowid);

				    $totalpaye = $facturesorig->getSommePaiement();
					$totalcreditnotes = $facturesorig->getSumCreditNotesUsed();
					$totaldeposits = $facturesorig->getSumDepositsUsed();
					$resteapayer = price2num($facturesorig->total_ttc - $totalpaye - $totalcreditnotes - $totaldeposits, 'MT');

					if ($facturesorig->paye || 
						(($facturesorig->statut == Facture::STATUS_CLOSED || $facturesorig->statut == Facture::STATUS_ABANDONED) && $facturesorig->close_code == 'discount_vat') || 

						(($facturesorig->statut == Facture::STATUS_CLOSED || $facturesorig->statut == Facture::STATUS_ABANDONED) && $facturesorig->close_code == 'product_returned') || 

						(($facturesorig->statut == Facture::STATUS_CLOSED || $facturesorig->statut == Facture::STATUS_ABANDONED) && $facturesorig->close_code == 'abandon')) 
					{
						$resteapayer = 0;
					}

				    $result['Factures'][$i]['id'] = $item->rowid;
					$result['Factures'][$i]['ref'] = $item->ref;
					$result['Factures'][$i]['date'] = dol_print_date($this->db->jdate($item->datef),'daytextshort');
					$result['Factures'][$i]['dateechance'] = dol_print_date($this->db->jdate($item->date_lim_reglement),'daytextshort');
					$result['Factures'][$i]['etat'] = html_entity_decode($facturesorig->getLibStatut(1), 0, 'UTF-8');
					$result['Factures'][$i]['montantttc'] = number_format($item->multicurrency_total_ttc, 2, ",", " ")." ".$item->multicurrency_code;
					$result['Factures'][$i]['resteapayer'] = number_format($resteapayer, 2, ",", " ")." ".$item->multicurrency_code;



					$otherdetails = [];
					$otherdetails['ref_client'] = $item->ref_client; // ref client
					$otherdetails['total_ht'] = number_format($item->multicurrency_total_ht, 2, ",", " ")." ".$item->multicurrency_code; // Total HT
					$otherdetails['total_tva'] = number_format($item->multicurrency_total_tva, 2, ",", " ")." ".$item->multicurrency_code; // Total TVA
					$otherdetails['mode_regelement'] = $form->cache_types_paiements[$facturesorig->mode_reglement_id]['label']; // Mode regelement
					$otherdetails['condition_regelement'] = html_entity_decode($form->cache_conditions_paiements[$facturesorig->cond_reglement_id]['label'], 0, 'UTF-8'); // Condition regelement

					$result['Factures'][$i]['otherdetails'] = json_encode($otherdetails);

					// $result['Factures'][$i]['refclient'] = $item->ref_client;
					// $result['Factures'][$i]['montantht'] = number_format($item->multicurrency_total_ht, 2, ",", " ")." ".$item->multicurrency_code;
					// $result['Factures'][$i]['montanttva'] = number_format($item->multicurrency_total_tva, 2, ",", " ")." ".$item->multicurrency_code;
					// $result['Factures'][$i]['moderegelement'] = $form->cache_types_paiements[$facturesorig->mode_reglement_id]['label'];
					// $result['Factures'][$i]['conditionregelement'] = $form->cache_conditions_paiements[$facturesorig->cond_reglement_id]['label'];

					// $result['Factures'][$i]['moderegelement'] = $form->form_modes_reglement($_SERVER['PHP_SELF'], $facturesorig->fk_mode_reglement, 'none', '', -1);
					// $result['Factures'][$i]['conditionregelement'] = $form->form_conditions_reglement($_SERVER['PHP_SELF'] . '?facid=' . $facturesorig->id, $facturesorig->cond_reglement_id, 'none');

			  }
			}
		}

		return $result;
	}
	

	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX ."facture";
		
		global $conf;
		if (dolibarr_get_const($this->db,'DOLIBARRMOBILE_FIX_ENTITY',0) && (dolibarr_get_const($this->db,'DOLIBARRMOBILE_FIX_ENTITY',0) > 0)){
			$filter .= " AND entity = ".dolibarr_get_const($this->db,'DOLIBARRMOBILE_FIX_ENTITY',0);
		}else{
			$filter .= " AND entity =  ".$conf->entity;
		}
		
		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		// echo $sql;
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		// echo $sql;
		// die();
		$this->rows = array();
		$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->id 	= $obj->rowid;
				$line->rowid 	= $obj->rowid;
				$line->entity 	= $obj->entity;
				$line->ref 	= $obj->ref;
				$line->datef 	= $obj->datef;
				$line->date_lim_reglement 	= $obj->date_lim_reglement;
				$line->fk_statut 	= $obj->fk_statut;
				$line->multicurrency_total_ttc 	= $obj->multicurrency_total_ttc;
				$line->multicurrency_code 	= $obj->multicurrency_code;

				
				$line->ref_client 	= $obj->ref_client;
				$line->multicurrency_total_ht 	= $obj->multicurrency_total_ht;
				$line->multicurrency_total_tva 	= $obj->multicurrency_total_tva;
				$this->rows[] 	= $line;
			}
			
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}

	}

	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'commande WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
				$this->id 		= $obj->rowid;
				$this->rowid 		= $obj->rowid;
				$this->ref 		= $obj->ref;
				$this->fk_soc 		= $obj->fk_soc;
				$this->fk_statut 	= $obj->fk_statut;
				$this->total 	= $obj->total;
				$this->multicurrency_code 	= $obj->multicurrency_code;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

} 

?>