<?php 

require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php"; 
require_once DOL_DOCUMENT_ROOT.'/core/lib/geturl.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 

dol_include_once('/dolibarrmobile/core/modules/moddolibarrmobile.class.php');
// dol_include_once('/dolibarrmobile/class/dolibarrmobile.class.php');
 
class dolibarrmobile extends Commonobject{ 

	public $errors = array();
	public $rowid;
	public $ref;

	public $element='dolibarrmobile';
	public $table_element='dolibarrmobile';
	
	public function __construct(DoliDBMysqli $db){ 
		$this->db = $db;
		return 1;
    }

    public function getprofilepic($userapi)
	{

		require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
		dol_include_once('/core/class/html.form.class.php');
		dol_include_once('/societe/class/societe.class.php');
		
		$societe 	= new Societe($this->db);


		global $langs, $conf, $mysoc, $dolibarr_main_data_root;


		$extentlogo=explode(".", $userapi->photo);
		$ext=$extentlogo[count($extentlogo) - 1];
		
		if($conf->user->multidir_output && is_readable($conf->user->multidir_output[1].'/'.$userapi->id.'/0/thumbs/'.$extentlogo[0].'_small.'.$ext)){
			$fullpath_original_file = $conf->user->multidir_output[1].'/'.$userapi->id.'/0/thumbs/'.$extentlogo[0].'_small.'.$ext;
			$original_file = $extentlogo[0].'_small.'.$ext;
		}else if($conf->user->multidir_output && is_readable($conf->user->multidir_output[1].'/'.$userapi->id.'/0/'.$userapi->photo)){
		    $fullpath_original_file = $conf->user->multidir_output[1].'/'.$userapi->id.'/0/'.$userapi->photo;
			$original_file = ($userapi->photo);
			
		}else if($conf->user->multidir_output && is_readable($conf->user->multidir_output[1].'/'.$userapi->id.'/'.$userapi->photo)){
		    $fullpath_original_file = $conf->user->multidir_output[1].'/'.$userapi->id.'/'.$userapi->photo;
			$original_file = ($userapi->photo);
			
		}else if ($userapi->societe_id){
			$societe->fetch($userapi->societe_id);
			// print_r($societe);
			// echo $conf->societe->dir_output.'/2/logos/thumbs/'.$societe->logo_small;
			if(is_readable($conf->societe->dir_output.'/'.$userapi->societe_id.'/logos/'.$societe->logo)){
				$fullpath_original_file=$conf->societe->dir_output.'/'.$userapi->societe_id.'/logos/'.($societe->logo);
				$original_file = ($societe->logo);
			}else{
			    $fullpath_original_file=$dolibarr_main_data_root.'/theme/dolibarr_logo.png';
				$original_file = ('theme/dolibarr_logo.png');
			}
		}else{
			$mysoc->logo_small=$conf->global->MAIN_INFO_SOCIETE_LOGO_SMALL;
			if (! empty($mysoc->logo_small) && is_readable($conf->mycompany->dir_output.'/logos/thumbs/'.$mysoc->logo_small))
			{
				$fullpath_original_file=$conf->mycompany->dir_output.'/logos/'.('thumbs/'.$mysoc->logo_small);
				$original_file = ('thumbs/'.$mysoc->logo_small);
			}else{
			    $fullpath_original_file=$dolibarr_main_data_root.'/theme/dolibarr_logo.png';
				$original_file = ('theme/dolibarr_logo.png');
			}

		}

		// print_r($original_file);die();
		clearstatcache();


		// Output files on browser
		dol_syslog("viewimage.php return file $fullpath_original_file content-type=$type");

		// This test is to avoid error images when image is not available (for example thumbs).
		if (! dol_is_file($fullpath_original_file))
		{
		    $fullpath_original_file=DOL_DOCUMENT_ROOT.'/public/theme/common/nophoto.png';
		    /*$error='Error: File '.$_GET["file"].' does not exists or filesystems permissions are not allowed';
		    print $error;
		    exit;*/
		}

		// Les drois sont ok et fichier trouve
		if ($type)
		{
		    top_httphead($type);
		    header('Content-Disposition: inline; filename="'.basename($fullpath_original_file).'"');
		}
		else
		{
		    top_httphead('image/png');
		    header('Content-Disposition: inline; filename="'.basename($fullpath_original_file).'"');
		}

		$fullpath_original_file_osencoded=dol_osencode($fullpath_original_file);

		readfile($fullpath_original_file_osencoded);




		clearstatcache();
		$type = 'application/octet-stream';
		$type = dol_mimetype($original_file);

		if ($type)
		{
		    echo top_httphead($type);
		    header('Content-Disposition: inline; filename="'.basename($fullpath_original_file).'"');
		}
		else
		{	
		    top_httphead('image/png');
		    header('Content-Disposition: inline; filename="'.basename($fullpath_original_file).'"');
		}

		$fullpath_original_file_osencoded=dol_osencode($fullpath_original_file);

		$content =file_get_contents($fullpath_original_file_osencoded);
		die($content);
    }

    public function getfilepdf($userapi, $elemtype, $elemid)
	{
		global $langs, $conf, $dolibarr_main_data_root;
		$filename=false;
		$forceDownload = 0;

		if($elemtype == "propals"){
			dol_include_once('/comm/propal/class/propal.class.php');
			$object = new Propal($this->db);
		}elseif($elemtype == "commandes"){
			dol_include_once('/commande/class/commande.class.php');
			$object = new Commande($this->db);
		}elseif($elemtype == "interventions"){
			dol_include_once('/dolibarrmobile/class/dolimobinterventions.class.php');
			$object = new interventions($this->db);
		}elseif($elemtype == "livraisons"){
			dol_include_once('/livraison/class/livraison.class.php');
			$object = new Livraison($this->db);
		}elseif($elemtype == "factures"){
			dol_include_once('compta/facture/class/facture.class.php');
			$object = new Facture($this->db);
		}

		$content = -1;

		if($object && $object->fetch($elemid) > 0)
		{
		    // if($object->statut>=Propal::STATUS_VALIDATED && ($object->socid==$user->societe_id || $user->admin))
		    if(1>0)
		    {
		    	$filename = $dolibarr_main_data_root.'/'.$object->last_main_doc;

		    	if($elemtype == "interventions"){
		    		$objtotest = $object->ref;
			        $documenturl = DOL_URL_ROOT.'/document.php';
			        $filename2 = dol_sanitizeFileName($object->ref);
			        $filename = $dolibarr_main_data_root."/ficheinter/".$filename2."/".$filename2.".pdf";
			        if(!file_exists($filename))
			            $filename = $dolibarr_main_data_root."/".$conf->entity."/ficheinter/".$filename2."/".$filename2.".pdf";

			    }elseif($elemtype == "livraisons"){
		    		$objtotest = $object->ref;
				    $filename = dol_sanitizeFileName($object->ref);
				    $filename = $dolibarr_main_data_root."/expedition/receipt/".$filename."/".$filename.".pdf";

		    	}else{
		    		$objtotest = $object->last_main_doc;		    		
		    	}


		        if(!empty($objtotest)){
		            //downloadFile($filename, $forceDownload);
		            if(!empty($filename) && file_exists($filename))
		            {
		                if(is_readable($filename) && is_file ( $filename ))
		                {
		                    $finfo = finfo_open(FILEINFO_MIME_TYPE);
		                    $mime = finfo_file($finfo, $filename);
		                    if($mime == 'application/pdf' && empty($forceDownload))
		                    {   
		                    	
		                        $content =file_get_contents($filename);
		                        die($content);
		                        exit();
		                    }
		                    
		                }
		                
		                
		            }
		            
		        }

		    }
		}

		$filename = dol_buildpath('/dolibarrmobile/img/emptyfile.pdf');
		$content =file_get_contents($filename);
    	die($content);	
    	
	}

	public function identification($userapi)
	{
		global $conf,$mysoc;

		dol_include_once('/societe/class/societe.class.php');
		$societe = new Societe($this->db);

		$name = $userapi->lastname." ".$userapi->firstname;
		$soc = $conf->global->MAIN_INFO_SOCIETE_NOM;
		if ($userapi->societe_id) {
			$societe->fetch($userapi->societe_id);
			$soc = $societe->nom;
		}


		$urllogo = "logo.png";
		$extentlogo=explode(".", $urllogo);

		$extentlogo=$extentlogo[count($extentlogo) - 1];

		// header("Access-Control-Allow-Origin: *");
		// header("Content-Type: application/json; charset=UTF-8");
		// header("Access-Control-Allow-Methods: POST");
		// header("Access-Control-Max-Age: 3600");
		// header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

		$result = [];

		$result[0]["connexion"] = "Connect";
		$result[0]['username'] = $name;
		$result[0]['societename'] = (!empty($soc)) ? $soc : "";

		$result[0]['extentlogo'] = $extentlogo;

		$result[0]['fonctionprofile'] = (!empty($userapi->job) ? $userapi->job : "-");
		$result[0]['fonctionprofile'] = (!empty($soc) ? $soc : "-");
		$result[0]['emailprofile'] = (!empty($userapi->email) ? $userapi->email : "-");
		$result[0]['phoneprofile'] = (!empty($userapi->user_mobile) ? $userapi->user_mobile : "-");
		$result[0]['faxprofile'] = (!empty($userapi->office_fax) ? $userapi->office_fax : "-");
		$result[0]['addressprofile'] = (!empty($userapi->address) ? $userapi->address : "-");


		return $result;
    }


















































	public function create($echo_sql=0,$insert)
	{
		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .get_class($this)." ( ";

		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			$sql_column .= " , `".$column."`";
			$sql_value .= " , ".$alias.$value.$alias;
		}

		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			return 0;
		} 
		return $this->db->db->insert_id;
	}

	public function update($id, array $data,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

        $sql = 'UPDATE ' . MAIN_DB_PREFIX .get_class($this). ' SET ';

        if (count($data) && is_array($data))
            foreach ($data as $key => $val) {
                $val = is_numeric($val) ? $val : '"'. $val .'"';
                $sql .= '`'. $key. '` = '. $val .',';
            }

        $sql  = substr($sql, 0, -1);
        $sql .= ' WHERE rowd = ' . $id;
        // die($sql);

        $resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			return -1;
		} 

		return 1;
	}

    
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX .get_class($this);

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		// die($sql);
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    = $obj->rowid;
				$line->rowid 	= $obj->rowid;
				$line->ref 	=  $obj->ref;
                // ....

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .get_class($this). ' WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			= $this->db->fetch_object($resql);
                $this->id    = $obj->rowid;
				$this->rowid 	= $obj->rowid;
				$this->ref 	=  $obj->ref;
                // ....
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id='',$attr=''){

	    global $conf;

	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'">';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

    function getNomUrl($withpicto=0, $option='', $get_params='', $notooltip=0, $save_lastsearch_value=-1)
    {
        global $langs, $conf, $user;

        if (! empty($conf->dol_no_mouse_hover)) $notooltip=1;   // Force disable tooltips

        $result='';
        $label='';
        $url='';

        // if ($user->rights->propal->lire){}

        $linkclose='';
        if (empty($notooltip))
        {
            $linkclose.= ' title="'.dol_escape_htmltag($label, 1).'"';
            $linkclose.=' class="classfortooltip"';
        }
        $linkstart = "";
        $linkend = "";
        $result = "";

        if ($this->ref) {
            $linkstart = '<a href="'.$url.'"';
            $linkstart.=$linkclose.'>';
            $linkend='</a>';

            $result .= $linkstart;
            if ($withpicto) 
                $result.= '<img height="16" src="'.DOL_URL_ROOT.'/dolibarrmobile/img/object_dolibarrmobile.png" >&nbsp;';
            if ($withpicto != 2) $result.= $this->ref;
        }

        $result .= $linkend;

        return $result;
    }








    public function getcountrows(){
        $tot = 0;
        $sql = "SELECT COUNT(rowid) as tot FROM ".MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);

        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
                $tot = $obj->tot;
            }
        }
        return $tot;
    }

    public function getdateformat($date,$time=true){
        
        $d = explode(' ', $date);
        $date = explode('-', $d[0]);
        $d2 = explode(':', $d[1]);
        $result = $date[2]."/".$date[1]."/".$date[0];
        if ($time) {
            $result .= " ".$d2[0].":".$d2[1];
        }
        return $result;
    }

    public function getYears($debut="debut")
    {
        $sql = 'SELECT YEAR('.$debut.') as years FROM ' . MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }


    public function getmonth($year)
    {
        $sql = 'SELECT MONTH(debut) as years FROM ' . MAIN_DB_PREFIX.get_class($this).' WHERE YEAR(debut) = '.$year;
        $resql  = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }
} 


class dolibarrmobilecls extends Commonobject{ 
    
    public function __construct($db){ 
        $this->db = $db;
        return 1;
    }

    public function fetch()
    {
        global $conf, $mysoc, $user, $langs;
        $langs->load('dolibarrmobile@dolibarrmobile');

        $modulrecrut = new moddolibarrmobile($this->db);

        $nummodul = $modulrecrut->numero;
        $editeurmodul = 'https://www.nextgestion.com';

        if (!dolibarr_get_const($this->db,'EDITOR_MODULE_DOLIBARRMOBILE',0))
            dolibarr_set_const($this->db,'EDITOR_MODULE_DOLIBARRMOBILE',$editeurmodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'ID_MODULE_DOLIBARRMOBILE',0))
            dolibarr_set_const($this->db,'ID_MODULE_DOLIBARRMOBILE',$nummodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'DATE_MODULE_DOLIBARRMOBILE',0))
            dolibarr_set_const($this->db,'DATE_MODULE_DOLIBARRMOBILE',date('Y-m-d'),'chaine',0,'',0);


        $id_modul      = dolibarr_get_const($this->db,'ID_MODULE_DOLIBARRMOBILE',0);
        $date_modul    = dolibarr_get_const($this->db,'DATE_MODULE_DOLIBARRMOBILE',0);
        $editor_modul  = dolibarr_get_const($this->db,'EDITOR_MODULE_DOLIBARRMOBILE',0);

        $link = urlencode(dol_buildpath('/',2));

        if(!empty($date_modul) && $date_modul <= date('Y-m-d') && !empty($editor_modul) && !empty($id_modul) && !empty($link)){

	        $name = ( $mysoc->name ? $mysoc->name : "(U) ".$user->lastname.' '.$user->firstname);
	        $name = urlencode($name);
        	$id_modul = urlencode($id_modul);
	        $mail = urlencode($mysoc->email); 

            $url = $editor_modul."/suivimod/module/registeruse?mod=".$id_modul."&link=".$link."&name=".$name."&email=".$mail;
            $urldata = getURLContent($url);
            $response = json_decode($urldata['content']);

            if($response && $response->actif == 0){
                dolibarr_set_const($this->db,'ID_MODULE_DOLIBARRMOBILE', 1, 'chaine',0,'',0);
                unActivateModule("moddolibarrmobile");
            }
            $newdate_modul = date("Y-m-d", strtotime("+ 1 day"));
            dolibarr_set_const($this->db,'DATE_MODULE_DOLIBARRMOBILE', $newdate_modul, 'chaine',0,'',0);
        }
        return 1;
    } 
}
?>