<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2015 ATM Consulting <support@atm-consulting.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *  \file       admin/dolibarrmobile.php
 *  \ingroup    dolibarrmobile
 *  \brief      This file is an example module setup page
 *              Put some comments here
 */
// Dolibarr environment
$res = @include("../../main.inc.php"); // From htdocs directory
if (! $res) {
    $res = @include("../../../main.inc.php"); // From "custom" directory
}

// Libraries
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once '../lib/dolibarrmobile.lib.php';

dol_include_once('/dolibarrmobile/class/dolibarrmobile.class.php');
dol_include_once('/dolibarrmobile/class/dolimobpropals.class.php');

$dolibarrmobile  = new dolibarrmobile($db);


$dolibarrmobilecls = new dolibarrmobilecls($db);
$result = $dolibarrmobilecls->fetch();
// $dolimobpropals  = new dolimobpropals($db);
// $dolimobpropals->fetchAll();
// print_r($dolimobpropals->rows);die;

// Translations
$langs->load("dolibarrmobile@dolibarrmobile");
$langs->load("propal");
$langs->load("admin");

// Access control
if (! $user->admin) {
    accessforbidden();
}

// Parameters
$action = GETPOST('action', 'alpha');


if ($action == 'dolibarrmobile_chooseentity') {
    $error = 0;

    $name = 'DOLIBARRMOBILE_FIX_ENTITY';

    if (isset($_POST[$name])){
        $res = dolibarr_set_const($db, $name, $_POST[$name], 'chaine', 0, '', 0);
    }
    if (! $res > 0) $error ++;


    if (! $error) {
        setEventMessage($langs->trans("SetupSaved"), 'mesgs');
    } else {
        setEventMessage($langs->trans("Error"), 'errors');
    }
}







/*
 * View
 */
$page_name = "dolibarrmobileSetup";
llxHeader('', $langs->trans($page_name));

// Subheader
$linkback = '<a href="' . DOL_URL_ROOT . '/admin/modules.php">'
    . $langs->trans("BackToModuleListDolibarrMobile") . '</a>';
print_fiche_titre($langs->trans($page_name), $linkback);

// Configuration header
// $head = dolibarrmobileAdminPrepareHead();
// dol_fiche_head(
//     $head,
//     'Proposals',
//     $langs->trans("dolibarrmobile"),
//     0,
//     "dolibarrmobile@dolibarrmobile"
// );

// Setup page goes here
$form=new Form($db);
$var=false;


$fixedentity = dolibarr_get_const($db,'DOLIBARRMOBILE_FIX_ENTITY',0);


$sql = "SELECT *";
$sql.= " FROM ".MAIN_DB_PREFIX."entity as t";
$sql.= ' WHERE t.active = 1';
$resql = $db->query($sql);


if($resql){

// print_r($status);
print '<form id="col4-form" method="post" action="dolibarrmobile_setup.php">';
print '<input type="hidden" name="action" value="dolibarrmobile_chooseentity">';
print '<table class="noborder" width="100%">';

print '<tr>';
    print '<td style="width:200px;">';
            print $langs->trans("dolibarrmobile_chooseentity");
    print '</td>';
    print '<td class="generatdolibarrmobileforcheck">';
        print '<select name="DOLIBARRMOBILE_FIX_ENTITY">';
        print '<option value="-1" ></option>';
		$slctd = '';
		if ($resql) {
			$num = $db->num_rows($resql);

			while ($obj = $db->fetch_object($resql)) {
				
				if($fixedentity){
					$slctd = ($obj->rowid == $fixedentity) ? 'selected' : '';
				}
				print '<option value="'.$obj->rowid.'" '.$slctd.'>'.$obj->label.'</option>';
			}
		}else{
			// print_r('Error ' . $db->lasterror());die;
		}
		print '</select>';
    print '</td>';
print '</tr>';

print '</table>';
print '<br><div style="text-align:left;"><input type="submit" class="butAction" value="'.$langs->trans("Validate").'"></div>';
print '</form>';
}



llxFooter();

$db->close();


