<?php
/* Copyright (C) 2014-2020		charlene Benke		<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file	   htdocs/customline/class/actions_customline.class.php
 * 	\ingroup	equipement
 * 	\brief	  Fichier de la classe des actions/hooks de customline
 */

class ActionsCustomtooltip // extends CommonObject 
{
	/** Overloading the doActions function : replacing the parent's function with the one below 
	 *  @param	  parameters  meta datas of the hook (context, etc...) 
	 *  @param	  object			 the object you want to process 
	 *  @param	  action			 current action (if set). Generally create or edit or null 
	 *  @return	   void 
	 */
	function getnomurltooltip($parameters, $object, $action) 
	{
		global $hookmanager;
		require_once DOL_DOCUMENT_ROOT.'/core/lib/functions.lib.php';
		require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';

		$hookmanager->initHooks(array('customtooltip'));

		global $conf, $langs, $db, $user;
		
		$langs->load("customtooltip@customtooltip");

		$form = new Form($db);
		switch ($object->table_element) {
			case "societe" :
				$object->fetch($object->id);

				if (! empty($object->name_alias)) 
					$tmptooltip.='<h3>'.$object->name_alias.'</h3>';	  // For thirdparty

				$tmptooltip.='<table><tr><td>'.$form->showphoto(
								"societe", $object, 0, 0, 0, 
								'photoref', 'small', 1, 0, 1
				);
				// pour empecher l'affichage d'un lien bidon
				$tmpusejavascriptajax = $conf->use_javascript_ajax ;
				$conf->use_javascript_ajax ="";
				$tmpadress= $object->getBannerAddress('refaddress', $object);
				$conf->use_javascript_ajax = $tmpusejavascriptajax;
				$tmptooltip.='</td><td valign=top>'.$tmpadress.'</td></tr></table>';

				$tmptooltip.="<br>".$langs->trans("Statut")." : ".$object->getLibStatut(2);
				
				// affichage des encours de facturation
				if ($conf->global->CUSTOMTOOLTIP_DISPLAY_OUTSTANDINGLIMIT) {
					$tmptooltip.="<br>".$langs->trans("OutstandingBill")." : ";
					if ((int) DOL_VERSION >10)
						$tmptooltip.= price($object->getOutstandingBills()) . ' / ';
					else
						$tmptooltip.= price($object->get_OutstandingBill()) . ' / ';
					$tmptooltip.= price($object->outstanding_limit, 0, '', 1, - 1, - 1, $conf->currency);
				}

				// affichage des extrafields
				if ($conf->global->CUSTOMTOOLTIP_DISPLAY_EXTRAFIELDS) {
					$extrafields = new ExtraFields($db);
					$extralabels=$extrafields->fetch_name_optionals_label($object->table_element);

					foreach ($extrafields->attribute_label as $key=>$label) {
						$value=$object->array_options["options_".$key];
						$tmptooltip.="<br>".$label." : ".$extrafields->showOutputField($key, $value);
					}
				}

				// HOOK du tooltip pour ajouter des infos en plus
				$parameters = array();
				// Note that $action and $object may have been modified by some hooks
				$reshook = $hookmanager->executeHooks('customtooltipAddInfo', $parameters, $object, $action); 
				if ($reshook > 0) 	$tmptooltip.="&lt;br&gt;".$hookmanager->resPrint;

				$linkclose= ' title="'.str_replace("\"", "'", $tmptooltip).'"';

				if ((int) DOL_VERSION < 7)
					$linkclose.=' class="classforcustomtooltip"';
				else
					$linkclose.=' class="classfortooltip refurl"';
					
				$this->resprints =$linkclose;
				break;

			case "socpeople" :
				$tmptooltip="";
				$object->fetch($object->id);

				if (! empty($object->name_alias)) 
					$tmptooltip.='<h3>'.$object->name_alias.'</h3>';	  // For thirdparty

				$tmptooltip.='<table><tr><td>'.$form->showphoto(
								"contact", $object, 0, 0, 0, 
								'photoref', 'small', 1, 0, 1
				);
				// pour empecher l'affichage d'un lien bidon
				$tmpusejavascriptajax = $conf->use_javascript_ajax ;
				$conf->use_javascript_ajax ="";
				$tmpadress= $object->getBannerAddress('refaddress', $object);
				$conf->use_javascript_ajax = $tmpusejavascriptajax;
				$tmptooltip.='</td><td valign=top>'.$tmpadress.'</td></tr></table>';

				$tmptooltip.="<br>".$langs->trans("Statut")." : ".$object->getLibStatut(2);

				// affichage des extrafields
				if ($conf->global->CUSTOMTOOLTIP_DISPLAY_EXTRAFIELDS) {
					$extrafields = new ExtraFields($db);
					$extralabels=$extrafields->fetch_name_optionals_label($object->table_element);
					
					foreach ($extrafields->attribute_label as $key=>$label) {
						$value=$object->array_options["options_".$key];
						$tmptooltip.="<br>".$label." : ".$extrafields->showOutputField($key, $value);
					}
				}

				$parameters = array();
				// Note that $action and $object may have been modified by some hooks
				$reshook = $hookmanager->executeHooks('customtooltipAddInfo', $parameters, $object, $action); 
				if ($reshook > 0) 	$tmptooltip.="&lt;br&gt;".$hookmanager->resPrint;

				$linkclose= ' title="'.str_replace("\"", "'", $tmptooltip).'"';
				if ((int) DOL_VERSION < 7)
					$linkclose.=' class="classforcustomtooltip">';
				elseif ((int) DOL_VERSION < 8)
					$linkclose.=' class="classfortooltip">';
				else
					$linkclose.=' class="classfortooltip"';
	
				$this->resprints =$linkclose;
				break;

			case "actioncomm" :
				$tmptooltip="";
				$object->fetch($object->id);
				$tmptooltip.='<table border=0>';
				// Ref
				$tmptooltip.='<tr><td width="30%">'.$langs->trans("Ref").'</td><td >';
				$tmptooltip.=$object->ref;
				$tmptooltip.='</td></tr>';

				// Type
				if (! empty($conf->global->AGENDA_USE_EVENT_TYPE))
					$tmptooltip.='<tr><td>'.$langs->trans("Type").'</td><td >'.$object->type.'</td></tr>';

				$tmptooltip.='<tr><td colspan=2 class="nowrap">'.$langs->trans("ActionAssignedTo").'</td></tr>';
				$tmptooltip.='<tr><td colspan="2" align=left>';
					$listofuserid=array();
				// Owner first
				if ($object->userownerid > 0) 
					$listofuserid[$object->userownerid]=array(
									'id'=>$object->userownerid,
									'transparency'=>$object->transparency
					);	
				if (! empty($object->userassigned)) { // Now concat assigned users
					// Restore array with key with same value than param 'id'
					$tmplist1=$object->userassigned;
					foreach ($tmplist1 as $key => $val)
						if ($val['id'] && $val['id'] != $object->userownerid)
							 $listofuserid[$val['id']]=$val;
				}
				$_SESSION['assignedtouser']=json_encode($listofuserid);
				$tmptooltip.=$form->select_dolusers_forevent(
								'view', 'assignedtouser',
								1, '', 0, '', '', 0, 0, 0, '', 0, '',
								'maxwidth300'
				);
				// We show nothing if event is assigned to nobody
				$tmptooltip.=$langs->trans("MyAvailability").': ';
				if ($object->userassigned[$user->id]['transparency'] > 0)
					$tmptooltip.=$langs->trans("Busy");
				else
					$tmptooltip.=$langs->trans("Available");
				$tmptooltip.= '</td></tr>';
				if ($object->label) {
					$tmptooltip.='<tr><td colspan=2>';
					$tmptooltip.=$object->label;
					$tmptooltip.='</td></tr>';
				}

				if ($object->note) {
					$tmptooltip.='<tr><td colspan=2>';
					$tmptooltip.=$object->note;
					$tmptooltip.='</td></tr>';
				}
				$tmptooltip.='</table>';

				$tmptooltip.=$langs->trans("Statut")." : ".$object->getLibStatut(2);
				// affichage des extrafields
				if ($conf->global->CUSTOMTOOLTIP_DISPLAY_EXTRAFIELDS) {
					$extrafields = new ExtraFields($db);
					$extralabels=$extrafields->fetch_name_optionals_label($object->table_element);
					$object->fetch_optionals($object->id, $extralabels);

					foreach ($extrafields->attribute_label as $key=>$label) {
						$value=$object->array_options["options_".$key];
						$tmptooltip.="<br>".$label." : ".$extrafields->showOutputField($key, $value);
					}
				}

				$parameters = array();
				// Note that $action and $object may have been modified by some hooks
				$reshook = $hookmanager->executeHooks('customtooltipAddInfo', $parameters, $object, $action); 
				if ($reshook > 0) 	$tmptooltip.="&lt;br&gt;".$hookmanager->resPrint;

				$linkclose= ' title="'.str_replace("\"", "'", $tmptooltip).'"';
				
				if ((int) DOL_VERSION < 7) {
					$linkclose.=' class="classforcustomtooltip">';
					if ((int) DOL_VERSION < 5)
						$linkclose.=' >';
				} else
					$linkclose.=' class="classfortooltip"';

				$this->resprints =$linkclose;
				break;

			case "adherent" :
				$tmptooltip="";
				$object->fetch($object->id);
				if (! is_object($adht)) {
					include_once DOL_DOCUMENT_ROOT.'/adherents/class/adherent_type.class.php';
					$adht = new AdherentType($db);
				}

				$adht->fetch($object->typeid);
				$tmptooltip.='<table class="border centpercent">';

				if (! empty($object->firstname) || ! empty($object->lastname)|| ! empty($object->societe)) {
					$tmptooltip.='<tr><td>'.$langs->trans("Name")."/".$langs->trans("Company").'</td>';
					$tmptooltip.='<td class="valeur">'.$object->getFullName($langs)." ".$object->societe."</td></tr>\n";
				}
				// Type
				$tmptooltip.='<tr><td>'.$langs->trans("Type").'</td><td class="valeur">'.$adht->getNomUrl(1)."</td></tr>\n";

				// Morphy
				$tmptooltip.='<tr><td>'.$langs->trans("Nature").'</td><td class="valeur" >'.$object->getmorphylib().'</td></tr>';

				$tmptooltip.='<tr><td>'.$langs->trans("SubscriptionEndDate").'</td><td class="valeur">';
				if ($object->datefin) {
					$tmptooltip.= dol_print_date($object->datefin, 'day');
					if ($object->hasDelay()) {
						$tmptooltip.= " ".img_warning($langs->trans("Late"));
					}
				} else {
					if (! $adht->cotisation)
						$tmptooltip.= $langs->trans("SubscriptionNotRecorded");
					else
						$tmptooltip.= $langs->trans("SubscriptionNotReceived");

					if ($object->statut > 0) // Affiche picto retard uniquement si non brouillon et non resilie
						$tmptooltip.= " ".img_warning($langs->trans("Late")); 
				}
				$tmptooltip.='</td></tr>';
				$tmptooltip.='<tr><td>'.$langs->trans("Statut").'</td>';
				$tmptooltip.='<td class="valeur">'.$object->getLibStatut(2).'&nbsp;</td></tr>';
				$tmptooltip.='</table>';

				// affichage des extrafields
				if ($conf->global->CUSTOMTOOLTIP_DISPLAY_EXTRAFIELDS) {
					$extrafields = new ExtraFields($db);
					$extralabels=$extrafields->fetch_name_optionals_label($object->table_element);
					
					foreach ($extrafields->attribute_label as $key=>$label) {
						$value=$object->array_options["options_".$key];
						$tmptooltip.="<br>".$label." : ".$extrafields->showOutputField($key, $value);
					}
				}
				$parameters = array();
				// Note that $action and $object may have been modified by some hooks
				$reshook = $hookmanager->executeHooks('customtooltipAddInfo', $parameters, $object, $action); 
				if ($reshook > 0) 	$tmptooltip.="&lt;br&gt;".$hookmanager->resPrint;

				$linkclose= '" title="'.str_replace("\"", "'", $tmptooltip).'"';
				if ((int) DOL_VERSION < 7)
					$linkclose.=' class="classforcustomtooltip">';
				else
					$linkclose.=' class="classfortooltip"';

				$this->resprints =$linkclose;
				break;

			case "product" :
				$tmptooltip='<table class="noborder" width="100%">';
				$object->fetch($object->id);
				$tmptooltip.='<tr class="liste_titre"><td colspan=2>';
				if ($object->type == Product::TYPE_PRODUCT) 
					$tmptooltip.=img_object($label, 'product', 'class="classfortooltip"', 0, 0, 1)." ";
				if ($object->type == Product::TYPE_SERVICE) 
					$tmptooltip.=img_object($label, 'service', 'class="classfortooltip"', 0, 0, 1)." ";

				$tmptooltip.=$object->label.'</td></tr>';
				$showimage=$object->is_photo_available($conf->product->multidir_output[$object->entity]);

				$maxvisiblephotos=5;
				if (isset($conf->global->PRODUCT_MAX_VISIBLE_PHOTO))
					$maxvisiblephotos=$conf->global->PRODUCT_MAX_VISIBLE_PHOTO;
				if ($conf->browser->phone) 
					$maxvisiblephotos=1;

				if ($showimage) {
					$tmptooltip.='<tr><td rowspan=3><div class="floatleft inline-block valignmiddle divphotoref">';
					$tmptooltip.=$object->show_photos(
									$conf->product->multidir_output[$object->entity], 
									'small', $maxvisiblephotos, 0, 0, 0, $width, 0
					);
					$tmptooltip.='</div></td>';
				} else
					$tmptooltip.='<tr>';
				if (! empty($conf->productbatch->enabled)) $langs->load("productbatch");
				
				$tmptooltip.='<td class="valeur" valign=top>'.$object->getLibStatut(2, 0).'&nbsp;<br>';
				$tmptooltip.=$object->getLibStatut(2, 1).'&nbsp;';
				if (! empty($conf->productbatch->enabled)) {
					$langs->load("productbatch");
					$tmptooltip.='<br>'.$langs->trans("Statut").'</td><td valign=top class="valeur">'.$object->getLibStatut(2, 2).'&nbsp;';
				}
				$tmptooltip.='</td></tr></table>';

				// affichage des extrafields
				if ($conf->global->CUSTOMTOOLTIP_DISPLAY_EXTRAFIELDS) {
					$extrafields = new ExtraFields($db);
					$extralabels=$extrafields->fetch_name_optionals_label('product');
					//$extralabels=$extrafields->fetch_name_optionals_label($object->table_element);
					
					foreach ($extrafields->attribute_label as $key=>$label) {
						$value=$object->array_options["options_".$key];
						$tmptooltip.="<br>".$label." : ".$extrafields->showOutputField($key, $value);
					}
				}

				// affichage des stocks des entrepots
				if ($conf->global->CUSTOMTOOLTIP_DISPLAY_WAREHOUSEQTY) {
					if ((int) DOL_VERSION < 7)
						$sql= "SELECT e.rowid, e.label as entlabel,";
					else
						$sql= "SELECT e.rowid, e.ref as entlabel,";

					$sql.= " e.lieu, ps.reel, ps.rowid as product_stock_id";
					$sql.= " FROM ".MAIN_DB_PREFIX."entrepot as e";
					$sql.= " , ".MAIN_DB_PREFIX."product_stock as ps";
					$sql.= " LEFT JOIN ".MAIN_DB_PREFIX."product as p ON p.rowid = ps.fk_product";
					$sql.= " WHERE ps.reel != 0";
					$sql.= " AND ps.fk_entrepot = e.rowid";
					$sql.= " AND e.entity IN (".getEntity('stock', 1).")";
					$sql.= " AND ps.fk_product = ".$object->id;
					$sql.= " ORDER BY entlabel";

					require_once DOL_DOCUMENT_ROOT.'/product/stock/class/entrepot.class.php';

					$entrepotstatic=new Entrepot($db);

					$resql=$db->query($sql);
					if ($resql) {
						$num = $db->num_rows($resql);
						$total=0;
						global $bc;
						$i=0; $var=false;
						$tmptooltipstock="<br>";
						$tmptooltipstock.='<table class="noborder" width="100%">';
						$tmptooltipstock.='<tr class="liste_titre"><td width="40%" colspan="4">'.$langs->trans("Warehouse").'</td>';
						$tmptooltipstock.='<td align="right">'.$langs->trans("NumberOfUnit").'</td>';

						while ($i < $num) {
							$obj = $db->fetch_object($resql);
							$entrepotstatic->id=$obj->rowid;
							$entrepotstatic->libelle=$obj->entlabel;
							$entrepotstatic->lieu=$obj->lieu;
							$stock_real = round($obj->reel, 10);
							$tmptooltipstock.='<tr '.$bc[$var].'>';
							$tmptooltipstock.='<td colspan="4">'.$entrepotstatic->getNomUrl(1).'</td>';
							$tmptooltipstock.='<td align="right">'.$stock_real.($stock_real < 0 ?' '.img_warning():'').'</td>';
							$total += $obj->reel;
							$tmptooltipstock.='</tr>';
							$i++;
							$var=!$var;
						}

						$tmptooltipstock.='<tr class="liste_total">';
						$tmptooltipstock.='<td align="right" class="liste_total" colspan="4">'.$langs->trans("Total").':</td>';
						$tmptooltipstock.='<td class="liste_total" align="right">'.$total.'</td>';
						$tmptooltipstock.='</tr></table>';

						$tmptooltip.=$tmptooltipstock;
					}
				}

				$parameters = array();
				// Note that $action and $object may have been modified by some hooks
				$reshook = $hookmanager->executeHooks('customtooltipAddInfo', $parameters, $object, $action); 
				if ($reshook > 0) 	$tmptooltip.="&lt;br&gt;".$hookmanager->resPrint;

				$linkclose= ' class="classfortooltip" title="'.str_replace("\"", "'", $tmptooltip).'"';

				if ((int) DOL_VERSION < 7)
					$linkclose.=' class="classforcustomtooltip"';
				elseif ((int) DOL_VERSION < 8)
					$linkclose.=' class="classfortooltip" ';
				
				$this->resprints =$linkclose;
				break;

			case "projet" :
				global $label;
			
				require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
				
				$object->fetch($object->id);
				//if ($object->socid > 0)

				$prjtooltip='<div class="refidno">';
				$prjtooltip.= $object->title.'<br>';
				// Thirdparty
				if ($object->socid > 0) {
					$soc = new Societe($db);
					$soc->fetch($object->socid);
					$object->fetch_thirdparty();
					$prjtooltip.= $langs->trans('ThirdParty').' : '.$object->thirdparty->getNomUrl(1, '', 0, 1).'<br>';
				}

				// tableau r�cap des taches, avec les infos
				$prjtooltip.=$langs->trans("Statut")." : ".$object->getLibStatut(2)."<br>";
				
				// nombre de taches
				if ((int) DOL_VERSION < 5) {
					require_once DOL_DOCUMENT_ROOT.'/projet/class/task.class.php';
					$taskstatic = new Task($db);

					$object->lines = $taskstatic->getTasksArray(0, $user, $object->id, 0, 0);
				} else
					$object->getLinesArray($user);
				


				$prjtooltip.=$langs->trans("NbTask")." : ".count($object->lines)."<br>";

				// nombre de d'heures pr�vue et pass�
				if (count($object->lines) > 0) {
					$timeplanned=0;
					$timemade=0;
					foreach ($object->lines as $line) {
						$timeplanned+=$line->planned_workload;
						$timemade+=$line->duration;
					}
					$prjtooltip.=$langs->trans("TimePlanned")." : ".convertSecondToTime($timeplanned)."<br>";
					$prjtooltip.=$langs->trans("TimeMade")." : ".convertSecondToTime($timemade)."<br>";
				}
				$prjtooltip.='</div>';
				
				// HOOK du tooltip pour ajouter des infos en plus
				$parameters = array();
				// Note that $action and $object may have been modified by some hooks
				$reshook = $hookmanager->executeHooks('customtooltipAddInfo', $parameters, $object, $action); 
				if ($reshook > 0) 	$prjtooltip.="&lt;br&gt;".$hookmanager->resPrint;

				$linkclose= ' title="'.str_replace("\"", "'", $prjtooltip).'"';
				if ((int) DOL_VERSION < 7)
					$linkclose.=' class="classforcustomtooltip"';
				else
					$linkclose.=' class="classfortooltip"';

				$this->resprints =$linkclose;
				break;

			default :
				// we do nothing
				$this->results=-1;
				return -1;
				break;
		}
		$this->results=1;
		return 1;
	}
	
	// on ajoute un tooltip après le label
	function getnomurl($parameters, $object, $action) 
	{
		$tmpArray = explode('"',$parameters['getnomurl']);
		$theUrl = $tmpArray[1];
		$this->getnomurltooltip($parameters, $object, $action);
		if ($this->resprints)
			$this->resprints =" <a href='".$theUrl."' target='_blank' ".$this->resprints.">".img_picto("", "object_customtooltip@customtooltip")."</a> ";
		return 0;
	}
}