<?php
/* Copyright (C) 2014-2016		Charlene BENKE	<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  \file	   htdocs/customtooltip/admin/societe.php
 *  \ingroup	customtooltip
 *  \brief	  Page d'administration-configuration du module customtooltip
 */

$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");					// For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");	// For "custom" directory

dol_include_once("/customtooltip/core/lib/customtooltip.lib.php");
require_once(DOL_DOCUMENT_ROOT."/core/lib/admin.lib.php");
require_once(DOL_DOCUMENT_ROOT."/core/class/html.formadmin.class.php");
require_once(DOL_DOCUMENT_ROOT."/core/class/html.form.class.php");
require_once(DOL_DOCUMENT_ROOT."/core/class/html.formother.class.php");

$langs->load("admin");
$langs->load("other");
$langs->load("customtooltip@customtooltip");

// Security check
if (! $user->admin || $user->design) accessforbidden();

$action = GETPOST('action', 'alpha');
$value = GETPOST('value', 'alpha');

$form = new Form($db);
/*
 * Actions
 */


if ($action == 'setvalue') {
	// on alimente 
	// save the setting
	dolibarr_set_const($db, "CUSTOMTOOLTIP_FADEOUT", GETPOST("fadeout"), 'chaine', 0, '', $conf->entity);
	$mesg = "<font class='ok'>".$langs->trans("SetupSaved")."</font>";
}
$fadeout=($conf->global->CUSTOMTOOLTIP_FADEOUT?$conf->global->CUSTOMTOOLTIP_FADEOUT:5000);

/*
 * View
 */

$page_name = $langs->trans("CustomTooltipSetup") . " - " .$langs->trans("CompanySetting");
llxHeader('', $page_name);

$linkback='<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
print_fiche_titre($page_name, $linkback, 'title_setup');

$head = customtooltip_admin_prepare_head();

dol_fiche_head($head, 'societe', $langs->trans("customTooltip"), 0, "customtooltip@customtooltip");

// Show errors
dol_htmloutput_errors($object->error, $object->errors);

print_titre($langs->trans("ListOfFields"));
print '<br>';

print "<table summary='listofattributes' class='noborder' width='100%' >";
print '<tr class="liste_titre">';
print '<td width=250px>'.$langs->trans("DisplayElementSetting").'</td>';
print '<td>'.$langs->trans("Value").'</td>';
print '</tr>';

print '<tr >';
print '<td width=20%  align=left>'.$langs->trans("DisplayExtrafields").'</td>';
print '<td  align=left>';
if ($displayextrafields == 1) {
	print '<a href="'.$_SERVER["PHP_SELF"].'?rowid='.$rowid.'&action=displayextrafields&value=0">';
	print img_picto($langs->trans("Enabled"), 'switch_on').'</a>';
} else {
	print '<a href="'.$_SERVER["PHP_SELF"].'?rowid='.$rowid.'&action=displayextrafields&value=1">';
	print img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
}
print '</td></tr>'."\n";

// extrafields
print '</table>';


// Show messages
dol_htmloutput_mesg($object->mesg, '', 'ok');

llxFooter();
$db->close();