<?php
/* Copyright (C) 2014-2017		Charlene BENKE	<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  \file	   htdocs/customtooltip/admin/setup.php
 *  \ingroup	customtooltip
 *  \brief	  Page d'administration-configuration du module customtooltip
 */

$res=0;
if (! $res && file_exists("../../main.inc.php"))
	$res=@include("../../main.inc.php");					// For root directory
if (! $res && file_exists("../../../main.inc.php"))
	$res=@include("../../../main.inc.php");	// For "custom" directory

dol_include_once("/customtooltip/core/lib/customtooltip.lib.php");
require_once(DOL_DOCUMENT_ROOT."/core/lib/admin.lib.php");
require_once(DOL_DOCUMENT_ROOT."/core/class/html.formadmin.class.php");
require_once(DOL_DOCUMENT_ROOT."/core/class/html.form.class.php");
require_once(DOL_DOCUMENT_ROOT."/core/class/html.formother.class.php");

$langs->load("admin");
$langs->load("other");
$langs->load("customtooltip@customtooltip");

// Security check
if (! $user->admin || $user->design) accessforbidden();

$action = GETPOST('action', 'alpha');
$value = GETPOST('value', 'alpha');

$form = new Form($db);
/*
 * Actions
 */

if ($action == 'displayextrafields' ) {
	dolibarr_set_const($db, "CUSTOMTOOLTIP_DISPLAY_EXTRAFIELDS", $value, 'chaine', 0, '', $conf->entity);
	//$mesg = "<font class='ok'>".$langs->trans("DisplaySettingSaved")."</font>";
	$displayextrafields=$value;
} else
	$displayextrafields=$conf->global->CUSTOMTOOLTIP_DISPLAY_EXTRAFIELDS;

if ($action == 'displayqtystorage') {
	dolibarr_set_const($db, "CUSTOMTOOLTIP_DISPLAY_WAREHOUSEQTY", $value, 'chaine', 0, '', $conf->entity);
	//$mesg = "<font class='ok'>".$langs->trans("DisplaySettingSaved")."</font>";
	$displayqtystorage=$value;
} else
	$displayqtystorage=$conf->global->CUSTOMTOOLTIP_DISPLAY_WAREHOUSEQTY;

if ($action == 'displayoutstandinglimit' ) {
	dolibarr_set_const($db, "CUSTOMTOOLTIP_DISPLAY_OUTSTANDINGLIMIT", $value, 'chaine', 0, '', $conf->entity);
	//$mesg = "<font class='ok'>".$langs->trans("DisplaySettingSaved")."</font>";
	$displayoutstandinglimit =$value;
} else
	$displayoutstandinglimit = $conf->global->CUSTOMTOOLTIP_DISPLAY_OUTSTANDINGLIMIT;

/*
 * View
 */

$page_name = $langs->trans("CustomTooltipSetup") . " - " .$langs->trans("customtooltipGeneralSetting");
llxHeader('', $page_name);

$linkback='<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
print_fiche_titre($page_name, $linkback, 'title_setup');

$head = customtooltip_admin_prepare_head();

dol_fiche_head($head, 'setup', $langs->trans("customTooltip"), 0, "customtooltip@customtooltip");

dol_htmloutput_errors($object->error, $object->errors);

print "<table summary='listofattributes' class='noborder' width='100%' >";
print '<tr class="liste_titre">';
print '<td >'.$langs->trans("DisplayElementSetting").'</td>';
print '<td>'.$langs->trans("Value").'</td>';
print '</tr>';
print '<tr >';
print '<td align=left>'.$langs->trans("DisplayExtrafields").'</td>';
print '<td  align=left>';
if ( $displayextrafields == 1 ) {
	print '<a href="'.$_SERVER["PHP_SELF"].'?rowid='.$rowid.'&action=displayextrafields&value=0">';
	print img_picto($langs->trans("Enabled"), 'switch_on').'</a>';
} else {
	print '<a href="'.$_SERVER["PHP_SELF"].'?rowid='.$rowid.'&action=displayextrafields&value=1">';
	print img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
}
print '</td></tr>'."\n";
print '<tr >';
print '<td align=left>'.$langs->trans("DisplayStorageQtyOnProduct").'</td>';
print '<td  align=left>';
if ( $displayqtystorage == 1 ) {
	print '<a href="'.$_SERVER["PHP_SELF"].'?rowid='.$rowid.'&action=displayqtystorage&value=0">';
	print img_picto($langs->trans("Enabled"), 'switch_on').'</a>';
} else {
	print '<a href="'.$_SERVER["PHP_SELF"].'?rowid='.$rowid.'&action=displayqtystorage&value=1">';
	print img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
}
print '</td></tr>'."\n";
print '<tr >';
print '<td align=left>'.$langs->trans("DisplayOutstandingLimit").'</td>';
print '<td  align=left>';
if ( $displayoutstandinglimit == 1 ) {
	print '<a href="'.$_SERVER["PHP_SELF"].'?rowid='.$rowid.'&action=displayoutstandinglimit&value=0">';
	print img_picto($langs->trans("Enabled"), 'switch_on').'</a>';
} else {
	print '<a href="'.$_SERVER["PHP_SELF"].'?rowid='.$rowid.'&action=displayoutstandinglimit&value=1">';
	print img_picto($langs->trans("Disabled"), 'switch_off').'</a>';
}
print '</td></tr>'."\n";

print '</table>';

/*
 *  Infos pour le support
 */
print '<br>';
libxml_use_internal_errors(true);
$sxe = simplexml_load_string(nl2br(file_get_contents('../changelog.xml')));
if ($sxe === false) {
	echo "Erreur lors du chargement du XML\n";
	foreach (libxml_get_errors() as $error) 
		print $error->message;
	exit;
} else
	$tblversions=$sxe->Version;

$currentversion = $tblversions[count($tblversions)-1];

print '<table class="noborder" width="100%">'."\n";
print '<tr class="liste_titre">'."\n";
print '<td width=20%>'.$langs->trans("SupportModuleInformation").'</td>'."\n";
print '<td>'.$langs->trans("Value").'</td>'."\n";
print "</tr>\n";
print '<tr '.$bc[false].'><td >'.$langs->trans("DolibarrVersion").'</td><td>'.DOL_VERSION.'</td></tr>'."\n";
print '<tr '.$bc[true].'><td >'.$langs->trans("ModuleVersion").'</td>';
print '<td>'.$currentversion->attributes()->Number." (".$currentversion->attributes()->MonthVersion.')</td></tr>'."\n";
print '<tr '.$bc[false].'><td >'.$langs->trans("PHPVersion").'</td><td>'.version_php().'</td></tr>'."\n";
print '<tr '.$bc[true].'><td >'.$langs->trans("DatabaseVersion").'</td>';
print '<td>'.$db::LABEL." ".$db->getVersion().'</td></tr>'."\n";
print '<tr '.$bc[false].'><td >'.$langs->trans("WebServerVersion").'</td>';
print '<td>'.$_SERVER["SERVER_SOFTWARE"].'</td></tr>'."\n";
print '<tr>'."\n";
print '<td colspan="2">'.$langs->trans("SupportModuleInformationDesc").'</td></tr>'."\n";
print "</table>\n";

// Show messages
dol_htmloutput_mesg($object->mesg, '', 'ok');

// Footer
llxFooter();
$db->close();