<?php
/* Copyright (C) 2014-2017	Charlene BENKE	<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

/**
 *	\defgroup   member	 customtabs
 *	\brief	  Module to manage Customtabs
 *	\file	   htdocs/customtabs/core/modules/modCustomtabs.class.php
 *	\ingroup	PatasTools
 *	\brief	  File descriptor or module customtabs
 */

include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';

/**
 *	\class	modCustomtabs
 *  \brief	Classe de description et activation du module customTabs
 */
class modcustomtabs extends DolibarrModules
{
	/**
	*   Constructor. Define names, constants, directories, boxes, permissions
	*
	*   @param	  DoliDB		$db	  Database handler
	*/
	function __construct($db)
	{
		global $langs;  // $conf,  

		$langs->load('customtabs@customtabs');

		$this->db = $db;
		$this->numero = 160001;
		$this->family = "Patas-Tools";


		// Module label (no space allowed), used if translation string 'ModuleXXXName' not found
		$this->name = preg_replace('/^mod/i', '', get_class($this));
		$this->description = $langs->trans("customTabsPresentation");

		$this->editor_name = "<b>Patas-Monkey</b>";
		$this->editor_web = "http://www.patas-monkey.com";

		// Possible values for version are: 'development', 'experimental', 'dolibarr' or version
		$this->version = $this->getLocalVersion();

		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		$this->special = 0;
		$this->picto = $this->name.'@'.$this->name;

		// Data directories to create when module is enabled
		$this->dirs = array("/customtabs/temp");

		// Config pages
		$this->config_page_url = array("setup.php@".$this->name);

		// Dependencies
		$this->depends = array();
		$this->requiredby = array();
		$this->conflictwith = array();
		$this->langfiles = array("customtabs@customtabs", "companies");

		// Constantes
		$this->const = array(); 

		// hook pour la recherche
		$this->module_parts = array(
			'hooks' => array('odtgeneration'),			// used for list ODT substitutions
			'css' => '/customtabs/css/patastools.css',	// Set this to relative path of css if module has its own css file
			'substitutions' => 1						// used for card ODT substitutions
		);

		// Permissions
		$this->rights = array();
		$this->rights_class = $this->name;
		$r=0;

		// $this->rights[$r][0]	 Id permission (unique tous modules confondus)
		// $this->rights[$r][1]	 Libelle par defaut si traduction de cle "PermissionXXX" non trouvee (XXX = Id permission)
		// $this->rights[$r][2]	 Non utilise
		// $this->rights[$r][3]	 1=Permis par defaut, 0=Non permis par defaut
		// $this->rights[$r][4]	 Niveau 1 pour nommer permission dans code
		// $this->rights[$r][5]	 Niveau 2 pour nommer permission dans code

		$r++;
		$this->rights[$r][0] = 1600011;
		$this->rights[$r][1] = 'Read customtabs card';
		$this->rights[$r][2] = 'r';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'lire';

		$r++;
		$this->rights[$r][0] = 1600012;
		$this->rights[$r][1] = 'Create/modify customtabs (need also user module permissions if member linked to a user)';
		$this->rights[$r][2] = 'w';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'creer';

		$r++;
		$this->rights[$r][0] = 1600014;
		$this->rights[$r][1] = 'Remove customtabs';
		$this->rights[$r][2] = 'd';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'supprimer';

		$r++;
		$this->rights[$r][0] = 1600016;
		$this->rights[$r][1] = 'Export customtabs';
		$this->rights[$r][2] = 'r';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'export';

		$r++;
		$this->rights[$r][0] = 1600017;
		$this->rights[$r][1] = 'Import customtabs';
		$this->rights[$r][2] = 'r';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'import';

		$r++;
		$this->rights[$r][0] = 1600015;
		$this->rights[$r][1] = 'Setup types and attributes of custom-parc';
		$this->rights[$r][2] = 'w';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'configurer';

		// Left-Menu of customtabs module
		$r=0;
		if ($this->no_topmenu()) {
			$this->menu[$r]=array('fk_menu'=>'',
						'type'=>'top',
						'titre'=>'PatasTools',
						'mainmenu'=>'patastools',
						'leftmenu'=>'customlink',
						'url'=>'/customtabs/core/patastools.php?mainmenu=patastools&leftmenu=customtabs',
						'langs'=>'customtabs@customtabs',
						'position'=>100, 'enabled'=>'1',
						'perms'=>'$user->rights->customtabs->lire',
						'target'=>'', 'user'=>0);
			$r++; //1
		}

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=patastools',
					'type'=>'left',
					'titre'=>'CustomTabs',
					'mainmenu'=>'patastools',
					'leftmenu'=>'customtabs',
					'url'=>'/customtabs/list.php',
					'langs'=>'customtabs@customtabs',
					'position'=>130, 'enabled'=>'1',
					'perms'=>'$user->rights->customtabs->lire',
					'target'=>'', 'user'=>2);
		$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=patastools,fk_leftmenu=customtabs',
					'type'=>'left',
					'titre'=>'NewTabs',
					'mainmenu'=>'', 'leftmenu'=>'',
					'url'=>'/customtabs/card.php?action=create',
					'langs'=>'customtabs@customtabs',
					'position'=>131, 'enabled'=>'1',
					'perms'=>'$user->rights->customtabs->lire',
					'target'=>'', 'user'=>2);	
		$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=patastools,fk_leftmenu=customtabs',
					'type'=>'left',
					'titre'=>'UserGroupTabsRight',
					'mainmenu'=>'', 'leftmenu'=>'',
					'url'=>'/customtabs/grouptabsright.php',
					'langs'=>'customtabs@customtabs',
					'position'=>132, 'enabled'=>'1',
					'perms'=>'$user->rights->customtabs->configurer',
					'target'=>'', 'user'=>2);
		$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=patastools,fk_leftmenu=customtabs',
					'type'=>'left',
					'titre'=>'Dictionarys',
					'mainmenu'=>'', 'leftmenu'=>'',
					'url'=>'/customtabs/dictionary.php',
					'langs'=>'customtabs@customtabs',
					'position'=>133, 'enabled'=>'1',
					'perms'=>'$user->rights->customtabs->lire',
					'target'=>'', 'user'=>2);
		$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=patastools,fk_leftmenu=customtabs',
					'type'=>'left',
					'titre'=>'ImportCustomTabs',
					'mainmenu'=>'', 'leftmenu'=>'',
					'url'=>'/customtabs/card.php?action=import',
					'langs'=>'customtabs@customtabs',
					'position'=>134, 'enabled'=>'1',
					'perms'=>'$user->rights->customtabs->export',
					'target'=>'', 'user'=>2);

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=patastools,fk_leftmenu=customtabs',
					'type'=>'left',
					'titre'=>'TransfertCustomTabs',
					'mainmenu'=>'', 'leftmenu'=>'',
					'url'=>'/customtabs/transfert.php',
					'langs'=>'customtabs@customtabs',
					'position'=>134, 'enabled'=>'1',
					'perms'=>'$user->rights->customtabs->configurer',
					'target'=>'', 'user'=>2);

		// dictionnarys
		$this->dictionnaries = array();
	}

	/**
	 *		Function called when module is enabled.
	 *		The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
	 *		It also creates data directories
	 *
	 *	  @param	  string	$options	Options when enabling module ('', 'noboxes')
	 *	  @return	 int			 	1 if OK, 0 if KO
	 */
	function init($options='')
	{
		$sql = array();
		$this->load_tables();
		return $this->_init($sql, $options);
	}

	/**
	 *		Function called when module is disabled.
	 *	  Remove from database constants, boxes and permissions from Dolibarr database.
	 *		Data directories are not deleted
	 *
	 *	  @param	  string	$options	Options when enabling module ('', 'noboxes')
	 *	  @return	 int			 	1 if OK, 0 if KO
	 */
	function remove($options='')
	{
		$sql = array();
		return $this->_remove($sql, $options);
	}

	/**
	 *		Create tables, keys and data required by module
	 * 		Files llx_table1.sql, llx_table1.key.sql llx_data.sql with create table, create keys
	 * 		and create data commands must be stored in directory /mymodule/sql/
	 *		This function is called by this->init.
	 *
	 * 		@return		int		<=0 if KO, >0 if OK
	 */
	function load_tables()
	{
		return $this->_load_tables('/customtabs/sql/');
	}
	
	/*  Is the top menu already exist */
	function no_topmenu()
	{
		global $conf;
		// gestion de la position du menu
		$sql="SELECT rowid FROM ".MAIN_DB_PREFIX."menu";
		$sql.=" WHERE mainmenu ='patastools'";
		//$sql.=" AND module ='patastools'";
		$sql.=" AND type = 'top'";
		$sql.=" AND entity = ".(int) $conf->entity;

		$resql = $this->db->query($sql);
		if ($resql) {
			// il y a un top menu on renvoie 0 : pas besoin d'en créer un nouveau
			if ($this->db->num_rows($resql) > 0)
				return 0;
		}
		// pas de top menu on renvoie 1
		return 1;
	}

	function getChangeLog()
	{
		// Libraries
		dol_include_once("/".$this->name."/core/lib/patasmonkey.lib.php");
		return getChangeLog($this->name);
	}

	function getVersion($translated = 1)
	{
		global $langs, $conf;
		$currentversion = $this->version;

		if ($conf->global->PATASMONKEY_SKIP_CHECKVERSION == 1)
			return $currentversion;

		if ($this->disabled) {
			$newversion= $langs->trans("DolibarrMinVersionRequiered")." : ".$this->dolibarrminversion;
			$currentversion="<font color=red><b>".img_error($newversion).$currentversion."</b></font>";
			return $currentversion;
		}

		$context  = stream_context_create(array('http' => array('header' => 'Accept: application/xml')));
		$changelog = @file_get_contents(
						str_replace("www", "dlbdemo", $this->editor_web).'/htdocs/custom/'.$this->name.'/changelog.xml', 
						false, $context
		);
		//$htmlversion = @file_get_contents($this->editor_web.$this->editor_version_folder.$this->name.'/');

		if ($htmlversion === false)	// not connected
			return $currentversion;
		else {
			$sxelast = simplexml_load_string(nl2br($changelog));
			if ($sxelast === false)
				return $currentversion;
			else
				$tblversionslast=$sxelast->Version;

			$lastversion = $tblversionslast[count($tblversionslast)-1]->attributes()->Number;

			if ($lastversion != (string) $this->version) {
				if ($lastversion > $this->version) {
					$newversion= $langs->trans("NewVersionAviable")." : ".$lastversion;
					$currentversion="<font title='".$newversion."' color=orange><b>".$currentversion."</b></font>";
				} else
					$currentversion="<font title='Version Pilote' color=red><b>".$currentversion."</b></font>";
			}
		}
		return $currentversion;
	}

	function getLocalVersion()
	{
		global $langs;
		$context  = stream_context_create(array('http' => array('header' => 'Accept: application/xml')));
		$changelog = @file_get_contents(dol_buildpath($this->name, 0).'/changelog.xml', false, $context);
		$sxelast = simplexml_load_string(nl2br($changelog));
		if ($sxelast === false) 
			return $langs->trans("ChangelogXMLError");
		else {
			$tblversionslast=$sxelast->Version;
			$currentversion = $tblversionslast[count($tblversionslast)-1]->attributes()->Number;
			$tblDolibarr=$sxelast->Dolibarr;
			$minversionDolibarr=$tblDolibarr->attributes()->minVersion;
			if ((int) DOL_VERSION < (int) $MinversionDolibarr) {
				$this->dolibarrminversion=$minversionDolibarr;
				$this->disabled = true;
			}
		}
		return $currentversion;
	}
}