<?php
/*  Copyright (C) 2019 Customizeforms Paulo Ricardo Carvalho de Oliveira	<paulorcdo@gmail.com>
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * \file admin/about.php
 * \ingroup customizeforms
 * \brief Module about page
 */

// Load Dolibarr environment
if (false === (@include '../../main.inc.php')) {  // From htdocs directory
    require '../../../main.inc.php'; // From "custom" directory
}

require_once '../core/modules/modCustomizeForms.class.php';
require_once '../lib/admin.lib.php';

global $db, $langs, $user;

$langs->load("customizeforms@customizeforms");
$langs->load("admin");
$langs->load("help");

// only readable by admin
if (! $user->admin) {
    accessforbidden();
}

$module = new modCustomizeForms($db);

/*
 * View
 */

// Little folder on the html page
llxHeader();
/// Navigation in the modules
$linkback = '<a href="' . DOL_URL_ROOT . '/admin/modules.php">';
$linkback .= $langs->trans("BackToModuleList") . '</a>';
// Folder icon title
print_fiche_titre("Customize Forms", $linkback, 'setup');

$head = PrepareHead();

dol_fiche_head(
    $head,
    'about',
    $langs->trans("Customize Forms"),
    0,
    'customizeforms@customizeforms'
);

echo '<img width=200 src="http://www.trucolivre.com.br/dolibarr/logotipo500.jpg" ><h3>', $langs->trans("Module468213Name"), '</h3>',
     '<em>', $langs->trans("Version"), ' ',
 $langs->trans($module->version), '</em><br>',
     '<em>&copy;2019 Paulo OLiveira<br><em>',
 '<a href="mailto:paulorcdo@gmail.com">paulorcdo@gmail.com</a>',

     '<h3>', $langs->trans("License"), '</h3>',
     '
<h3>Customize Forms</h3>
<h6>External Module for Dolibarr.</h6>

<p>Functions
<p>Create new features in 24 dolibarr forms ( + 430 standard fields and + all extra fields)

<p>1- Hide fields;

<p>2- Make fields as mandatory (Javascript);

<p>3- Disable fields;

<p>4- Create Custom Header and Footer;

<p>5- Define default values for fields (texts, lists, html, selection and categories);

<p>6- Create tooltip with instructions on the fields;

<p>7- Create auxiliary lists of preformatted texts and phrases to easily insert into the fields (text, html);

<p>8- Change the presented names of the fields without changing the translations;

<p>Prerequisites
<p>Partial Features - Dolibarr ≥ 5.0.3

<p>All Features - Dolibarr ≥ 9.0.3

<p>License
<p>Copyright (C) 2019 Paulo Oliveira - paulorcdo@gmail.com

<p>GPLv3 any later version.
 
';

dol_fiche_end();
llxFooter();
