<?php
require_once DOL_DOCUMENT_ROOT . "/core/class/commonobject.class.php";
require_once DOL_DOCUMENT_ROOT . "/core/class/extrafields.class.php";
class CommonObjectConsoGazoil extends CommonObject {
	/**
	 * Load properties id_previous and id_next
	 *
	 * @param string $filter Optional filter
	 * @param int $fieldid Name of field to use for the select MAX and MIN
	 * @return int <0 if KO, >0 if OK
	 */
	function load_previous_next_ref($filter, $fieldid, $nodbprefix = 0) {
		global $conf, $user;
		
		if (! $this->table_element) {
			dol_print_error('', get_class($this) . "::load_previous_next_ref was called on objet with property table_element not defined", LOG_ERR);
			return - 1;
		}
		
		// this->ismultientitymanaged contains
		// 0=No test on entity, 1=Test with field entity, 2=Test with link by societe
		$alias = 's';
		if ($this->element == 'societe')
			$alias = 'te';
		
		$sql = "SELECT MAX(te." . $fieldid . ")";
		$sql .= " FROM " . MAIN_DB_PREFIX . $this->table_element . " as te";
		if (isset($this->ismultientitymanaged) && $this->ismultientitymanaged == 2 || ($this->element != 'societe' && empty($this->isnolinkedbythird) && empty($user->rights->societe->client->voir)))
			$sql .= ", " . MAIN_DB_PREFIX . "societe as s"; // If we need to link to societe to limit select to entity
		if (empty($this->isnolinkedbythird) && ! $user->rights->societe->client->voir)
			$sql .= " LEFT JOIN " . MAIN_DB_PREFIX . "societe_commerciaux as sc ON " . $alias . ".rowid = sc.fk_soc";
		$sql .= " WHERE te." . $fieldid . " < '" . $this->db->escape($this->id) . "'";
		if (empty($this->isnolinkedbythird) && ! $user->rights->societe->client->voir)
			$sql .= " AND sc.fk_user = " . $user->id;
		if (! empty($filter))
			$sql .= " AND " . $filter;
		if (isset($this->ismultientitymanaged) && $this->ismultientitymanaged == 2 || ($this->element != 'societe' && empty($this->isnolinkedbythird) && ! $user->rights->societe->client->voir))
			$sql .= ' AND te.fk_soc = s.rowid'; // If we need to link to societe to limit select to entity
		if (isset($this->ismultientitymanaged) && $this->ismultientitymanaged == 1)
			$sql .= ' AND te.entity IN (' . getEntity($this->element, 1) . ')';
			
			// print $sql."<br>";
		$result = $this->db->query($sql);
		if (! $result) {
			$this->error = $this->db->error();
			return - 1;
		}
		$row = $this->db->fetch_row($result);
		$this->ref_previous = $row[0];
		
		$sql = "SELECT MIN(te." . $fieldid . ")";
		$sql .= " FROM " . MAIN_DB_PREFIX . $this->table_element . " as te";
		if (isset($this->ismultientitymanaged) && $this->ismultientitymanaged == 2 || ($this->element != 'societe' && empty($this->isnolinkedbythird) && ! $user->rights->societe->client->voir))
			$sql .= ", " . MAIN_DB_PREFIX . "societe as s"; // If we need to link to societe to limit select to entity
		if (empty($this->isnolinkedbythird) && ! $user->rights->societe->client->voir)
			$sql .= " LEFT JOIN " . MAIN_DB_PREFIX . "societe_commerciaux as sc ON " . $alias . ".rowid = sc.fk_soc";
		$sql .= " WHERE te." . $fieldid . " > '" . $this->db->escape($this->id) . "'";
		if (empty($this->isnolinkedbythird) && ! $user->rights->societe->client->voir)
			$sql .= " AND sc.fk_user = " . $user->id;
		if (! empty($filter))
			$sql .= " AND " . $filter;
		if (isset($this->ismultientitymanaged) && $this->ismultientitymanaged == 2 || ($this->element != 'societe' && empty($this->isnolinkedbythird) && ! $user->rights->societe->client->voir))
			$sql .= ' AND te.fk_soc = s.rowid'; // If we need to link to societe to limit select to entity
		if (isset($this->ismultientitymanaged) && $this->ismultientitymanaged == 1)
			$sql .= ' AND te.entity IN (' . getEntity($this->element, 1) . ')';
			// Rem: Bug in some mysql version: SELECT MIN(rowid) FROM llx_socpeople WHERE rowid > 1 when one row in database with rowid=1, returns 1 instead of null
			
		// print $sql."<br>";
		$result = $this->db->query($sql);
		if (! $result) {
			$this->error = $this->db->error();
			return - 2;
		}
		$row = $this->db->fetch_row($result);
		$this->ref_next = $row[0];
		
		return 1;
	}
	
	/**
	 * Give information on the object
	 *
	 * @param int $id Id object
	 * @return int <0 if KO, >0 if OK
	 */
	function info($id) {
		global $langs;
		
		$sql = "SELECT";
		$sql .= " p.rowid, p.datec, p.tms, p.fk_user_modif, p.fk_user_creat";
		$sql .= " FROM " . MAIN_DB_PREFIX . $this->table_element . " as p";
		$sql .= " WHERE p.rowid = " . $id;
		
		dol_syslog(get_class($this) . "::info sql=" . $sql, LOG_DEBUG);
		$resql = $this->db->query($sql);
		if ($resql) {
			if ($this->db->num_rows($resql)) {
				$obj = $this->db->fetch_object($resql);
				$this->id = $obj->rowid;
				$this->date_creation = $this->db->jdate($obj->datec);
				$this->date_modification = $this->db->jdate($obj->tms);
				$this->user_modification = $obj->fk_user_modif;
				$this->user_creation = $obj->fk_user_creat;
			}
			$this->db->free($resql);
			return 1;
		} else {
			$this->error = "Error " . $this->db->lasterror();
			dol_syslog(get_class($this) . "::info " . $this->error, LOG_ERR);
			return - 1;
		}
	}
}