<?php 

require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/geturl.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 

dol_include_once('/checkifsentemail/class/checkifsentemail.class.php');
dol_include_once('/checkifsentemail/core/modules/modcheckifsentemail.class.php');

class checkifsentemail extends Commonobject{ 

	public $errors = array();
	public $rowid;
	public $number;

	public $element='checkifsentemail';
	public $table_element='checkifsentemail';
	
	public function __construct($db){ 
		$this->db = $db;
		return 1;
    }

	public function checkifmailsent($invoice,$facture,$facture_extrafields,$AC_BILL_SENTBYMAIL,$checkifsentemailcode)
	{
		global $langs, $user, $confirm, $conf;

		require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
		require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
		require_once DOL_DOCUMENT_ROOT.'/fourn/class/fournisseur.facture.class.php';
		require_once DOL_DOCUMENT_ROOT.'/comm/propal/class/propal.class.php';

		$extrafields 	= new ExtraFields($this->db);
		$factureClient 		= new Facture($this->db);
		$factureFournisseur = new FactureFournisseur($this->db);
		$propal = new Propal($this->db);
		
		$cf = ""; 
		$objecttouse = $factureClient;
		if($facture == "facture_fourn")
			$objecttouse = $factureFournisseur;
		elseif($facture == "propal")
			$objecttouse = $propal;

		$action = GETPOST('action');
		$models = GETPOST('models');
		$receiver = GETPOST('receiver');
		$sendto = GETPOST('sendto');
		$ids = GETPOST('id');


		$error = 0;
		if(($models == "facture_send" || $models == "invoice_supplier_send" || $models == "propal_send" || $models == "proposal_send") && !empty($ids) && ( ($receiver && count($receiver) > 0) || !empty($sendto) )){
			$arrids = explode(",", $ids);
			foreach ($arrids as $id) {
				$ret = $objecttouse->fetch($id);

				if($objecttouse->statut > 0){
		        	$objecttouse->array_options[$checkifsentemailcode] = 1;
		        	$extralabels = [$checkifsentemailcode => "Email envoyé?"];

					$ret = $extrafields->setOptionalsFromPost($extralabels, $objecttouse);
					if ($ret < 0) $error++;

					if (! $error)
					{
						$result = $objecttouse->insertExtraFields();// Actions on extra fields
					}
				}
			}

		}else{

			// die("ee");
			$sql2 = 'SELECT * FROM '.MAIN_DB_PREFIX.'actioncomm WHERE elementtype = "'.$invoice.'" AND code LIKE "'.$AC_BILL_SENTBYMAIL.'"';
			$sql2 .= ' AND fk_element NOT IN (SELECT fk_object from '.MAIN_DB_PREFIX.$facture_extrafields.' WHERE '.$checkifsentemailcode.' = 1)';
			// $sql2 .= ' AND fk_user_action = "'.$user->id.'" AND fk_element NOT IN (SELECT fk_object from '.MAIN_DB_PREFIX.$facture_extrafields.' WHERE '.$checkifsentemailcode.' = 1)';
			$sql2 .= ' AND fk_element IN (SELECT rowid from '.MAIN_DB_PREFIX.$facture.')';
	 		$resql = $this->db->query($sql2);
	 		// echo $sql2."<br>";
	 		$facturessent = array();
	 		if($resql){
	 			$error = 0;
				$num = $this->db->num_rows($resql);
		        while ($obj = $this->db->fetch_object($resql)) {
			        if(!isset($facturessent[$obj->fk_element])){

			        	$ret = $objecttouse->fetch($obj->fk_element);
			        	$objecttouse->array_options[$checkifsentemailcode] = 1;
			        	$extralabels = [$checkifsentemailcode => "Email envoyé?"];

						$ret = $extrafields->setOptionalsFromPost($extralabels, $objecttouse);
						if ($ret < 0) $error++;

						if (! $error)
						{
							$result = $objecttouse->insertExtraFields();// Actions on extra fields
						}
					}
		            $facturessent[$obj->fk_element] = $obj->fk_element;
		        }
			}
			else {
				$this->db->rollback();
				$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
				print_r($this->errors);
				die();
				return 0;
			}
		}

		return 1;
	}

} 


class checkifsentemailcls extends Commonobject{ 
    
    public function __construct($db){ 
        $this->db = $db;
        return 1;
    }

    public function fetch()
    {
        global $conf, $mysoc, $user, $langs;
        $langs->load('checkifsentemail@checkifsentemail');

        $modulrecrut = new modcheckifsentemail($this->db);

        $nummodul = $modulrecrut->numero;
        $editeurmodul = 'https://www.nextgestion.com';

        if (!dolibarr_get_const($this->db,'EDITOR_MODULE_CHECKIFSENTEMAIL',0))
            dolibarr_set_const($this->db,'EDITOR_MODULE_CHECKIFSENTEMAIL',$editeurmodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'ID_MODULE_CHECKIFSENTEMAIL',0))
            dolibarr_set_const($this->db,'ID_MODULE_CHECKIFSENTEMAIL',$nummodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'DATE_MODULE_CHECKIFSENTEMAIL',0))
            dolibarr_set_const($this->db,'DATE_MODULE_CHECKIFSENTEMAIL',date('Y-m-d'),'chaine',0,'',0);


        $id_modul      = dolibarr_get_const($this->db,'ID_MODULE_CHECKIFSENTEMAIL',0);
        $date_modul    = dolibarr_get_const($this->db,'DATE_MODULE_CHECKIFSENTEMAIL',0);
        $editor_modul  = dolibarr_get_const($this->db,'EDITOR_MODULE_CHECKIFSENTEMAIL',0);

        $link = urlencode(dol_buildpath('/',2));

        if(!empty($date_modul) && $date_modul <= date('Y-m-d') && !empty($editor_modul) && !empty($id_modul) && !empty($link)){


        	$id_modul = urlencode($id_modul);


            $url = $editor_modul."/suivimod/module/registeruse?mod=".$id_modul."&link=".$link;
            $urldata = getURLContent($url);
            $response = json_decode($urldata['content']);

            if($response && $response->actif == 0){
                dolibarr_set_const($this->db,'ID_MODULE_CHECKIFSENTEMAIL', 1, 'chaine',0,'',0);
                unActivateModule("modcheckifsentemail");
            }
            $newdate_modul = date("Y-m-d", strtotime("+ 1 day"));
            dolibarr_set_const($this->db,'DATE_MODULE_CHECKIFSENTEMAIL', $newdate_modul, 'chaine',0,'',0);
        }
        return 1;
    } 
}


?>