<?php 
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 

// dol_include_once('/chartsdolibarr/class/chartsdolibarr.class.php');

require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';


class charts_tiers extends Commonobject{ 

	public $errors = array();
	public $rowid;
	public $number;

	public $element='societe';
	public $table_element='societe';
	
	public function __construct($db){ 
		$this->db = $db;
		return 1;
    }

    
















    // Statistiques
	public function tiers_statistiques()
	{
		$resultat = array();
		
		$sql = "SELECT * FROM ".MAIN_DB_PREFIX."societe";
        $resql = $this->db->query($sql);
        $resultat['client'] = $resultat['prospect'] = $resultat['fournisseur'] = $resultat['autres'] = 0;
        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
            	if($obj->client == 1 || $obj->client == 3)
                	$resultat['client'] += 1;
            	if($obj->client == 2 || $obj->client == 3)
                	$resultat['prospect'] += 1;
            	if(($obj->client == 0 && $obj->fournisseur == 1) || $obj->fournisseur == 1 )
                	$resultat['fournisseur'] += 1;
            	if(($obj->client == 0 && $obj->fournisseur == 0))
                	$resultat['autres'] += 1;
            }
        }
        return $resultat;
    }

    // Nombre de tiers / Année (3 ans)
	public function tiers_LastThreeYear()
	{
		$resultat = array();
		
		$thisyear = date('Y');
		$lasthtree = date('Y') - 2;

		$sql = "SELECT * FROM ".MAIN_DB_PREFIX."societe";
		$sql .= " WHERE YEAR(datec) >= ".$lasthtree;
		$sql .= " ORDER BY datec ASC ";
        $resql = $this->db->query($sql);

        // echo "sql : ".$sql;
        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
            	$date = explode("-", $obj->datec);
            	$year = $date[0];
            	if($obj->client == 1 || $obj->client == 3)
                	$resultat[$year]['client'] += 1;
            	if($obj->client == 2 || $obj->client == 3)
                	$resultat[$year]['prospect'] += 1;
            	if(($obj->client == 0 && $obj->fournisseur == 1) || $obj->fournisseur == 1 )
                	$resultat[$year]['fournisseur'] += 1;
                if(($obj->client == 0 && $obj->fournisseur == 0))
                	$resultat[$year]['autres'] += 1;
            }
        }
        return $resultat;
    }

    // Les 5 Meilleurs contacts
    public function tiers_bestfive($filter="AND client = 1 OR client = 3")
	{
		$resultat = array();
		
		$sql .= "SELECT COUNT(contact.fk_socpeople) as countsocp, contact.fk_socpeople, peopl.fk_soc, soc.client";
		$sql .= " FROM ".MAIN_DB_PREFIX."element_contact contact";
		$sql .= " JOIN ".MAIN_DB_PREFIX."socpeople peopl ON contact.fk_socpeople = peopl.rowid";
		$sql .= " JOIN ".MAIN_DB_PREFIX."societe soc ON soc.rowid = peopl.fk_soc";
		$sql .= " WHERE 1> 0";
		if(!empty($filter))
			$sql .= " ".$filter;
		$sql .= " GROUP BY contact.fk_socpeople ORDER BY countsocp DESC";
		// echo $filter;
		// die();
        $resql = $this->db->query($sql);
        $som = 0;
        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
            	if(!isset($resultat[$obj->fk_soc]['count']) || (isset($resultat[$obj->fk_soc]['count']) && $obj->countsocp > $resultat[$obj->fk_soc]['count'])){
            			$resultat[$obj->fk_soc]['count'] = $obj->countsocp;
            			$resultat[$obj->fk_soc]['people'] = $obj->fk_socpeople;
            			$som++;
            	}
            	if($som == 5)
            		break;
            }
        }
        // print_r($resultat);
        return $resultat;
    }

    // Tags Client / Prospect
	public function tiers_TagsClientUsed()
	{
		$resultat = array();
		
		$sql = "SELECT COUNT(catgsoc.fk_categorie) as countcatg, catgsoc.fk_categorie, catg.label";
		$sql .= " FROM ".MAIN_DB_PREFIX."categorie catg";
		$sql .= " JOIN ".MAIN_DB_PREFIX."categorie_societe catgsoc ON catg.rowid = catgsoc.fk_categorie";
		$sql .= " WHERE 1> 0";
		$sql .= " GROUP BY catgsoc.fk_categorie ORDER BY countcatg DESC";
		// echo $sql;
        $resql = $this->db->query($sql);
        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
            	$resultat[$obj->fk_categorie]['count'] = $obj->countcatg;
            	$resultat[$obj->fk_categorie]['label'] = $obj->label;
            }
        }
        // print_r($resultat);
        return $resultat;
    }

    // Tags Fournisseur
	public function tiers_TagsFournisseurUsed()
	{
		$resultat = array();
		
		$sql = "SELECT COUNT(catgsoc.fk_categorie) as countcatg, catgsoc.fk_categorie, catg.label";
		$sql .= " FROM ".MAIN_DB_PREFIX."categorie catg";
		$sql .= " JOIN ".MAIN_DB_PREFIX."categorie_fournisseur catgsoc ON catg.rowid = catgsoc.fk_categorie";
		$sql .= " WHERE 1> 0";
		$sql .= " GROUP BY catgsoc.fk_categorie ORDER BY countcatg DESC";
		// echo $sql;
        $resql = $this->db->query($sql);
        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
            	$resultat[$obj->fk_categorie]['count'] = $obj->countcatg;
            	$resultat[$obj->fk_categorie]['label'] = $obj->label;
            }
        }
        // print_r($resultat);
        return $resultat;
    }

















	public function create($echo_sql=0,$insert)
	{
		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .get_class($this)." ( ";
		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			$sql_column .= " , `".$column."`";
			$sql_value .= " , ".$alias.$value.$alias;
		}

		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			return 0;
		} 
		return $this->db->db->insert_id;
	}

	public function update($id, array $data,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;
        $sql = 'UPDATE ' . MAIN_DB_PREFIX .get_class($this). ' SET ';
        // print_r($data);die();
        if (count($data) && is_array($data))
            foreach ($data as $key => $val) {
                $val = is_numeric($val) ? $val : "'". $val ."'";
                $sql .= "`". $key. "` = ". $val .",";
            }

        $sql  = substr($sql, 0, -1);
        $sql .= ' WHERE rowid = ' . $id;
        // echo $sql."<br>";

        // print_r($id);
        // die($sql);

        $resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			return -1;
		} 

		return 1;
	}

    
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX .get_class($this);

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		// die($sql);
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    = $obj->rowid;
				$line->rowid 	= $obj->rowid;
				$line->number 	=  $obj->number;
				$line->issuedate 	=  $obj->issuedate;
				$line->expirydate 	=  $obj->expirydate;
				$line->date_notification 	=  $obj->date_notification;
				$line->fk_type_document 	=  $obj->fk_type_document;
				$line->fk_user 	=  $obj->fk_user;
				$line->file 	=  $obj->file;
				$line->description 	=  $obj->description;
                // ....

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	public function fetch($id, $name = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .get_class($this). ' WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			= $this->db->fetch_object($resql);
                $this->id    = $obj->rowid;
				$this->rowid 	= $obj->rowid;
				$this->number 	=  $obj->number;
				$this->issuedate 	=  $obj->issuedate;
				$this->expirydate 	=  $obj->expirydate;
				$this->date_notification 	=  $obj->date_notification;
				$this->fk_type_document 	=  $obj->fk_type_document;
				$this->fk_user 	=  $obj->fk_user;
				$this->file 	=  $obj->file;
				$this->description 	=  $obj->description;
                // ....
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id='',$attr=''){

	    global $conf;

	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'">';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}




	public function select_documents_type($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    
	    $objet = "label";
	    $moreforfilter.='<select class="flat" id="'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT * FROM ".MAIN_DB_PREFIX."type_document";
    	// $sql2= "SELECT * FROM ".MAIN_DB_PREFIX."user";
    	$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			
			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

	public function select_user($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    
	    $objet = "label";
	    $moreforfilter.='<select class="flat" id="'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql= "SELECT * FROM ".MAIN_DB_PREFIX."user";
    	$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			
			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->lastname.' '.$obj->firstname.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}










    public function getcountrows(){
        $tot = 0;
        $sql = "SELECT COUNT(rowid) as tot FROM ".MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);

        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
                $tot = $obj->tot;
            }
        }
        return $tot;
    }

    public function getdateformat($date,$time=true){
        $d = explode(' ', $date);
        $date = explode('-', $d[0]);
        $d2 = explode(':', $d[1]);
        $result = $date[2]."/".$date[1]."/".$date[0];
        if ($time) {
            $result .= " ".$d2[0].":".$d2[1];
        }
        return $result;
    }

    public function getYears($debut="debut"){
        $sql = 'SELECT YEAR('.$debut.') as years FROM ' . MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }

    public function getmonth($year){
        $sql = 'SELECT MONTH(debut) as years FROM ' . MAIN_DB_PREFIX.get_class($this).' WHERE YEAR(debut) = '.$year;
        $resql  = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }

    public function get_type_document($id){
    	$type='';
    	$sql ='SELECT name AS type FROM ' . MAIN_DB_PREFIX.'type_document WHERE rowid = '.$id;
    	$exsql=$this->db->query($sql);
    	if($exsql){
    		$type = $this->db->fetch_object($exsql)->type;
    	}
    	return '<a href="'.dol_buildpath('/type_document/card.php?id='.$id,2).'">'.$type.'</a>';
    }

    public function get_employe($id){
    	$name='';
    	$sql ='SELECT login AS name FROM ' . MAIN_DB_PREFIX.'user WHERE rowid = '.$id;
    	$exsql=$this->db->query($sql);
    	if($exsql){
    		$name = $this->db->fetch_object($exsql)->name;
    	}
    	return '<a href="'.dol_buildpath('/user/card.php?id='.$id,2).'">'.$name.'</a>';
    }

    public function logo_user($id){
    	$logo="";
    	$sql ='SELECT logo  FROM ' . MAIN_DB_PREFIX.'user WHERE rowid = '.$id;
    	$exsql=$this->db->query($sql);
    	if($exsql){
    		$logo = $this->db->fetch_object($exsql);
    	}
    	return $logo;
    }



    
} 
?>