<?php
/*  Copyright (C) 2019 categorizeall Paulo Ricardo Carvalho de Oliveira	<paulorcdo@gmail.com>
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * \file core/modules/modcategorizeall.class.php
 * \brief categorizeall module
 *
 * \ingroup categorizeall
*/


include_once DOL_DOCUMENT_ROOT . "/core/modules/DolibarrModules.class.php";

/**
 * Describes and activates Zenfusion Maps module
 */
class modcategorizeall extends DolibarrModules
{

    /**
     * Constructor. Define names, constants, directories, boxes, permissions
     *
     * @param DoliDB $db Database handler
     */
    public function __construct($db)
    {
        global $user,$langs;
        
        $this->db = $db;
        $this->numero = 468224;
        $this->rights_class = 'categorizeall';
        $this->family = "other";
        $this->name = preg_replace('/^mod/i', '', get_class($this));
        $this->description = "CategorizeAll";
        $this->version = '1.0.0';
         $this->editor_name = 'Paulo Oliveira - paulorcdo@gmail.com';
        $this->const_name = 'MAIN_MODULE_' . strtoupper($this->name);
        $this->special = 1; // Interface
        $this->picto = 'categorizeall@categorizeall';
        $this->module_parts = array(
            'hooks' => array(
                 
                
                
            ),
              
        );
        
        $this->dirs = array();
        $this->config_page_url = array("about.php@categorizeall");
        $this->hidden = false;
        $this->depends = array();
        $this->requiredby = array();
        $this->conflictwith = array();
        $this->phpmin = array(5, 3);
        $this->need_dolibarr_version = array(3, 5);
        $this->langfiles = array("categorizeall@categorizeall");
        $this->const = array();
        $this->tabs = array();
        $this->dictionaries = array();
        $this->boxes = array();
            $this->rights = array();        // Permission array used by this module

        $r=0;
        $this->rights[$r][0] = $this->numero + $r;    // Permission id (must not be already used)
        $this->rights[$r][1] = $langs->trans("ReadPerm").' '.$langs->trans("Fields").' CategorizeAll';    // Permission label // Permission label
        $this->rights[$r][3] = 0;                     // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'read';                // In php code, permission will be checked by test if ($user->rights->gps->level1->level2)
        $this->rights[$r][5] = '';                    // In php code, permission will be checked by test if ($user->rights->gps->level1->level2)

        $r++;
        $this->rights[$r][0] = $this->numero + $r;    // Permission id (must not be already used)
        $this->rights[$r][1] = $langs->trans("Edit").' '.$langs->trans("Fields").' CategorizeAll';    // Permission label
        $this->rights[$r][3] = 0;                     // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'write';                // In php code, permission will be checked by test if ($user->rights->gps->level1->level2)
        $this->rights[$r][5] = '';                    // In php code, permission will be checked by test if ($user->rights->gps->level1->level2)
 
 $r++;
        $this->rights[$r][0] = $this->numero + $r;    // Permission id (must not be already used)
        $this->rights[$r][1] = $langs->trans("Delete").' '.$langs->trans("Fields").' CategorizeAll';    // Permission label
        $this->rights[$r][3] = 0;                     // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'delete';                // In php code, permission will be checked by test if ($user->rights->gps->level1->level2)
        $this->rights[$r][5] = '';                    // In php code, permission will be checked by test if ($user->rights->gps->level1->level2)
 
        // Main menu entries
        $this->menu = array();            // List of menus to add
        $r=0;

        // Add here entries to declare new menus

        /* BEGIN MODULEBUILDER TOPMENU */
        //$this->menu[$r++]=array('fk_menu'=>'',			                // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
        // 'type'=>'top',			                // This is a Top menu entry
        // 'titre'=>'Gps',
        // 'mainmenu'=>'gps',
        // 'leftmenu'=>'',
        // 'url'=>'/gps/gpsindex.php',
        // 'langs'=>'gps@gps',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
        // 'position'=>1000+$r,
        // 'enabled'=>'$conf->gps->enabled',	// Define condition to show or hide menu entry. Use '$conf->gps->enabled' if entry must be visible if module is enabled.
        // 'perms'=>'1',			                // Use 'perms'=>'$user->rights->gps->level1->level2' if you want your menu with a permission rules
        // 'target'=>'',
        // 'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both

        /* END MODULEBUILDER TOPMENU */

        /* BEGIN MODULEBUILDER LEFTMENU GPSCOORD
        $this->menu[$r++]=array(	'fk_menu'=>'fk_mainmenu=gps',	    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
								'type'=>'left',			                // This is a Left menu entry
								'titre'=>'List GpsCoord',
								'mainmenu'=>'gps',
								'leftmenu'=>'gps_gpscoord_list',
								'url'=>'/gps/gpscoord_list.php',
								'langs'=>'gps@gps',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>1000+$r,
								'enabled'=>'$conf->gps->enabled',  // Define condition to show or hide menu entry. Use '$conf->gps->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
								'perms'=>'1',			                // Use 'perms'=>'$user->rights->gps->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
        $this->menu[$r++]=array(	'fk_menu'=>'fk_mainmenu=gps,fk_leftmenu=gps',	    // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
								'type'=>'left',			                // This is a Left menu entry
								'titre'=>'New GpsCoord',
								'mainmenu'=>'gps',
								'leftmenu'=>'gps_gpscoord_new',
								'url'=>'/gps/gpscoord_page.php?action=create',
								'langs'=>'gps@gps',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
								'position'=>1000+$r,
								'enabled'=>'$conf->gps->enabled',  // Define condition to show or hide menu entry. Use '$conf->gps->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
								'perms'=>'1',			                // Use 'perms'=>'$user->rights->gps->level1->level2' if you want your menu with a permission rules
								'target'=>'',
								'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
        */

        $this->menu[$r++]=array(
         'fk_menu'=>'fk_mainmenu=tools',        // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
         'type'=>'left',                            // This is a Left menu entry
         'titre'=>'CategorizeAll',
         'mainmenu'=>'tools',
         'leftmenu'=>'categorizeall',
         'url'=>'/categorizeall/list.php?action=create',
          'position'=>1100+$r,
         'enabled'=>'$conf->categorizeall->enabled',  // Define condition to show or hide menu entry. Use '$conf->gps->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
         'perms'=>'1',                            // Use 'perms'=>'$user->rights->gps->level1->level2' if you want your menu with a permission rules
         'target'=>'',
         'user'=>0);                                // 0=Menu for internal users, 1=external users, 2=both
        //$this->menu[$r++]=array(
        // 'fk_menu'=>'fk_mainmenu=tools,fk_leftmenu=gps_gpscoord',        // '' if this is a top menu. For left menu, use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
        // 'type'=>'left',                            // This is a Left menu entry
        // 'titre'=>'categorizeall',
        // 'mainmenu'=>'tools',
        // 'leftmenu'=>'gps_gpscoord',
        // 'url'=>'/categorizeall/gpscoord_card.php?action=create',
        //  'position'=>1100+$r,
        // 'enabled'=>'$conf->categorizeall->enabled',  // Define condition to show or hide menu entry. Use '$conf->gps->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
        // 'perms'=>'1',                            // Use 'perms'=>'$user->rights->gps->level1->level2' if you want your menu with a permission rules
        // 'target'=>'',
        // 'user'=>0);                                // 0=Menu for internal users, 1=external users, 2=both
        //               
        /* END MODULEBUILDER LEFTMENU GPSCOORD */


        // Exports 
        $r=1;
    }

    /**
     * Function called when module is enabled.
     * The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
     * It also creates data directories.
     *
     * @param string $options Options when enabling module ('', 'newboxdefonly', 'noboxes')
     *                        'noboxes' = Do not insert boxes
     *                        'newboxdefonly' = For boxes, insert def of boxes only and not boxes activation
     * @return int 1 if OK, 0 if KO
     */
    public function init($options = '')
    {
        
        $result=$this->_load_tables('/categorizeall/sql/');
        if ($result < 0) {
            return -1; // Do not activate module if not allowed errors found on module SQL queries (the _load_table run sql with run_sql with error allowed parameter to 'default')
        }
        $sql = array();
        return $this->_init($sql, $options);
    }

    /**
     * Function called when module is disabled.
     * Remove from database constants, boxes and permissions from Dolibarr database.
     * Data directories are not deleted.
     *
     * @param string $options Options when enabling module ('', 'noboxes')
     * @return int 1 if OK, 0 if KO
     */
    public function remove($options = '')
    {
        $sql = array();
        return $this->_remove($sql, $options);
    }
}
