<?php
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class invoice_location_expenses extends Commonobject{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

  	public $ht;
  	public $tva ;
  	public $invoice_id ;
  	public $location_expenses_id 	;
  	public $user_id ;
  	public $created_by ;
  	public $created_at ;
  	public $updated_at ;
  	public $rows = array();
  	public $table_element = 'invoice_location_expenses';

	public $now;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new DateTime("now");
		$this->now 		 = date('Y-m-d');//$this->now->format('Y-m-d');
		return 1;
	}


	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/tresorie/invoice_location_expenses/index.php?id='. $id,1) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
	  $this->ht = $this->ht ? $this->db->escape($this->ht): null;
	  //$this->tva = $this->tva ? $this->db->escape($this->tva): null;
	  $this->invoice_id = $this->invoice_id ? $this->db->escape($this->invoice_id): null;
	  $this->location_expenses_id = $this->location_expenses_id ? $this->db->escape($this->location_expenses_id): null;
	  $this->user_id = $this->user_id ? $this->db->escape($this->user_id): null;
	  $this->created_by = $this->created_by ? $this->db->escape($this->created_by): null;
	  $this->created_at = $this->now;
	// Insert request
	$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'invoice_location_expenses' . ' (ht,tva,';
	$sql .= 'invoice_id,location_expenses_id,user_id,created_by,created_at) ';
	$sql .= 'VALUES ( '.$this->ht.', '. $this->tva.', '.$this->invoice_id.',';
	$sql .=	$this->location_expenses_id.', '.$this->user_id.', '.$this->created_by.',';
	$sql .= '"'.$this->created_at.'")'; 
	//die($sql);
	$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error invoice_location_expenses ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			die();
			return -1;
		} else {
			$this->db->commit();
			return 1;
			//return $this->getLasInsrtedId();
		}
	}

/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'invoice_location_expenses';
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->id             = $obj->rowid;
			  $this->ht 			= $obj->ht ;
			  $this->tva 		= $obj->tva ;
			  $this->invoice_id = $obj->invoice_id ;
			  $this->location_expenses_id 	= $obj->location_expenses_id ;
			  $this->user_id 		= $obj->user_id ;
			  $this->created_by 	= $obj->created_by ;
			  $this->created_at 	= $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'invoice_location_expenses';

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
					$line->id 			 = $obj->rowid;
				  $line->ht 			= $obj->ht ;
				  $line->tva 		= $obj->tva ;
				  $line->invoice_id = $obj->invoice_id ;
				  $line->location_expenses_id 	= $obj->location_expenses_id ;
				  $line->user_id 		= $obj->user_id ;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
					$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}



	/**
	 * Updatec object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Updatec request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'invoice_location_expenses' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
			$now = new DateTime("now");
			$now 		 = $now->format('Y-m-d');
			$sql .= '`updated_at` = "'. $now.'"' ;

		//$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'invoice_location_expenses' .' WHERE rowid = ' . $this->id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	
/*
    public function check_mat($mat)
    {
    	$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'invoice_location_expenses WHERE mat ="'.$mat.'"';
    	$resql 		 = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			if($num > 0)
				return true;
			$this->db->free($resql);
    	}

    	return false;
    }*/

    public function getNames()
    {
    	$this->fetchAll();
    	$names = array();

    	if (count($this->rows))
    	foreach ($this->rows as $key => $line) {
			$names[$line->id] = $line->ht;    		
    	}

    	return $names;
    }

    public function getName($id)
    {
    	$sql = 'SELECT ht FROM ' . MAIN_DB_PREFIX . 'invoice_location_expenses WHERE rowid='.$id;
    	$resql = $this->db->query($sql);
    	$name = '';
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$name = $obj->ht;
			}
			$this->db->free($resql);
    	}

    	return $name;
    }

    public function getInvoices()
    {
    	$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'facture_fourn';
    	$resql = $this->db->query($sql);
    	//die($sql);
    	$invoices = array();
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$invoices[$obj->rowid] = $obj->ref; 
			}
			$this->db->free($resql);
    	}

    	return $invoices;
    }

    public function getInvoice_Ref($id)
    {
    	$sql = 'SELECT ref FROM ' . MAIN_DB_PREFIX . 'facture_fourn WHERE rowid='.$id;
    	$resql = $this->db->query($sql);
    	//die($sql);
    	$name = '';
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$name = $obj->ref;
			}
			$this->db->free($resql);
    	}

    	return $name;
    }

    public function load_state_board()
	{
		global $conf, $user;

		$this->nb=array();

		$sql = "SELECT count(e.rowid) as nb";
		$sql.= " FROM ".MAIN_DB_PREFIX. $this->table_element ." as e";

		$resql=$this->db->query($sql);
		
		if ($resql) {
			while ($obj=$this->db->fetch_object($resql)) {
				$this->nb["invoicelocationexpenses"]=$obj->nb;
			}
            $this->db->free($resql);
			return 1;
		}
		else {
			dol_print_error($this->db);
			$this->error=$this->db->error();
			return -1;
		}
	}

	public function getStatData()
    {
    	global $langs;
    	$this->fetchAll();
    	$countAmount = 0;

    	foreach ($this->rows as $key => $obj)
    		$countAmount += $obj->ht;

    	$object 		= new stdClass();
    	$object->number = count($this->rows);
    	$object->cost 	= $countAmount;
    	$object->label 	= $langs->trans('invoice_location_expenses');
    	$object->url 	= dol_buildpath('/btp/tresorie/invoice_location_expenses/index.php',1);

    	return $object;
    }
}
?>