<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/tresorie/advance_supplier/class/advance_supplier.class.php');
require_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';


$form 		= new Form($db);
$advance_supplier   = new advance_supplier($db);
$societe     = new societe($db);
$paiement     = new paiement($db);
$account     = new account($db);


$var = false;
$filter = '';
$td_travaux =  array(1 => 'Travaux 1', 2 => 'Travaux 2' );
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$search_date_start      		= "";
if (GETPOST('search_date_start') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_date_start'));
    $search_date_start         = $ety.'-'.$etm.'-'.$etd ;
}
$search_date_end      		= "";
if (GETPOST('search_date_end') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_date_end'));
    $search_date_end         = $ety.'-'.$etm.'-'.$etd ;
}
$search_amount    		= GETPOST('search_amount');
$search_payment    		= GETPOST('search_payment');
$search_check_num    		= GETPOST('search_check_num');
$search_bank    		= GETPOST('search_bank');
$search_supplier   		= GETPOST('search_supplier');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_date_start      		= '';
$search_date_end    		= '';
$search_amount    		= '';
$search_payment    		= '';
$search_check_num    		= '';
$search_bank    		= '';
$search_supplier    		= '';
}
$filter .= (!empty($search_date_start) && $search_date_start != -1) ? " AND transaction_date = '".$db->escape($search_date_start)."'\n" :"";
$filter .= (!empty($search_date_end) && $search_date_end != -1) ? " AND due_date = '".$db->escape($search_date_end)."'\n" :"";
$filter .= (!empty($search_amount) && $search_amount != -1) ? " AND amount = ".$db->escape($search_amount):"";
$filter .= (!empty($search_payment) && $search_payment != -1) ? " AND payment_id = ".$db->escape($search_payment) : "";
$filter .= (!empty($search_check_num) && $search_check_num != -1) ? " AND check_num = ".$db->escape($search_check_num) : "";
$filter .= (!empty($search_bank) && $search_bank != -1) ? " AND bank_id = ".$db->escape($search_bank) : "";
$filter .= (!empty($search_supplier) && $search_supplier != -1) ? " AND supplier_id = ".$db->escape($search_supplier) : "";


$getadvance_suppliers = $advance_supplier->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);
if (!empty($getadvance_suppliers)  && $action == "xsl" ) {
$filename="Liste_avances_fournisseurs.xls";
      dol_include_once('/btp/tresorie/advance_supplier/tpl/advance_supplier_xsl.php');
 die();
 
}
// Si erreur SQL
if ($getadvance_suppliers == '-1') {
    print_fiche_titre($langs->trans('ListOfadvance_supplier'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$advance_supplier->error);
    exit();
}
if ($id > 0) {
	$advance_supplier->fetch($id);
	llxHeader('', $langs->trans('advance_supplier'));
	print_fiche_titre($langs->trans("advance_supplier"));


	print '<table class="border" width="100%">';
	// amount
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("amount").'</td>';
	print '<td colspan="2">'. $advance_supplier->amount .'</td></tr>';
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("transaction_date").'</td>';
	print '<td colspan="2">'. dol_print_date($advance_supplier->transaction_date,'day') .'</td></tr>';
	// due_date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("due_date").'</td>';
	print '<td colspan="2">'. dol_print_date($advance_supplier->due_date,'day') .'</td></tr>';
	// engin
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("payment").'</td>';
	print '<td colspan="2">'. $advance_supplier->getPayment($advance_supplier->payment_id) .'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("supplier").'</td>';
	 $societe->fetch($advance_supplier->supplier_id);
	print '<td colspan="2">'. $societe->getNomUrl(1).'</td></tr>';
	// chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("check_num").'</td>';
	print '<td colspan="2">'. $advance_supplier->check_num .'</td></tr>';
	//travaux
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("bank").'</td>';
	$account->fetch($advance_supplier->bank_id,'');
	print '<td colspan="2">'. $account->getNomUrl(1) .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';
	if ($action == 'delete') {
                    
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }
}
else {

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('advance_supplier'),'','','','',$morejs,$morecss,0,0);

print '<link rel="stylesheet" href= "'.dol_buildpath('/btp/css/fontawesome.css',2).'">';

print_fiche_titre($langs->trans("ListOfadvance_supplier"));


	dol_fiche_head('', 'advance_supplier', $langs->trans("ListOfadvance_supplier"), 1, '');
print '<div style="float: right; margin-bottom: 6px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addadvance_supplier').'</a>';
		print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_date_start" value="'. $search_date_start .'" type="hidden" />';
print '<input name="search_date_end" value="'. $search_date_end .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
print '<input name="search_amount" value="'. $search_amount .'" type="hidden" />';
print '<input name="search_payment" value="'. $search_payment .'" type="hidden" />';
print '<input name="search_check_num" value="'. $search_check_num .'" type="hidden" />';
print '<input name="search_bank" value="'. $search_bank .'" type="hidden" />';
print '<input name="search_supplier" value="'. $search_supplier .'" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("ref"), $_SERVER["PHP_SELF"], 'rowid', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("transaction_date"), $_SERVER["PHP_SELF"], 'transaction_date', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("due_date"),$_SERVER["PHP_SELF"],"due_date", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("amount"),$_SERVER["PHP_SELF"],"amount", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("payment"),$_SERVER["PHP_SELF"],"payment_id", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("check_num"), $_SERVER["PHP_SELF"], 'check_num', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("supplier"), $_SERVER["PHP_SELF"], 'supplier_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("bank"), $_SERVER["PHP_SELF"], 'bank_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// num
	print '<td class="liste_titre" olspan="1" align="center">';
	print '</td>';
	//transaction_date
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_date_start,'day').'" class="datepicker" autocomplete="off"  name="search_date_start"  readonly="readonly" /> ';
    print '</td>';
    //due_date
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_date_end,'day').'" class="datepicker" autocomplete="off"  name="search_date_end"  readonly="readonly" /> ';
    print '</td>';
	// amount
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_amount" value="'.$search_amount.'">';
	print '</td>';
	// engin
	print '<td class="liste_titre" olspan="1" align="center">';
	 $form->select_types_paiements($search_payment, "search_payment", '', 0, 1, 1);
    print '</td>';
	// check_num
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_check_num" value="'.$search_check_num.'">';
	print '</td>';
	//supplier_id
	print '<td class="liste_titre" colspan="1" align="center">';
	print  $form->select_thirdparty($search_supplier,"search_supplier",'s.fournisseur=1');
    print '</td>';
	// procedure
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->select_comptes($search_bank,'search_bank', '', 0, 1, 1);
	print '</td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($advance_supplier->rows)) {
		//$createdBy = new User($db);
		foreach($advance_supplier->rows as $obj) {
			  $amount 				= $obj->amount ;
			  $transaction_date 			= dol_print_date($obj->transaction_date,'day') ;
			  $due_date 			= dol_print_date($obj->due_date,'day') ;
			  $payment_id 		    = $advance_supplier->getPayment($obj->payment_id);
			  $check_num         			= $obj->check_num ;
			   $societe->fetch($obj->supplier_id);
			  $account->fetch($obj->bank_id,'');
	
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $advance_supplier->getNomUrl(1,  $obj->id, $obj->id);
			print '</td>';
			 
			print '<td align="center">'. $transaction_date .'</td>';
			print '<td align="center">'. $due_date .'</td>';
			print '<td align="center">'. $amount .'</td>';
			print '<td align="center">'. $payment_id .'</td>';
			print '<td align="center">'. $check_num .'</td>';
			print '<td align="center">'. $societe->getNomUrl(1) .'</td>';
			print '<td align="center">'. $account->getNomUrl(1) .'</td>';
			print '<td align="center"></td>';

			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		


}

llxFooter();

$db->close();


?>