<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       tender/releases/index.php
 * \ingroup    list
 * \brief      List of releases related to given Tender
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/btp/tender/releases/class/releases.class.php');
dol_include_once('/btp/class/tender.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');


// Protection if external user
if (!$user) 
	accessforbidden();

$langs->load('users');

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');
$td 	  = GETPOST('td', 'int');
$id 	  = GETPOST('id', 'int');

if (!$td)
	die('ID de l\'appel d\'offre n\'existe pas!');

$search_ref  	   = $_GET['search_ref'];
$search_createdby  = $_GET['search_createdby'];
$search_amount     = $_GET['search_amount'];
$search_rel_date   = $_GET['search_rel_date'];

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref 	  = "";
	$search_createdby = "";
	$search_amount    = "";
    $search_rel_date  = "";
}

/**
 * Actions
 */

/**
 * View
 */
$releases = new Releases($db);
$tender   = new Tender($db);
$filter   = '';

if ($id > 0) {
	$releases->fetch($id, $td);
	$object 	= $releases;
    $param 		= '&td='. $td;

	$upload_dir = $conf->btp->dir_output.'/releases/'.$releases->id;
	$modulepart = 'btp';

	$filearray = array();

	// Construit liste des fichiers
	$filearray = dol_dir_list($upload_dir, "files", 0, '', '(\.meta|_preview\.png)$', $sortfield, (strtolower($sortorder)=='desc'?SORT_DESC:SORT_ASC),1);
	$totalsize=0;
	foreach($filearray as $key => $file) {
		$totalsize+=$file['size'];
	}

	include_once dol_buildpath('/btp/core/tpl/document_actions_pre_headers.tpl.php');
}


// Filter
$filter .= !empty($search_ref) ? " AND rowid = ". $db->escape(trim($search_ref)) : "";
$filter .= !empty($search_amount) ? " AND amount = ". (float)$db->escape($search_amount) : "";
$filter .= (!empty($search_createdby) && $search_createdby != -1) ? " AND fk_createdby = ". $db->escape($search_createdby) : "";

if (isset($search_rel_date) && !empty($search_rel_date)) {
	$filter .=  " AND rel_date = '". $db->escape(Tools::convertDateTo($search_rel_date, 'sql'))  ."'";
}

/*************************************
 * Fin des filtres de recherche
*************************************/
llxHeader(array(), $langs->trans('ListOfReleases'), '', '', '', '', array('/btp/js/btp.js'));

$getReleases = $releases->fetchAll($td, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getReleases == '-1') {
    print_fiche_titre($langs->trans('ListOfReleases'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$releases->error);
    exit();
}

// Show table of vacations
$var 		= true;
$num 		= count($releases->lines);
$form 		= new FormChild($db);

if ($id) {
	$releases->fetch($id, $td);
	$tender->fetch($td);
	$object 	= $releases;
	$title 		= $langs->trans("ListOfReleases");
	$head  		= tender_prepare_head($tender);
	dol_fiche_head($head, 'releases', $title, 0, '');

	echo $tender->getTenderHeader();

	$createdBy  = new User($db);
	$createdBy->fetch($db->escape($releases->fk_createdby));
	$amount 	= $releases->amount ? number_format($releases->amount,  2, ",", " ") : '';
	$rel_date	= $releases->rel_date ? dol_print_date($releases->rel_date, 'day') : '';
	$created_at = $releases->created_at ? dol_print_date($releases->created_at, 'dayhoursec') : '';

	print '<table class="border" width="100%">';
	print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $createdBy->getNomUrl('1') .'</td></tr>';
	print '<tr><td>'. $langs->trans("Amount") .'</td>';
	print '<td colspan="2">'. $amount ' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	print '<tr><td>'.$langs->trans("ReleaseDate").'</td>';
	print '<td colspan="2">'. $rel_date .'</td></tr>';
	
	print '</table>';

	// if ($user->id && $user->rights->btp->write_all) {
		print '<div class="tabsAction">';
            // Boutons d'actions
			print '<a href="./card.php?action=edit&td='. $td .'&id='. $releases->id .'" class="butAction">'.$langs->trans('Modify').'</a>';
        	print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
            
            // If draft
            // if ($user->rights->btp->delete)	{
            	print '<a href="./card.php?td='.$_GET['td'].'&action=delete&id='. $releases->id .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
            // }
        print '</div>';
	// }
	$modulepart = 'btp';
    $permission = $user->rights->btp->write;
    $param 		            = '&td='. $td;
    $relativepathwithnofile = '/releases/'.$releases->id.'/';

    // include_once dol_buildpath('/btp/core/tpl/document_actions_post_headers.tpl.php');
}
else {
	$title = $langs->trans("ListOfReleases");
	$tender->fetch($td);
	$head = tender_prepare_head($tender);
   	dol_fiche_head($head, 'releases', $title, 1, '');
   	$moreparam = 'td='.$td;

	echo $tender->getTenderHeader();

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">';
	print '<input type="hidden" name="td" value="'. $td .'" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_createdby", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("ReleaseDate"), $_SERVER["PHP_SELF"], 'rel_date', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Amount"),$_SERVER["PHP_SELF"],"amount","", $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left">';
	print '<input class="flat center" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';

    print '<td class="liste_titre" align="center">';
    print $form->select_dolusers($search_createdby,"search_createdby",1,"",0,'','',0,32);
    print '</td>';

	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center datepicker" type="text" size="30" name="search_rel_date" value="'.$search_rel_date.'"></td>';

	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat center" size="30" type="text" name="search_amount" value="'.dol_escape_htmltag($search_amount).'">';
	print '</td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($releases->lines)) {
		$createdBy = new User($db);

		foreach($releases->lines as $line) {
			$var = !$var;
			$createdBy->fetch($db->escape($line->fk_createdby));
			$amount   = $line->amount ? number_format($line->amount,  2, ",", " ") : '';
			$rel_date = $line->rel_date ? dol_print_date($line->rel_date, 'day'): '';

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="260px">';
			print $releases->getNomUrl(1,  $line->fk_tender,  $line->id);
			print '</td>';
			print '<td align="center">'.$createdBy->getNomUrl('1').'</td>';
			print '<td align="center">'. $rel_date .'</td>';
			print '<td align="center">'. $amount .'</td>';
			print '<td></td>';
			print '</tr>'."\n";
		}
	}
	else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

	// if ($user->id && $user->rights->btp->write) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&td='. $td .'" class="butAction">'.$langs->trans('AddRelease').'</a>';
		print '</div>';
	// }
}

llxFooter();

$db->close();

?>