<?php
dol_include_once('/btp/db/nxdb.class.php');

class Integration extends NXdb{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
     /**
	 * @var string Id to identify managed objects
	 */
	public $element = 'integration';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'integration';
	public $coefficient;
	public $datec ;
	public $fk_createdby;
	public $rows = array();
	public $now;
    public $rowid;
    public $id;
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		return 1;
	}
	public function create()
	{
 		dol_syslog(__METHOD__, LOG_DEBUG);
		// Clean parameters
		$this->fk_createdby   = $this->fk_createdby ? $this->db->escape($this->fk_createdby): null;
		$this->coefficient	  = $this->coefficient ? $this->db->escape($this->coefficient): 0;
		$this->datec 		  = $this->datec ? $this->db->escape($this->datec): null;
			// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element .'(created_by,coefficient,datec,created_at,updated_at) VALUES (';
		$sql .= ''.$this->fk_createdby.', '.$this->coefficient.',"'.$this->datec.'",
	"'.$this->now.'","'.$this->now.'")';
		$this->db->begin();
		$resql = $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error Evenement ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			
			return -1;
		} else {
			$this->db->commit();
	 return $this->getLasInsrtedId();
		}
	}
public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			   = $this->db->fetch_object($resql);
				$this->rowid 	   = $obj->rowid;
			    $this->fk_createdby= $obj->fk_createdby;
		        $this->coefficient = $obj->coefficient;
			    $this->datec 	   = $obj->datec ;
			}
			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}

	public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;
        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/rh/integration/index.php?id='. $id .'" title="'.dol_escape_htmltag($label, 1),2).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';
        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        if ($setRef != "") {
        	$result = $link."<div class='icon-empty_folder mainvmenu'></div>  ".$setRef.$linkend;
        }else{
        	$result = "-";
        }
        return $result;
    }
	
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);
		$this->db->begin();
		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE  rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE  rowid = ' . $id;

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
   //search
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $id = '')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .$this->table_element;
		// die($sql);

		if (!empty($filter)) {
		$sql .= ' WHERE '. substr($filter, 4);
		}
	if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}
		$this->rows = array();
		$resql 		 = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
            	$line->rowid 		 = $obj->rowid;
				$line->coefficient	 = $obj->coefficient;
				$line->datec		 = $obj->datec;
				$line->fk_createdby  = $obj->fk_createdby;
				$this->rows[] 		 = $line;
			}
			$this->db->free($resql);
			return $num;
		} else {
			echo 'erreur';
			die();
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function getStatData()
    {
    	global $langs;
    	$this->fetchAll();

    	$object 		= new stdClass();
    	$object->number = count($this->rows);
    	$object->cost 	= false;
    	$object->label 	= $langs->trans('Integrations');
    	$object->url 	= dol_buildpath('/btp/rh/integration/index.php',1);

    	return $object;
    }
}
