<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/rh/advance_user/class/AdvanceUser.class.php');
dol_include_once('/btp/lib/tools.lib.php');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];
$langs->load('btp');
// Protection if external user
$morecss = array();
$morejs  = array("/btp/js/btp.js");
if ($user->societe_id > 0) accessforbidden();
$now 	= new DateTime('now');
$error 	= false;
$form=new Form($db);
if ($action == 'update' && $request_method === 'POST') {
    $advan_user_id = (int) GETPOST('advan_user_id', 'int');
    if (!$advan_user_id || $advan_user_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }
    $advance_user = new AdvanceUser($db);
    $advance_user->fetch($advan_user_id);
     $canedit = true ; 
    // If this is the requestor or has read/write rights
    if ($canedit) {
         $datep=trim(GETPOST('datead'));
         $adforuser=trim(GETPOST('pourad'));
         $adbyuser=trim(GETPOST('parad'));
         $amount  =(float)trim(GETPOST('admount'));
		// Update
     
        $data = array(
            'advancefor_id'=>$adforuser,
            'advanceby_id'=>$adbyuser,
            'datec'=>Tools::convertDateTo($datep, 'sql'),
        'amount'=>$amount,
                 
        );  
       if (!$datep){
     header('Location: ./card.php?id='. $advan_user_id .'&action=edit&error=SQL_Create&msg=Veuillez renseigner tous les champs');
        exit();
        } 
         $vider="";
         $vider.=($adforuser==-1)?"erreur":"";
         $vider.=($adbyuser==-1)?"erreur":"";
         $vider.=($amount==0)?"erreur":"";
            if($vider!=""){
                header('Location: ./card.php?id='. $advan_user_id .'&action=edit&error=SQL_Create&msg=Veuillez renseigner tous les champs');
        exit();
            }
        $getMarcheID = $advance_user->update($advan_user_id, $data);
        if ($getMarcheID > 0) { 
       header('Location: ./index.php?id='.$advan_user_id);
            exit;
        } else {
      // Otherwise we display the request form with the SQL error message
       header('Location:./card.php?id='. $advan_user_id .'&action=edit&error=SQL_Create&msg=Veuillez renseigner tous les champs');
            exit();
        }
    }
}
// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;
	$advance_user  = new AdvanceUser($db);
	 $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $advance_user->fetch($id);
		$advance_user->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
	
        header('Location: index.php');
	
		exit;
	}
	else {
        header('Location: index.php?leftmenu=advance_user');
        exit;
	}
}

/*
 * View
 */

$form           = new Form($db);
$advance_user     = new AdvanceUser($db);

if ($action == 'create' && $request_method === 'POST') {
    
       $datep=GETPOST("ad_date");
       $userpour=(int)trim(GETPOST("pour"));
       $userpar=(int)trim(GETPOST("par"));
       $amount=(float)GETPOST("mont");
        $advance_user->fk_createdby     = $user->id;
        $advance_user->advancefor_id    = $userpour;
        $advance_user->advanceby_id     = $userpar;
        $advance_user->datec            =Tools::convertDateTo($datep, 'sql');
        $advance_user->amount           = $amount;
         $vider="";
         $vider.=($userpour==-1)?"erreur":"";
         $vider.=($userpar==-1)?"erreur":"";
         $vider.=($amount==0)?"erreur":"";
              if (!$datep ){
   header('Location: card.php?action=request&error=SQL_Create&msg=Veuillez renseigner tous les champs');
       die();
          }  if($vider==""){
         $getMarcheID = $advance_user->create();}else{
            $getMarcheID=-1;
         }
         if ($getMarcheID > 0) {   
        header('Location: index.php?id='.$getMarcheID);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
  header('Location: card.php?action=request&error=SQL_Create&msg=Veuillez renseigner tous les champs');
 
      exit(); 
        }
}
llxHeader(array(), $langs->trans('ListeofAdvanceuser'),'','','','',$morejs,$morecss,0,0);
if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	
         print_fiche_titre($langs->trans('dAdvance'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }
        print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

         print '<tr><td class="fieldrequired">'.$langs->trans("advance_for").'</td><td class="fieldrequired">';
          print $form->select_users('',"pour",1);
  print '</td></tr>';

         print '<tr><td class="fieldrequired">'.$langs->trans("made_by").'</td><td class="fieldrequired">';
        
        print $form->select_users('',"par",1);
        print '</td></tr>';
             print '<tr><td class="fieldrequired">'.$langs->trans("Date").'</td><td class="fieldrequired">';
         print '<input type="text" class="datepicker" autocomplete="off"  id="datel" name="ad_date" value="" href="javascript:;" required="required">';
        print '</td></tr>';

           print '<tr><td class="fieldrequired">'.$langs->trans("Amount").'</td><td class="fieldrequired">';
             print '<input type=text name="mont"   required="required">';
        print '</td></tr>';
        print '</tbody>';
        print '</table>';
        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("CAdvance") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage 
        if ($id > 0) {
            $advance_user->fetch($id);
			  // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }
            // On vérifie si l'utilisateur à le droit de lire cette demande
                if ($action == 'delete') {
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDeletesup"),$langs->trans("ConfirmDeletesup"),"confirm_delete", '', 0, 1);
    print_fiche_titre($langs->trans('det_adv_user'));
    print '<table class="border" width="100%">';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Refe").'</td>';
    print '<td colspan="2">'. $advance_user->rowid .'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("advance_for").'</td>';
    $use_u   = new User($db);
    $use_u->fetch($advance_user->advancefor_id);     
    print '<td colspan="2">'.$use_u->getNomUrl(1,$advance_user->advancefor_id,$use_u->lastname.'  '.$use_u->firstname).'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("made_by").'</td>';
       $useu   = new User($db);
       $useu->fetch($advance_user->advanceby_id);     
       $nom=$useu->lastname;
       $nom.='   '.$useu->firstname;
    print '<td colspan="2">'.$useu->getNomUrl(1,$advance_user->advanceby_id,$nom).'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Date").'</td>';
    print '<td colspan="2">'.dol_print_date($advance_user->datec,'day').'</td></tr>';   
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Amount").'</td>';
    print '<td colspan="2">'.$advance_user->amount.' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';     
    
        
    print '</table>';
                }
                // Si annulation 
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }
                if ($action == 'edit') {
                    $edit = true;
                    $id=$_GET['id'];
                    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" id="h" name="advan_user_id" value='.$id.' />'."\n";
                    print '<table class="border" width="100%">';
                    print '<tbody>';
                    print '<tr><td class="fieldrequired">'.$langs->trans("advance_for").'</td><td>';
                    print $form->select_users($advance_user->advancefor_id,"pourad",1);
                    print '</td></tr>' ;
                    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("made_by").'</td><td>';
                    print $form->select_users($advance_user->advanceby_id,"parad",1);
                    print '</td></tr>';  
                    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Date").'</td><td>';
                    print '<input type="text" class="datepicker" autocomplete="off"  name="datead" id="sdate" value="'.dol_print_date($advance_user->datec,'day') .'" name="sdate" required="required" />';
                    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Amount").'</td><td>';
                    print '<input name="admount"  type=text value="'.$advance_user->amount.'" required="required"></td></tr>';
                    print '</tbody>';
                    print '</table>';
                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';  
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';
                    // Boutons d'actions
                 
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    // If draft
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    print '</div>';
                }
        } else {
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }
    }

}
//confirmation de suppression
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
    $error=0;
    $advance_user  = new AdvanceUser($db);
    $canedit = true;
    // Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
    if ($canedit) {
        $advance_user->fetch($id);
        $advance_user->delete();
    }
    else {
        $error = $langs->trans('ErrorCantDelete');
    }

    if (!$error) {
        //$db->commit();
        header('Location: index.php');
        exit;
    }
    else {
        
        header('Location: index.php?leftmenu=advance_user');
        exit;
    }
}

// End of page
llxFooter();llxFooter();

$db->close();


?>