
<?php
/* Copyright (C) 2005		Rodolphe Quiedeville 	<rodolphe@quiedeville.org>
 * Copyright (C) 2004-2013	Laurent Destailleur  	<eldy@users.sourceforge.net>
 * Copyright (C) 2005-2010	Regis Houssin        	<regis.houssin@capnetworks.com>
 * Copyright (C) 2010     	François Legastelois 	<flegastelois@teclib.com>
 * Copyright (C) 2014-2015	charlie BENKE			<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file       /management/projet/listtime.php
 *	\ingroup    projet
 *	\brief      List activities of tasks
 */

$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");		// For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");	// For "custom" directory

require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
require_once DOL_DOCUMENT_ROOT.'/projet/class/task.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/project.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
dol_include_once('/btp/rh/pointage/class/pointage.class.php');
dol_include_once('/btp/nc_under_modules/management/core/lib/management.lib.php');

// load css theme.css ici 
$langs->load('btp@btp');

$langs->load('management@management');
$action=GETPOST('action');
$mode=GETPOST("mode");
$id=GETPOST('id','int');

$periodyears=GETPOST('periodyears','int');
if (!$periodyears)
	$periodyears=date('Y');

$periodmonths=GETPOST('periodmonths','int');
if (!$periodmonths)
	$periodmonths=date('m');

	
// récupération du nombre de jour dans le mois
$time = mktime(0, 0, 0, $periodmonths+1, 1, $periodyears); // premier jour du mois suivant
$time--; // Recule d'une seconde
$nbdaymonth=date('d', $time); // on récupère le dernier jour

$form=new Form($db);
$formother = new FormOther($db);
$pointage= new pointage($db);
$user_array=new User($db);
$project = new Project($db);
/*
 * Actions
 */


/*
 * View
 */
$title=$langs->trans("consulte");

llxHeader("",$title,"");
print_barre_liste($title, $page, $_SERVER["PHP_SELF"], "", $sortfield, $sortorder, "", $num);
dol_htmloutput_mesg($mesg);

// 

print '<form name="selectperiod" method="POST" action="'.$_SERVER["PHP_SELF"].'?id='.$project->id.'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="selectperiod">';

print '<table  width="45%">';
print '<tr >';
print '<td>'.$langs->trans("PeriodAAAAMM").'</td>';
print '<td>'.$formother->selectyear($periodyears,'periodyears',1).$formother->select_month($periodmonths,'periodmonths',1).'</td>';
print '<td><div id="lblBlurWeekEnd">'.$langs->trans("ShowHideWeekend").'</div></td>';
print "</tr>\n";
print '<tr >';
$showempty=0;
// attention le dernier paramétre n'est dispo que sur la 3.7 et le patch fournis
print '<td></td><td></td><td ><input type=submit align="center" name="select" value="'.$langs->trans("Select").'"></td>';
print "</tr>\n";
print "</table>";
print '</form>';


print '<table class="noborder" width="100%" >';
print '<tr class="liste_titre nc_filtrage_tr">';
print '<td  align="center" >'.$langs->trans("Names").'</td>';
print '<td  align="center">'.$langs->trans("Qualif").'</td>';

print '<td colspan="32" align="right"></td>';
print '<td  align="center">'.$langs->trans("nbjour").'</td>';
print '<td  align="center">'.$langs->trans("nbHeurseup").'</td>';
print '<td  align="center">'.$langs->trans("avance").'</td>';




print "</tr>\n";

timesheetLines($j,$pointage->rows, $level, $projectsrole, $tasksrole, $mine, $perioduser);

print "</table>";
print '</form>';
print '<div style="float: right; margin-top: 8px;">';
print '<a href="./listtime.php" class="butAction">'.$langs->trans('TimeSpentPeriod').'</a>';
print '</div>';

// pour activer ou non le week-end
print '<script language="javascript">';
print '$(document).ready(function() {';
print '$(".weekendtohide").toggle();';
print '	$("#lblBlurWeekEnd").click(function() {';
print '		$(".weekendtohide").toggle();';
print '		$(".weekendtoshow").toggle();';
print '	});';
print '});';
print '</script>';

llxFooter();

$db->close();
/**
 * Output a task line
 *
 * @param	string	   	&$inc			?
 * @param   string		$parent			?
 * @param   Object		$lines			?
 * @param   int			&$level			?
 * @param   string		&$projectsrole	?
 * @param   string		&$tasksrole		?
 * @param   int			$mytask			0 or 1 to enable only if task is a task i am affected to
 * @return  $inc
 */
function timesheetLines(&$inc,$lines, &$level, &$projectsrole, &$tasksrole, $mytask=0, $perioduser='')
{
	global $user, $bc, $langs;
	global $form, $formother, $pointage, $taskstatic;
	global $periodyears, $periodmonths, $nbdaymonth,$pointage;
     global $lines;
     global $numlines,$user_array,$project;
     $filter="and year_point=".$periodyears;
    $filter.=" and month_point=".$periodmonths;
    $pointage->fetchAll('','p.rowid',0,0,$filter);
    
	$lastprojectid=0;
	$var=true;
	$array=['','J','HS','AV'];
    
    $numlines=count($array);
    $num=count($lines);
            if (count($pointage->rows)) {
            	
           
     foreach($pointage->rows as $line) {
	       	$user_array->fetch($line->fk_user);
	       	$project->fetch($line->fk_project);
	   		for ($i = 0 ; $i <$numlines ; $i++)
	  		 {      $nbr=0;
	   
				if(empty($array[$i])){
	            print '<td align="left" >'.$user_array->getNomUrl($line->fk_user).'<p style="margin-left:30px;"></p>
	               </td><td>'.$user_array->job.'</td><td>'.$array[$i].'</td>';
	                }else{
	                	    if($array[$i]=='HS'){
	                	print '<tr>
						<td colspan=2>'.$project->title.'</td></td><td>'.$array[$i].'</td>';}
					else{

	    print '<tr>
						<td></td><td></td><td>'.$array[$i].'</td>';
	                }
}

	            for ($day=1;$day <= $nbdaymonth ;$day++)
				{ 

					  $curday=mktime(0, 0, 0, $periodmonths, $day, $periodyears);
					  $bgcolor="";
					if (date('N', $curday) == 6 || date('N', $curday) == 7)
					{
						print '<td width=1px class=weekendtoshow bgcolor=grey ></td>';
						$bgcolor=" class=weekendtohide bgcolor=grey ";}
				    	if(empty($array[$i]))
					    {
				
							print '<td '.$bgcolor.' align=center>';
							print substr($langs->trans(date('l', $curday)),0,1)." ".$day.'</td>';
						}
					    else{

								print '<td '.$bgcolor.' align=center size="12">';
				// le nom du champs c'est à la fois le jour et l'id de la tache
								print '<input type=text id="inputday" name="'.$array[$i].'-'.$day.'-'.$line->fk_user.'"'; 	
				//$timespent=fetchSumTimeSpent($taskstatic->id, $curday, $perioduser);
				$val=$pointage->getVal($periodmonths,$periodyears,$line->fk_user,$array[$i],$day,$line->fk_project);
				$nbr=$nbr+$val;
				print ' value="'.$val.'"';
				
				print ' size=2 style="font-size:0.9em" disabled>';
				print '</td>';

					}
				
				


   }
   $pe=$nbdaymonth+1;
   for ($s=$pe; $s <=31 ; $s++) { 
   	print '<td></td>';
   }
 for ($com=1; $com <$i ; $com++) {
    if(!empty($array[$i])) 
print '<td align="center"></td>';
 	
 }

   if(!empty($array[$i]))
print '<td align="center">'.$nbr.'</td>';
for ($c=$com; $c<3 ; $c++) {
   if(!empty($array[$i])) 
print '<td align="center"></td>';
 	
 }
PRINT'</tr>';
}
PRINT'</tr>';

}}else{

     	print '<tr>';
	    print '<td colspan="34" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}
			

	return $inc;
}
?>

