<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/po_recap/index.php
 * \ingroup    list
 * \brief      List of po_recap related to given poid
 */
$res=0;
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../../main.inc.php")) $res=@include("../../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
dol_include_once('/btp/nc_under_modules/marches/lib/marches.lib.php');
dol_include_once('/btp/nc_under_modules/marches/purchaseorder/class/purchaseorder.class.php');
dol_include_once('/btp/nc_under_modules/marches/po_recap/class/po_recap.class.php');

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$poid 	 = GETPOST('poid', 'int');
$action	 = GETPOST('action', 'alpha');
$confirm = GETPOST('confirm', 'alpha');

if (!$poid)
	die('ID bon de commande n\'existe pas!');

$object = new PORecap($db);
$po_recapstatic = new PORecap($db);
$purchaseorder = new PurchaseOrder($db);
$form   = new Form($db);

/**
 * Actions
 */

// None

/**
 * View
 */

$morejs  = array("/marches/js/marches.js");
llxHeader(array(), $langs->trans('RecapBC'),'','','','',$morejs,array(),0,0);

// Récupération de l'ID de l'utilisateur
$object->fetchAll($poid, true);
$purchaseorder->fetch($poid);
$head  = purchaseorder_prepare_head($purchaseorder);
dol_fiche_head($head, 'po_recap', $langs->trans('RecapBC'), 0, '');

echo $purchaseorder->getMarketHeader();

print '<form method="post" action="./card.php">';
print '<input name="action" value="add" type="hidden" />';
print '<input name="poid" value="'. $poid .'" type="hidden" />';
print '<input id="btnAddText" value="'. $langs->trans('Add') .'" type="hidden" />';
print '<h3>'. $langs->trans('RecapMainTitle') .': </h3>';

/*echo '<table class="" width="100%"><tr><td width="50%">';
echo '<table class="border" width="100%"><tr><td colspan="2">';
print '<h4>'. $langs->trans('po_recapDefaultTitle'). ' ('. $langs->trans('MissedPiecesPhrase') .')</h4>';
echo '</td></tr>';

$checkDefPcs = 0;
if (count($object->lines)) {
	$defaultPcs = $object->lines;
	$spaces = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
	$object->fetchAll($poid, false, 1);
	$getDefaultInsertedPcs = $object->lines;

	foreach ($defaultPcs as $key => $obj) {
		$checked = '';
		$comment = '';
		if (count($getDefaultInsertedPcs) && in_array($obj->ref, $object->getRowsRefs($object->lines))) {
			$checked = ' checked="checked"';
			$checkDefPcs++;
			$po_recapstatic->fetchByRef($obj->ref, $poid, false);
			$comment = $po_recapstatic->comment;
		}
		$disabled = ($purchaseorder->statut == 3 ? ' disabled="disabled"' : '');

		print '<tr>';
		print '<td width="35%"><label for="pc-'. $key .'"><input id="pc-'. $key .'" name="origin_pieces[]" type="checkbox" value="'. $obj->ref .'"'. $checked . $disabled .' /> '. $obj->ref .'</label></td>';
		print '<td width="65%"><textarea name="origin_pieces_comments[]" cols="70" rows="2">'. $comment .'</textarea></td>';
		print '</tr>';
	}
}

echo '</table>';*/

echo '</td><td valign="top" width="50%"><table class="border pcs_container" width="100%"><tr><td colspan="2">';
print '<h4>'. $langs->trans('RecapNewTitle') .'</h4>';
echo '</td></tr>';

$object->fetchAll($poid, false);
if (count($object->lines)) {
	foreach ($object->lines as $key => $obj) {
		$disabled = ($purchaseorder->statut == 3 ? ' disabled="disabled"' : '');
		print '<tr>';
		print '<td width="35%"><label for="npc-'. $key .'"><input class="new_pcs" id="npc-'. $key .'" name="new_pieces[]" type="checkbox" value="'. $obj->id .'" checked="checked"'. $disabled .' /> '.$obj->ref .'</label></td>';
			print '<td width="65%"><textarea name="new_pieces_comments[]" cols="70" rows="2"'. $disabled .'>'. $obj->comment .'</textarea></td>';
		print '</tr>';
	}
}

echo '</table>';
echo '</td></tr></table>';

if ($user->id && $user->rights->btp->write) {
	print '<br>';
	print '<div style="float:right; margin-top: 8px;">';

	if ($purchaseorder->statut != 3) {
		print '<input type="submit" class="butAction" value="'. $langs->trans('Save') .'" />';
		print '<a id="addNewPiece" href="javascript:void(0);" class="butAction">'. $langs->trans('Add') .'</a>';
		
		if (count($object->lines))
			print '<a href="./card.php?action=archive&poid='. $poid .'" class="butAction">'. $langs->trans('Archive') .'</a>';
	}
	
	print '</div>';
}
print '</form>';

llxFooter();

$db->close();

?>