<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/notifications/index.php
 * \ingroup    notifications
 * \brief      List of notifications
 */
$res=0;
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../../main.inc.php")) $res=@include("../../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/nc_under_modules/marches/core/class/html.form.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/btp/nc_under_modules/marches/marche/class/marche.class.php');
dol_include_once('/btp/nc_under_modules/marches/notifications/class/notification.class.php');
dol_include_once('/btp/nc_under_modules/marches/lib/marches.lib.php');

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0)  $socid = $user->societe_id;

$sortfield 	= GETPOST("sortfield",'alpha');
$sortorder 	= GETPOST("sortorder",'alpha');
$page 		= GETPOST("page",'int');
$page 		= is_numeric($page) ? $page : 0;
$page 		= $page == -1 ? 0 : $page;
$filter 	= '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$mid 	  = GETPOST('mid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

$object = new Notifications_two($db);
$marche = new Marches($db);

$search_ref 		= GETPOST('search_ref');
$search_created_by 	= (int) GETPOST('search_created_by');
$search_subject     = GETPOST('search_subject');
$search_date     	= GETPOST('search_date');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref 		= "";
	$search_created_by 	= "";
	$search_subject  	= "";
    $search_date     	= "";
}

if ($id > 0) {
	$object->fetch($id);
    $param 		= '&mid='. $mid;
	$upload_dir = $conf->marches->dir_output.'/notifications/'.$object->id;
	$modulepart = 'marches';

	$filearray = array();
	// Construit liste des fichiers
	$filearray = dol_dir_list($upload_dir, "files", 0, '', '(\.meta|_preview\.png)$', $sortfield, (strtolower($sortorder)=='desc'?SORT_DESC:SORT_ASC),1);
	$totalsize=0;
	foreach($filearray as $key => $file) {
		$totalsize+=$file['size'];
	}

	dol_include_once('/btp/nc_under_modules/marches/core/tpl/document_actions_pre_headers.tpl.php');
}

/**
 * Actions
 */

// None

/**
 * View
 */
llxHeader(array(), $langs->trans('ListOfMarkets'), '', '', '', '', array('/btp/nc_under_modules/marches/js/marches.js'));

// Filter
$filter .= (!empty($search_ref) && $search_ref != -1) ? " AND ref = '". $db->escape($search_ref) ."'\n" : "";
if (isset($search_date) && !empty($search_date)) {
	list($sd, $sm, $sy)  = explode("/", $search_date);
	$filter .=  " AND notif_date = '". $sy.'-'.$sm.'-'.$sd ."'";
}
$filter .= (!empty($search_created_by) && $search_created_by != -1) ? " AND fk_created_by = '".$db->escape($search_created_by)."'\n" : "";
$filter .= (!empty($search_subject) && $search_subject != -1) ? " AND subject like '%".$db->escape($search_subject)."%'\n" : "";
$filter .= ' AND fk_marche = '. $mid;
/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$getNotificationList = $object->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getNotificationList == '-1') {
    print_fiche_titre($langs->trans('ListOfNotifications'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}
 

$
// Show table of vacations
$var 		= true;
$num 		= count($object->lines);
$form 		= new FormChild($db);

if ($id > 0) {
	$title = $langs->trans("NotifDetail");
	print_fiche_titre($title,'','');

	$object->fetch($id);
	$marche->fetch($mid);
	$head = marches_prepare_head($marche);
	dol_fiche_head($head, 'notifications', $langs->trans("NotifDetail"), 0, '');
	
	$head_btm = phase_notification_prepare_head($marche);
	dol_fiche_head($head_btm, '', $langs->trans('NotificationsPhase'), 0, '');

	echo $marche->getMarketHeader();
	
	print '<table class="border" width="100%">';
	print '<tr><td width="25%">'.$langs->trans("Ref").'</td>';
	print '<td colspan="2">'. $object->ref .'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("Subject").'</td>';
	print '<td colspan="2">'. nl2br($object->subject) .'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("NotifDate").'</td>';
	print '<td colspan="2">'. dol_print_date($object->notif_date, 'day') .'</td></tr>';
	print '</table><br />';

	print '<div style="float: right;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	if ($user->id && $user->rights->btp->write_all) {
		print '<a href="./card.php?action=edit&id='.$id.'&mid='. $mid .'" class="butAction">'.$langs->trans('Modify').'</a>';
	}

	if ($user->rights->btp->delete)	{
    	print '<a href="./card.php?id='.$id.'&action=delete&mid='. $mid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
    }
	print '</div>';

	$modulepart = 'marches';
    $permission = $user->rights->btp->write;
    $param 		= '&mid='. $mid;
    $relativepathwithnofile = '/notifications/'.$object->id.'/';

    dol_include_once('/btp/nc_under_modules/marches/core/tpl/document_actions_post_headers.tpl.php');
} else {
	$title = $langs->trans("ListOfNotifications");
print_fiche_titre($title,'','');

	$marche->fetch($mid);
	$head = marches_prepare_head($marche);
	dol_fiche_head($head, 'notifications', $langs->trans("NotifDetail"), 0, '');
	
	$head_btm = phase_notification_prepare_head($marche);
	dol_fiche_head($head_btm, '', $langs->trans('NotificationsPhase'), 0, '');

	echo $marche->getMarketHeader();
   	$moreparam = 'mid='.$mid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">';
	print '<input type="hidden" value="'. $mid .'" name="mid" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "ref", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_created_by", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Subject"), $_SERVER["PHP_SELF"], 'subject', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("NotifDate"),$_SERVER["PHP_SELF"],"notif_date","", $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat center" size="30" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';

    print '<td class="liste_titre" align="center">';
    print $form->select_dolusers($search_created_by,"search_created_by",1,"",0,'','',0,32);
    print '</td>';

	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center" type="text" size="30" name="search_subject" value="'.$search_subject.'"></td>';

	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center datepicker" type="text" size="14" name="search_date" value="'.$search_date.'"></td>';
	// ACTION
	print '<td align="right">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($object->lines)) {
		$createdBy = new User($db);

		foreach($object->lines as $line) {
			$var = !$var;
			$createdBy->fetch($db->escape($line->fk_created_by));
			$ref 		 = $line->ref ? $line->ref : $line->id;
			$notif_date	 = $line->notif_date ? dol_print_date($line->notif_date, 'day'): '';
			$subject 	 = '';
			$fullsubject = '';
			if (null !== $line->subject) {
				$fullsubject = str_replace(array("\r\n", "\n"), "", nl2br(strip_tags($line->subject)));
				$subject 	= substr($line->subject, 0, 100);
				$subject 	= strlen($line->subject) > 100 ? $subject.'...' : $subject;
			}

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="260px">';
			print $object->getNomUrl(1,  $line->id,  $ref, $mid);
			print '</td>';
			print '<td align="center">'.$createdBy->getNomUrl('1').'</td>';
			print '<td align="center"><span class="classfortooltip" title="'. $fullsubject .'">'. $subject .'</span></td>';
			print '<td align="center">'. $notif_date .'</td>';
			print '<td></td>';
			print '</tr>'."\n";
		}
	}

	print '</table>';
	print '</form>';

	if ($user->id && $user->rights->btp->write) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('AddNotif').'</a>';
		print '</div>';
	}
}

llxFooter();

$db->close();

?>