<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/marche/card.php
 * \ingroup    marche
 * \brief      markets CRUD
 */
$res=0;
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../../main.inc.php")) $res=@include("../../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/btp/nc_under_modules/marches/marche/class/marche.class.php');
dol_include_once('/btp/nc_under_modules/marches/lib/marches.lib.php');
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';

$langs->load('users');
$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0)  $socid = $user->societe_id;

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id      = GETPOST('id', 'int');
$mid 	 = GETPOST('mid', 'int');

$langs->load('marches');
$error 	= false;
$marche = new Marches($db);
$request_method = $_SERVER['REQUEST_METHOD'];

if ($action == 'clone_marche' && $mid) {
    $clonedMarche = $marche->cloneMarche($mid, $user);

    if (!$clonedMarche) {
        header("Location: ./index.php?id=". $mid);
        die();
    }

    $marche->ref_marche           = $clonedMarche->cloned_ref;
    $marche->fk_created_by        = (int)$user->id;
    $marche->fk_appel_offre       = (int)$clonedMarche->cloned_ao;
    $marche->label                = $clonedMarche->cloned_label;
    $marche->budget               = $clonedMarche->cloned_amount_ht;
    $marche->sig_date             = $clonedMarche->cloned_signature_date;
    $getId = $marche->create();

    if ($getId) {
        header("Location: ./index.php?id=". $getId);
        die();
    }
}

if ($action == 'update' && $request_method === 'POST') {
	// If no right to update a request
    if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error = true;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='edit';
    }

    $label 		= GETPOST('label', 'alpha');
    $ref_marche = GETPOST('ref_marche', 'alpha');
    $sig_date 	= GETPOST('sig_date', 'alpha');
    $budget 	= GETPOST('budget');
    $marche_id 	= GETPOST('marche_id', 'int');

    if (!isset($_POST['ref_marche']) || empty($_POST['ref_marche'])) {
    	header("Location: ./card.php?id=". $marche_id ."&action=edit&error=markerN");
    	die();
    }

    if (!isset($_POST['label']) || empty($_POST['label'])) {
		header("Location: ./card.php?id=". $marche_id ."&action=edit&error=markerL");
    	die();
    }

    if (!isset($_POST['sig_date']) || empty($_POST['sig_date'])) {
    	header("Location: ./card.php?id=". $marche_id ."&action=edit&error=markerD");
    	die();
    }

    list($day, $mon, $year) = explode("/", $sig_date);
    $sig_date = $year.'-'.$mon.'-'.$day;

    if (!$error) {
    	$data = array(
    		'ref_marche' => trim($ref_marche),
    		'label' 	 => trim($label),
    		'sig_date'   => $sig_date,
    		'budget' 	 => (float)trim($budget),
    	);
    	$upated = $marche->update($marche_id, $data);
    	
    	if ($upated) {
	    	header("Location: ./index.php?id=". $marche_id);
	    	die();
    	} else {
    		header("Location: ./index.php?id=". $marche_id."&error=SQL_Create&msg=". $marche->error);
	    	die();
    	}
    }
}

/*
 * View
 */

$form    = new Form($db);
$morejs  = array("/marches/js/marches.js");
$morecss = array();

llxHeader(array(), $langs->trans('ListOfMarkets'),'','','','',$morejs,$morecss,0,0);

if ($id || $action == 'edit' || $action == 'update') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {
        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'cantDelete' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'markerN' :
                    $errors[] = $langs->trans('MarketNError');
                    break;
                case 'markerL' :
                    $errors[] = $langs->trans('MarketLError');
                    break;
                case 'markerD' :
                    $errors[] = $langs->trans('MarketDError');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

		$canedit = ($user->rights->btp->delete || $user->rights->btp->write_all);
        
        if ($canedit) {
            if ($action == 'delete') {
                if($user->rights->btp->delete) {
                    print $form->formconfirm("./card.php?id=".$id, $langs->trans("TitleDeleteMarket"),$langs->trans("ConfirmDeleteMarket"),"confirm_delete", '', 0, 1);
                }
            }
 $title = $langs->trans("EditMarket");
            print_fiche_titre($title,'','');
            $marche->fetch($id);
            $head = marches_prepare_head($marche);
            dol_fiche_head($head, 'marche', $langs->trans("MyPageName"), 0, '');

            if ($action == 'edit') {
                $edit = true;
                print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">';
                print '<input type="hidden" name="action" value="update" />';
                print '<input type="hidden" name="marche_id" value="'.$id.'" />';

                print '<table class="border" width="100%">';
                print '<tbody>';

                // Label
                print '<tr><td class="fieldrequired">'.$langs->trans("MarketRef").'</td><td>';
                print '<input type="text" value="'. $marche->ref_marche .'" name="ref_marche" required="required" /></td></tr>';
                print '<tr><td class="fieldrequired">'.$langs->trans("MarketLabel").'</td><td>';
                print '<input type="text" value="'. $marche->label .'" name="label" required="required" /></td></tr>';
                print '<tr><td class="fieldrequired">'.$langs->trans("MarketDate").'</td><td>';
                print '<input type="text" class="datepicker" autocomplete="off"  value="'. dol_print_date($marche->sig_date, 'day') .'" name="sig_date" required="required" readonly="readonly" /></td></tr>';
                print '<tr><td class="fieldrequired">'.$langs->trans("MarketAmount").'</td><td>';
                print '<input type="text" value="'. $marche->budget .'" name="budget" required="required" /></td></tr>';

                print '</tbody>';
                print '</table><br />';

                print '<div class="center">';
                // Boutons d'actions
                print '<input type="submit" class="butAction" value="'. $langs->trans('Modify') .'">';

                print '</div>';
            }

            dol_fiche_end();

        }
    }
}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>
