<?php

require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
dol_include_once('/btp/nc_under_modules/marches/documentmanagement/class/documentmanagement.class.php');
dol_include_once('/btp/nc_under_modules/marches/po_documentmanagement/class/po_documentmanagement.class.php');

/**
* Extends formfile functionality
*/
class FormFileChild extends FormFile
{
	protected $entity;

	function __construct($db)
    {
    	parent::__construct($db);
        $this->db = $db;
        $this->numoffiles=0;
        $this->entity = new DocumentManagement($db);
        $this->po_entity = new PODocumentManagement($db);
        return 1;
    }

    /**
     *	Show list of documents in a directory
     *
     *  @param	string	$upload_dir         Directory that was scanned
     *  @param  array	$filearray          Array of files loaded by dol_dir_list function before calling this function
     *  @param  string	$modulepart         Value for modulepart used by download wrapper
     *  @param  string	$param              Parameters on sort links
     *  @param  int		$forcedownload      Force to open dialog box "Save As" when clicking on file
     *  @param  string	$relativepath       Relative path of docs (autodefined if not provided)
     *  @param  int		$permtodelete       Permission to delete
     *  @param  int		$useinecm           Change output for use in ecm module
     *  @param  int		$textifempty        Text to show if filearray is empty
     *  @param  int		$maxlength          Maximum length of file name shown
     *  @param	string $url				Full url to use for click links ('' = autodetect)
     *  @return int                 		<0 if KO, nb of files shown if OK
     */
    function list_of_market_documents($upload_dir,$filearray,$modulepart,$param,$forcedownload=0,$relativepath='',$permtodelete=1,$useinecm=0,$textifempty='',$maxlength=0,$url='')
    {
        global $user, $conf, $langs;
        global $bc;
        global $sortfield, $sortorder;

        dol_syslog(get_class($this).'::list_of_autoecmfiles upload_dir='.$upload_dir.' modulepart='.$modulepart);

        // Show list of documents
        if (empty($useinecm)) print_titre($langs->trans("AttachedFiles"));
        if (empty($url)) $url=$_SERVER["PHP_SELF"];
        print '<table width="100%" class="nobordernopadding">';
        print '<tr class="liste_titre nc_filtrage_tr">';
        $sortref="level1name";

        print_liste_field_titre($langs->trans("Ref"),$url,$sortref,"",$param,'align="left"',$sortfield,$sortorder);
        print_liste_field_titre($langs->trans("Documents2"),$url,"name","",$param,'align="left"',$sortfield,$sortorder);
        print_liste_field_titre($langs->trans("Size"),$url,"size","",$param,'align="right"',$sortfield,$sortorder);
        print_liste_field_titre($langs->trans("Date"),$url,"date","",$param,'align="center"',$sortfield,$sortorder);
        print_liste_field_titre('','','');
        print '</tr>';

        $object_instance = $this->entity;
        $modules_dir = $object_instance->getDocumentTypesDir();

        $var=true;
        foreach($filearray as $key => $file) {
        	if (!is_dir($file['name']) && ($file['name'] != '.' && $file['name'] != '..') && $file['name'] != 'CVS' && ! preg_match('/\.meta$/i',$file['name'])) {
                // Define relative path used to store the file
                $relativefile = preg_replace('/'.preg_quote($upload_dir.'/','/').'/','',$file['fullname']);

                $id=0; $ref=''; $label='';

                // To show ref or specific information according to view to show (defined by $module)
            	preg_match('/(\d+)\/[^\/]+$/', $relativefile, $reg);
            	$id  = (isset($reg[1]) ? $reg[1] : '');

                if (!$id && !$ref) continue;
                
                $found = 0;
                $result = 0;

                if ($id) {
                    $result = $object_instance->fetch($id);
                }

                if ($result)  {
                	$found = 1;
                }    // Save object into a cache
                if (!$result) {
                	$found=1;
                	unset($filearray[$key]);
                }

                if (!$found > 0) continue; // We do not show orphelins files

                $full_recreared_path = $modulepart.'/'. $object_instance->fk_marche .'/'.$relativefile;
                $var=!$var;
                print '<tr '.$bc[$var].'>';
                print '<td>';
                
                if ($found) {
                	print $object_instance->getNomUrl(1, $id, $object_instance->type_id, ucfirst($object_instance->ref), $object_instance->fk_marche);
                }
                else 
                	print $langs->trans("ObjectDeleted",($id?$id:$ref));

                print '</td>';
                print '<td>';

                print '<a data-ajax="false" href="'.DOL_URL_ROOT.'/document.php?modulepart=marches';
                if ($forcedownload) print '&attachment=1';
                print '&file='.urlencode($full_recreared_path).'">';
                print img_mime($file['name'],$file['name'].' ('.dol_print_size($file['size'],0,0).')').' ';
                print dol_trunc($file['name'],$maxlength,'middle');
                print '</a>';
                print "</td>\n";
                print '<td align="right">'.dol_print_size($file['size'],1,1).'</td>';
                print '<td align="center">'.dol_print_date($file['date'],"dayhour").'</td>';
                print '<td align="right">';
                if (! empty($useinecm))  print '<a data-ajax="false" href="'.DOL_URL_ROOT.'/document.php?modulepart=marches';
                if ($forcedownload) print '&attachment=1';
                print '&file='.urlencode($full_recreared_path).'">';
                print img_view().'</a> &nbsp; ';
                print "</td></tr>\n";
            }
        }

        if (!count($filearray)) {
            print '<tr '.$bc[false].'><td colspan="4">';
            if (empty($textifempty)) print $langs->trans("NoFileFound");
            else print $textifempty;
            print '</td></tr>';
        }
        print "</table>";
        // Fin de zone
    }

    function list_of_purchaseorder_documents($upload_dir,$filearray,$modulepart,$param,$forcedownload=0,$relativepath='',$permtodelete=1,$useinecm=0,$textifempty='',$maxlength=0,$url='')
    {
        global $user, $conf, $langs;
        global $bc;
        global $sortfield, $sortorder;

        dol_syslog(get_class($this).'::list_of_autoecmfiles upload_dir='.$upload_dir.' modulepart='.$modulepart);

        // Show list of documents
        if (empty($useinecm)) print_titre($langs->trans("AttachedFiles"));
        if (empty($url)) $url=$_SERVER["PHP_SELF"];
        print '<table width="100%" class="nobordernopadding">';
        print '<tr class="liste_titre nc_filtrage_tr">';
        $sortref="level1name";

        print_liste_field_titre($langs->trans("Ref"),$url,$sortref,"",$param,'align="left"',$sortfield,$sortorder);
        print_liste_field_titre($langs->trans("Documents2"),$url,"name","",$param,'align="left"',$sortfield,$sortorder);
        print_liste_field_titre($langs->trans("Size"),$url,"size","",$param,'align="right"',$sortfield,$sortorder);
        print_liste_field_titre($langs->trans("Date"),$url,"date","",$param,'align="center"',$sortfield,$sortorder);
        print_liste_field_titre('','','');
        print '</tr>';

        $object_instance = $this->po_entity;
        $modules_dir = $object_instance->getDocumentTypesDir();

        $var=true;
        foreach($filearray as $key => $file) {
            if (!is_dir($file['name']) && ($file['name'] != '.' && $file['name'] != '..') && $file['name'] != 'CVS' && ! preg_match('/\.meta$/i',$file['name'])) {
                // Define relative path used to store the file
                $relativefile = preg_replace('/'.preg_quote($upload_dir.'/','/').'/','',$file['fullname']);

                $id=0; $ref=''; $label='';

                // To show ref or specific information according to view to show (defined by $module)
                preg_match('/(\d+)\/[^\/]+$/', $relativefile, $reg);
                $id  = (isset($reg[1]) ? $reg[1] : '');

                if (!$id && !$ref) continue;

                $found = 0;
                $result = 0;

                if ($id) {
                    $result = $object_instance->fetch($id);
                }

                if ($result)  {
                    $found = 1;
                }    // Save object into a cache
                if (!$result) {
                    $found=1;
                    unset($filearray[$key]);
                }

                if (!$found > 0) continue; // We do not show orphelins files

                $full_recreared_path = $modulepart.'/'. $object_instance->fk_po .'/'.$relativefile;
                $var=!$var;
                print '<tr '.$bc[$var].'>';
                print '<td>';
                
                if ($found) {
                    print $object_instance->getNomUrl(1, $id, $object_instance->type_id, ucfirst($object_instance->ref), $object_instance->fk_po);
                }
                else 
                    print $langs->trans("ObjectDeleted",($id?$id:$ref));

                print '</td>';
                print '<td>';

                print '<a data-ajax="false" href="'.DOL_URL_ROOT.'/document.php?modulepart=marches';
                if ($forcedownload) print '&attachment=1';
                print '&file='.urlencode($full_recreared_path).'">';
                print img_mime($file['name'],$file['name'].' ('.dol_print_size($file['size'],0,0).')').' ';
                print dol_trunc($file['name'],$maxlength,'middle');
                print '</a>';
                print "</td>\n";
                print '<td align="right">'.dol_print_size($file['size'],1,1).'</td>';
                print '<td align="center">'.dol_print_date($file['date'],"dayhour").'</td>';
                print '<td align="right">';
                if (! empty($useinecm))  print '<a data-ajax="false" href="'.DOL_URL_ROOT.'/document.php?modulepart=marches';
                if ($forcedownload) print '&attachment=1';
                print '&file='.urlencode($full_recreared_path).'">';
                print img_view().'</a> &nbsp; ';
                print "</td></tr>\n";
            }
        }

        if (!count($filearray)) {
            print '<tr '.$bc[false].'><td colspan="4">';
            if (empty($textifempty)) print $langs->trans("NoFileFound");
            else print $textifempty;
            print '</td></tr>';
        }
        print "</table>";
        // Fin de zone
    }
}