<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/DelayManagement/exceedingdelay.php
 * \ingroup    DelayManagement
 * \brief      List of DelayManagement
 */
$res=0;
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../../main.inc.php")) $res=@include("../../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/btp/nc_under_modules/marches/delaymanagement/class/delaymanagement.class.php');
dol_include_once('/btp/nc_under_modules/marches/delaymanagement/class/exceedingdelay.class.php');
dol_include_once('/btp/nc_under_modules/marches/marche/class/marche.class.php');
dol_include_once('/btp/nc_under_modules/marches/lib/marches.lib.php');

$langs->load('marches');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$mid && $request_method !== 'POST')
	die('ID marche n\'existe pas!');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 	= false;
$object = new ExceedingDelay($db);
$marche = new Marches($db);
$fuser 	= new User($db);
$form 	= new Form($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {
	    $exceeding_date	= trim($_POST['exceeding_date']);
	    $subject 		= trim($_POST['subject']);
	    $observes 		= trim($_POST['observes']);
	    $mid 			= trim(GETPOST('mid', 'int'));

	    if (!$mid || !$exceeding_date || !$subject)
			return;

		if (isset($exceeding_date) && !empty($exceeding_date)) {
	        list($etd, $etm, $ety) = explode("/", $exceeding_date);
	        $exceeding_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    $object->fk_created_by 	= $user->id;
	    $object->fk_marche  	= $mid;
	    $object->exceeding_date = $exceeding_date;
	    $object->subject 		= $subject;
	    $object->observes 		= $observes;

		$getExceeding = $object->create();

		if ($getExceeding) {
		    header('Location: ./exceedingdelay.php?id='. $getExceeding .'&mid='.$mid);
		    die();
		} else {
			header('Location: ./exceedingdelay.php?mid='.$mid);
		    die();
		}
    }
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['mid'] > 0 && $request_method === 'POST') {

	 if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {
	  	$exceeding_date	= trim($_POST['exceeding_date']);
	    $subject 		= trim($_POST['subject']);
	    $observes 		= trim($_POST['observes']);
	    $mid 			= trim(GETPOST('mid', 'int'));

	    if (!$mid || !$exceeding_date || !$subject)
			return;

		if (isset($exceeding_date) && !empty($exceeding_date)) {
	        list($etd, $etm, $ety) = explode("/", $exceeding_date);
	        $exceeding_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    $data = array(
		    'exceeding_date' => $exceeding_date,
		    'subject' 	 	 => $subject,
		    'observes' 		 => $observes
	    );

		$object->update($id, $data);
		header('Location: ./exceedingdelay.php?id='. $id .'&mid='.$mid);
	    die();
	}

	$action = "edit";
}

if ($id) {
	$object->fetch($id);
    $param 		= '&mid='. $mid;
	$upload_dir = $conf->marches->dir_output.'/exceedingdelay/'.get_exdir($object->id, 1, 0, 0, $object, 'marches');
	$modulepart = 'marches';

	$filearray = array();

	// Construit liste des fichiers
	$filearray = dol_dir_list($upload_dir, "files", 0, '', '(\.meta|_preview\.png)$', $sortfield, (strtolower($sortorder)=='desc'?SORT_DESC:SORT_ASC),1);
	$totalsize=0;
	foreach($filearray as $key => $file) {
		$totalsize+=$file['size'];
	}

	include_once DOL_DOCUMENT_ROOT . '/core/tpl/document_actions_pre_headers.tpl.php';
}

if ($request_method === 'POST') {
	if (GETPOST('mid', 'int') && GETPOST('id', 'int')) {	
		header("Location: ./exceedingdelay.php?id=". $id .'&mid='. $mid);
		die();
	}
	var_dump($_POST); die();
}

llxHeader(array(), $langs->trans('ExceedingFile'),'','','','',array('/btp/nc_under_modules/marches/js/marches.js'),array(),0,0);
$marche->fetch($mid);

if ($id > 0 && $action != 'edit') {
	$object->fetch($id);
	$title = $langs->trans("ExecutionFile");
	$head  = marches_prepare_head($marche);
	dol_fiche_head($head, 'execution', $title, 0, '');

	$head_btm = phase_execution_prepare_head($marche);
	dol_fiche_head($head_btm, 'delaymanagement', $langs->trans("ExceedingFile"), 0, '');
	echo $marche->getMarketHeader();

	$fuser->fetch($object->fk_created_by);

	$exceeding_date	= $object->exceeding_date ? dol_print_date($object->exceeding_date,'day') : '';
	$subject		= nl2br($object->subject);
	$observes		= nl2br($object->observes);
	$created_at 	= $object->created_at ? dol_print_date($object->created_at,'dayhoursec') : '';

	print '<table class="border" width="100%">';
	// Created By
	print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $fuser->getNomUrl('1') .'</td></tr>';
	// Created By
	print '<tr><td width="25%">'.$langs->trans("CreatedAt").'</td>';
	print '<td colspan="2">'. $created_at .'</td></tr>';
	// Start date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ExceedingDate").'</td>';
	print '<td colspan="2">'. $exceeding_date .'</td></tr>';
	// Subject
	print '<tr><td valign="top" width="25%" class="fieldrequired">'.$langs->trans("Subject").'</td>';
	print '<td colspan="2">'. $subject .'</td></tr>';
	print '<tr><td valign="top" width="25%">'.$langs->trans("Observation").'</td>';
	print '<td colspan="2">'. $observes .'</td></tr>';
	print '</table>';

	if ($user->id && $user->rights->btp->write_all) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./exceedingdelay.php?action=edit&id='. $id .'&mid='. $mid .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '</div>';
	}

	$modulepart = 'marches';
    $permission = $user->rights->btp->write;
    $param 		            = '&mid='. $mid;
    $relativepathwithnofile = '/exceedingdelay/'.$object->id.'/';

    include_once DOL_DOCUMENT_ROOT . '/core/tpl/document_actions_post_headers.tpl.php';
}

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[] = $langs->trans('CantCreate');
    } else {
		$head  = marches_prepare_head($marche);
		dol_fiche_head($head, 'execution', $langs->trans("ExecutionFile"), 0, '');

		$head_btm = phase_execution_prepare_head($marche);
		dol_fiche_head($head_btm, 'delaymanagement', $langs->trans("ExceedingFile"), 0, '');

		echo $marche->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("ExceedingDate").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="exceeding_date" required="required" />';
        print '</td></tr>';

        print '<tr><td valign="top" class="fieldrequired">'.$langs->trans("Subject").'</td><td>';
        print '<textarea type="text" cols="60" rows="8" name="subject" required="required"></textarea></td></tr>';

        print '<tr><td valign="top" class="fieldrequired">'.$langs->trans("Observation").'</td><td>';
        print '<textarea type="text" cols="60" rows="8" name="observes" required="required"></textarea></td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateExceedingFile") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    }
} else {
	if ($id > 0 && $mid > 0) {
		$object->fetch($id);
		$canedit = ($user->rights->btp->delete || $user->rights->btp->write_all);

		if ($canedit) {
			if ($action == 'edit') {
				$head  = marches_prepare_head($marche);
				dol_fiche_head($head, 'execution', $langs->trans("ExecutionFile"), 0, '');

				$head_btm = phase_execution_prepare_head($marche);
				dol_fiche_head($head_btm, 'delaymanagement', $langs->trans("ExceedingFile"), 0, '');

				echo $marche->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$exceeding_date	= $object->exceeding_date ? dol_print_date($object->exceeding_date,'day') : '';
				$subject		= $object->subject;
				$observes		= $object->observes;
				
		        print '<table class="border" width="100%">';
		        print '<tbody>';

			    print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("ExceedingDate").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $exceeding_date .'" name="exceeding_date" required="required" />';
		        print '</td></tr>';

		        print '<tr><td valign="top" class="fieldrequired">'.$langs->trans("Subject").'</td><td>';
		        print '<textarea type="text" cols="60" rows="8" name="subject" required="required">'. $subject .'</textarea></td></tr>';

		        print '<tr><td valign="top" class="fieldrequired">'.$langs->trans("Observation").'</td><td>';
		        print '<textarea type="text" cols="60" rows="8" name="observes" required="required">'. $observes .'</textarea></td></tr>';

		        print '</tbody></table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
