<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/work_advances/class/work_advances.class.php');
dol_include_once('/btp/material/constraction_site/class/constraction_site.class.php');

$form 		= new Form($db);
$work_advances   = new work_advances($db);
$constraction_site   = new constraction_site($db);

$var = false;
$filter = '';
$td_travaux =  array(1 => 'Travaux 1', 2 => 'Travaux 2' );
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$id 	  = GETPOST('id','int');
$search_qty      		= GETPOST('search_qty');
$search_datec      		= "";
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}
$search_const_site    		= GETPOST('search_const_site');
$search_td_work    		= GETPOST('search_td_work');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_mat      		= '';
$search_datec      		= '';
$search_const_site    		= '';
$search_td_work    		= '';
}
$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datec = '". $db->escape($search_datec)."'\n" : "";
$filter .= (!empty($search_qty) && $search_qty != -1) ? " AND qty = ".$db->escape($search_qty):"";
$filter .= (!empty($search_const_site) && $search_const_site != -1) ? " AND const_site_id = ".$db->escape($search_const_site): "";
$filter .= (!empty($search_td_work) && $search_td_work != -1) ? " AND td_work_id = ".$db->escape($search_td_work): "";


$getwork_advancess = $work_advances->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getwork_advancess == '-1') {
    print_fiche_titre($langs->trans('ListOfwork_advances'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$work_advances->error);
    exit();
}
if ($id > 0) {
	$work_advances->fetch($id);
	llxHeader('', $langs->trans('work_advances'));
	print_fiche_titre($langs->trans("work_advances"));


	print '<table class="border" width="100%">';
	// qty
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
	print '<td colspan="2">'. $work_advances->qty .'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($work_advances->datec,'day') .'</td></tr>';
	// chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("const_site").'</td>';
	$constraction_site->fetch($work_advances->const_site_id);
	print '<td colspan="2">'. $constraction_site->getNomUrl('1') .'</td></tr>';
	//travaux
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("td_work").'</td>';
	print '<td colspan="2">'. $td_travaux[$work_advances->td_work_id] .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '</div>';
}
else {

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('work_advances'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("ListOfwork_advances"));


	dol_fiche_head('', 'work_advances', $langs->trans("ListOfwork_advances"), 1, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("datec"), $_SERVER["PHP_SELF"], 'datec', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("qty"),$_SERVER["PHP_SELF"],"qty", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("const_site"), $_SERVER["PHP_SELF"], 'const_site_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("td_work"), $_SERVER["PHP_SELF"], 'td_work_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	//datec
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec"  readonly="readonly" /> ';
    print '</td>';
	// qty
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_qty" value="'.$search_qty.'">';
	print '</td>';
	// const_site
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_const_site', $constraction_site->getNames(), $search_const_site, 1, 0, 0, 'required="required"');
	print '</td>';
	// td_work
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_td_work', $td_travaux, $search_td_work, 1, 0, 0, 'required="required"');

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($work_advances->rows)) {
		//$createdBy = new User($db);
		foreach($work_advances->rows as $obj) {
			  $qty 				= $obj->qty ;
			  $datec 			= dol_print_date($obj->datec,'day') ;
			  $note 				= $obj->note ;
			  $constraction_site->fetch($obj->const_site_id) ;
			  $td_work            = $td_travaux[$obj->td_work_id];
	
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $work_advances->getNomUrl(1,  $obj->id, $datec);
			print '</td>';
			 
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $constraction_site->getNomUrl('1') .'</td>';
			print '<td align="center">'. $td_work .'</td>';

			print '<td><div style="float: right; margin-top: 8px;">';
			print '<a href="./card.php?action=delete&id='. $obj->id .'" >'.$langs->trans('Delete').'</a>';
			print '</div></td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addwork_advances').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>