<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/index.php
 * \ingroup    market
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
dol_include_once('/btp/lib/tools.lib.php');




// Protection if external user
if (!$user) accessforbidden();

$langs->load('users');

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$tasktab   = GETPOST("tasktab",'int');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
$id_markets = array();
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$action   = GETPOST('action','alpha');
$mid 	  = GETPOST('mid','int');

$search_product = GETPOST('search_product');
$search_dated = GETPOST('search_dated');
$search_datef = GETPOST('search_datef');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_datef = "";
	$search_dated = "";
	$search_product  = "";
	
}


$market = new Market($db);

$product   = new product($db);


llxHeader(array(), $langs->trans('stock de produit'),'','','','',array('/btp/js/btp.js'));

// Filter
$filter  = '';

// Filter
$filter .= (!empty($search_product) && $search_product != -1) ? " AND fk_product =".$db->escape($search_product)."" : "";
$filter .= (!empty($search_product) && $search_product != -1) ? " AND inventorycode is not null" : "";
$filter .= (!empty($search_dated) && !empty($search_datef)) ? " AND datem between '". $db->escape(Tools::convertDateTo($search_dated, 'sql')) ."' and '". $db->escape(Tools::convertDateTo($search_datef, 'sql'))."' " : "";

$numero = $market->Stock_market_product($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter,$mid,$search_product); 


/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur

// Si erreur SQL
/*if ($getMarketList == '-1') {
    print_fiche_titre($langs->trans('ListOfMarkets'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$market->error);
    exit();
}*/

// Show table of vacations
$var 		= true;

$form 		= new FormChild($db);
$formother 	= new FormOther($db);
$formChild 		= new Form($db);


//$num 		= count($market->lines);

	print_barre_liste($langs->trans("stock"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	
	print_liste_field_titre($langs->trans("product"),$_SERVER["PHP_SELF"], "c.rowid", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("date_start"),$_SERVER["PHP_SELF"],"fk_product", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("EndDateP"),$_SERVER["PHP_SELF"],"", '','','align="center"',$sortfield,$sortorder);print_liste_field_titre('',$_SERVER["PHP_SELF"],"", '','','align="center"',$sortfield,$sortorder);
	

	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center">';
	
	print $form->select_produits($search_product,'search_product', 0, 30, 0, 0, 0,'',1);
    print '</td>';

	// date debut
    
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat datepicker" autocomplete="off"  type="text" size="14" name="search_dated" value="'.$search_dated.'">';
	
	print '</td>';

	// date fin
	  	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat datepicker" autocomplete="off"  type="text" size="14" name="search_datef" value="'.$search_datef.'">';
	print '</td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
		print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';

	print "</tr>\n";print '</form>';

print '</table>';
if (!empty($search_product)) {
	$product->fetch($search_product);
	// Lines
	if (!empty($market->lines)) {
		foreach($market->lines as $line) {
        $idmark= explode("-", $line->inventorycode);
	        if(!empty($idmark[0]) && !in_array($idmark[0], $id_markets)){
				$id_markets[]=$idmark[0];
	        }
		}
	}

print '</br>';
print '</table>';
if(!empty($search_product)){
$num = $market->StockBydateProduct($search_product, $db->escape(Tools::convertDateTo($search_dated, 'sql')),$db->escape(Tools::convertDateTo($search_datef, 'sql')));
//var_dump($market->lines);
// Show table of stock
	if($num){

		$dates= array();
		foreach($market->lines as $line) 
		{
			if( !in_array(dol_print_date($line->datem,'day'), $dates) && !empty($line->inventorycode) && $line->value<0){
				$dates[]=dol_print_date($line->datem,'day');
	        }
	    }
	}

print '</table>';
	print '</form>';
	$dates_data = array();

	if($dates){
	foreach ($dates as $date) {
		foreach($market->lines as $line) 
		{
			if($date == dol_print_date($line->datem,'day')){
			if(!empty($line->inventorycode)){
			/*	if(!array_key_exists('entry'.$date, $dates_data))
					$dates_data['entry'.$date] = $line->value;
				else
					$dates_data['entry'.$date] += $line->value;
			}
			else{*/
				$idmark= explode("-", $line->inventorycode);
			foreach ($id_markets as  $val) {
				if($idmark[0]==$val){
					if(!array_key_exists($val.$date, $dates_data))
						$dates_data[$val.$date] = (-1*$line->value);
					else
						$dates_data[$val.$date] += (-1*$line->value);}
			}
		}
		}
		}
	}
	}


	$market1 = new Market($db);
	print'<div style="width:100%;overflow-x:scroll;" >';
	print '<table class="border" style="min-width:100%;width:auto;">';
	print "<tr class=\"liste_titre\" >";
	 print '<th style="text-align: center" > Date/Marchés </th>';
	 print '<th style="text-align: center" > Entrée </th>';
	 print '<th style="text-align: center"> NBC </th>';
	 print '<th style="text-align: center"> NBL </th>';
	 foreach ($id_markets as  $val) {
			$market1->fetch($val);
			 print '<th style="text-align: center"> '.$market1->code.' </th>';
		}
		print '<th style="text-align: center"> Stock </th>';
		print '<th style="text-align: center"> P.U </th>';
		print '<th style="text-align: center"> P.T </th>';
	print '</tr>';
	if($num){

		$mark=array();
		$stock = 0;
		$pu = 0 ;
		$pt = 0;
		foreach($market->lines as $line) 
		{
			
            $var = !$var;
        	$idmark= explode("-", $line->inventorycode);
        
        	print '<tr '.$bc[$var].'>';

        	
        	if(empty($line->inventorycode))
        	{
			print '<td style="text-align: center" >'. dol_print_date($line->datem,'dayhour').'</td>';
        		$stock += $line->value;
        		print '<td style="text-align: center" >'. $line->value.'</td>';
    			if(!array_key_exists('entry', $mark)){
					$mark['entry'] =$line->value;
				}
				else
					$mark['entry'] +=$line->value;
				dol_include_once('/btp/material/stock/class/nb.class.php');
					$nb_btp = new Nb($db);
					$nb_btp->fetch($line->id);
					print '<td style="text-align: center" >'. $nb_btp->nbc.'</td>';
					print '<td style="text-align: center" >'. $nb_btp->nbl.'</td>';
					if($nb_btp->pu)
						$pu = $nb_btp->pu;
					else
						$pu = $product->pmp;
					foreach ($id_markets as  $val) {
						print '<td style="text-align: center" ></td>';
					}
					print '<td style="text-align: center" >'.$stock.'</td>';
					print '<td style="text-align: center" >'.price($pu).'</td>';
					print '<td style="text-align: center;white-space: nowrap;" width="30%">'.price($stock*$pu).'</td>';
					$pt += $stock*$pu;
			print '</tr>';
			}
        else
        	{
        			$date = dol_print_date($line->datem,'day');
        		if(in_array($date, $dates)){
        		print '<td style="text-align: center" >'. dol_print_date($line->datem,'day').'</td>';
        	print '<td style="text-align: center" ></td>';
    		print '<td style="text-align: center" ></td>';
    		print '<td style="text-align: center" ></td>';
    		$key = array_search($date, $dates);
    			 unset($dates[$key]);
    		foreach ($id_markets as  $val) {
					if(array_key_exists($val.$date, $dates_data))
						{print '<td style="text-align: center" >'. $dates_data[$val.$date].'</td>';
							$stock -= $dates_data[$val.$date];

						if(!array_key_exists($idmark[0], $mark))
							$mark[$val] =$dates_data[$val.$date];
						else
							$mark[$val] +=$dates_data[$val.$date];
						
					  unset($dates_data[$val.$date]);
					}
					else
						print '<td style="text-align: center" ></td>';
				}
			print '<td style="text-align: center" >'.$stock.'</td>';
			print '<td style="text-align: center" >'.price($pu).'</td>';
					print '<td style="text-align: center;white-space: nowrap;" >'.price($stock*$pu).'</td>';
					$pt += $stock*$pu;
			print '</tr>';
		}
			}
       } 

       $var = !$var;
        print '<tr '.$bc[$var].'>';
        print '<td style="text-align: center" ><strong>Total</strong></td>';
         print '<td style="text-align: center" ><strong>'.$mark['entry'].'</strong></td>';
         print '<td style="text-align: center" ></td>';
    		print '<td style="text-align: center" ></td>';
         foreach ($id_markets as  $val) {
		 print '<td style="text-align: center" ><strong>'.$mark[$val].'</strong></td>';
		}
		print '<td style="text-align: center" ><strong>'.$stock.'</strong></td>';
		print '<td style="text-align: center" ></td>';
					print '<td style="text-align: center;white-space: nowrap;" ><strong>'.price($pt).'</strong></td>';
		print '</tr>';
		}
	
else{
print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';

}

print '</table>';
print '</div>';
print '<form method="post" action="card.php">'."\n";
	print '<input type="hidden" name="action" value="xsl">';
	print '<input type="hidden" name="search_product" value="'.$search_product.'">';
	print '<input type="hidden" name="search_dated" value="'.$search_dated.'">';
	print '<input type="hidden" name="search_datef" value="'.$search_datef.'">';
	print '<div style="float: right; margin-top: 8px;">';
	print '<input type="submit" class="button" name="submit" value="Générer Le XSL">';
	print '</div>';
	
print '</form>';
}
}

llxFooter();

$db->close();

?>