<?php
/* Copyright (C) Yassine Belkaid y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/market/stock_const/class/stock_const.class.php
 * \ingroup stock_const
 * \brief   This file is stock_const CRUD class file
 *
 */

dol_include_once('/btp/db/nxdb.class.php');

class stock_const extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

	public $datem;
	public $value;
	public $fk_product 	;
	public $inventorycode;
	public $fk_entrepot;
	public $rows = array();

	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'stock_const';
	/**
	 * @var string Name of table without pgeneral_fee_marcheix where object is stored
	 */
	public $table_element = 'stock_const';

	public $now;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = date('Y-m-d');//$this->now->format('Y-m-d');
		$this->updated_at= $this->now;
		return 1;
	}


	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id = null, $ref = null, $cid)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/market/stock_const/index.php?id='. $id .'&cid='.$cid,1).'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

    public function getNomUrl2($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/material/stock/add_stock_list.php?id='. $id,1).'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->datem= $this->datem ? $this->db->escape($this->datem): null;
		$this->num = $this->num ? $this->db->escape($this->num): null;
		$this->value = $this->value ? $this->db->escape($this->value): null;
		$this->fk_product = $this->fk_product ? $this->db->escape($this->fk_product): null;
		$this->unit_type_id = $this->unit_type_id ? $this->db->escape($this->unit_type_id): null;
		$this->inventorycode	= $this->inventorycode ? $this->db->escape($this->inventorycode): null;
		$this->created_by = $this->created_by ? $this->db->escape($this->created_by): null;
		$this->created_at = $this->now;
		
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'stock_const' . ' (datem,num,value,';
		$sql .= 'fk_product,unit_type_id,inventorycode,created_by,created_at,updated_at, entity) ';
		$sql .= 'VALUES ("'.$this->datem.'",'.$this->num.', ';
		$sql .=	 $this->value.','.$this->fk_product.', '.$this->unit_type_id.', ';
		$sql .=	 $this->inventorycode.', '.$this->created_by.',"'.$this->created_at.'","'. $this->updated_at .'", '. $conf->entity .')';

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error stock_const ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			die();
			return -1;
		} else {
			$this->db->commit();
		
			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'stock_mouvement';
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		//$sql .= ' AND entity = '. $conf->entity;
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->id 			= $obj->rowid;
			  $this->datem 			= $this->db->jdate($obj->datem);
			  $this->value          = $obj->value ;
			  $this->fk_product 	= $obj->fk_product ;
			  $this->inventorycode	= $obj->inventorycode ;
			  $this->fk_entrepot	= $obj->fk_entrepot ;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($cid = null,$num, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $ignore_id = false)
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$ignore_id)
			$sql = "SELECT * FROM ". MAIN_DB_PREFIX ."stock_mouvement
			WHERE `inventorycode` LIKE '%".$num."%'";


		if (!empty($filter)) {
			$sql .= $filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}
		//die($sql);
		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				  $line->id 			= $obj->rowid;
				  $line->datem 			= $this->db->jdate($obj->datem);
				  $line->value          = $obj->value ;
				  $line->fk_product 	= $obj->fk_product ;
				  $line->inventorycode	= $obj->inventorycode ;
				  $line->fk_entrepot	= $obj->fk_entrepot ;
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'stock_mouvement' . ' SET  ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = rtrim($sql, ',');
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();
		
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();
			$this->Update_stock($this->fk_product,$this->fk_entrepot);
			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'stock_mouvement' .' WHERE rowid = ' . (int)$id;
		$resql 	= $this->db->query($sql);
		//$resql 	= 1;

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();
			$this->Update_stock($this->fk_product,$this->fk_entrepot);
			return 1;
		}
	}

	public function Update_stock($fk_product,$entrepot_id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();
		$stock=0;
		$sql = "SELECT * FROM ". MAIN_DB_PREFIX ."stock_mouvement
			WHERE fk_entrepot = ".$entrepot_id." AND fk_product = ".$fk_product;
		//die($sql);
		$resql 	= $this->db->query($sql);
		
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				  $stock = $stock+(int)$obj->value ;
			}
			$this->db->free($resql);
		} 
		//echo($stock);
		//die();
		$sql = "UPDATE ".MAIN_DB_PREFIX."product_stock SET reel = ".$stock;
		$sql.= " WHERE fk_entrepot = ".$entrepot_id." AND fk_product = ".$fk_product;
		
		$resql=$this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();
			$sql = "UPDATE ".MAIN_DB_PREFIX."product SET stock = ".$stock;
			$sql.= " WHERE rowid = ".$fk_product;
			$resql=$this->db->query($sql);
				if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();
			return 1;
		}
	}

	}

	public function getStatData($cid = false, $market_id = 0)
    {
    	global $langs;
    	$this->fetchAll(($cid ?: null), '', '', 0, 0, '', ($cid ? false : true));
    	$countAmount = 0;

    	foreach ($this->rows as $key => $obj)
    		$countAmount += ($obj->price*$obj->value);

    	$object 		= new stdClass();
    	$object->number = (!$cid && $market_id ? 0 : count($this->rows));
    	$object->cost 	= (!$cid && $market_id ? 0 : $countAmount);
    	$object->label 	= $langs->trans('stock_const');
    	$object->url 	= (int)$cid ? dol_buildpath('/btp/market/stock_const/index.php?cid='. $cid .'&mid='. $market_id,1) : '';

    	return $object;
    }
}
?>