<?php
/* Copyright (C) 2015 Yassine Belkaid   <y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	    \file       htdocs/certificates/card.php
 *      \ingroup    certificates
 *		\brief      Page of certificates
 */

$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/market/market/class/market.class.php');
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
dol_include_once('/btp/lib/tools.lib.php');


$id_product = GETPOST("search_product");
$dated = GETPOST("search_dated");
$datef = GETPOST("search_datef");
$action = GETPOST('action');


/**
 * Actions
 */
$market = new Market($db);
$product = new product($db);


function cleanData(&$str)
  {
    $str = preg_replace("/\t/", "\\t", $str);
    $str = preg_replace("/\r?\n/", "\\n", $str);
    if(strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
  }

if ( !empty($id_product) && !empty($dated) && !empty($datef) && $action == "xsl") {
	dol_include_once('/btp/material/stock/tpl/stock_xsl.php');
	
	$filename = "etat_stock-".$product->ref.$dated.$datef.".xls";

  header("Content-Disposition: attachment; filename=\"$filename\"");
  header("Content-Type: application/vnd.ms-excel");

  $flag = false;
  if($data){
  foreach($data as $row) {
    if(!$flag) {
      // display field/column names as first row
      echo implode("\t", array_keys($row)) . "\r\n";
      $flag = true;
    }
    array_walk($row, __NAMESPACE__ . '\cleanData');
    echo implode("\t", array_values($row)) . "\r\n";
  }
  }
  exit;

}

if (!empty($id_product) && !empty($dated) && !empty($datef) && $action == "pdf") {
	dol_include_once('/btp/material/stock/pdf/pdf.lib.php');
    $pdf->SetFont('times', '', 13, '', true);
    $pdf->AddPage();

	
	$today 			= date('d/m/Y');
	// require template
	dol_include_once('/btp/material/stock/tpl/etat_stock.tpl.php');
    /*echo($html);
    die();*/
	//$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
    $pdf->writeHTML($html, true, false, true, false, '');
    ob_end_clean();
	$pdf->Output('etat_stock-'.$product->ref.$dated.$datef.'.pdf', 'I');
	die();
}



llxFooter();

$db->close();