<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/index.php
 * \ingroup    market
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
dol_include_once('/btp/market/stock_const/class/stock_const.class.php');
dol_include_once('/btp/material/stock/class/nb.class.php');




// Protection if external user
if (!$user) accessforbidden();

$langs->load('users');

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$tasktab   = GETPOST("tasktab",'int');
$page = GETPOST("page",'int');
$id 	  = GETPOST('id','int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
$id_markets = array();
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$action   = GETPOST('action','alpha');
$mid 	  = GETPOST('mid','int');

$search_product = GETPOST('search_product');
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_datef = "";
	$search_datec = "";
	$search_product = "";
	
}


$market = new Market($db);
$stock_const = new stock_const($db);
$product   = new product($db);
$nb_btp = new Nb($db);
$numero = '';



// Filter
$filter  = '';

// Filter
$filter .= (!empty($search_product) && $search_product != -1) ? " AND fk_product =".$db->escape($search_product)."" : "";
$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datem Like '%". $db->escape($search_datec)."%'\n" : "";
$filter .= " AND value > 0";
if(!empty($search_product) && $search_product != -1){
 $product->fetch($search_product);


$numero = $market->Stock_market_product($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter,$mid,$search_product);
if (!empty($numero) && $action == "xsl" ) {
$filename="liste_Entree_Stock.xls";
      dol_include_once('/btp/material/stock/tpl/add_stock_exl.php');
 die();
 
}
}
llxHeader(array(), $langs->trans('stock de produit'),'','','','',array('/btp/js/btp.js'));
/*************************************
echo "<br><br><br>".$filter;
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur

// Show table of vacations
$var 		= true;


$formChild 		= new FormChild($db);


//$num 		= count($market->lines);

	print_barre_liste($langs->trans("stockadd"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
if ($id) {
	$stock_const->fetch($id);
	 $nb_btp->fetch($stock_const->id);
	$product->fetch($stock_const->fk_product);

	print '<table class="border" width="100%">';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($stock_const->datem,'dayhour').'</td></tr>';
	// produit
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Product").'</td>';
	print '<td colspan="2">'. $product->getNomUrl(1) .'</td></tr>';
	// quantité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
	print '<td colspan="2">'. $stock_const->value .'</td></tr>';
	// PU
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("PU").'</td>';
	print '<td colspan="2">'. $nb_btp->pu .'</td></tr>';
	// NBC
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("NBC").'</td>';
	print '<td colspan="2">'. $nb_btp->nbc .'</td></tr>';
	// NBL
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("NBL").'</td>';
	print '<td colspan="2">'. $nb_btp->nbl .'</td></tr>';
	
	
	
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./add_stock_list.php" class="butAction">'.$langs->trans('Cancel').'</a>';
	print '<a href="./add_stock.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '<a href="./add_stock_list.php?action=delete&id='. $id .'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';

	if ($action == 'delete')
		print $formChild->formconfirm("add_stock.php?id=".$id, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);

}
else {
	print '<div style="float: right;margin-bottom: 6px;">';
	print '<a href="./add_stock.php" class="butAction">'.$langs->trans('Addstock_const').'</a>';
	print '</div>';
	print '<div style="float: right; ">';
	   print '<form style="background: transparent;" method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_product" value="'. $search_product .'" type="hidden" />';

print '<input name="action" value="xsl" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';   
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	

	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center">';
	
	print $formChild->select_produits($search_product,'search_product', 0, 30, 0, 0, 0,'',1);
    print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
		print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';

	print "</tr>\n";print '</form>';

print '</table>';
if (!empty($numero)) {
	
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="cid" value="'. $cid .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Date"), $_SERVER["PHP_SELF"], 'datem', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("NBC"), $_SERVER["PHP_SELF"], 'pu', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("NBL"), $_SERVER["PHP_SELF"], 'pu', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("qty"),$_SERVER["PHP_SELF"], "value", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("PU"), $_SERVER["PHP_SELF"], 'pu', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("total"), $_SERVER["PHP_SELF"], 'total', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	/*// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	
	//datec
	print '<td class="liste_titre" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec" readonly="readonly" /> ';
    print '</td>';
    // qty
    print '<td class="liste_titre" align="center"></td>';
    print '<td class="liste_titre" align="center"></td>';
	print '<td class="liste_titre" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="1" name="search_qty" value="'.$search_qty.'">';
	print '</td>';
	// unit_type
	print '<td class="liste_titre" align="center"></td>';
	print '<td class="liste_titre" align="center"></td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";*/

	// Lines
	if($numero>0){

	foreach($market->lines as $line) {
			  $datec 			= dol_print_date($line->datem,'dayhour') ;
			  $qty 	   		    = $line->value ;
			 $nb_btp = new Nb($db);
			 $nb_btp->fetch($line->id);
			 	$pu = ($nb_btp->pu)?$nb_btp->pu:$product->pmp;
			print '<tr >';
			 
			print '<td align="center">'. $stock_const->getNomUrl2(0,$line->id,$datec) .'</td>';
			print '<td align="center">'. $nb_btp->nbc .'</td>';
			print '<td align="center">'. $nb_btp->nbl .'</td>';
			print '<td align="center">'. $qty .'</td>';
				
			print '<td align="center">'. price($pu) .'</td>';
			$t = $pu * $qty;
			print '<td align="center">'. price($t) .'</td>';
			
			print '<td>&nbsp;</td>';
			print '</tr>'."\n";
		}
		

	
	}
	print '</table>';
	print '</form>';
	
}


}
llxFooter();

$db->close();

?>