<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/receptions/class/receptions.class.php');
dol_include_once('/btp/material/machine/class/machine.class.php');
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
require_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';



$societe     = new Societe($db);
$categories =  array('1' => 'categorie 1', '2'=> 'categorie 2' );

// Get parameters
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$receptions = new receptions($db);

    if (!$error) {
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $receptions->datec         = $ety.'-'.$etm.'-'.$etd ;
        }
          $receptions->tva            = trim(GETPOST('tva_'));
          $receptions->note            = trim(GETPOST('note_'));
          $receptions->cat_id            = trim(GETPOST('cat_id_'));
          $receptions->ref     = trim(GETPOST('ref_'));
          $receptions->purchase_order     = trim(GETPOST('purchase_order_'));
          $receptions->delivery_order     = trim(GETPOST('delivery_order_'));
          $receptions->supplier_id  = trim(GETPOST('supplier_id_'));
          $receptions->company_id  = trim(GETPOST('company_id_'));
           $receptions->const_site_id  = trim(GETPOST('const_site_id_'));
          $receptions->created_by     = $user->id;
            //if(!$receptions->check_mat($receptions->mat)){
                    $receptionsID = $receptions->create();
            
                    // If no SQL error we redirect to the request card
                    if ($receptionsID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php');
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$receptions->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$receptions->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->btp->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $receptions_id = (int) GETPOST('receptions_id', 'int');

    if (!$receptions_id || $receptions_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $receptions = new receptions($db);
    $receptions->fetch($receptions_id);

   // $canedit = ($user->rights->btp->write || $user->rights->btp->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $datec = '';
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $datec         = $ety.'-'.$etm.'-'.$etd ;
        }
        $data = array(
          'datec'  =>$datec,
          'tva'    =>trim(GETPOST('tva_')),
          'note'    =>trim(GETPOST('note_')),
          'cat_id'    =>trim(GETPOST('cat_id_')),
          'ref' =>trim(GETPOST('ref_')),
          'purchase_order' =>trim(GETPOST('purchase_order_')),
          'delivery_order' =>trim(GETPOST('delivery_order_')),
          'supplier_id'  =>trim(GETPOST('supplier_id_')),
          'const_site_id'  =>trim(GETPOST('const_site_id_')),
          'company_id'  =>trim(GETPOST('company_id_'))
        );

		$getreceptionsID = $receptions->update($receptions_id, $data);
        
                if ($getreceptionsID > 0) {
                    header('Location: ./index.php?id='.$receptions_id);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $receptions_id .'&action=edit&error=SQL_Create&msg='.$receptions->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new receptions($db);
	//$canedit = ($user->rights->btp->write_all || $user->rights->btp->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php');
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$receptions     = new receptions($db);
$machine     = new machine($db);
$ConstructionSite   = new ConstructionSite($db);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('receptions'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addreceptions'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

         //reference 
        print '<tr><td>'.$langs->trans("ref").'</td><td>'; 
        print '<input type="text" value="" name="ref_" required="required" />';
        print '</td></tr>';

       //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //tva
        print '<tr><td class="fieldrequired">'.$langs->trans("tva").'</td><td>';
        print '<input type="number" value="" name="tva_" required="required" />';
        print '</td></tr>';

        //note
        print '<tr><td class="fieldrequired">'.$langs->trans("note").'</td><td>';
        print '<input type="text" value="" name="note_" required="required" />';
        print '</td></tr>';

        //engin
        print '<tr><td class="fieldrequired">'.$langs->trans("cat").'</td><td>';
         $machines  = array('1' => 'categorie 1', '2'=> 'categorie 2' );
        print $form->selectarray('cat_id_', $machines,(GETPOST('cat_id_') ? GETPOST('cat_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

         //prix 
        print '<tr><td>'.$langs->trans("purchase_order").'</td><td>'; 
        print '<input type="text" value="" name="purchase_order_" required="required" />';
        print '</td></tr>';

        //prix 
        print '<tr><td>'.$langs->trans("delivery_order").'</td><td>'; 
        print '<input type="text" value="" name="delivery_order_" required="required" />';
        print '</td></tr>';
        
         //produit
        print '<tr><td>'.$langs->trans("company").'</td><td>'; 
        print $form->select_thirdparty(null,'company_id_');
        print '</td></tr>';

        //fournisseur 
        print '<tr><td>'.$langs->trans("supplier").'</td><td>'; 
        print  $form->select_thirdparty(null,"supplier_id_",'s.fournisseur=1');
        print '</td></tr>';

        //Chantier 
        print '<tr><td>'.$langs->trans("const_site").'</td><td>'; 
        $const_sites = $ConstructionSite->getNames();
        print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createreceptions") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $receptions->fetch($id);

			//$canedit = ($user->rights->btp->delete || $user->rights->btp->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEnddatecP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {
                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'receptionss', $langs->trans("receptions"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="receptions_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';



        //chantier 
        print '<tr><td>'.$langs->trans("ref").'</td><td>'; 
        print '<input type="text" value="'.$receptions->ref.'" name="ref_" required="required" />';
        print '</td></tr>';

        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" value="'.dol_print_date($receptions->datec,'day').'" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';


        //tva
        print '<tr><td class="fieldrequired">'.$langs->trans("tva").'</td><td>';
        print '<input type="number" value="'.$receptions->tva.'" name="tva_" required="required" />';
        print '</td></tr>';

        //note
        print '<tr><td class="fieldrequired">'.$langs->trans("note").'</td><td>';
        print '<input type="text" value="'.$receptions->note.'" name="note_" required="required" />';
        print '</td></tr>';

        //engin
        print '<tr><td class="fieldrequired">'.$langs->trans("machine").'</td><td>';
         $machines = array('1' => 'categorie 1', '2'=> 'categorie 2' );
        print $form->selectarray('cat_id_', $machines,(GETPOST('cat_id_') ? GETPOST('cat_id_') : $receptions->cat_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //chantier 
        print '<tr><td>'.$langs->trans("purchase_order").'</td><td>'; 
        print '<input type="number" value="'.$receptions->purchase_order.'" name="purchase_order_" required="required" />';
        print '</td></tr>';

        //chantier 
        print '<tr><td>'.$langs->trans("delivery_order").'</td><td>'; 
        print '<input type="number" value="'.$receptions->delivery_order.'" name="delivery_order_" required="required" />';
        print '</td></tr>';

         //produit
        print '<tr><td>'.$langs->trans("company").'</td><td>'; 
        print $form->select_thirdparty($receptions->company_id,'company_id_');
        print '</td></tr>';


        //fournisseur 
        print '<tr><td>'.$langs->trans("supplier").'</td><td>'; 
        print  $form->select_thirdparty($receptions->supplier_id,"supplier_id_",'s.fournisseur=1');
        print '</td></tr>';

                //Chantier 
        print '<tr><td>'.$langs->trans("const_site").'</td><td>'; 
        $const_sites = $ConstructionSite->getNames();
        print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : $receptions->const_site_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';



                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->btp->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>