<?php
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class machine extends Commonobject{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
  public $id;
  public $code;
  public $type;
  public $type_machine;
  public $serie;
  public $regigster_num;
  public $year;
  public $chassis_num;
  public $avg_consomation;
  public $location_rate;
  public $immo_rate ;
  public $couthoraireengin ;
  public $machine_mark_id ;
  public $machine_cat_id ;
  public $counter_type_id ;
  public $unit_type_id 	;
  public $driver_id ;
  public $const_site_id	 ;
  public $created_by ;
  public $created_at ;
  public $updated_at ;
  public $rows = array();
	public $table_element = 'machine';

	public $now;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = date('Y-m-d');//$this->now->format('Y-m-d');
		return 1;
	}


	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : $this->regigster_num;
        $id  	= ($id  ?: $this->id);
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/material/machine/index.php?id='.$id,1) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        if ($setRef != "") {
        	$result = $link."<div class='icon-empty_folder mainvmenu'></div>  ".$setRef.$linkend;
        }else{
        	$result = "-";
        }
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
	  $this->code = $this->code ? $this->db->escape($this->code): null;
	  $this->type= $this->type ? $this->db->escape($this->type): null;
	  $this->type_machine= $this->type_machine ? $this->db->escape($this->type_machine): null;
	  $this->serie= $this->serie ? $this->db->escape($this->serie): null;
	  $this->regigster_num = $this->regigster_num ? $this->db->escape($this->regigster_num): null;
	  $this->year = $this->year ? $this->db->escape($this->year): null;
	  $this->chassis_num = $this->chassis_num ? $this->db->escape($this->chassis_num): null;
	  $this->avg_consomation = $this->avg_consomation ? $this->db->escape($this->avg_consomation): null;
	  $this->location_rate = $this->location_rate ? $this->db->escape($this->location_rate): null;
	  $this->immo_rate = $this->immo_rate ? $this->db->escape($this->immo_rate): null;
	  $this->couthoraireengin = $this->couthoraireengin ? $this->db->escape($this->couthoraireengin): null;
	  $this->machine_mark_id = $this->machine_mark_id ? $this->db->escape($this->machine_mark_id): null;
	  $this->machine_cat_id = $this->machine_cat_id ? $this->db->escape($this->machine_cat_id): null;
	  $this->counter_type_id = $this->counter_type_id ? $this->db->escape($this->counter_type_id): null;
	  $this->unit_type_id = $this->unit_type_id ? $this->db->escape($this->unit_type_id): null;
	  $this->driver_id = $this->driver_id ? $this->db->escape($this->driver_id): null;
	  $this->const_site_id	= $this->const_site_id ? $this->db->escape($this->const_site_id): null;
	  $this->created_by = $this->created_by ? $this->db->escape($this->created_by): null;
	  $this->created_at = $this->now;
	// Insert request
	$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'machine' . ' (code,type,type_machine,serie,regigster_num,';
	$sql .= 'year,chassis_num,avg_consomation,location_rate,immo_rate,couthoraireengin,machine_mark_id,machine_cat_id,';
	$sql .= 'counter_type_id,unit_type_id,driver_id,const_site_id,created_by,created_at) ';
	$sql .= 'VALUES ("'.$this->code.'", "'.$this->type.'", '.$this->type_machine.', "'.$this->serie.'", "'.$this->regigster_num.'",';
	$sql .=	$this->year.', "'.$this->chassis_num.'", '.$this->avg_consomation.', '.$this->location_rate.',';
	$sql .=	$this->immo_rate.','.$this->couthoraireengin.', '.$this->machine_mark_id.', '.$this->machine_cat_id.', '.$this->counter_type_id.',';
	$sql .=	$this->unit_type_id.', '.$this->driver_id.', '.$this->const_site_id.', '.$this->created_by.',"';
	$sql .=	$this->created_at.'")';
	//die($sql);
	// echo $sql."<br>";
	$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error machine ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			die();
			return -1;
		} else {
			
			$this->db->commit();
			return 1;
			//return $this->getLasInsrtedId();
		}
	}

/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'machine';
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->id 			= $obj->rowid;
			  $this->code 			= $obj->code ;
			  $this->type 			= $obj->type ;
			  $this->type_machine 	= $obj->type_machine ;
			  $this->serie 			= $obj->serie ;
			  $this->regigster_num 	= $obj->regigster_num ;
			  $this->year 			= $obj->year ;
			  $this->chassis_num 	= $obj->chassis_num ;
			  $this->avg_consomation = $obj->avg_consomation ;
			  $this->location_rate 	= $obj->location_rate ;
			  $this->immo_rate 		= $obj->immo_rate ;
			  $this->couthoraireengin 		= $obj->couthoraireengin ;
			  $this->machine_mark_id = $obj->machine_mark_id ;
			  $this->machine_cat_id = $obj->machine_cat_id ;
			  $this->counter_type_id = $obj->counter_type_id ;
			  $this->unit_type_id 	= $obj->unit_type_id ;
			  $this->driver_id 		= $obj->driver_id ;
			  $this->const_site_id	= $obj->const_site_id ;
			  $this->created_by 	= $obj->created_by ;
			  $this->created_at 	= $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'machine';

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}
  if(!empty($limit)){
         $sql.= " limit  ".$limit ;
		}
		
		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
					$line->id 			 = $obj->rowid;
					$line->code 			= $obj->code ;
				  $line->type 			= $obj->type ;
				  $line->type_machine 	= $obj->type_machine ;
				  $line->serie 			= $obj->serie ;
				  $line->regigster_num 	= $obj->regigster_num ;
				  $line->year 			= $obj->year ;
				  $line->chassis_num 	= $obj->chassis_num ;
				  $line->avg_consomation = $obj->avg_consomation ;
				  $line->location_rate 	= $obj->location_rate ;
				  $line->immo_rate 		= $obj->immo_rate ;
				  $line->couthoraireengin 		= $obj->couthoraireengin ;
				  $line->machine_mark_id = $obj->machine_mark_id ;
				  $line->machine_cat_id = $obj->machine_cat_id ;
				  $line->counter_type_id = $obj->counter_type_id ;
				  $line->unit_type_id 	= $obj->unit_type_id ;
				  $line->driver_id 		= $obj->driver_id ;
				  $line->const_site_id	= $obj->const_site_id ;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
					$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}



	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'machine' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
			$now = new \DateTime("now");
			$now 		 = $now->format('Y-m-d');
			$sql .= '`updated_at` = "'. $now.'"' ;

		//$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'machine' .' WHERE rowid = ' . $this->id;
		$resql 	= $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}



    public function getMats()
    {
    	$this->fetchAll();
    	$camions = array();

    	if (count($this->rows))
    	foreach ($this->rows as $key => $line) {
			$camions[$line->id] = $line->code;    		
    	}

    	return $camions;
    }

    public function check_mat($mat)
    {
    	$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'machine WHERE regigster_num ="'.$mat.'"';
    	$resql 		 = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			if($num > 0)
				return true;
			$this->db->free($resql);
    	}

    	return false;
    }

    public function getMat($id)
    {
    	$sql = 'SELECT regigster_num FROM ' . MAIN_DB_PREFIX . 'machine WHERE rowid='.$id;
    	$resql = $this->db->query($sql);
    	$mat = '';
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$mat = $obj->regigster_num;
			}
			$this->db->free($resql);
    	}

    	return $mat;
    }

    /**
     * get intern machines
     */
    public function load_state_board()
	{
		global $conf, $user;

		$this->nb=array();

		$sql = "SELECT count(m.rowid) as nb";
		$sql.= " FROM ".MAIN_DB_PREFIX. $this->table_element ." as m WHERE m.type_machine = 1";

		$resql=$this->db->query($sql);
		
		if ($resql) {
			while ($obj=$this->db->fetch_object($resql)) {
				$this->nb["machineinterns"]=$obj->nb;
			}
            $this->db->free($resql);
			return 1;
		}
		else {
			dol_print_error($this->db);
			$this->error=$this->db->error();
			return -1;
		}
	}
	public function findNummarche()
{
$sql = 'SELECT regigster_num ,rowid ';
$sql.= ' FROM '. MAIN_DB_PREFIX .'machine';

$this->db->begin();
		$resql = $this->db->query($sql);
		if($resql){
			$numrows = $this->db->num_rows($resql);
			if($numrows){
				while ($obj = $this->db->fetch_object($resql)) {
					$line = new stdClass;
									$line->id 			 = $obj->rowid;

					$line->regigster_num 			 = $obj->regigster_num;
				


					$this->rows[] = $line;
				}
				return $this->rows;
			}
			return false;
		}
		return false;
}


}
?>