<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/lubricant_consom/class/lubricant_consom.class.php');
dol_include_once('/btp/material/lubricant/class/lubricant.class.php');
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
dol_include_once('/btp/material/machine/class/machine.class.php');
dol_include_once('/btp/lib/machine.lib.php');

// Get parameters
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$mid      = GETPOST('mid', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$lubricant_consom = new lubricant_consom($db);

    if (!$error) {
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $lubricant_consom->datec         = $ety.'-'.$etm.'-'.$etd ;
        }
          $lubricant_consom->num            = trim(GETPOST('num_'));
          $lubricant_consom->price          = trim(GETPOST('price_'));
          $lubricant_consom->qty            = trim(GETPOST('qty_'));
          $lubricant_consom->lubricant_id   = trim(GETPOST('lubricant_id_'));
          $lubricant_consom->machine_id     = (int)$mid;
          $lubricant_consom->const_site_id  = trim(GETPOST('const_site_id_'));
          $lubricant_consom->created_by     = $user->id;
            //if(!$lubricant_consom->check_mat($lubricant_consom->mat)){
                    $lubricant_consomID = $lubricant_consom->create();
            
                    // If no SQL error we redirect to the request card
                    if ($lubricant_consomID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php?mid='.$mid);
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$lubricant_consom->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$lubricant_consom->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->btp->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $lubricant_consom_id = (int) GETPOST('lubricant_consom_id', 'int');

    if (!$lubricant_consom_id || $lubricant_consom_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $lubricant_consom = new lubricant_consom($db);
    $lubricant_consom->fetch($lubricant_consom_id);

   // $canedit = ($user->rights->btp->write || $user->rights->btp->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $datec = '';
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $datec         = $ety.'-'.$etm.'-'.$etd ;
        }
        $data = array(
          'datec'  =>$datec,
          'num'    =>trim(GETPOST('num_')),
          'price' =>trim(GETPOST('price_')),
          'qty'  =>trim(GETPOST('qty_')),
          'lubricant_id' =>trim(GETPOST('lubricant_id_')),
          'machine_id' =>(int)$mid,
          'const_site_id'  =>trim(GETPOST('const_site_id_')),
          'updated_at'    =>$now
        );

		$getlubricant_consomID = $lubricant_consom->update($lubricant_consom_id, $data);
        
                if ($getlubricant_consomID > 0) {
                    header('Location: ./index.php?id='.$lubricant_consom_id.'&mid='.$mid);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $lubricant_consom_id .'&action=edit&error=SQL_Create&msg='.$lubricant_consom->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new lubricant_consom($db);
	//$canedit = ($user->rights->btp->write_all || $user->rights->btp->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php?mid='.$mid);
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$lubricant_consom     = new lubricant_consom($db);
$lubricant     = new lubricant($db);
$ConstructionSite     = new ConstructionSite($db);
$machine     = new machine($db);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('lubricant_consom'),'','','','',$morejs,$morecss,0,0);
$machine->fetch($mid);
        $head = material_prepare_head($machine);
        dol_fiche_head($head, 'lubricant_consom', $langs->trans('lubricant_consom'), 0, '');
        $html .= '<table class="border" width="100%">';
        $html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addlubricant_consom'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?mid='.$mid.'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

         //Numéro
        print '<tr><td class="fieldrequired">'.$langs->trans("num").'</td><td>';
        print '<input type="number" min="0" value="" name="num_" required="required" />';
        print '</td></tr>';

        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //lubricant
        print '<tr><td>'.$langs->trans("lubricant").'</td><td>'; 
        $cat_lubricant_consoms = $lubricant->getNames();
        print $form->selectarray('lubricant_id_', $cat_lubricant_consoms,(GETPOST('lubricant_id_') ? GETPOST('lubricant_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';
       

        //Engin 
        /*print '<tr><td>'.$langs->trans("machine").'</td><td>'; 
        $mark_lubricant_consoms = $machine->getMats();
        print $form->selectarray('machine_id_', $mark_lubricant_consoms,(GETPOST('machine_id_') ? GETPOST('machine_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';
*/
       //Prix 
        print '<tr><td class="fieldrequired">'.$langs->trans("price").'</td><td>';
        print '<input type="number" step="0.01" min="0"  value="" name="price_" required="required" />';
        print '</td></tr>';

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="0"  value="" name="qty_" required="required" />';
        print '</td></tr>';



        //Chantier 
        print '<tr><td>'.$langs->trans("const_site").'</td><td>'; 
        $const_sites = $ConstructionSite->getNames();
        print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        
        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createlubricant_consom") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $lubricant_consom->fetch($id);

			//$canedit = ($user->rights->btp->delete || $user->rights->btp->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'lubricant_consoms', $langs->trans("lubricant_consom"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'&mid='.$mid.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="lubricant_consom_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';

        //Numéro
        print '<tr><td class="fieldrequired">'.$langs->trans("num").'</td><td>';
        print '<input type="number" min="0" value="'.$lubricant_consom->num.'" name="num_" required="required" />';
        print '</td></tr>';


        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" value="'.dol_print_date($lubricant_consom->datec,'day').'" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';
            

        //lubricant
        print '<tr><td>'.$langs->trans("lubricant").'</td><td>'; 
        $cat_lubricant_consoms = $lubricant->getNames();
        print $form->selectarray('lubricant_id_', $cat_lubricant_consoms,(GETPOST('lubricant_id_') ? GETPOST('lubricant_id_') : $lubricant_consom->lubricant_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //Engin 
       /* print '<tr><td>'.$langs->trans("machine").'</td><td>'; 
        $mark_lubricant_consoms = $machine->getMats();
        print $form->selectarray('machine_id_', $mark_lubricant_consoms,(GETPOST('machine_id_') ? GETPOST('machine_id_') : $lubricant_consom->machine_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';*/

       //Prix 
        print '<tr><td class="fieldrequired">'.$langs->trans("price").'</td><td>';
        print '<input type="number" step="0.01" min="0"  value="'.$lubricant_consom->price.'" name="price_" required="required" />';
        print '</td></tr>';

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="0"  value="'.$lubricant_consom->qty.'" name="qty_" required="required" />';
        print '</td></tr>';



        //Chantier 
        print '<tr><td>'.$langs->trans("const_site").'</td><td>'; 
        $const_sites =  $ConstructionSite->getNames();
        print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : $lubricant_consom->const_site_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

       


                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->btp->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>