<?php
/* Copyright (C) 2016	Souieh Laghdaf	<laghdaf.souieh@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       /material/location_recipe/index.php
 * \ingroup    list
 * \brief      List of location expensess
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/location_recipe/class/location_recipe.class.php');
dol_include_once('/btp/material/machine/class/machine.class.php');
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
dol_include_once('/btp/settings/unit_type/class/unitType.class.php');
require_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';



$form 		= new Form($db);
$location_recipe     = new location_recipe($db);
$machine     = new machine($db);
$ConstructionSite   = new ConstructionSite($db);
$unit_type = new unitType($db);
$User = new User($db);
$societe     = new Societe($db);

$var = false;
$filter = '';
$counters_location_recipes = array(1 => $langs->trans('track'), 2 => $langs->trans('other'));
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$search_bon      		= GETPOST('search_bon');
$search_datec      		= "";
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}
$search_works_nature    		= GETPOST('search_works_nature');
$search_unit_type    		= GETPOST('search_unit_type');
$search_price    		= GETPOST('search_price');
$search_qty    		= GETPOST('search_qty');
$search_machine    		= GETPOST('search_machine');
$search_client    		= GETPOST('search_client');
$search_const_site    		= GETPOST('search_const_site');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_bon      		= '';
$search_datec      		= '';
$search_works_nature    		= '';
$search_unit_type    		= '';
$search_price    		= '';
$search_qty    		= '';
$search_machine    		= '';
$search_client    		= '';
$search_const_site    		= '';
}
$filter .= (!empty($search_bon) && $search_bon != -1) ? " AND bon = '". $db->escape($search_bon)."'\n" : "";
$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datec = '".$db->escape($search_datec)."'\n":"";
$filter .= (!empty($search_works_nature) && $search_works_nature != -1) ? " AND works_nature = '".$db->escape($search_works_nature)."'\n" : "";
$filter .= (!empty($search_unit_type) && $search_unit_type != -1) ? " AND unit_type_id = ".$db->escape($search_unit_type) : "";
$filter .= (!empty($search_price) && $search_price != -1) ? " AND price = ".$db->escape($search_price) : "";
$filter .= (!empty($search_qty) && $search_qty != -1) ? " AND qty = ".$db->escape($search_qty) : "";
$filter .= (!empty($search_machine) && $search_machine != -1) ? " AND machine_id = ".$db->escape($search_machine) : "";
$filter .= (!empty($search_client) && $search_client != -1) ? " AND client_id = ".$db->escape($search_client) : "";
$filter .= (!empty($search_const_site) && $search_const_site != -1) ? " AND const_site_id = ".$db->escape($search_const_site) : "";


$getlocation_recipes = $location_recipe->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);
if (!empty($getlocation_recipes) && $action == "xsl" ) {
$filename="liste_recettes_location.xls";
      dol_include_once('/btp/material/location_recipe/tpl/location_recipe_exl.php');
 die();
 
}
// Si erreur SQL
if ($getlocation_recipes == '-1') {
    print_fiche_titre($langs->trans('ListOflocation_recipe'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$location_recipe->error);
    exit();
}
if ($id > 0) {
	$location_recipe->fetch($id);
	llxHeader('', $langs->trans('location_recipe'));
	print '<link rel="stylesheet" href= "'.dol_buildpath('/btp/css/fontawesome.css',2).'">';

	print_fiche_titre($langs->trans("location_recipe"));


	print '<table class="border" width="100%">';
	// bon
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("bon").'</td>';
	print '<td colspan="2">'. $location_recipe->bon .'</td></tr>';
	// datec
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($location_recipe->datec,'day') .'</td></tr>';
	// matricule
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("works_nature").'</td>';
	print '<td colspan="2">'. $location_recipe->works_nature .'</td></tr>';
	// unit_type
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("unit_type").'</td>';
	$unit_type->fetch($location_recipe->unit_type_id);
	print '<td colspan="2">'. $unit_type->getNomUrl('1').'</td></tr>';
	// Moyenne de consommation estimée
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("price").'</td>';
	print '<td colspan="2">'. $location_recipe->price .'</td></tr>';
	// quantité de Location
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
	print '<td colspan="2">'. $location_recipe->qty .'</td></tr>';
	// Engin
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine").'</td>';
	$machine->fetch($location_recipe->machine_id);
	print '<td colspan="2">'. $machine->getNomUrl('1') .'</td></tr>';
	// locataire 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("client").'</td>';
	$societe->fetch($location_recipe->client_id);
	print '<td colspan="2">'. $societe->getNomUrl('1').'</td></tr>';
	//chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ConstructionSite").'</td>';
	$ConstructionSite->fetch($location_recipe->const_site_id);
	print '<td colspan="2">'. $ConstructionSite->getNomUrl(1,$ConstructionSite->id,$ConstructionSite->name,$ConstructionSite->market_id) .'</td></tr>';
	
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';
	if ($action == 'delete') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }
}
else {

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('location_recipes'),'','','','',$morejs,$morecss,0,0);
print '<link rel="stylesheet" href= "'.dol_buildpath('/btp/css/fontawesome.css',2).'">';

print_fiche_titre($langs->trans("ListOflocation_recipe"));


	dol_fiche_head('', 'location_recipes', $langs->trans("Listlocation_recipe"), 1, '');
print '<div style="float: right; margin-bottom: 4px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addlocation_recipe').'</a>';
		print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_bon" value="'. $search_bon .'" type="hidden" />';
print '<input name="search_datec" value="'. $search_datec .'" type="hidden" />';
print '<input name="search_works_nature" value="'. $search_works_nature .'" type="hidden" />';
print '<input name="search_unit_type" value="'. $search_unit_type .'" type="hidden" />';
print '<input name="search_price" value="'. $search_price .'" type="hidden" />';
print '<input name="search_qty" value="'. $search_qty .'" type="hidden" />';
print '<input name="search_machine" value="'. $search_machine .'" type="hidden" />';
print '<input name="search_client" value="'. $search_client .'" type="hidden" />';
print '<input name="search_const_site" value="'. $search_const_site .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("bon"), $_SERVER["PHP_SELF"], 'bon', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("datec"),$_SERVER["PHP_SELF"],"datec", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("works_nature"), $_SERVER["PHP_SELF"], 'works_nature', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("unit_type"), $_SERVER["PHP_SELF"], 'unit_type_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("price"),$_SERVER["PHP_SELF"],"price", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("qty"), $_SERVER["PHP_SELF"], 'qty', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("total"), $_SERVER["PHP_SELF"], '', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("machine"), $_SERVER["PHP_SELF"], 'machine_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("client"), $_SERVER["PHP_SELF"], 'client_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("ConstructionSite"), $_SERVER["PHP_SELF"], 'const_site_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// bon
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="8" name="search_bon" value="'.$search_bon.'">';
	print '</td>';
	//datec
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec"  readonly="readonly" /> ';
    print '</td>';
    // works_nature
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_works_nature" value="'.$search_works_nature.'">';
	print '</td>';
	// unit_type
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_unit_type', $unit_type->getNames(), $search_unit_type, 1, 0, 0, 'required="required"');
	print '</td>';
	 // price
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_price" value="'.$search_price.'">';
	print '</td>';
	 // qty
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_qty" value="'.$search_qty.'">';
	print '</td>';
	// total
	print '<td class="liste_titre" olspan="1" align="center">';
	print '</td>';
	// engin
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_machine', $machine->getMats(), $search_machine, 1, 0, 0, 'required="required"');
	print '</td>';
	// client
	print '<td class="liste_titre" olspan="1" align="center">';
	print  $form->select_thirdparty($search_client,"search_client",'s.fournisseur=0');
    print '</td>';
    // const_site
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_const_site', $ConstructionSite->getNames(), $search_const_site, 1, 0, 0, 'required="required"');
	print '</td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($location_recipe->rows)) {
		//$createdBy = new User($db);
		foreach($location_recipe->rows as $obj) {
			  $datec 			= dol_print_date($obj->datec,'day') ;
			  $works_nature 	= $obj->works_nature ;
			  $bon 				= $obj->bon ;
			  $price  			= $obj->price ;
			  $qty 				= $obj->qty ;
			  $machine->fetch($obj->machine_id) ;
			  $ConstructionSite->fetch($obj->const_site_id) ;
			  $unit_type->fetch($obj->unit_type_id) ;
			  $societe->fetch($obj->client_id);
			  
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $location_recipe->getNomUrl(1,  $obj->id, $bon);
			print '</td>';
			 
			print '<td align="center">'. $datec .'</td>';
			print '<td align="center">'. $works_nature .'</td>';
			print '<td align="center">'. $unit_type->getNomUrl('1')	 .'</td>';
			print '<td align="center">'. $price .'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $qty*$price .'</td>';
			print '<td align="center">'. $machine->getNomUrl('1') .'</td>';
			print '<td align="center">'. $societe->getNomUrl('1') .'</td>';
			print '<td align="center">'. $ConstructionSite->getNomUrl(1,$ConstructionSite->id,$ConstructionSite->name,$ConstructionSite->market_id) .'</td>';
			print '<td align="center"></td>';

			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


}

llxFooter();

$db->close();


?>