<?php
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class location_recipe extends Commonobject{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

  public $works_nature;
  public $datec;
  public $bon;
  public $price;
  public $qty ;
  public $machine_id ;
  public $unit_type_id 	;
  public $client_id ;
  public $const_site_id	 ;
  public $created_by ;
  public $created_at ;
  public $updated_at ;
  public $rows = array();

	public $now;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = date('Y-m-d');//$this->now->format('Y-m-d');
		return 1;
	}


	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/material/location_recipe/index.php?id='. $id,1) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
	  $this->works_nature = $this->works_nature ? $this->db->escape($this->works_nature): null;
	  $this->datec = $this->datec ? $this->db->escape($this->datec): null;
	  $this->bon = $this->bon ? $this->db->escape($this->bon): null;
	  $this->price = $this->price ? $this->db->escape($this->price): null;
	  $this->qty = $this->qty ? $this->db->escape($this->qty): null;
	  $this->machine_id = $this->machine_id ? $this->db->escape($this->machine_id): null;
	  $this->unit_type_id = $this->unit_type_id ? $this->db->escape($this->unit_type_id): null;
	  $this->client_id = $this->client_id ? $this->db->escape($this->client_id): null;
	  $this->const_site_id	= $this->const_site_id ? $this->db->escape($this->const_site_id): null;
	  $this->created_by = $this->created_by ? $this->db->escape($this->created_by): null;
	  $this->created_at = $this->now;
	// Insert request
	$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'location_recipe' . ' (works_nature,datec,bon,price,qty,';
	$sql .= 'machine_id,unit_type_id,client_id,const_site_id,created_by,created_at) ';
	$sql .= 'VALUES ("'.$this->works_nature.'", "'.$this->datec.'","';
	$sql .=	$this->bon.'", '.$this->price.', '. $this->qty.', '.$this->machine_id.',';
	$sql .=	$this->unit_type_id.', '.$this->client_id.', '.$this->const_site_id.', '.$this->created_by.',';
	$sql .= '"'.$this->created_at.'")'; 
	//die($sql);
	$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error location_recipe ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			die();
			return -1;
		} else {
			$this->db->commit();
			return 1;
			//return $this->getLasInsrtedId();
		}
	}

/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'location_recipe';
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->id             = $obj->rowid;
			  $this->works_nature 			= $obj->works_nature ;
			  $this->datec 	= $this->db->jdate($obj->datec) ;
			  $this->bon 			= $obj->bon ;
			  $this->price = $obj->price ;
			  $this->qty 		= $obj->qty ;
			  $this->machine_id = $obj->machine_id ;
			  $this->unit_type_id 	= $obj->unit_type_id ;
			  $this->client_id 		= $obj->client_id ;
			  $this->const_site_id	= $obj->const_site_id ;
			  $this->created_by 	= $obj->created_by ;
			  $this->created_at 	= $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'location_recipe';

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
					$line->id 			 = $obj->rowid;
					$line->works_nature 			= $obj->works_nature ;
				  $line->datec 		= $this->db->jdate($obj->datec) ;
				  $line->bon 			= $obj->bon ;
				  $line->price 		= $obj->price ;
				  $line->qty 		= $obj->qty ;
				  $line->machine_id = $obj->machine_id ;
				  $line->unit_type_id 	= $obj->unit_type_id ;
				  $line->client_id 		= $obj->client_id ;
				  $line->const_site_id	= $obj->const_site_id ;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
					$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}



	/**
	 * Updatec object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Updatec request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'location_recipe' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
			$now = new \DateTime("now");
			$now 		 = $now->format('Y-m-d');
			$sql .= '`updated_at` = "'. $now.'"' ;

		//$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'location_recipe' .' WHERE rowid = ' . $this->id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	public function getStatData()
    {
    	global $langs;
    	$this->fetchAll();
    	$countAmount = 0;

    	foreach ($this->rows as $key => $obj)
    		$countAmount += ($obj->price*$obj->qty);
	
    	$object 		= new stdClass();
    	$object->number = count($this->rows);
    	$object->cost 	= $countAmount;
    	$object->label 	= $langs->trans('location_recipe');
    	$object->url 	= dol_buildpath('/btp/material/location_recipe/index.php',1);

    	return $object;
    }

    public function getDataByYear($year)
    {
    	$sql = 'SELECT MONTH(datec) as month, SUM(qty*price) as total FROM ' . MAIN_DB_PREFIX . 'location_recipe WHERE YEAR(datec)='.$year;
    	$sql .=' GROUP BY MONTH(datec)';
    	$resql = $this->db->query($sql);
    	$data = array();
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$data[$obj->month] = $obj->total;
			}
			$this->db->free($resql);
    	}

    	return $data;
    }
}
?>